/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.crypto.asymmetric;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1ObjectIdentifier;
import com.aspose.html.internal.ms.core.bc.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.aspose.html.internal.ms.core.bc.asn1.x509.AlgorithmIdentifier;
import com.aspose.html.internal.ms.core.bc.crypto.Algorithm;
import com.aspose.html.internal.ms.core.bc.crypto.AsymmetricKey;
import com.aspose.html.internal.ms.core.bc.crypto.CryptoServicesRegistrar;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.GOST3410Parameters;
import com.aspose.html.internal.ms.core.bc.crypto.asymmetric.KeyUtils;
import com.aspose.html.internal.ms.core.bc.crypto.fips.FipsUnapprovedOperationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsymmetricGOST3410Key<T>
implements AsymmetricKey {
    private Algorithm algorithm;
    private GOST3410Parameters<T> domainParameters;

    AsymmetricGOST3410Key(Algorithm algorithm, GOST3410Parameters<T> gOST3410Parameters) {
        this.algorithm = algorithm;
        this.domainParameters = gOST3410Parameters;
    }

    AsymmetricGOST3410Key(Algorithm algorithm, ASN1ObjectIdentifier aSN1ObjectIdentifier, AlgorithmIdentifier algorithmIdentifier) {
        if (!aSN1ObjectIdentifier.equals(algorithmIdentifier.getAlgorithm())) {
            throw new IllegalArgumentException("Unknown algorithm type: " + algorithmIdentifier.getAlgorithm());
        }
        this.algorithm = algorithm;
        this.domainParameters = AsymmetricGOST3410Key.decodeDomainParameters(algorithmIdentifier);
    }

    private static GOST3410Parameters decodeDomainParameters(AlgorithmIdentifier algorithmIdentifier) {
        if (KeyUtils.isNotNull(algorithmIdentifier.getParameters())) {
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = GOST3410PublicKeyAlgParameters.getInstance(algorithmIdentifier.getParameters());
            return new GOST3410Parameters(gOST3410PublicKeyAlgParameters.getPublicKeyParamSet(), gOST3410PublicKeyAlgParameters.getDigestParamSet(), gOST3410PublicKeyAlgParameters.getDigestParamSet());
        }
        return null;
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public GOST3410Parameters<T> getParameters() {
        return this.domainParameters;
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }

    protected void zeroize() {
        this.algorithm = null;
        this.domainParameters = null;
    }
}

