/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.cms;

import com.aspose.html.internal.ms.core.bc.asn1.x500.X500Name;
import com.aspose.html.internal.ms.core.bc.util.Arrays;
import com.aspose.html.internal.ms.core.bc.util.Selector;
import java.math.BigInteger;

class OriginatorId
implements Selector {
    private byte[] subjectKeyId;
    private X500Name issuer;
    private BigInteger serialNumber;

    public OriginatorId(byte[] byArray) {
        this.setSubjectKeyID(byArray);
    }

    private void setSubjectKeyID(byte[] byArray) {
        this.subjectKeyId = byArray;
    }

    public OriginatorId(X500Name x500Name, BigInteger bigInteger) {
        this.setIssuerAndSerial(x500Name, bigInteger);
    }

    private void setIssuerAndSerial(X500Name x500Name, BigInteger bigInteger) {
        this.issuer = x500Name;
        this.serialNumber = bigInteger;
    }

    public OriginatorId(X500Name x500Name, BigInteger bigInteger, byte[] byArray) {
        this.setIssuerAndSerial(x500Name, bigInteger);
        this.setSubjectKeyID(byArray);
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public Object clone() {
        return new OriginatorId(this.issuer, this.serialNumber, this.subjectKeyId);
    }

    public int hashCode() {
        int n2 = Arrays.hashCode(this.subjectKeyId);
        if (this.serialNumber != null) {
            n2 ^= this.serialNumber.hashCode();
        }
        if (this.issuer != null) {
            n2 ^= this.issuer.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OriginatorId)) {
            return false;
        }
        OriginatorId originatorId = (OriginatorId)object;
        return Arrays.areEqual(this.subjectKeyId, originatorId.subjectKeyId) && this.equalsObj(this.serialNumber, originatorId.serialNumber) && this.equalsObj(this.issuer, originatorId.issuer);
    }

    private boolean equalsObj(Object object, Object object2) {
        return object != null ? object.equals(object2) : object2 == null;
    }

    public boolean match(Object object) {
        return false;
    }
}

