/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.bc.asn1.x509;

import com.aspose.html.internal.ms.core.bc.asn1.ASN1EncodableVector;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Integer;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Object;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1OctetString;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Primitive;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1Sequence;
import com.aspose.html.internal.ms.core.bc.asn1.ASN1TaggedObject;
import com.aspose.html.internal.ms.core.bc.asn1.DEROctetString;
import com.aspose.html.internal.ms.core.bc.asn1.DERSequence;
import com.aspose.html.internal.ms.core.bc.asn1.DERTaggedObject;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extension;
import com.aspose.html.internal.ms.core.bc.asn1.x509.Extensions;
import com.aspose.html.internal.ms.core.bc.asn1.x509.GeneralNames;
import com.aspose.html.internal.ms.core.bc.util.encoders.Hex;
import java.math.BigInteger;
import java.util.Enumeration;

public class AuthorityKeyIdentifier
extends ASN1Object {
    ASN1OctetString keyidentifier = null;
    GeneralNames certissuer = null;
    ASN1Integer certserno = null;

    public static AuthorityKeyIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return AuthorityKeyIdentifier.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static AuthorityKeyIdentifier getInstance(Object object) {
        if (object instanceof AuthorityKeyIdentifier) {
            return (AuthorityKeyIdentifier)object;
        }
        if (object != null) {
            return new AuthorityKeyIdentifier(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static AuthorityKeyIdentifier fromExtensions(Extensions extensions) {
        return AuthorityKeyIdentifier.getInstance(extensions.getExtensionParsedValue(Extension.authorityKeyIdentifier));
    }

    protected AuthorityKeyIdentifier(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = DERTaggedObject.getInstance(enumeration.nextElement());
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.keyidentifier = ASN1OctetString.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                case 1: {
                    this.certissuer = GeneralNames.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                case 2: {
                    this.certserno = ASN1Integer.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("illegal tag");
        }
    }

    public AuthorityKeyIdentifier(GeneralNames generalNames, BigInteger bigInteger) {
        this(null, generalNames, bigInteger);
    }

    public AuthorityKeyIdentifier(byte[] byArray) {
        this(byArray, null, null);
    }

    public AuthorityKeyIdentifier(byte[] byArray, GeneralNames generalNames, BigInteger bigInteger) {
        this.keyidentifier = byArray != null ? new DEROctetString(byArray) : null;
        this.certissuer = generalNames;
        this.certserno = bigInteger != null ? new ASN1Integer(bigInteger) : null;
    }

    public byte[] getKeyIdentifier() {
        if (this.keyidentifier != null) {
            return this.keyidentifier.getOctets();
        }
        return null;
    }

    public GeneralNames getAuthorityCertIssuer() {
        return this.certissuer;
    }

    public BigInteger getAuthorityCertSerialNumber() {
        if (this.certserno != null) {
            return this.certserno.getValue();
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.keyidentifier != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.keyidentifier));
        }
        if (this.certissuer != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.certissuer));
        }
        if (this.certserno != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.certserno));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        return "AuthorityKeyIdentifier: KeyID(" + (this.keyidentifier != null ? Hex.toHexString(this.keyidentifier.getOctets()) : "null") + ")";
    }
}

