/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.Int64Extensions;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.msArray;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;

public class ASN1Convert {
    public static ASN1 fromDateTime(DateTime dateTime) {
        if (dateTime.getYear() < 2050) {
            return new ASN1(23, Encoding.getASCII().getBytes(DateTime.toString(dateTime.toUniversalTime(), "yyMMddHHmmss", CultureInfo.getInvariantCulture()) + "Z"));
        }
        return new ASN1(24, Encoding.getASCII().getBytes(DateTime.toString(dateTime.toUniversalTime(), "yyyyMMddHHmmss", CultureInfo.getInvariantCulture()) + "Z"));
    }

    public static ASN1 fromInt32(int n2) {
        int n3;
        byte[] byArray = BitConverter.getBytesInt32(n2);
        msArray.reverse(byArray);
        for (n3 = 0; n3 < byArray.length && byArray[n3] == 0; ++n3) {
        }
        ASN1 aSN1 = new ASN1(2);
        switch (n3) {
            case 0: {
                aSN1.setValue(byArray);
                break;
            }
            case 4: {
                aSN1.setValue(new byte[1]);
                break;
            }
            default: {
                byte[] byArray2 = new byte[4 - n3];
                Buffer.blockCopy(Array.boxing(byArray), n3, Array.boxing(byArray2), 0, byArray2.length);
                aSN1.setValue(byArray2);
            }
        }
        return aSN1;
    }

    public static ASN1 fromOid(String string) {
        if (string == null) {
            throw new ArgumentNullException("oid");
        }
        return new ASN1(CryptoConfig.encodeOID(string));
    }

    public static ASN1 fromUnsignedBigInteger(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("big");
        }
        if ((byArray[0] & 0xFF) >= 128) {
            int n2 = byArray.length + 1;
            byte[] byArray2 = new byte[n2];
            Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(byArray2), 1, n2 - 1);
            byArray = byArray2;
        }
        return new ASN1(2, byArray);
    }

    public static int toInt32(ASN1 aSN1) {
        if (aSN1 == null) {
            throw new ArgumentNullException("asn1");
        }
        if (aSN1.getTag() != 2) {
            throw new FormatException("Only integer can be converted");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < aSN1.getValue().length; ++i2) {
            n2 = (n2 << 8) + (aSN1.getValue()[i2] & 0xFF);
        }
        return n2;
    }

    public static String toOid(ASN1 aSN1) {
        if (aSN1 == null) {
            throw new ArgumentNullException("asn1");
        }
        byte[] byArray = aSN1.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = (byArray[0] & 0xFF) / 40;
        byte by2 = (byte)((byArray[0] & 0xFF) % 40);
        if ((n2 & 0xFF) > 2) {
            by2 = (byte)((by2 & 0xFF) + ((byte)(((n2 & 0xFF) - 2) * 40) & 0xFF));
            n2 = 2;
        }
        stringBuilder.append(ByteExtensions.toString((byte)n2, CultureInfo.getInvariantCulture()));
        stringBuilder.append(".");
        stringBuilder.append(ByteExtensions.toString(by2, CultureInfo.getInvariantCulture()));
        long l2 = 0L;
        n2 = 1;
        while ((n2 & 0xFF) < byArray.length) {
            l2 = l2 << 7 | (long)((byte)(byArray[n2 & 0xFF] & 0xFF & 0x7F));
            if ((byArray[n2 & 0xFF] & 0xFF & 0x80) != 128) {
                stringBuilder.append(".");
                stringBuilder.append(Int64Extensions.toString(l2, CultureInfo.getInvariantCulture()));
                l2 = 0L;
            }
            n2 = (byte)(n2 + 1);
        }
        return stringBuilder.toString();
    }

    public static DateTime toDateTime(ASN1 aSN1) {
        if (aSN1 == null) {
            throw new ArgumentNullException("time");
        }
        String string = Encoding.getASCII().getString(aSN1.getValue());
        String string2 = null;
        switch (string.length()) {
            case 11: {
                string2 = "yyMMddHHmmZ";
                break;
            }
            case 13: {
                short s2 = Convert.toInt16(string.substring(0, 2), (IFormatProvider)CultureInfo.getInvariantCulture());
                string = s2 >= 50 ? "19" + string : "20" + string;
                string2 = "yyyyMMddHHmmssZ";
                break;
            }
            case 15: {
                string2 = "yyyyMMddHHmmssZ";
                break;
            }
            case 17: {
                short s3 = Convert.toInt16(string.substring(0, 2), (IFormatProvider)CultureInfo.getInvariantCulture());
                String string3 = s3 >= 50 ? "19" : "20";
                char c2 = string.charAt(12) == '+' ? (char)'-' : '+';
                string = StringExtensions.format("{0}{1}{2}{3}{4}:{5}{6}", string3, string.substring(0, 12), Character.valueOf(c2), Character.valueOf(string.charAt(13)), Character.valueOf(string.charAt(14)), Character.valueOf(string.charAt(15)), Character.valueOf(string.charAt(16)));
                string2 = "yyyyMMddHHmmsszzz";
            }
        }
        return DateTime.parseExact(string, string2, (IFormatProvider)CultureInfo.getInvariantCulture(), 16);
    }
}

