/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.FilterType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.FilterWriteStrategy;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.ImageLine;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngHelperInternal;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngIDatChunkOutputStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjExceptionInternal;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjOutputException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.PngjUnsupportedException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkCopyBehaviour;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunkPredicate;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunksList;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.ChunksListForWrite;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunk;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkIEND;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkIHDR;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkSkipped;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngChunkTextVar;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.png.pngj.chunks.PngMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.stream.ImageOutputStream;

public class PngWriter {
    public final ImageInfo imgInfo;
    private final String a;
    protected int rowNum = -1;
    private final ChunksListForWrite b;
    private final PngMetadata c;
    protected int currentChunkGroup = -1;
    protected FilterWriteStrategy filterStrat;
    private int d = 6;
    private boolean e = true;
    private PngIDatChunkOutputStream f;
    private DeflaterOutputStream g;
    private int h = 1;
    private final int[] i = new int[256];
    private int j = 0;
    private final ImageOutputStream k;
    protected byte[] rowb = null;
    protected byte[] rowbfilter = null;
    protected byte[] rowbprev = null;
    private boolean l = false;
    private ChunkPredicate m = null;
    private ChunksList n = null;

    public PngWriter(ImageOutputStream imageOutputStream, ImageInfo imageInfo) {
        this(imageOutputStream, imageInfo, "[NO FILENAME AVAILABLE]");
    }

    public PngWriter(ImageOutputStream imageOutputStream, ImageInfo imageInfo, String string) {
        this.a = string == null ? "" : string;
        this.k = imageOutputStream;
        this.imgInfo = imageInfo;
        this.rowb = new byte[imageInfo.bytesPerRow + 1];
        this.rowbprev = new byte[this.rowb.length];
        this.rowbfilter = new byte[this.rowb.length];
        this.b = new ChunksListForWrite(imageInfo);
        this.c = new PngMetadata(this.b);
        this.filterStrat = new FilterWriteStrategy(imageInfo, FilterType.FILTER_DEFAULT);
    }

    private void a() {
        this.f = new PngIDatChunkOutputStream(this.k, this.j);
        Deflater deflater = new Deflater(this.d);
        deflater.setStrategy(this.h);
        this.g = new DeflaterOutputStream((OutputStream)this.f, deflater);
        this.e();
        this.c();
    }

    private void a(int n2, FilterType filterType, boolean bl2) {
        Arrays.fill(this.i, 0);
        int n3 = 0;
        for (int i2 = 1; i2 <= this.imgInfo.bytesPerRow; ++i2) {
            byte by2 = this.rowbfilter[i2];
            n3 = by2 < 0 ? (n3 -= by2) : (n3 += by2);
            int n4 = by2 & 0xFF;
            this.i[n4] = this.i[n4] + 1;
        }
        this.filterStrat.fillResultsForFilter(n2, filterType, n3, this.i, bl2);
    }

    private void b() {
        PngChunkIEND pngChunkIEND = new PngChunkIEND(this.imgInfo);
        pngChunkIEND.createRawChunk().writeChunk(this.k);
    }

    private void c() {
        int n2 = 0;
        this.currentChunkGroup = 1;
        this.f();
        n2 = this.b.writeChunks(this.k, this.currentChunkGroup);
        this.currentChunkGroup = 2;
        n2 = this.b.writeChunks(this.k, this.currentChunkGroup);
        if (n2 > 0 && this.imgInfo.greyscale) {
            throw new PngjOutputException("cannot write palette for this format");
        }
        if (n2 == 0 && this.imgInfo.indexed) {
            throw new PngjOutputException("missing palette");
        }
        this.currentChunkGroup = 3;
        n2 = this.b.writeChunks(this.k, this.currentChunkGroup);
        this.currentChunkGroup = 4;
    }

    private void d() {
        this.f();
        this.currentChunkGroup = 5;
        this.b.writeChunks(this.k, this.currentChunkGroup);
        List<PngChunk> list = this.b.getQueuedChunks();
        if (!list.isEmpty()) {
            throw new PngjOutputException(list.size() + " chunks were not written! Eg: " + list.get(0).toString());
        }
        this.currentChunkGroup = 6;
    }

    private void e() {
        this.currentChunkGroup = 0;
        PngHelperInternal.writeBytes(this.k, PngHelperInternal.getPngIdSignature());
        PngChunkIHDR pngChunkIHDR = new PngChunkIHDR(this.imgInfo);
        pngChunkIHDR.setCols(this.imgInfo.cols);
        pngChunkIHDR.setRows(this.imgInfo.rows);
        pngChunkIHDR.setBitspc(this.imgInfo.bitDepth);
        int n2 = 0;
        if (this.imgInfo.alpha) {
            n2 += 4;
        }
        if (this.imgInfo.indexed) {
            ++n2;
        }
        if (!this.imgInfo.greyscale) {
            n2 += 2;
        }
        pngChunkIHDR.setColormodel(n2);
        pngChunkIHDR.setCompmeth(0);
        pngChunkIHDR.setFilmeth(0);
        pngChunkIHDR.setInterlaced(0);
        pngChunkIHDR.createRawChunk().writeChunk(this.k);
    }

    protected void encodeRowFromByte(byte[] byArray) {
        if (byArray.length == this.imgInfo.samplesPerRowPacked) {
            int n2 = 1;
            if (this.imgInfo.bitDepth <= 8) {
                for (byte by2 : byArray) {
                    this.rowb[n2++] = by2;
                }
            } else {
                byte[] byArray2 = byArray;
                int n3 = byArray2.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    byte by3;
                    this.rowb[n2] = by3 = byArray2[i2];
                    n2 += 2;
                }
            }
        } else {
            if (byArray.length >= this.imgInfo.samplesPerRow && this.l) {
                ImageLine.packInplaceByte(this.imgInfo, byArray, byArray, false);
            }
            if (this.imgInfo.bitDepth <= 8) {
                int n4 = 1;
                for (int i3 = 0; i3 < this.imgInfo.samplesPerRowPacked; ++i3) {
                    this.rowb[n4++] = byArray[i3];
                }
            } else {
                int n5 = 1;
                for (int i4 = 0; i4 < this.imgInfo.samplesPerRowPacked; ++i4) {
                    this.rowb[n5++] = byArray[i4];
                    this.rowb[n5++] = 0;
                }
            }
        }
    }

    protected void encodeRowFromInt(int[] nArray) {
        if (nArray.length == this.imgInfo.samplesPerRowPacked) {
            int n2 = 1;
            if (this.imgInfo.bitDepth <= 8) {
                for (int n3 : nArray) {
                    this.rowb[n2++] = (byte)n3;
                }
            } else {
                for (int n4 : nArray) {
                    this.rowb[n2++] = (byte)(n4 >> 8);
                    this.rowb[n2++] = (byte)n4;
                }
            }
        } else {
            if (nArray.length >= this.imgInfo.samplesPerRow && this.l) {
                ImageLine.packInplaceInt(this.imgInfo, nArray, nArray, false);
            }
            if (this.imgInfo.bitDepth <= 8) {
                int n5 = 1;
                for (int i2 = 0; i2 < this.imgInfo.samplesPerRowPacked; ++i2) {
                    this.rowb[n5++] = (byte)nArray[i2];
                }
            } else {
                int n6 = 1;
                for (int i3 = 0; i3 < this.imgInfo.samplesPerRowPacked; ++i3) {
                    this.rowb[n6++] = (byte)(nArray[i3] >> 8);
                    this.rowb[n6++] = (byte)nArray[i3];
                }
            }
        }
    }

    private void a(int n2) {
        if (this.filterStrat.shouldTestAll(n2)) {
            this.filterRowNone();
            this.a(n2, FilterType.FILTER_NONE, true);
            this.filterRowSub();
            this.a(n2, FilterType.FILTER_SUB, true);
            this.filterRowUp();
            this.a(n2, FilterType.FILTER_UP, true);
            this.filterRowAverage();
            this.a(n2, FilterType.FILTER_AVERAGE, true);
            this.filterRowPaeth();
            this.a(n2, FilterType.FILTER_PAETH, true);
        }
        FilterType filterType = this.filterStrat.gimmeFilterType(n2, true);
        this.rowbfilter[0] = (byte)filterType.val;
        switch (filterType) {
            case FILTER_NONE: {
                this.filterRowNone();
                break;
            }
            case FILTER_SUB: {
                this.filterRowSub();
                break;
            }
            case FILTER_UP: {
                this.filterRowUp();
                break;
            }
            case FILTER_AVERAGE: {
                this.filterRowAverage();
                break;
            }
            case FILTER_PAETH: {
                this.filterRowPaeth();
                break;
            }
            default: {
                throw new PngjUnsupportedException("Filter type " + (Object)((Object)filterType) + " not implemented");
            }
        }
        this.a(n2, filterType, false);
    }

    private void b(int n2) {
        if (this.f == null) {
            this.a();
        }
        ++this.rowNum;
        if (n2 >= 0 && this.rowNum != n2) {
            throw new PngjOutputException("rows must be written in order: expected:" + this.rowNum + " passed:" + n2);
        }
        byte[] byArray = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = byArray;
    }

    private void c(int n2) {
        this.a(n2);
        try {
            this.g.write(this.rowbfilter, 0, this.imgInfo.bytesPerRow + 1);
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    protected void filterRowAverage() {
        int n2 = this.imgInfo.bytesPerRow;
        int n3 = 1 - this.imgInfo.bytesPixel;
        int n4 = 1;
        while (n4 <= n2) {
            this.rowbfilter[n4] = (byte)(this.rowb[n4] - ((this.rowbprev[n4] & 0xFF) + (n3 > 0 ? this.rowb[n3] & 0xFF : 0)) / 2);
            ++n4;
            ++n3;
        }
    }

    protected void filterRowNone() {
        for (int i2 = 1; i2 <= this.imgInfo.bytesPerRow; ++i2) {
            this.rowbfilter[i2] = this.rowb[i2];
        }
    }

    protected void filterRowPaeth() {
        int n2 = this.imgInfo.bytesPerRow;
        int n3 = 1 - this.imgInfo.bytesPixel;
        int n4 = 1;
        while (n4 <= n2) {
            this.rowbfilter[n4] = (byte)PngHelperInternal.filterRowPaeth(this.rowb[n4], n3 > 0 ? this.rowb[n3] & 0xFF : 0, this.rowbprev[n4] & 0xFF, n3 > 0 ? this.rowbprev[n3] & 0xFF : 0);
            ++n4;
            ++n3;
        }
    }

    protected void filterRowSub() {
        int n2;
        for (n2 = 1; n2 <= this.imgInfo.bytesPixel; ++n2) {
            this.rowbfilter[n2] = this.rowb[n2];
        }
        int n3 = 1;
        n2 = this.imgInfo.bytesPixel + 1;
        while (n2 <= this.imgInfo.bytesPerRow) {
            this.rowbfilter[n2] = (byte)PngHelperInternal.filterRowSub(this.rowb[n2], this.rowb[n3]);
            ++n2;
            ++n3;
        }
    }

    protected void filterRowUp() {
        for (int i2 = 1; i2 <= this.imgInfo.bytesPerRow; ++i2) {
            this.rowbfilter[i2] = (byte)PngHelperInternal.filterRowUp(this.rowb[i2], this.rowbprev[i2]);
        }
    }

    private void f() {
        if (this.n == null || this.m == null) {
            return;
        }
        boolean bl2 = this.currentChunkGroup >= 4;
        for (PngChunk pngChunk : this.n.getChunks()) {
            boolean bl3;
            int n2 = pngChunk.getChunkGroup();
            if (n2 <= 4 && bl2 || n2 >= 4 && !bl2 || pngChunk.crit && !pngChunk.id.equals("PLTE") || !(bl3 = this.m.match(pngChunk)) || !this.b.getEquivalent(pngChunk).isEmpty() || !this.b.getQueuedEquivalent(pngChunk).isEmpty()) continue;
            this.b.queue(pngChunk);
        }
    }

    protected int sumRowbfilter() {
        int n2 = 0;
        for (int i2 = 1; i2 <= this.imgInfo.bytesPerRow; ++i2) {
            if (this.rowbfilter[i2] < 0) {
                n2 -= this.rowbfilter[i2];
                continue;
            }
            n2 += this.rowbfilter[i2];
        }
        return n2;
    }

    private void a(PngReader pngReader, int n2, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.currentChunkGroup >= 4;
        if (bl2 && pngReader.getCurrentChunkGroup() < 6) {
            throw new PngjExceptionInternal("tried to copy last chunks but reader has not ended");
        }
        for (PngChunk pngChunk : pngReader.getChunksList().getChunks()) {
            int n3 = pngChunk.getChunkGroup();
            if (n3 < 4 && bl3) continue;
            boolean bl5 = false;
            if (pngChunk.crit) {
                if (pngChunk.id.equals("PLTE")) {
                    if (this.imgInfo.indexed && ChunkHelper.maskMatch(n2, 1)) {
                        bl5 = true;
                    }
                    if (!this.imgInfo.greyscale && ChunkHelper.maskMatch(n2, 8)) {
                        bl5 = true;
                    }
                }
            } else {
                boolean bl6 = pngChunk instanceof PngChunkTextVar;
                boolean bl7 = pngChunk.safe;
                if (ChunkHelper.maskMatch(n2, 8)) {
                    bl5 = true;
                }
                if (bl7 && ChunkHelper.maskMatch(n2, 4)) {
                    bl5 = true;
                }
                if (pngChunk.id.equals("tRNS") && ChunkHelper.maskMatch(n2, 64)) {
                    bl5 = true;
                }
                if (pngChunk.id.equals("pHYs") && ChunkHelper.maskMatch(n2, 16)) {
                    bl5 = true;
                }
                if (bl6 && ChunkHelper.maskMatch(n2, 32)) {
                    bl5 = true;
                }
                if (!(!ChunkHelper.maskMatch(n2, 256) || ChunkHelper.isUnknown(pngChunk) || bl6 || pngChunk.id.equals("hIST") || pngChunk.id.equals("tIME"))) {
                    bl5 = true;
                }
                if (pngChunk instanceof PngChunkSkipped) {
                    bl5 = false;
                }
            }
            if (!bl5) continue;
            this.b.queue(PngChunk.cloneChunk(pngChunk, this.imgInfo));
        }
    }

    public void copyChunksFirst(PngReader pngReader, int n2) {
        this.a(pngReader, n2, false);
    }

    public void copyChunksLast(PngReader pngReader, int n2) {
        this.a(pngReader, n2, true);
    }

    public void copyChunksFrom(ChunksList chunksList, int n2) {
        this.copyChunksFrom(chunksList, ChunkCopyBehaviour.createPredicate(n2, this.imgInfo));
    }

    public void copyChunksFrom(ChunksList chunksList) {
        this.copyChunksFrom(chunksList, 8);
    }

    public void copyChunksFrom(ChunksList chunksList, ChunkPredicate chunkPredicate) {
        if (chunkPredicate == null) {
            throw new PngjOutputException("copyChunksFrom requires a predicate");
        }
        this.n = chunksList;
        this.m = chunkPredicate;
    }

    public double computeCompressionRatio() {
        if (this.currentChunkGroup < 6) {
            throw new PngjOutputException("must be called after end()");
        }
        double d2 = this.f.getCountFlushed();
        double d3 = (this.imgInfo.bytesPerRow + 1) * this.imgInfo.rows;
        return d2 / d3;
    }

    public void end() {
        if (this.rowNum != this.imgInfo.rows - 1) {
            throw new PngjOutputException("all rows have not been written");
        }
        try {
            this.g.finish();
            this.f.flush();
            this.d();
            this.b();
            if (this.e) {
                this.k.close();
            }
        }
        catch (IOException iOException) {
            throw new PngjOutputException(iOException);
        }
    }

    public ChunksListForWrite getChunksList() {
        return this.b;
    }

    public String getFilename() {
        return this.a;
    }

    public PngMetadata getMetadata() {
        return this.c;
    }

    public void setCompLevel(int n2) {
        if (n2 < 0 || n2 > 9) {
            throw new PngjOutputException("Compression level invalid (" + n2 + ") Must be 0..9");
        }
        this.d = n2;
    }

    public void setFilterType(FilterType filterType) {
        this.filterStrat = new FilterWriteStrategy(this.imgInfo, filterType);
    }

    public void setIdatMaxSize(int n2) {
        this.j = n2;
    }

    public void setShouldCloseStream(boolean bl2) {
        this.e = bl2;
    }

    public void setDeflaterStrategy(int n2) {
        this.h = n2;
    }

    public void writeRow(ImageLine imageLine) {
        this.writeRow(imageLine.scanline, imageLine.getRown());
    }

    public void writeRow(ImageLine imageLine, int n2) {
        this.l = imageLine.samplesUnpacked;
        if (imageLine.sampleType == ImageLine.SampleType.INT) {
            this.writeRowInt(imageLine.scanline, n2);
        } else {
            this.writeRowByte(imageLine.scanlineb, n2);
        }
    }

    public void writeRow(int[] nArray) {
        this.writeRow(nArray, -1);
    }

    public void writeRow(int[] nArray, int n2) {
        this.writeRowInt(nArray, n2);
    }

    public void writeRowInt(int[] nArray, int n2) {
        this.b(n2);
        this.encodeRowFromInt(nArray);
        this.c(n2);
    }

    public void writeRowByte(byte[] byArray, int n2) {
        this.b(n2);
        this.encodeRowFromByte(byArray);
        this.c(n2);
    }

    public void writeRowsInt(int[][] nArray) {
        for (int i2 = 0; i2 < this.imgInfo.rows; ++i2) {
            this.writeRowInt(nArray[i2], i2);
        }
    }

    public void writeRowsByte(byte[][] byArray) {
        for (int i2 = 0; i2 < this.imgInfo.rows; ++i2) {
            this.writeRowByte(byArray[i2], i2);
        }
    }

    public boolean isUnpackedMode() {
        return this.l;
    }

    public void setUseUnPackedMode(boolean bl2) {
        this.l = bl2;
    }
}

