/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.ico;

import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.ico.BmpInfoHeader;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.imageio.stream.ImageInputStream;

class BmpDecoder {
    private final BufferedImage a;
    private final BmpInfoHeader b;
    static SortedMap<Integer, Integer> map64to8 = new TreeMap<Integer, Integer>();
    static SortedMap<Integer, Integer> map64to8cache = new TreeMap<Integer, Integer>();

    public static void clearCache() {
        map64to8cache.clear();
    }

    public static int getCacheSize() {
        return map64to8cache.size();
    }

    public static byte as8BitColorComponentCached(int n2) {
        if (map64to8.containsKey(n2)) {
            return ((Integer)map64to8.get(n2)).byteValue();
        }
        if (n2 >= 0 && n2 <= 8192) {
            if (map64to8cache.containsKey(n2)) {
                return ((Integer)map64to8cache.get(n2)).byteValue();
            }
            Integer n3 = map64to8.firstKey();
            for (Integer n4 : map64to8.keySet()) {
                if (n4 >= n2) {
                    Integer n5;
                    Integer n6 = n5 = n4 - n2 > n2 - n3 ? (Integer)map64to8.get(n3) : (Integer)map64to8.get(n4);
                    if (map64to8cache.size() > 1024) {
                        map64to8cache.remove(map64to8cache.firstKey());
                    }
                    map64to8cache.put(n2, n5);
                    return n5.byteValue();
                }
                n3 = n4;
            }
            return -1;
        }
        throw new IllegalArgumentException("colorComponent16bit must be in [0..8192] diapason");
    }

    public static byte as8BitColorComponent(int n2) {
        if (map64to8.containsKey(n2)) {
            return ((Integer)map64to8.get(n2)).byteValue();
        }
        if (n2 >= 0 && n2 <= 8192) {
            Integer n3 = map64to8.firstKey();
            for (Integer n4 : map64to8.keySet()) {
                if (n4 >= n2) {
                    return n4 - n2 > n2 - n3 ? ((Integer)map64to8.get(n3)).byteValue() : ((Integer)map64to8.get(n4)).byteValue();
                }
                n3 = n4;
            }
            return -1;
        }
        throw new IllegalArgumentException("colorComponent16bit must be in [0..8192] diapason");
    }

    public BmpDecoder(ImageInputStream imageInputStream, boolean bl2, boolean[] blArray, boolean bl3) throws IOException {
        byte[] byArray = new byte[]{0, 0};
        int n2 = imageInputStream.read(byArray);
        if (byArray[0] != 66 || byArray[1] != 77) {
            throw new IOException("Invalid signature '[" + byArray[0] + "," + byArray[1] + "]' for BMP format");
        }
        imageInputStream.readInt();
        imageInputStream.readInt();
        imageInputStream.readInt();
        this.b = BmpDecoder.readInfoHeader(imageInputStream);
        blArray[0] = this.b.bitCount == 64;
        this.a = bl3 ? null : BmpDecoder.read(this.b, imageInputStream, bl2);
    }

    public BmpInfoHeader getInfoHeader() {
        return this.b;
    }

    public BufferedImage getBufferedImage() {
        return this.a;
    }

    public static BmpInfoHeader readInfoHeader(ImageInputStream imageInputStream) throws IOException {
        BmpInfoHeader bmpInfoHeader = new BmpInfoHeader(imageInputStream, true);
        return bmpInfoHeader;
    }

    public static BmpInfoHeader readInfoHeader(ImageInputStream imageInputStream, int n2) throws IOException {
        BmpInfoHeader bmpInfoHeader = new BmpInfoHeader(imageInputStream, n2);
        return bmpInfoHeader;
    }

    private static BmpInfoHeader a(ImageInputStream imageInputStream, int n2, boolean bl2) throws IOException {
        BmpInfoHeader bmpInfoHeader = new BmpInfoHeader(imageInputStream, n2, bl2);
        return bmpInfoHeader;
    }

    private static void a(ColorEntry[] colorEntryArray, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 0; i2 < colorEntryArray.length; ++i2) {
            byArray[i2] = (byte)colorEntryArray[i2].c[2];
            byArray2[i2] = (byte)colorEntryArray[i2].c[1];
            byArray3[i2] = (byte)colorEntryArray[i2].c[0];
        }
    }

    private static ColorEntry[] a(BmpInfoHeader bmpInfoHeader, ImageInputStream imageInputStream) throws IOException {
        ColorEntry[] colorEntryArray = new ColorEntry[bmpInfoHeader.numColors];
        for (int i2 = 0; i2 < bmpInfoHeader.numColors; ++i2) {
            ColorEntry colorEntry;
            colorEntryArray[i2] = colorEntry = new ColorEntry(imageInputStream);
        }
        return colorEntryArray;
    }

    public static BufferedImage read(BmpInfoHeader bmpInfoHeader, ImageInputStream imageInputStream, boolean bl2) throws IOException {
        ColorEntry[] colorEntryArray = null;
        if (bmpInfoHeader.bitCount <= 8) {
            colorEntryArray = BmpDecoder.a(bmpInfoHeader, imageInputStream);
        }
        return BmpDecoder.read(bmpInfoHeader, imageInputStream, colorEntryArray, bl2);
    }

    public static BufferedImage read(BmpInfoHeader bmpInfoHeader, ImageInputStream imageInputStream, ColorEntry[] colorEntryArray, boolean bl2) throws IOException {
        BufferedImage bufferedImage = null;
        if (bmpInfoHeader.bitCount == 1 && bmpInfoHeader.compression == 0) {
            bufferedImage = BmpDecoder.read1bpp(bmpInfoHeader, imageInputStream, colorEntryArray);
        } else if (bmpInfoHeader.bitCount == 4 && bmpInfoHeader.compression == 0) {
            bufferedImage = BmpDecoder.read4bpp(bmpInfoHeader, imageInputStream, colorEntryArray);
        } else if (bmpInfoHeader.bitCount == 8 && bmpInfoHeader.compression == 0) {
            bufferedImage = BmpDecoder.read8bpp(bmpInfoHeader, imageInputStream, colorEntryArray);
        } else if (bmpInfoHeader.bitCount == 24 && bmpInfoHeader.compression == 0) {
            bufferedImage = BmpDecoder.read24bpp(bmpInfoHeader, imageInputStream);
        } else if (bmpInfoHeader.bitCount == 32 && bmpInfoHeader.compression == 0) {
            bufferedImage = BmpDecoder.read32bpp(bmpInfoHeader, imageInputStream, bl2);
        } else if (bmpInfoHeader.bitCount == 64 && bmpInfoHeader.compression == 0) {
            bufferedImage = BmpDecoder.read64bpp(bmpInfoHeader, imageInputStream, bl2);
        } else {
            throw new IOException("Unknown format: bits=" + bmpInfoHeader.bitCount + ", compression=" + bmpInfoHeader.compression);
        }
        return bufferedImage;
    }

    public static BufferedImage read1bpp(BmpInfoHeader bmpInfoHeader, ImageInputStream imageInputStream, ColorEntry[] colorEntryArray) throws IOException {
        int n2;
        byte[] byArray = new byte[colorEntryArray.length];
        byte[] byArray2 = new byte[colorEntryArray.length];
        byte[] byArray3 = new byte[colorEntryArray.length];
        BmpDecoder.a(colorEntryArray, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(bmpInfoHeader.width, bmpInfoHeader.height, 12, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = n2 = bmpInfoHeader.width;
        if (n3 % 32 != 0) {
            n3 = (n3 / 32 + 1) * 32;
        }
        int n4 = n3 - n2;
        int n5 = n4 / 8;
        int n6 = n3 / 8;
        int[] nArray = new int[n6];
        for (int i2 = bmpInfoHeader.height - 1; i2 >= 0; --i2) {
            int n7;
            for (n7 = 0; n7 < n6; ++n7) {
                nArray[n7] = imageInputStream.readUnsignedByte();
            }
            for (n7 = 0; n7 < bmpInfoHeader.width; ++n7) {
                int n8 = n7 / 8;
                int n9 = nArray[n8];
                int n10 = n7 % 8;
                int n11 = n9 >> 7 - n10 & 1;
                writableRaster.setSample(n7, i2, 0, n11);
            }
        }
        return bufferedImage;
    }

    public static BufferedImage read4bpp(BmpInfoHeader bmpInfoHeader, ImageInputStream imageInputStream, ColorEntry[] colorEntryArray) throws IOException {
        byte[] byArray = new byte[colorEntryArray.length];
        byte[] byArray2 = new byte[colorEntryArray.length];
        byte[] byArray3 = new byte[colorEntryArray.length];
        BmpDecoder.a(colorEntryArray, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(4, bmpInfoHeader.numColors, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(bmpInfoHeader.width, bmpInfoHeader.height, 12, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = bmpInfoHeader.width * 4;
        if (n2 % 32 != 0) {
            n2 = (n2 / 32 + 1) * 32;
        }
        int n3 = n2 / 8;
        int[] nArray = new int[n3];
        for (int i2 = bmpInfoHeader.height - 1; i2 >= 0; --i2) {
            int n4;
            int n5;
            for (n5 = 0; n5 < n3; ++n5) {
                nArray[n5] = n4 = imageInputStream.readUnsignedByte();
            }
            for (n5 = 0; n5 < bmpInfoHeader.width; ++n5) {
                n4 = n5 / 2;
                int n6 = n5 % 2;
                int n7 = nArray[n4];
                int n8 = n7 >> 4 * (1 - n6) & 0xF;
                writableRaster.setSample(n5, i2, 0, n8);
            }
        }
        return bufferedImage;
    }

    public static BufferedImage read8bpp(BmpInfoHeader bmpInfoHeader, ImageInputStream imageInputStream, ColorEntry[] colorEntryArray) throws IOException {
        int n2;
        byte[] byArray = new byte[colorEntryArray.length];
        byte[] byArray2 = new byte[colorEntryArray.length];
        byte[] byArray3 = new byte[colorEntryArray.length];
        BmpDecoder.a(colorEntryArray, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(8, bmpInfoHeader.numColors, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(bmpInfoHeader.width, bmpInfoHeader.height, 13, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = n2 = bmpInfoHeader.width;
        if (n3 % 4 != 0) {
            n3 = (n3 / 4 + 1) * 4;
        }
        int n4 = n3 - n2;
        for (int i2 = bmpInfoHeader.height - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < bmpInfoHeader.width; ++i3) {
                int n5 = imageInputStream.readUnsignedByte();
                writableRaster.setSample(i3, i2, 0, n5);
            }
            imageInputStream.skipBytes(n4);
        }
        return bufferedImage;
    }

    public static BufferedImage read24bpp(BmpInfoHeader bmpInfoHeader, ImageInputStream imageInputStream) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(bmpInfoHeader.width, bmpInfoHeader.height, 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = bmpInfoHeader.width * 3;
        int n3 = n2;
        if (n3 % 4 != 0) {
            n3 = (n3 / 4 + 1) * 4;
        }
        int n4 = n3 - n2;
        for (int i2 = bmpInfoHeader.height - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < bmpInfoHeader.width; ++i3) {
                int n5 = imageInputStream.readUnsignedByte();
                int n6 = imageInputStream.readUnsignedByte();
                int n7 = imageInputStream.readUnsignedByte();
                writableRaster.setSample(i3, i2, 0, n7);
                writableRaster.setSample(i3, i2, 1, n6);
                writableRaster.setSample(i3, i2, 2, n5);
            }
            imageInputStream.skipBytes(n4);
        }
        return bufferedImage;
    }

    public static BufferedImage read32bpp(BmpInfoHeader bmpInfoHeader, ImageInputStream imageInputStream, boolean bl2) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(bmpInfoHeader.width, bmpInfoHeader.height, bl2 ? 2 : 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bl2 ? bufferedImage.getAlphaRaster() : null;
        for (int i2 = bmpInfoHeader.height - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < bmpInfoHeader.width; ++i3) {
                int n2 = imageInputStream.readUnsignedByte();
                int n3 = imageInputStream.readUnsignedByte();
                int n4 = imageInputStream.readUnsignedByte();
                int n5 = imageInputStream.readUnsignedByte();
                writableRaster.setSample(i3, i2, 0, n4);
                writableRaster.setSample(i3, i2, 1, n3);
                writableRaster.setSample(i3, i2, 2, n2);
                if (writableRaster2 == null) continue;
                writableRaster2.setSample(i3, i2, 0, n5);
            }
        }
        return bufferedImage;
    }

    public static BufferedImage read64bpp(BmpInfoHeader bmpInfoHeader, ImageInputStream imageInputStream, boolean bl2) throws IOException {
        bl2 = true;
        BufferedImage bufferedImage = new BufferedImage(bmpInfoHeader.width, bmpInfoHeader.height, bl2 ? 2 : 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bl2 ? bufferedImage.getAlphaRaster() : null;
        for (int i2 = bmpInfoHeader.height - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < bmpInfoHeader.width; ++i3) {
                short s2 = imageInputStream.readShort();
                short s3 = imageInputStream.readShort();
                short s4 = imageInputStream.readShort();
                short s5 = imageInputStream.readShort();
                writableRaster.setSample(i3, i2, 0, BmpDecoder.as8BitColorComponent(s4));
                writableRaster.setSample(i3, i2, 1, BmpDecoder.as8BitColorComponent(s3));
                writableRaster.setSample(i3, i2, 2, BmpDecoder.as8BitColorComponent(s2));
                if (writableRaster2 == null) continue;
                writableRaster2.setSample(i3, i2, 0, BmpDecoder.as8BitColorComponent(s5));
            }
        }
        return bufferedImage;
    }

    public static BufferedImage read(ImageInputStream imageInputStream, boolean bl2) throws IOException {
        BmpDecoder bmpDecoder = new BmpDecoder(imageInputStream, bl2, new boolean[]{false}, false);
        return bmpDecoder.getBufferedImage();
    }

    public static boolean is64bit(ImageInputStream imageInputStream) throws IOException {
        boolean[] blArray = new boolean[]{false};
        new BmpDecoder(imageInputStream, false, blArray, true);
        return blArray[0];
    }

    static {
        map64to8.put(0, 0);
        map64to8.put(2, 1);
        map64to8.put(5, 2);
        map64to8.put(7, 3);
        map64to8.put(10, 4);
        map64to8.put(12, 5);
        map64to8.put(15, 6);
        map64to8.put(17, 7);
        map64to8.put(20, 8);
        map64to8.put(22, 9);
        map64to8.put(25, 10);
        map64to8.put(27, 11);
        map64to8.put(30, 12);
        map64to8.put(33, 13);
        map64to8.put(36, 14);
        map64to8.put(39, 15);
        map64to8.put(42, 16);
        map64to8.put(46, 17);
        map64to8.put(50, 18);
        map64to8.put(53, 19);
        map64to8.put(57, 20);
        map64to8.put(61, 21);
        map64to8.put(66, 22);
        map64to8.put(70, 23);
        map64to8.put(75, 24);
        map64to8.put(80, 25);
        map64to8.put(85, 26);
        map64to8.put(90, 27);
        map64to8.put(95, 28);
        map64to8.put(101, 29);
        map64to8.put(106, 30);
        map64to8.put(112, 31);
        map64to8.put(118, 32);
        map64to8.put(125, 33);
        map64to8.put(131, 34);
        map64to8.put(138, 35);
        map64to8.put(145, 36);
        map64to8.put(152, 37);
        map64to8.put(159, 38);
        map64to8.put(166, 39);
        map64to8.put(174, 40);
        map64to8.put(182, 41);
        map64to8.put(190, 42);
        map64to8.put(198, 43);
        map64to8.put(206, 44);
        map64to8.put(215, 45);
        map64to8.put(224, 46);
        map64to8.put(233, 47);
        map64to8.put(242, 48);
        map64to8.put(252, 49);
        map64to8.put(261, 50);
        map64to8.put(271, 51);
        map64to8.put(281, 52);
        map64to8.put(292, 53);
        map64to8.put(302, 54);
        map64to8.put(313, 55);
        map64to8.put(324, 56);
        map64to8.put(335, 57);
        map64to8.put(347, 58);
        map64to8.put(358, 59);
        map64to8.put(370, 60);
        map64to8.put(382, 61);
        map64to8.put(395, 62);
        map64to8.put(407, 63);
        map64to8.put(420, 64);
        map64to8.put(433, 65);
        map64to8.put(446, 66);
        map64to8.put(460, 67);
        map64to8.put(474, 68);
        map64to8.put(488, 69);
        map64to8.put(502, 70);
        map64to8.put(516, 71);
        map64to8.put(531, 72);
        map64to8.put(546, 73);
        map64to8.put(561, 74);
        map64to8.put(576, 75);
        map64to8.put(592, 76);
        map64to8.put(608, 77);
        map64to8.put(624, 78);
        map64to8.put(641, 79);
        map64to8.put(657, 80);
        map64to8.put(674, 81);
        map64to8.put(691, 82);
        map64to8.put(709, 83);
        map64to8.put(726, 84);
        map64to8.put(744, 85);
        map64to8.put(762, 86);
        map64to8.put(781, 87);
        map64to8.put(799, 88);
        map64to8.put(818, 89);
        map64to8.put(838, 90);
        map64to8.put(857, 91);
        map64to8.put(877, 92);
        map64to8.put(897, 93);
        map64to8.put(917, 94);
        map64to8.put(937, 95);
        map64to8.put(958, 96);
        map64to8.put(979, 97);
        map64to8.put(1001, 98);
        map64to8.put(1022, 99);
        map64to8.put(1044, 100);
        map64to8.put(1066, 101);
        map64to8.put(1088, 102);
        map64to8.put(1111, 103);
        map64to8.put(1134, 104);
        map64to8.put(1157, 105);
        map64to8.put(1181, 106);
        map64to8.put(1204, 107);
        map64to8.put(1228, 108);
        map64to8.put(1253, 109);
        map64to8.put(1277, 110);
        map64to8.put(1302, 111);
        map64to8.put(1327, 112);
        map64to8.put(1353, 113);
        map64to8.put(1378, 114);
        map64to8.put(1404, 115);
        map64to8.put(1431, 116);
        map64to8.put(1457, 117);
        map64to8.put(1484, 118);
        map64to8.put(1511, 119);
        map64to8.put(1539, 120);
        map64to8.put(1566, 121);
        map64to8.put(1594, 122);
        map64to8.put(1623, 123);
        map64to8.put(1651, 124);
        map64to8.put(1680, 125);
        map64to8.put(1709, 126);
        map64to8.put(1739, 127);
        map64to8.put(1768, 128);
        map64to8.put(1798, 129);
        map64to8.put(1829, 130);
        map64to8.put(1859, 131);
        map64to8.put(1890, 132);
        map64to8.put(1921, 133);
        map64to8.put(1953, 134);
        map64to8.put(1985, 135);
        map64to8.put(2017, 136);
        map64to8.put(2049, 137);
        map64to8.put(2082, 138);
        map64to8.put(2115, 139);
        map64to8.put(2148, 140);
        map64to8.put(2182, 141);
        map64to8.put(2216, 142);
        map64to8.put(2250, 143);
        map64to8.put(2285, 144);
        map64to8.put(2320, 145);
        map64to8.put(2355, 146);
        map64to8.put(2390, 147);
        map64to8.put(2426, 148);
        map64to8.put(2462, 149);
        map64to8.put(2498, 150);
        map64to8.put(2535, 151);
        map64to8.put(2572, 152);
        map64to8.put(2610, 153);
        map64to8.put(2647, 154);
        map64to8.put(2685, 155);
        map64to8.put(2723, 156);
        map64to8.put(2762, 157);
        map64to8.put(2801, 158);
        map64to8.put(2840, 159);
        map64to8.put(2880, 160);
        map64to8.put(2920, 161);
        map64to8.put(2960, 162);
        map64to8.put(3000, 163);
        map64to8.put(3041, 164);
        map64to8.put(3082, 165);
        map64to8.put(3124, 166);
        map64to8.put(3166, 167);
        map64to8.put(3208, 168);
        map64to8.put(3250, 169);
        map64to8.put(3293, 170);
        map64to8.put(3336, 171);
        map64to8.put(3380, 172);
        map64to8.put(3423, 173);
        map64to8.put(3467, 174);
        map64to8.put(3512, 175);
        map64to8.put(3557, 176);
        map64to8.put(3602, 177);
        map64to8.put(3647, 178);
        map64to8.put(3693, 179);
        map64to8.put(3739, 180);
        map64to8.put(3785, 181);
        map64to8.put(3832, 182);
        map64to8.put(3879, 183);
        map64to8.put(3927, 184);
        map64to8.put(3974, 185);
        map64to8.put(4022, 186);
        map64to8.put(4071, 187);
        map64to8.put(4120, 188);
        map64to8.put(4169, 189);
        map64to8.put(4218, 190);
        map64to8.put(4268, 191);
        map64to8.put(4318, 192);
        map64to8.put(4369, 193);
        map64to8.put(4419, 194);
        map64to8.put(4471, 195);
        map64to8.put(4522, 196);
        map64to8.put(4574, 197);
        map64to8.put(4626, 198);
        map64to8.put(4679, 199);
        map64to8.put(4732, 200);
        map64to8.put(4785, 201);
        map64to8.put(4838, 202);
        map64to8.put(4892, 203);
        map64to8.put(4947, 204);
        map64to8.put(5001, 205);
        map64to8.put(5056, 206);
        map64to8.put(5111, 207);
        map64to8.put(5167, 208);
        map64to8.put(5223, 209);
        map64to8.put(5280, 210);
        map64to8.put(5336, 211);
        map64to8.put(5393, 212);
        map64to8.put(5451, 213);
        map64to8.put(5509, 214);
        map64to8.put(5567, 215);
        map64to8.put(5625, 216);
        map64to8.put(5684, 217);
        map64to8.put(5743, 218);
        map64to8.put(5803, 219);
        map64to8.put(5863, 220);
        map64to8.put(5923, 221);
        map64to8.put(5984, 222);
        map64to8.put(6045, 223);
        map64to8.put(6106, 224);
        map64to8.put(6168, 225);
        map64to8.put(6230, 226);
        map64to8.put(6293, 227);
        map64to8.put(6356, 228);
        map64to8.put(6419, 229);
        map64to8.put(6482, 230);
        map64to8.put(6546, 231);
        map64to8.put(6611, 232);
        map64to8.put(6675, 233);
        map64to8.put(6740, 234);
        map64to8.put(6806, 235);
        map64to8.put(6871, 236);
        map64to8.put(6938, 237);
        map64to8.put(7004, 238);
        map64to8.put(7071, 239);
        map64to8.put(7138, 240);
        map64to8.put(7206, 241);
        map64to8.put(7274, 242);
        map64to8.put(7342, 243);
        map64to8.put(7411, 244);
        map64to8.put(7480, 245);
        map64to8.put(7550, 246);
        map64to8.put(7619, 247);
        map64to8.put(7690, 248);
        map64to8.put(7760, 249);
        map64to8.put(7831, 250);
        map64to8.put(7903, 251);
        map64to8.put(7974, 252);
        map64to8.put(8047, 253);
        map64to8.put(8119, 254);
        map64to8.put(8192, 255);
    }

    static class ColorEntry {
        public int[] c = new int[4];

        public ColorEntry(ImageInputStream imageInputStream) throws IOException {
            this.c[0] = imageInputStream.readUnsignedByte();
            this.c[1] = imageInputStream.readUnsignedByte();
            this.c[2] = imageInputStream.readUnsignedByte();
            this.c[3] = imageInputStream.readUnsignedByte();
        }

        public ColorEntry(int n2, int n3, int n4, int n5) {
            this.c[0] = n4;
            this.c[1] = n3;
            this.c[2] = n2;
            this.c[3] = n5;
        }
    }
}

