/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ImageOptionsBase;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ResolutionSetting;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.TiffImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffRational;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.Group3Options;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffAlphaStorage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffCompressions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffFillOrders;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffNewSubFileTypes;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffOrientations;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffPhotometrics;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffPlanarConfigs;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffPredictor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffResolutionUnits;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.enums.TiffThresholds;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.instancefactory.ITiffTagCreator;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.instancefactory.creators.TiffAsciiCreator;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.instancefactory.creators.TiffByteCreator;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.instancefactory.creators.TiffLongCreator;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.instancefactory.creators.TiffRationalCreator;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.instancefactory.creators.TiffShortCreator;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffASCIIType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffByteType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffLongType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffRationalType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffShortType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffUndefinedType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffUnknownType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.lang.Operators;

public class TiffOptions
extends ImageOptionsBase {
    private final Dictionary<Integer, TiffDataType> a = new Dictionary();
    private final List<TiffDataType> b = new List();
    private int c = 18761;
    private boolean d;

    public TiffOptions(int n2, int n3) {
        switch (n2) {
            case 8: {
                this.setCompression(2);
                break;
            }
            case 4: {
                this.setCompression(3);
                break;
            }
            case 5: {
                this.setCompression(4);
                break;
            }
            case 6: {
                this.setCompression(8);
                break;
            }
            case 7: {
                this.setCompression(8);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 9: {
                this.setCompression(7);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 10: {
                this.setCompression(7);
                this.setPhotometric(6);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 1: {
                this.setCompression(5);
                break;
            }
            case 2: {
                this.setCompression(5);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 3: {
                this.setCompression(5);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                this.setAlphaStorage(2);
                break;
            }
            case 12: {
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 13: {
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                this.setAlphaStorage(2);
            }
        }
        this.c = n3;
    }

    public TiffOptions(int n2) {
        this(n2, 18761);
    }

    public TiffOptions(TiffOptions tiffOptions) {
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        if (tiffOptions.b != null) {
            this.a(tiffOptions.b.toArray((TiffDataType[])new TiffDataType[0]));
        }
    }

    public TiffOptions(TiffDataType[] tiffDataTypeArray) {
        if (tiffDataTypeArray == null) {
            throw new ArgumentNullException("tags");
        }
        this.a(tiffDataTypeArray);
    }

    public boolean isValid() {
        return this.a(true);
    }

    public String getArtist() {
        return this.d(315);
    }

    public void setArtist(String string) {
        this.a(315, string);
    }

    public boolean isTagPresent(int n2) {
        return this.a.containsKey(n2);
    }

    public int getByteOrder() {
        return this.c;
    }

    public void setByteOrder(int n2) {
        this.c = n2;
    }

    public int[] getBitsPerSample() {
        int[] nArray = this.b(258);
        if (nArray == null) {
            nArray = new int[]{1};
        } else if (nArray.length < (this.getSamplesPerPixel() & 0xFFFF) && this.getPhotometric() == 2) {
            TiffShortType tiffShortType;
            int n2 = this.getSamplesPerPixel() & 0xFFFF;
            int[] nArray2 = new int[n2];
            Array.copy(Array.boxing(nArray), Array.boxing(nArray2), nArray.length);
            TiffDataType tiffDataType = this.getTagByType(338);
            int n3 = 0;
            if (Operators.is(tiffDataType, TiffShortType.class) && (tiffShortType = Operators.as(tiffDataType, TiffShortType.class)).getValues() != null) {
                n3 = tiffShortType.getValues().length;
            }
            for (int i2 = n3; i2 > 0; --i2) {
                nArray2[nArray2.length - i2] = 8;
            }
            nArray = nArray2;
        }
        return nArray;
    }

    public void setBitsPerSample(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        if (nArray.length == 0) {
            throw new ArgumentOutOfRangeException("value", "At least single array value must be specified.");
        }
        this.a(258, nArray);
        this.a(277, (Type)null, nArray.length & 0xFFFF);
    }

    public int getCompression() {
        return this.a(259, 1) & 0xFFFF;
    }

    public void setCompression(int n2) {
        this.a(259, Operators.typeOf(TiffCompressions.class), n2);
    }

    public String getCopyright() {
        return this.d(33432);
    }

    public void setCopyright(String string) {
        this.a(33432, string);
    }

    public int[] getColorMap() {
        return this.b(320);
    }

    public void setColorMap(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        if ((this.getSamplesPerPixel() & 0xFFFF) != 1) {
            throw new InvalidOperationException("TiffImageException: The color map may be defined for samples per pixel equal to 1 only.");
        }
        int n2 = this.getBitsPerPixel();
        if (n2 == 0) {
            throw new InvalidOperationException("TiffImageException: The bits per sample are not defined.");
        }
        int n3 = (int)(3.0 * msMath.pow(2.0, n2));
        if (nArray.length != n3) {
            throw new ArgumentOutOfRangeException("value", "The array length must correspond to the followign formula: 3 * (2**BitsPerSample).");
        }
        this.a(320, nArray);
    }

    @Override
    public IColorPalette getPalette() {
        return this.a();
    }

    @Override
    public void setPalette(IColorPalette iColorPalette) {
        if (iColorPalette == null || iColorPalette.getEntriesCount() == 0) {
            this.removeTag(320);
        } else {
            int[] nArray = iColorPalette.getArgb32Entries();
            int n2 = iColorPalette.getEntriesCount();
            int n3 = this.getBitsPerPixel();
            if (n3 == 0) {
                throw new InvalidOperationException("TiffImageException: The bits per sample are not defined. Please specify the BitsPerSample first.");
            }
            int n4 = (int)msMath.pow(2.0, n3);
            int[] nArray2 = new int[3 * n4];
            n2 = msMath.min(n2, n4);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5 = nArray[i2];
                int n6 = n5 >> 16 & 0xFF;
                int n7 = n5 >> 8 & 0xFF;
                int n8 = n5 & 0xFF;
                nArray2[i2] = (byte)n6 & 0xFF;
                nArray2[i2 + n4] = (byte)n7 & 0xFF;
                nArray2[i2 + n4 * 2] = (byte)n8 & 0xFF;
            }
            this.setColorMap(nArray2);
            this.d = iColorPalette.isCompactPalette();
        }
    }

    public String getDateTime() {
        return this.d(306);
    }

    public void setDateTime(String string) {
        this.a(306, string);
    }

    public String getDocumentName() {
        return this.d(269);
    }

    public void setDocumentName(String string) {
        this.a(269, string);
    }

    public int getAlphaStorage() {
        return this.a(338, 0) & 0xFFFF;
    }

    public void setAlphaStorage(int n2) {
        this.a(338, Operators.typeOf(TiffAlphaStorage.class), n2);
    }

    public int getFillOrder() {
        return this.a(266, 1) & 0xFFFF;
    }

    public void setFillOrder(int n2) {
        this.a(266, Operators.typeOf(TiffFillOrders.class), n2);
    }

    public int[] getHalfToneHints() {
        return this.b(321);
    }

    public void setHalfToneHints(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        if (nArray.length != 2) {
            throw new ArgumentOutOfRangeException("value", "Halftone hints array length must be equal to 2.");
        }
        this.a(321, nArray);
    }

    public String getImageDescription() {
        return this.d(270);
    }

    public void setImageDescription(String string) {
        this.a(270, string);
    }

    public String getInkNames() {
        return this.d(333);
    }

    public void setInkNames(String string) {
        this.a(333, string);
    }

    public String getScannerManufacturer() {
        return this.d(271);
    }

    public void setScannerManufacturer(String string) {
        this.a(271, string);
    }

    public int[] getMaxSampleValue() {
        int[] nArray = this.b(281);
        if (nArray == null) {
            int[] nArray2 = this.getBitsPerSample();
            nArray = new int[nArray2.length];
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                int n2;
                nArray[i2] = n2 = Operators.castToUInt16(Operators.castToInt32(msMath.pow(2.0, Operators.castToDouble(nArray2[i2], 8)), 14) - 1, 9);
            }
        }
        return nArray;
    }

    public void setMaxSampleValue(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        if (nArray.length != Operators.castToUInt16(this.getSamplesPerPixel(), 8)) {
            throw new ArgumentOutOfRangeException("value", "The array length must correspond to the samples per pixel count.");
        }
        this.a(281, nArray);
    }

    public int[] getMinSampleValue() {
        int[] nArray = this.b(280);
        if (nArray == null) {
            nArray = new int[this.getSamplesPerPixel()];
        }
        return nArray;
    }

    public void setMinSampleValue(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        if (nArray.length != Operators.castToUInt16(this.getSamplesPerPixel(), 8)) {
            throw new ArgumentOutOfRangeException("value", "The array length must correspond to the samples per pixel count.");
        }
        this.a(280, nArray);
    }

    public String getScannerModel() {
        return this.d(272);
    }

    public void setScannerModel(String string) {
        this.a(272, string);
    }

    public int getOrientation() {
        return Operators.castToUInt16(this.a(274, 1), 8);
    }

    public void setOrientation(int n2) {
        this.a(274, Operators.typeOf(TiffOrientations.class), n2);
    }

    public String getPageName() {
        return this.d(285);
    }

    public void setPageName(String string) {
        this.a(285, string);
    }

    public int[] getPageNumber() {
        return this.b(297);
    }

    public void setPageNumber(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        if (nArray.length != 2) {
            throw new ArgumentOutOfRangeException("value", "Expected 2 values in the array: PageNumber[0] is the page number and PageNumber[1] is the total number of pages in the document.");
        }
        this.a(297, nArray);
    }

    public int getPhotometric() {
        return Operators.castToUInt16(this.a(262, 0), 8);
    }

    public void setPhotometric(int n2) {
        this.a(262, Operators.typeOf(TiffPhotometrics.class), n2);
    }

    public int getPlanarConfiguration() {
        return Operators.castToUInt16(this.a(284, 1), 8);
    }

    public void setPlanarConfiguration(int n2) {
        this.a(284, Operators.typeOf(TiffPlanarConfigs.class), n2);
    }

    public int getResolutionUnit() {
        return Operators.castToUInt16(this.a(296, 2), 8);
    }

    public void setResolutionUnit(int n2) {
        this.a(296, Operators.typeOf(TiffResolutionUnits.class), n2);
    }

    public long getRowsPerStrip() {
        return this.b(278, 0xFFFFFFFFL);
    }

    public void setRowsPerStrip(long l2) {
        this.a(278, new long[]{l2}, false);
    }

    public int[] getSampleFormat() {
        int[] nArray;
        int[] nArray2 = this.b(339);
        if (nArray2 == null) {
            nArray = new int[this.getSamplesPerPixel()];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = 1;
            }
        } else {
            nArray = new int[nArray2.length];
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                nArray[i3] = Operators.castToInt32(nArray2[i3], 8);
            }
        }
        return nArray;
    }

    public void setSampleFormat(int[] nArray) {
        this.a(Array.boxing(nArray), Operators.castToInt32(this.getSamplesPerPixel(), 8), "samples per pixel.");
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = nArray[i2];
        }
        this.a(339, nArray2);
    }

    public int getSamplesPerPixel() {
        return this.a(277, 1);
    }

    public long[] getSmaxSampleValue() {
        return this.a(341, 0xFFFFFFFFL, Operators.castToInt32(this.getSamplesPerPixel(), 8));
    }

    public void setSmaxSampleValue(long[] lArray) {
        this.a(Array.boxing(lArray), Operators.castToInt32(this.getSamplesPerPixel(), 8), "samples per pixel.");
        this.a(341, lArray, true);
    }

    public long[] getSminSampleValue() {
        return this.a(340, 0L, Operators.castToInt32(this.getSamplesPerPixel(), 8));
    }

    public void setSminSampleValue(long[] lArray) {
        this.a(Array.boxing(lArray), Operators.castToInt32(this.getSamplesPerPixel(), 8), "samples per pixel.");
        this.a(340, lArray, true);
    }

    public String getSoftwareType() {
        return this.d(305);
    }

    public void setSoftwareType(String string) {
        this.a(305, string);
    }

    public long[] getStripByteCounts() {
        return this.a(279);
    }

    public void setStripByteCounts(long[] lArray) {
        this.a(279, lArray, false);
    }

    public long[] getStripOffsets() {
        return this.a(273);
    }

    public void setStripOffsets(long[] lArray) {
        this.a(273, lArray, false);
    }

    public long getSubFileType() {
        return Operators.castToUInt32(this.a(254, 0L), 10);
    }

    public void setSubFileType(long l2) {
        this.a(254, Operators.typeOf(TiffNewSubFileTypes.class), l2);
    }

    public String getTargetPrinter() {
        return this.d(337);
    }

    public void setTargetPrinter(String string) {
        this.a(337, string);
    }

    public int getThreshholding() {
        return Operators.castToUInt16(this.a(263, 1), 8);
    }

    public void setThreshholding(int n2) {
        this.a(263, Operators.typeOf(TiffThresholds.class), n2);
    }

    public int getTotalPages() {
        int n2 = 0;
        TiffShortType tiffShortType = Operators.as(this.getTagByType(297), TiffShortType.class);
        if (tiffShortType != null && tiffShortType.getValues() != null && tiffShortType.getValues().length > 1) {
            n2 = tiffShortType.getValues()[1];
        }
        return n2;
    }

    public TiffRational getXposition() {
        return this.c(286);
    }

    public void setXposition(TiffRational tiffRational) {
        this.a(286, null, tiffRational);
    }

    @Override
    public ResolutionSetting getResolutionSettings() {
        return super.getResolutionSettings();
    }

    @Override
    public void setResolutionSettings(ResolutionSetting resolutionSetting) {
        super.setResolutionSettings(resolutionSetting);
        if (resolutionSetting != null) {
            this.setXresolution(new TiffRational(Operators.castToUInt32(resolutionSetting.getHorizontalResolution(), 14), 1L));
            this.setYresolution(new TiffRational(Operators.castToUInt32(resolutionSetting.getVerticalResolution(), 14), 1L));
        } else {
            this.setXresolution(null);
            this.setYresolution(null);
        }
    }

    public TiffRational getXresolution() {
        return this.c(282);
    }

    public void setXresolution(TiffRational tiffRational) {
        this.a(282, null, tiffRational);
    }

    public TiffRational getYposition() {
        return this.c(287);
    }

    public void setYposition(TiffRational tiffRational) {
        this.a(287, null, tiffRational);
    }

    public TiffRational getYresolution() {
        return this.c(283);
    }

    public void setYresolution(TiffRational tiffRational) {
        this.a(283, null, tiffRational);
    }

    public long getFaxT4Options() {
        return Operators.castToUInt32(this.a(292, 0L), 10);
    }

    public void setFaxT4Options(long l2) {
        this.a(292, Operators.typeOf(Group3Options.class), l2);
    }

    public int getPredictor() {
        return Operators.castToUInt16(this.a(317, 1), 8);
    }

    public void setPredictor(int n2) {
        this.a(317, Operators.typeOf(TiffPredictor.class), n2);
    }

    public long getImageLength() {
        return this.b(257, 0L);
    }

    public void setImageLength(long l2) {
        this.a(257, new long[]{l2}, false);
    }

    public long getImageWidth() {
        return this.b(256, 0L);
    }

    public void setImageWidth(long l2) {
        this.a(256, new long[]{l2}, false);
    }

    public byte[] getIccProfile() {
        TiffDataType tiffDataType = this.getTagByType(34675);
        if (tiffDataType != null && tiffDataType instanceof TiffUndefinedType) {
            TiffUndefinedType tiffUndefinedType = (TiffUndefinedType)tiffDataType;
            return tiffUndefinedType.getData();
        }
        return null;
    }

    public TiffDataType[] getTags() {
        return this.b.toArray((TiffDataType[])new TiffDataType[0]);
    }

    public void setTags(TiffDataType[] tiffDataTypeArray) {
        this.b.clear();
        this.a.clear();
        if (tiffDataTypeArray != null) {
            for (int i2 = 0; i2 < tiffDataTypeArray.length; ++i2) {
                this.addTag(tiffDataTypeArray[i2]);
            }
        }
    }

    public int getValidTagCount() {
        return TiffOptions.getValidTagsCount(this.b.toArray((TiffDataType[])new TiffDataType[0]));
    }

    public int getBitsPerPixel() {
        int[] nArray = this.getBitsPerSample();
        int n2 = 0;
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                n2 += Operators.castToInt32(nArray[i2], 8);
            }
        }
        return n2;
    }

    public boolean removeTag(int n2) {
        boolean bl2 = false;
        if (this.a.containsKey(n2)) {
            TiffDataType tiffDataType = this.a.get_Item(n2);
            this.a.removeItemByKey(n2);
            this.b.removeItem(tiffDataType);
            bl2 = true;
        }
        return bl2;
    }

    public void validate() {
        this.a(false);
    }

    public void addTags(TiffDataType[] tiffDataTypeArray) {
        if (tiffDataTypeArray == null) {
            throw new ArgumentNullException("tagsToAdd");
        }
        for (int i2 = 0; i2 < tiffDataTypeArray.length; ++i2) {
            this.addTag(tiffDataTypeArray[i2]);
        }
    }

    public void addTag(TiffDataType tiffDataType) {
        if (tiffDataType == null) {
            throw new ArgumentNullException("tagToAdd");
        }
        if (!this.a.containsKey(tiffDataType.getTagId())) {
            this.b.addItem(tiffDataType);
        }
        this.a.set_Item(tiffDataType.getTagId(), tiffDataType);
    }

    public TiffDataType getTagByType(int n2) {
        TiffDataType tiffDataType = null;
        if (this.a.containsKey(n2)) {
            tiffDataType = this.a.get_Item(n2);
        }
        return tiffDataType;
    }

    public static int getValidTagsCount(TiffDataType[] tiffDataTypeArray) {
        int n2 = 0;
        if (tiffDataTypeArray != null) {
            for (TiffDataType tiffDataType : tiffDataTypeArray) {
                if (tiffDataType == null || Operators.is(tiffDataType, TiffUnknownType.class) || !tiffDataType.isValid()) continue;
                ++n2;
            }
        }
        return n2;
    }

    private IColorPalette a() {
        ColorPalette colorPalette = null;
        int[] nArray = this.getColorMap();
        if (nArray != null) {
            int[] nArray2;
            boolean bl2 = false;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (Operators.castToUInt16(nArray[i2], 8) <= 255) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                int[] nArray3 = new int[nArray.length];
                for (int i3 = 0; i3 < nArray3.length; ++i3) {
                    nArray3[i3] = Operators.castToUInt16(Operators.castToUInt16(nArray[i3], 8) >> 8 & 0xFF, 9);
                }
                nArray2 = nArray3;
            } else {
                nArray2 = nArray;
            }
            int n2 = nArray2.length / 3;
            if (n2 > 0) {
                int[] nArray4 = new int[n2];
                for (int i4 = 0; i4 < nArray4.length; ++i4) {
                    nArray4[i4] = ColorHelper.toArgb(Operators.castToInt32(nArray2[i4], 8), Operators.castToInt32(nArray2[i4 + n2], 8), Operators.castToInt32(nArray2[i4 + n2 * 2], 8));
                }
                colorPalette = new ColorPalette(nArray4, this.d);
            }
        }
        return colorPalette;
    }

    private void a(Array array, int n2, String string) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getLength() != n2) {
            throw new ArgumentOutOfRangeException("array", StringExtensions.concat("The array length is not valid. Expected length equal to ", string));
        }
    }

    private long[] a(int n2) {
        long[] lArray = null;
        TiffDataType tiffDataType = this.getTagByType(n2);
        if (tiffDataType != null && Operators.is(tiffDataType.getValue(), Array.class)) {
            Array array = Operators.as(tiffDataType.getValue(), Array.class);
            lArray = new long[array.getLength()];
            for (int i2 = 0; i2 < array.getLength(); ++i2) {
                lArray[i2] = Convert.toUInt32(array.getValue(i2));
            }
        }
        return lArray;
    }

    private long[] a(int n2, long l2, int n3) {
        long[] lArray = this.a(n2);
        if (lArray == null) {
            lArray = new long[n3];
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                lArray[i2] = l2;
            }
        }
        return lArray;
    }

    private void a(int n2, long[] lArray, boolean bl2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (Operators.castToUInt32(lArray[i2], 10) <= Operators.castToUInt32(l2, 10)) continue;
            l2 = lArray[i2];
        }
        if (bl2 && Operators.castToUInt32(l2, 10) <= 255L) {
            byte[] byArray = new byte[lArray.length];
            for (int i3 = 0; i3 < lArray.length; ++i3) {
                byArray[i3] = Operators.castToByte(lArray[i3], 10);
            }
            TiffDataType tiffDataType = this.getTagByType(n2);
            if (tiffDataType != null && tiffDataType.getTagType() != 1) {
                this.removeTag(n2);
            }
            this.a(n2, byArray);
        } else if (Operators.castToUInt32(l2, 10) <= (long)Operators.castToUInt16(65535, 8)) {
            int[] nArray = new int[lArray.length];
            for (int i4 = 0; i4 < lArray.length; ++i4) {
                nArray[i4] = Operators.castToUInt16(lArray[i4], 10);
            }
            TiffDataType tiffDataType = this.getTagByType(n2);
            if (tiffDataType != null && tiffDataType.getTagType() != 3) {
                this.removeTag(n2);
            }
            this.a(n2, nArray);
        } else {
            TiffDataType tiffDataType = this.getTagByType(n2);
            if (tiffDataType != null && tiffDataType.getTagType() != 4) {
                this.removeTag(n2);
            }
            this.a(n2, lArray);
        }
    }

    private void a(TiffDataType[] tiffDataTypeArray) {
        for (TiffDataType tiffDataType : tiffDataTypeArray) {
            this.addTag(tiffDataType.deepClone());
        }
    }

    private void a(int n2, byte[] byArray) {
        TiffByteType tiffByteType = (TiffByteType)this.a(n2, new TiffByteCreator());
        tiffByteType.setValues(byArray);
        this.addTag(tiffByteType);
    }

    private void a(int n2, int[] nArray) {
        TiffShortType tiffShortType = (TiffShortType)this.a(n2, new TiffShortCreator());
        tiffShortType.setValues(nArray);
        this.addTag(tiffShortType);
    }

    private void a(int n2, long[] lArray) {
        TiffLongType tiffLongType = (TiffLongType)this.a(n2, new TiffLongCreator());
        tiffLongType.setValues(lArray);
        this.addTag(tiffLongType);
    }

    private void a(int n2, TiffRational[] tiffRationalArray) {
        TiffRationalType tiffRationalType = (TiffRationalType)this.a(n2, new TiffRationalCreator());
        tiffRationalType.setValues(tiffRationalArray);
        this.addTag(tiffRationalType);
    }

    private void a(int n2, Type type, int n3) {
        if (type != null && !Enum.isDefined(type, Operators.boxing(n3))) {
            throw new ArgumentOutOfRangeException("value", "The value is not defined.");
        }
        this.a(n2, new int[]{n3});
    }

    private void a(int n2, Type type, long l2) {
        if (type != null && !Enum.isDefined(type, Operators.boxing(l2))) {
            throw new ArgumentOutOfRangeException("value", "The value is not defined.");
        }
        this.a(n2, new long[]{l2});
    }

    private void a(int n2, Type type, TiffRational tiffRational) {
        if (type != null && !Enum.isDefined(type, tiffRational)) {
            throw new ArgumentOutOfRangeException("value", "The value is not defined.");
        }
        this.a(n2, new TiffRational[]{tiffRational});
    }

    private int[] b(int n2) {
        int[] nArray = null;
        TiffShortType tiffShortType = Operators.as(this.getTagByType(n2), TiffShortType.class);
        if (tiffShortType != null) {
            nArray = tiffShortType.getValues();
        }
        return nArray;
    }

    private int a(int n2, int n3) {
        int n4 = n3;
        TiffShortType tiffShortType = Operators.as(this.getTagByType(n2), TiffShortType.class);
        if (tiffShortType != null && tiffShortType.getValues() != null && tiffShortType.getValues().length > 0) {
            n4 = tiffShortType.getValues()[0];
        }
        return n4;
    }

    private long a(int n2, long l2) {
        long l3 = l2;
        TiffLongType tiffLongType = Operators.as(this.getTagByType(n2), TiffLongType.class);
        if (tiffLongType != null && tiffLongType.getValues() != null && tiffLongType.getValues().length > 0) {
            l3 = tiffLongType.getValues()[0];
        }
        return l3;
    }

    private long b(int n2, long l2) {
        long l3 = l2;
        TiffDataType tiffDataType = this.getTagByType(n2);
        if (tiffDataType != null && tiffDataType.getValue() != null && Operators.is(tiffDataType.getValue(), Array.class) && Operators.as(tiffDataType.getValue(), Array.class).getLength() > 0) {
            l3 = Convert.toUInt32(Operators.as(tiffDataType.getValue(), Array.class).getValue(0));
        }
        return l3;
    }

    private void a(int n2, String string) {
        TiffASCIIType tiffASCIIType = (TiffASCIIType)this.a(n2, new TiffAsciiCreator());
        tiffASCIIType.setText(string);
        this.addTag(tiffASCIIType);
    }

    private TiffRational c(int n2) {
        TiffRational tiffRational = null;
        TiffRationalType tiffRationalType = Operators.as(this.getTagByType(n2), TiffRationalType.class);
        if (tiffRationalType != null && tiffRationalType.getValues() != null && tiffRationalType.getValues().length > 0) {
            tiffRational = tiffRationalType.getValues()[0];
        }
        return tiffRational;
    }

    private String d(int n2) {
        String string = null;
        TiffASCIIType tiffASCIIType = Operators.as(this.getTagByType(n2), TiffASCIIType.class);
        if (tiffASCIIType != null) {
            string = tiffASCIIType.getText();
        }
        return string;
    }

    private TiffDataType a(int n2, ITiffTagCreator iTiffTagCreator) {
        TiffDataType tiffDataType = iTiffTagCreator.createInstance(n2);
        TiffDataType tiffDataType2 = null;
        if (this.a.containsKey(n2) && (tiffDataType2 = this.a.get_Item(n2)).getTagType() != tiffDataType.getTagType()) {
            this.removeTag(n2);
            tiffDataType2 = null;
        }
        if (tiffDataType2 == null) {
            tiffDataType2 = tiffDataType;
        }
        return tiffDataType2;
    }

    private boolean a(boolean bl2) {
        boolean bl3 = true;
        int[] nArray = this.getBitsPerSample();
        int n2 = this.getPhotometric();
        switch (n2) {
            case 3: {
                if (nArray.length != 1) {
                    if (bl2) {
                        bl3 = false;
                        break;
                    }
                    throw new TiffImageException("The palette tiff images require samples per pixels to be equal 1.TiffOptionsError.PhotometricSppMismatch");
                }
                int[] nArray2 = this.getColorMap();
                if (nArray2 == null) {
                    if (bl2) {
                        bl3 = false;
                        break;
                    }
                    throw new TiffImageException("The palette tiff images require ColorMap to be defined. Use ColorMap or Palette property to specify the ColorMap. TiffOptionsError.NoColorMap");
                }
                int n3 = Operators.castToInt32(3.0 * msMath.pow(2.0, Operators.castToDouble(nArray[0], 8)), 14);
                if (nArray2.length == n3) break;
                if (bl2) {
                    bl3 = false;
                    break;
                }
                throw new TiffImageException("The palette tiff images require ColorMap length corresponding to the followign formula: 3 * (2**BitsPerSample). TiffOptionsError.ColorMapLengthInvalid");
            }
            case 0: 
            case 1: {
                if (nArray.length == 1) break;
                if (bl2) {
                    bl3 = false;
                    break;
                }
                throw new TiffImageException("The MinIsWhite or MinIsBlack photometric for tiff images require samples per pixels to be equal 1. TiffOptionsError.PhotometricSppMismatch");
            }
            case 2: {
                if (nArray.length >= 3) break;
                if (bl2) {
                    bl3 = false;
                    break;
                }
                throw new TiffImageException("The samples per pixel are invalid. Samples per pixels should be at least 3 for RGB images. TiffOptionsError.PhotometricSppMismatch");
            }
            case 6: {
                if (nArray.length != 3) {
                    if (bl2) {
                        bl3 = false;
                        break;
                    }
                    throw new TiffImageException("The samples per pixel are invalid. Samples per pixels should be at least 3 for YCbCr images. TiffOptionsError.PhotometricSppMismatch");
                }
                if (this.getCompression() == 7 || this.getCompression() == 6) break;
                if (bl2) {
                    bl3 = false;
                    break;
                }
                throw new TiffImageException(StringExtensions.concat("For  photometric ", Enum.getName(TiffPhotometrics.class, n2), " compression must be Jpeg only. TiffOptionsError.PhotometricCompressionMismatch"));
            }
            default: {
                if (bl2) {
                    bl3 = false;
                    break;
                }
                throw new TiffImageException(StringExtensions.format("The Photometric={0} format is not supported at the moment.", Enum.getName(TiffPhotometrics.class, n2)));
            }
        }
        if (bl3) {
            int n4 = this.getCompression();
            switch (n4) {
                case 1: 
                case 5: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 32771: {
                    if (nArray.length != 1) {
                        if (bl2) {
                            bl3 = false;
                            break;
                        }
                        throw new TiffImageException(StringExtensions.concat("For compression ", Enum.getName(TiffCompressions.class, n4), " expected 1 sample per pixel. TiffOptionsError.CompressionSppMismatch"));
                    }
                    if (n2 != 1 && n2 != 0) {
                        if (bl2) {
                            bl3 = false;
                            break;
                        }
                        throw new TiffImageException(StringExtensions.concat("For compression ", Enum.getName(TiffCompressions.class, n4), " the photometric should be MinIsWhite or MinIsBlack only. TiffOptionsError.PhotometricCompressionMismatch"));
                    }
                    if (Operators.castToUInt16(nArray[0], 8) == 1) break;
                    if (bl2) {
                        bl3 = false;
                        break;
                    }
                    throw new TiffImageException(StringExtensions.concat("For compression ", Enum.getName(TiffCompressions.class, n4), " expected 1 bit per sample. TiffOptionsError.CompressionSppMismatch"));
                }
                case 32773: {
                    break;
                }
                case 8: 
                case 32946: {
                    break;
                }
                case 7: {
                    if (n2 == 1 || n2 == 2 || n2 == 6) break;
                    if (bl2) {
                        bl3 = false;
                        break;
                    }
                    throw new TiffImageException(StringExtensions.concat("For compression ", Enum.getName(TiffCompressions.class, n4), " the photometric should be MinIsBlack or RGB or YCbCr only. TiffOptionsError.PhotometricCompressionMismatch"));
                }
                default: {
                    if (bl2) {
                        bl3 = false;
                        break;
                    }
                    throw new TiffImageException(StringExtensions.format("The compression {0} is not supported at the moment.", Operators.boxing(n4)));
                }
            }
        }
        return bl3;
    }
}

