/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc;

import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccCurve;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccInvalidProfileException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccProfileReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.icc.IccUtil;

class IccTagParametricCurve
extends IccCurve {
    private int a;
    private int b;

    IccTagParametricCurve() {
    }

    @Override
    public void read(IccProfileReader iccProfileReader) {
        int n2;
        this._sig = (int)(iccProfileReader.read32() & 0xFFFFFFFFL);
        this.verifyTagSignature();
        this._reserved = iccProfileReader.read32();
        this.b = iccProfileReader.read16();
        this.a = iccProfileReader.read16();
        switch (this.b) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 5;
                break;
            }
            case 4: {
                n2 = 7;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        if ((n2 & 0xFFFF) != 0) {
            this._data = iccProfileReader.read32fArray(n2 & 0xFFFF);
        }
    }

    @Override
    protected void verifyTagSignature() {
        if (this._sig != 1885434465) {
            throw new IccInvalidProfileException();
        }
    }

    @Override
    public boolean isIdentity() {
        switch (this.b) {
            case 0: {
                return IccUtil.isUnity(this._data[0]);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
        }
        return true;
    }

    @Override
    public float apply(float f2) {
        if ((double)f2 < 0.0) {
            f2 = 0.0f;
        }
        if ((double)f2 > 1.0) {
            f2 = 1.0f;
        }
        float f3 = 0.0f;
        switch (this.b) {
            case 0: {
                return (float)msMath.pow(f2, this._data[0]);
            }
            case 1: {
                if (f2 >= -this._data[2] / this._data[1]) {
                    f3 = (float)msMath.pow(this._data[1] * f2 + this._data[2], this._data[0]);
                    break;
                }
                return 0.0f;
            }
            case 2: {
                if (f2 >= -this._data[2] / this._data[1]) {
                    f3 = (float)msMath.pow((double)this._data[1] * (double)f2 + (double)this._data[2], this._data[0]) + this._data[3];
                    break;
                }
                f3 = this._data[3];
                break;
            }
            case 3: {
                if (f2 >= this._data[4]) {
                    f3 = (float)msMath.pow((double)this._data[1] * (double)f2 + (double)this._data[2], this._data[0]);
                    break;
                }
                f3 = this._data[3] * f2;
                break;
            }
            case 4: {
                if (f2 >= this._data[4]) {
                    f3 = (float)msMath.pow((double)this._data[1] * (double)f2 + (double)this._data[2], this._data[0]) + this._data[5];
                    break;
                }
                f3 = this._data[3] * f2 + this._data[6];
                break;
            }
            default: {
                return f2;
            }
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        return f3;
    }
}

