/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.codecs.readers;

import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.TiffUtils;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.EntropyTable;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.QTable;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.encodingcontrollers.JpegDecodingController;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodecDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageloadoptions.JpegLoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.loaders.JpegLoader;
import com.aspose.html.internal.ms.lang.Operators;

public class TiffJpegReader
extends TiffCodecDataReader {
    private byte[] a;

    public TiffJpegReader(TiffOptions tiffOptions, int n2, int n3) {
        super(tiffOptions, n2, n3);
    }

    public byte[] getTablesData() {
        return this.a;
    }

    public void setTablesData(byte[] byArray) {
        this.a = byArray;
    }

    @Override
    public void decode(TiffStream tiffStream, Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        PartialLoader partialLoader = new PartialLoader(this, tiffStream, iPartialArgb32PixelLoader, this.a);
        PartialProcessor.process(rectangle.Clone(), partialLoader);
    }

    private static class PartialLoader
    implements IPartialProcessor {
        private final IPartialArgb32PixelLoader a;
        private final TiffStream b;
        private final long[] c;
        private final byte[] d;
        private final int e;

        public PartialLoader(TiffJpegReader tiffJpegReader, TiffStream tiffStream, IPartialArgb32PixelLoader iPartialArgb32PixelLoader, byte[] byArray) {
            this.b = tiffStream;
            this.a = iPartialArgb32PixelLoader;
            this.d = byArray;
            this.c = tiffJpegReader.getOptions().getStripOffsets();
            this.e = tiffJpegReader.getOptions().getPhotometric();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(Rectangle rectangle) {
            long l2 = this.b.getPosition();
            int n2 = 0;
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                QTable[] qTableArray;
                EntropyTable[] entropyTableArray;
                this.b.setPosition(Operators.castToInt64(this.c[i2], 10));
                JpegLoadOptions jpegLoadOptions = new JpegLoadOptions();
                jpegLoadOptions.setColorMode(TiffUtils.tiffPhotometricToJpegColorSpace(this.e));
                if (this.d != null) {
                    entropyTableArray = JpegDecodingController.readEntropyTables(new JpegStream(new MemoryStream(this.d)));
                    qTableArray = JpegDecodingController.readQuantTables(new JpegStream(new MemoryStream(this.d)));
                    jpegLoadOptions.setEntropyTables(entropyTableArray);
                    jpegLoadOptions.setQuantTables(qTableArray);
                }
                entropyTableArray = new StreamContainer(this.b.getStream());
                try {
                    qTableArray = JpegLoader.getJpegInfo((StreamContainer)entropyTableArray, jpegLoadOptions);
                    Rectangle rectangle2 = new Rectangle(0, n2, qTableArray.getWidth(), qTableArray.getHeight());
                    JpegStripShifter jpegStripShifter = new JpegStripShifter(new Point(0, n2), this.a);
                    if (rectangle2.intersectsWith(rectangle.Clone())) {
                        Rectangle rectangle3 = Rectangle.intersect(rectangle2.Clone(), rectangle.Clone()).Clone();
                        Rectangle rectangle4 = new Rectangle(rectangle3.getX(), rectangle3.getLocation().getY() - n2, rectangle3.getWidth(), rectangle3.getHeight());
                        qTableArray.getJpegDataReader().loadPartialArgb32Pixels(rectangle4.Clone(), jpegStripShifter);
                    }
                    n2 += qTableArray.getHeight();
                    continue;
                }
                finally {
                    if (entropyTableArray != null) {
                        entropyTableArray.dispose();
                    }
                }
            }
            this.b.setPosition(l2);
        }

        private static class JpegStripShifter
        implements IPartialArgb32PixelLoader {
            private final Point a = new Point();
            private final IPartialArgb32PixelLoader b;

            public JpegStripShifter(Point point, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
                point.CloneTo(this.a);
                this.b = iPartialArgb32PixelLoader;
            }

            @Override
            public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
                rectangle.offset(this.a.Clone());
                point.offset(this.a.Clone());
                point2.offset(this.a.Clone());
                this.b.process(rectangle.Clone(), nArray, point.Clone(), point2.Clone());
            }
        }
    }
}

