/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialPixelSaver;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterCachedImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImagePixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.TransparentColorRenderProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exif.ExifData;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodec;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffCodecDataWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffDataWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.TiffTagsSaver;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStream;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.filemanagement.TiffStreamFactory;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffSShortType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.tiff.tifftagtypes.TiffShortType;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.imageoptions.TiffOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IAdvancedBufferProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.internal.ms.lang.Operators;

public final class TiffFrame
extends RasterCachedImage {
    private TiffOptions a;
    private int b;
    private int c;
    private ExifData d;

    public TiffFrame(RasterImage rasterImage) {
        this(rasterImage, new TiffOptions(0));
    }

    public TiffFrame(RasterImage rasterImage, TiffOptions tiffOptions) {
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.a(new RasterImagePixelLoader(rasterImage), tiffOptions);
    }

    public TiffFrame(TiffOptions tiffOptions, int n2, int n3) {
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.a = tiffOptions;
        this.c = n2;
        this.b = n3;
    }

    public TiffFrame(TiffOptions tiffOptions, int n2, int n3, IRasterImageArgb32PixelLoader iRasterImageArgb32PixelLoader) {
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        this.a = tiffOptions;
        this.c = n2;
        this.b = n3;
        if (iRasterImageArgb32PixelLoader != null) {
            this.setDataLoader(iRasterImageArgb32PixelLoader);
        }
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return this.getFrameOptions().getBitsPerPixel();
    }

    public TiffOptions getFrameOptions() {
        this.verifyNotDisposed();
        return this.a;
    }

    @Override
    public int getHeight() {
        return this.b;
    }

    @Override
    public int getWidth() {
        return this.c;
    }

    public ExifData getExifData() {
        return this.d;
    }

    public void setExifData(ExifData exifData) {
        this.d = exifData;
    }

    public static TiffFrame copyFrame(TiffFrame tiffFrame) {
        if (tiffFrame == null) {
            throw new ArgumentNullException("tiffFrame");
        }
        TiffOptions tiffOptions = new TiffOptions(tiffFrame.a);
        TiffFrame tiffFrame2 = new TiffFrame(tiffOptions, tiffFrame.c, tiffFrame.b);
        if (tiffFrame.getDataLoader() != null) {
            tiffFrame2.setDataLoader(tiffFrame.getDataLoader());
        } else {
            tiffFrame.loadPartialArgb32Pixels(tiffFrame.getBounds().Clone(), new PartialPixelSaver(tiffFrame2));
        }
        return tiffFrame2;
    }

    public static TiffFrame createFrameFrom(TiffFrame tiffFrame, TiffOptions tiffOptions) {
        if (tiffFrame == null) {
            throw new ArgumentNullException("tiffFrame");
        }
        if (tiffOptions == null) {
            throw new ArgumentNullException("options");
        }
        TiffFrame tiffFrame2 = new TiffFrame(tiffOptions, tiffFrame.c, tiffFrame.b);
        tiffFrame.loadPartialArgb32Pixels(tiffFrame.getBounds().Clone(), new PartialPixelSaver(tiffFrame2));
        return tiffFrame2;
    }

    public static void save(RasterImage rasterImage, TiffStream tiffStream, boolean bl2, TiffOptions tiffOptions, ExifData exifData) {
        TiffDataType[] tiffDataTypeArray;
        TiffDataType[] tiffDataTypeArray2;
        TiffDataType[] tiffDataTypeArray3;
        tiffOptions.validate();
        tiffOptions.setImageWidth(Operators.castToUInt32(rasterImage.getWidth(), 9));
        tiffOptions.setImageLength(Operators.castToUInt32(rasterImage.getHeight(), 9));
        if (tiffOptions.getCompression() == 7) {
            tiffOptions.setRowsPerStrip(Operators.castToUInt32(rasterImage.getHeight(), 9));
            tiffDataTypeArray3 = new TiffSShortType(530);
            tiffDataTypeArray3.setValues(new short[]{2, 2});
            tiffDataTypeArray2 = new TiffShortType(284);
            tiffDataTypeArray2.setValues(new int[]{1});
            tiffOptions.addTag((TiffDataType)tiffDataTypeArray3);
            tiffOptions.addTag((TiffDataType)tiffDataTypeArray2);
        }
        tiffOptions.setStripByteCounts(new long[]{0L});
        tiffOptions.setStripOffsets(new long[]{0L});
        if (!tiffOptions.isTagPresent(278)) {
            tiffOptions.setRowsPerStrip(0xFFFFFFFFL);
        }
        tiffDataTypeArray3 = null;
        tiffDataTypeArray2 = null;
        if (exifData != null) {
            tiffDataTypeArray3 = exifData.getExifTags();
            tiffDataTypeArray2 = exifData.getGPSTags();
        }
        TiffTagsSaver tiffTagsSaver = new TiffTagsSaver(tiffOptions.getTags(), tiffDataTypeArray3, tiffDataTypeArray2);
        long l2 = tiffStream.getPosition();
        long l3 = tiffTagsSaver.estimateTagsInfoSize();
        PartialSaver partialSaver = new PartialSaver(tiffOptions, Operators.castToUInt32(Operators.castToUInt32(Operators.castToUInt32(l2, 11), 10) + Operators.castToUInt32(l3, 10), 10), tiffStream, rasterImage.getWidth(), rasterImage.getHeight());
        if (rasterImage.hasTransparentColor()) {
            tiffDataTypeArray = new TransparentColorRenderProcessor(rasterImage.getTransparentColor(), rasterImage.getBackgroundColor(), partialSaver);
            rasterImage.loadPartialArgb32Pixels(rasterImage.getBounds().Clone(), (IPartialArgb32PixelLoader)tiffDataTypeArray);
        } else {
            rasterImage.loadPartialArgb32Pixels(rasterImage.getBounds().Clone(), partialSaver);
        }
        tiffOptions.setStripByteCounts(partialSaver.getWriter().getStripByteCountsArray());
        tiffOptions.setStripOffsets(partialSaver.getWriter().getStripOffsetsArray());
        tiffOptions.setRowsPerStrip(partialSaver.getWriter().getRowsPerStrip());
        tiffDataTypeArray = new TiffDataType[]{tiffOptions.getTagByType(278), tiffOptions.getTagByType(279), tiffOptions.getTagByType(273)};
        tiffTagsSaver.replaceTags(tiffDataTypeArray);
        long l4 = partialSaver.getWriter().getDataOffset();
        tiffStream.seek(l2, 0);
        tiffTagsSaver.writeTags(tiffStream, l4, bl2);
    }

    @Override
    protected void releaseManagedResources() {
        this.a = null;
        super.releaseManagedResources();
    }

    @Override
    public void saveData(Stream stream) {
        this.verifyNotDisposed();
        int n2 = 18761;
        if (Operators.is(this.getContainer(), TiffImage.class)) {
            n2 = Operators.as(this.getContainer(), TiffImage.class).getByteOrder();
        }
        TiffStream tiffStream = TiffStreamFactory.getTiffStream(stream, n2);
        TiffFrame.save(this, tiffStream, true, this.a, this.d);
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.c = n2;
        this.b = n3;
    }

    private void a(RasterImagePixelLoader rasterImagePixelLoader, TiffOptions tiffOptions) {
        this.setDataLoader(rasterImagePixelLoader);
        this.a = tiffOptions;
        this.c = rasterImagePixelLoader.getRasterImage().getWidth();
        this.b = rasterImagePixelLoader.getRasterImage().getHeight();
        this.setPalette(rasterImagePixelLoader.getRasterImage().getPalette());
    }

    private static class PartialSaver
    implements IPartialArgb32PixelLoader {
        private final PartialWriter a;
        private final TiffCodecDataWriter b;

        public PartialSaver(TiffOptions tiffOptions, long l2, TiffStream tiffStream, int n2, int n3) {
            this.b = TiffDataWriter.createCompressionObject(tiffOptions, n2, n3);
            long l3 = tiffOptions.getRowsPerStrip();
            this.a = new PartialWriter(tiffStream, l2, Operators.castToUInt32(this.b.getHeight(), 9), l3, this.b.getOptions().getFillOrder() == 2);
        }

        public PartialWriter getWriter() {
            return this.a;
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            try {
                this.b.encode(nArray, rectangle.Clone(), this.a);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new OutOfMemoryException("FrameworkException: Fatal error", outOfMemoryError);
            }
        }
    }

    private static class PartialWriter
    implements IAdvancedBufferProcessor {
        private final TiffStream a;
        private final long b;
        private final long[] c;
        private final long[] d;
        private final long e;
        private final boolean f;
        private long g;
        private long h;
        private long i;
        private long j;

        public PartialWriter(TiffStream tiffStream, long l2, long l3, long l4, boolean bl2) {
            this.f = bl2;
            this.a = tiffStream;
            this.g = l2;
            if (Operators.castToUInt32(l4, 10) == 0L) {
                l4 = l3;
            }
            this.b = l4;
            long l5 = Operators.castToUInt32(Operators.castToUInt32(l3, 10) / Operators.castToUInt32(l4, 10), 10);
            if (Operators.castToUInt32(Operators.castToUInt32(l3, 10) % Operators.castToUInt32(l4, 10), 10) != 0L) {
                ++l5;
            }
            this.c = new long[(int)Operators.castToUInt32(l5, 10)];
            this.d = new long[(int)Operators.castToUInt32(l5, 10)];
            this.c[0] = l2;
            this.e = l3;
        }

        public long[] getStripOffsetsArray() {
            return this.c;
        }

        public long[] getStripByteCountsArray() {
            return this.d;
        }

        public long getRowsPerStrip() {
            return this.b;
        }

        public long getDataOffset() {
            return this.g;
        }

        @Override
        public void processBuffer(byte[] byArray, int n2) {
            if (this.f) {
                TiffCodec.reverseBits(byArray, 0, n2);
            }
            this.a.seek(Operators.castToInt64(this.g, 10), 0);
            this.a.write(byArray, 0, n2);
            this.g = Operators.castToUInt32(Operators.castToUInt32(this.g, 10) + Operators.castToUInt32(Operators.castToUInt32(n2, 9), 10), 10);
            this.j = Operators.castToUInt32(Operators.castToUInt32(this.j, 10) + Operators.castToUInt32(Operators.castToUInt32(n2, 9), 10), 10);
        }

        @Override
        public void finishRow() {
            ++this.h;
            if (Operators.castToUInt32(Operators.castToUInt32(this.h, 10) % Operators.castToUInt32(this.b, 10), 10) == 0L || Operators.castToUInt32(this.h, 10) == Operators.castToUInt32(this.e, 10)) {
                this.d[(int)this.i++] = this.j;
                if (Operators.castToUInt32(this.i, 10) < (long)this.c.length) {
                    this.c[(int)this.i] = this.g;
                }
                this.j = 0L;
            }
        }

        @Override
        public void finishRows(int n2) {
            this.h = Operators.castToUInt32(Operators.castToUInt32(this.h, 10) + Operators.castToUInt32(Operators.castToUInt32(n2, 9), 10), 10);
            if (Operators.castToUInt32(Operators.castToUInt32(this.h, 10) % Operators.castToUInt32(this.b, 10), 10) == 0L || Operators.castToUInt32(this.h, 10) == Operators.castToUInt32(this.e, 10)) {
                this.d[(int)this.i++] = this.j;
                if (Operators.castToUInt32(this.i, 10) < (long)this.c.length) {
                    this.c[(int)this.i] = this.g;
                }
                this.j = 0L;
            }
        }
    }
}

