/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.datawriters;

import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegDataWriter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;

public class CMYKWriter
extends JpegDataWriter {
    public CMYKWriter(IPartialRawDataLoader iPartialRawDataLoader) {
        this.dataLoader = iPartialRawDataLoader;
        this.targetPixelSettings = PixelDataFormat.getCMYK();
    }

    @Override
    protected void convert(int[] nArray, byte[] byArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            byte by2 = (byte)(n3 >> 16 & 0xFF);
            byte by3 = (byte)(n3 >> 8 & 0xFF);
            byte by4 = (byte)(n3 & 0xFF);
            double d2 = 1.0 - (double)(by2 & 0xFF) / 255.0;
            double d3 = 1.0 - (double)(by3 & 0xFF) / 255.0;
            double d4 = 1.0 - (double)(by4 & 0xFF) / 255.0;
            double d5 = msMath.min(msMath.min(msMath.min(1.0, d2), d3), d4);
            if (msMath.abs(d5 - 1.0) < 0.001) {
                d4 = 0.0;
                d3 = 0.0;
                d2 = 0.0;
            } else {
                d2 = (d2 - d5) / (1.0 - d5);
                d3 = (d3 - d5) / (1.0 - d5);
                d4 = (d4 - d5) / (1.0 - d5);
            }
            byArray[n2++] = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d2) * (1.0 - d5)));
            byArray[n2++] = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d3) * (1.0 - d5)));
            byArray[n2++] = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d4) * (1.0 - d5)));
            byArray[n2++] = (byte)msMath.max(0.0, msMath.min(255.0, 255.0 * (1.0 - d5)));
        }
    }
}

