/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg;

import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.ImageLoadException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegFrame;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegRawDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg.JpegStream;
import com.aspose.html.internal.ms.lang.Operators;

public class JpegScan {
    public byte ApproxBit;
    public int[] Components;
    public byte SpectralSelectorEnd = (byte)63;
    public byte SpectralSelectorStart;
    private int[] a = new int[10];
    private int b;
    private int c;
    private int d;

    public JpegScan(byte by2, byte by3, int n2, int n3, int n4) {
        this(by2, by3, n2, n3, new int[n4]);
    }

    public JpegScan(byte by2, byte by3, int n2, int n3, int[] nArray) {
        this.setApproxBitPosHigh(n2);
        this.setApproxBitPosLow(n3);
        this.SpectralSelectorStart = by2;
        this.SpectralSelectorEnd = by3;
        this.Components = nArray;
    }

    public JpegScan() {
    }

    public int getApproxBitPosHigh() {
        return Operators.castToInt32(Operators.castToByte(Operators.castToInt32(this.ApproxBit, 6) >> 4, 9), 6);
    }

    public void setApproxBitPosHigh(int n2) {
        this.ApproxBit = Operators.castToByte(Operators.castToInt32(this.ApproxBit, 6) | n2 << 4, 9);
    }

    public int getApproxBitPosLow() {
        return Operators.castToInt32(Operators.castToByte(Operators.castToInt32(this.ApproxBit, 6) & 0xF, 9), 6);
    }

    public void setApproxBitPosLow(int n2) {
        this.ApproxBit = Operators.castToByte(Operators.castToInt32(this.ApproxBit, 6) & 0xF0 | n2, 9);
    }

    public int[] getMCUMembership() {
        return this.a;
    }

    public void setMCUMembership(int[] nArray) {
        this.a = nArray;
    }

    public int getMaxH() {
        return this.b;
    }

    public void setMaxH(int n2) {
        this.b = n2;
    }

    public int getMaxV() {
        return this.c;
    }

    public void setMaxV(int n2) {
        this.c = n2;
    }

    public int getBlocksInMcu() {
        return this.d;
    }

    public void setBlocksInMcu(int n2) {
        this.d = n2;
    }

    public static JpegScan read(JpegRawDataReader jpegRawDataReader, JpegFrame jpegFrame) {
        int n2;
        int n3;
        JpegScan jpegScan = new JpegScan();
        jpegRawDataReader.skipInputData(2);
        int n4 = 0;
        int[] nArray = new int[]{0};
        jpegRawDataReader.getByte(nArray);
        n4 = nArray[0];
        jpegScan.Components = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5;
            n2 = 0;
            int[] nArray2 = new int[]{0};
            jpegRawDataReader.getByte(nArray2);
            n2 = nArray2[0];
            boolean bl2 = false;
            int n6 = 0;
            for (n5 = 0; n5 < jpegFrame.getComponentInfos().length; ++n5) {
                if ((jpegFrame.getComponentInfos()[n5].getId() & 0xFF) != n2) continue;
                bl2 = true;
                n6 = n5;
                break;
            }
            if (!bl2) {
                throw new FrameworkException(StringExtensions.Empty, new ImageLoadException("Corrupted Jpeg scan component id definition. Cannot load image."));
            }
            jpegScan.Components[n3] = n2;
            n5 = 0;
            int[] nArray3 = new int[]{0};
            jpegRawDataReader.getByte(nArray3);
            n5 = nArray3[0];
            jpegFrame.getComponentInfos()[n6].setEntropySelector((byte)n5 & 0xFF);
        }
        n3 = 0;
        n2 = 0;
        int n7 = 0;
        int[] nArray4 = new int[]{0};
        jpegRawDataReader.getByte(nArray4);
        n3 = nArray4[0];
        int[] nArray5 = new int[]{0};
        jpegRawDataReader.getByte(nArray5);
        n2 = nArray5[0];
        int[] nArray6 = new int[]{0};
        jpegRawDataReader.getByte(nArray6);
        n7 = nArray6[0];
        jpegScan.SpectralSelectorStart = (byte)n3;
        jpegScan.SpectralSelectorEnd = (byte)n2;
        jpegScan.ApproxBit = (byte)n7;
        return jpegScan;
    }

    public static void write(JpegStream jpegStream, JpegFrame jpegFrame, JpegScan jpegScan) {
        jpegStream.writeByte((byte)-1);
        jpegStream.writeByte((byte)-38);
        jpegStream.writeShort(6 + 2 * jpegScan.Components.length & 0xFFFF);
        jpegStream.writeByte((byte)jpegScan.Components.length);
        for (int i2 = 0; i2 < jpegScan.Components.length; ++i2) {
            jpegStream.writeByte(jpegFrame.getComponentInfos()[jpegScan.Components[i2]].getId());
            byte by2 = (byte)(((jpegFrame.getComponentInfos()[jpegScan.Components[i2]].getDCSelector() & 0xFF) << 4) + (jpegFrame.getComponentInfos()[jpegScan.Components[i2]].getACSelector() & 0xFF));
            jpegStream.writeByte(by2);
        }
        jpegStream.writeByte(jpegScan.SpectralSelectorStart);
        jpegStream.writeByte(jpegScan.SpectralSelectorEnd);
        jpegStream.writeByte(jpegScan.ApproxBit);
    }
}

