/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.jpeg;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;

class ColorFromRGB24Converter
implements IPartialRawDataLoader {
    private final IPartialArgb32PixelLoader a;

    public ColorFromRGB24Converter(IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        this.a = iPartialArgb32PixelLoader;
    }

    @Override
    public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2) {
        if (byArray.length % 3 != 0) {
            throw new ArgumentException("Data must contain 3 bytes for each pixel.");
        }
        int[] nArray = new int[byArray.length / 3];
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; i2 += 3) {
            nArray[n2++] = 0xFF000000 | (byArray[i2 + 2] & 0xFF) << 16 | (byArray[i2 + 1] & 0xFF) << 8 | byArray[i2] & 0xFF;
        }
        this.a.process(rectangle.Clone(), nArray, point.Clone(), point2.Clone());
    }

    @Override
    public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2, LoadOptions loadOptions) {
        throw new NotImplementedException();
    }
}

