/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.BufferHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.DisposableObject;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterCachedImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImagePixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RgbEntriesPaletteHash;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors.LzwVariableWidthBlockEncoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.FrameworkException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.GifImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.GifFrameBlockDataReader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.GifHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.GifImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.IGifBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IAdvancedBufferProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;
import com.aspose.html.internal.ms.lang.Operators;

public final class GifFrameBlock
extends RasterCachedImage
implements IGifBlock {
    public static final int EXTENSION_LABEL = 44;
    public static final int IMAGE_DESCRIPTOR_SIZE = 10;
    private byte a;
    private int b;
    private int c;
    private int d;
    private int e;
    private byte f;

    public GifFrameBlock(int n2, int n3) {
        this(0, 0, n2, n3);
    }

    public GifFrameBlock(int n2, int n3, int n4, int n5) {
        this(null, n2, n3, n4, n5, null, false, false, 8);
    }

    public GifFrameBlock(int n2, int n3, int n4, int n5, IColorPalette iColorPalette, boolean bl2, boolean bl3, byte by2) {
        this(null, n2, n3, n4, n5, iColorPalette, bl2, bl3, by2);
    }

    public GifFrameBlock(RasterImage rasterImage) {
        this(rasterImage, 0, 0, false, false, 8);
    }

    public GifFrameBlock(RasterImage rasterImage, int n2, int n3) {
        this(rasterImage, n2, n3, false, false, 8);
    }

    public GifFrameBlock(RasterImage rasterImage, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        if (rasterImage == null) {
            throw new ArgumentNullException("image");
        }
        this.a(new RasterImagePixelLoader(rasterImage), n2, n3, bl2, bl3, by2);
    }

    public GifFrameBlock(GifFrameBlockDataReader gifFrameBlockDataReader, int n2, int n3, int n4, int n5, IColorPalette iColorPalette, boolean bl2, boolean bl3, byte by2) {
        super(iColorPalette);
        this.a(iColorPalette, n2, n3, Operators.castToInt32(n4, 8), Operators.castToInt32(n5, 8), bl2, bl3, by2);
        if (gifFrameBlockDataReader != null) {
            this.setDataLoader(gifFrameBlockDataReader);
            gifFrameBlockDataReader.setGifFrameBlock(this);
        }
    }

    @Override
    public int getWidth() {
        return this.b;
    }

    @Override
    public int getHeight() {
        return this.c;
    }

    @Override
    public int getBitsPerPixel() {
        this.verifyNotDisposed();
        return Operators.castToInt32(this.a, 6);
    }

    public boolean getInterlaced() {
        this.verifyNotDisposed();
        return (Operators.castToInt32(this.f, 6) & 0x40) != 0;
    }

    public void setInterlaced(boolean bl2) {
        this.verifyNotDisposed();
        byte by2 = this.f;
        by2 = bl2 ? (byte)(Operators.castToInt32(by2, 6) | 0x40) : (byte)(Operators.castToInt32(by2, 6) & 0xBF);
        this.f = by2;
    }

    public boolean isPaletteSorted() {
        this.verifyNotDisposed();
        return (Operators.castToInt32(this.f, 6) & 0x20) != 0;
    }

    public void setPaletteSorted(boolean bl2) {
        this.verifyNotDisposed();
        byte by2 = this.f;
        by2 = bl2 ? (byte)(Operators.castToInt32(by2, 6) | 0x20) : (byte)(Operators.castToInt32(by2, 6) & 0xDF);
        this.f = by2;
    }

    public byte getGifFrameBitsPerPixel() {
        this.verifyNotDisposed();
        return this.a;
    }

    public void setGifFrameBitsPerPixel(byte by2) {
        this.verifyNotDisposed();
        if (Operators.castToInt32(by2, 6) > 8) {
            throw new ArgumentOutOfRangeException("value", "Too big bits per pixel. The maximal allowed is 8 bits.");
        }
        if (Operators.castToInt32(by2, 6) < 2) {
            throw new ArgumentOutOfRangeException("value", "Too small bits per pixel. The minimal allowed is 2 bits.");
        }
        this.a = by2;
    }

    public int getLeft() {
        this.verifyNotDisposed();
        return this.d;
    }

    public void setLeft(int n2) {
        this.verifyNotDisposed();
        this.d = n2;
    }

    public int getTop() {
        this.verifyNotDisposed();
        return this.e;
    }

    public void setTop(int n2) {
        this.verifyNotDisposed();
        this.e = n2;
    }

    public byte getFlags() {
        this.verifyNotDisposed();
        return this.f;
    }

    public void setFlags(byte by2) {
        this.verifyNotDisposed();
        if (Operators.castToInt32(this.f, 6) != Operators.castToInt32(by2, 6)) {
            if ((Operators.castToInt32(by2, 6) & 0x80) > 0 && this.getPalette() == null) {
                throw new ArgumentOutOfRangeException("value", "The flags are incorrect since palette is not present but flags indicate it is.");
            }
            if ((Operators.castToInt32(by2, 6) & 0x80) == 0 && this.getPalette() != null) {
                throw new ArgumentOutOfRangeException("value", "The flags are incorrect since palette is present but flags indicate it is not.");
            }
            if (this.getPalette() != null && this.getPalette().getEntriesCount() != 2 << (Operators.castToInt32(by2, 6) & 7)) {
                throw new ArgumentOutOfRangeException("value", "The flags are incorrect since palette entries count do not correspond to flags entries count.");
            }
            this.f = by2;
        }
    }

    public GifGraphicsControlBlock getControlBlock() {
        GifGraphicsControlBlock gifGraphicsControlBlock = null;
        if (Operators.is(this.getContainer(), GifImage.class)) {
            IGifBlock[] iGifBlockArray = Operators.as(this.getContainer(), GifImage.class).getBlocks();
            for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                IGifBlock iGifBlock;
                if (iGifBlockArray[i2] != this) continue;
                if (i2 <= 0 || !Operators.is(iGifBlock = iGifBlockArray[i2 - 1], GifGraphicsControlBlock.class)) break;
                gifGraphicsControlBlock = (GifGraphicsControlBlock)iGifBlock;
                break;
            }
        }
        return gifGraphicsControlBlock;
    }

    @Override
    public boolean hasTransparentColor() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return false;
        }
        return gifGraphicsControlBlock.hasTransparentColor();
    }

    @Override
    public void setTransparentColor(boolean bl2) {
        if (this.getControlBlock() != null) {
            this.getControlBlock().setTransparentColor(bl2);
        } else if (Operators.is(this.getContainer(), GifImage.class)) {
            IGifBlock[] iGifBlockArray = Operators.as(this.getContainer(), GifImage.class).getBlocks();
            for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                if (iGifBlockArray[i2] != this) continue;
                GifImage gifImage = Operators.as(this.getContainer(), GifImage.class);
                GifGraphicsControlBlock gifGraphicsControlBlock = new GifGraphicsControlBlock();
                gifGraphicsControlBlock.setTransparentColor(bl2);
                gifImage.insertBlock(i2, gifGraphicsControlBlock);
            }
        } else {
            throw new FrameworkException("The block does not belong to any image and transparent color could not be set.");
        }
    }

    @Override
    public int getTransparentColor() {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        if (gifGraphicsControlBlock == null) {
            return 0;
        }
        IColorPalette iColorPalette = this.a();
        if (iColorPalette != null && Operators.castToInt32(gifGraphicsControlBlock.getTransparentColorIndex(), 6) < iColorPalette.getEntriesCount()) {
            return iColorPalette.getArgb32Color(Operators.castToInt32(gifGraphicsControlBlock.getTransparentColorIndex(), 6));
        }
        return 0;
    }

    @Override
    public void setTransparentColor(int n2) {
        GifGraphicsControlBlock gifGraphicsControlBlock = this.getControlBlock();
        IColorPalette iColorPalette = this.a();
        int n3 = n2;
        if (gifGraphicsControlBlock == null) {
            if (Operators.is(this.getContainer(), GifImage.class)) {
                IGifBlock[] iGifBlockArray = Operators.as(this.getContainer(), GifImage.class).getBlocks();
                for (int i2 = 0; i2 < iGifBlockArray.length; ++i2) {
                    if (iGifBlockArray[i2] != this) continue;
                    GifImage gifImage = Operators.as(this.getContainer(), GifImage.class);
                    GifGraphicsControlBlock gifGraphicsControlBlock2 = new GifGraphicsControlBlock();
                    gifGraphicsControlBlock2.setTransparentColorIndex(Operators.castToByte(iColorPalette.getNearestColorIndex(n3), 9));
                    gifGraphicsControlBlock2.setTransparentColor(true);
                    gifImage.insertBlock(i2, gifGraphicsControlBlock2);
                    return;
                }
            } else {
                throw new FrameworkException("The block does not belong to any image and transparent color could not be set.");
            }
        }
        if (iColorPalette != null) {
            gifGraphicsControlBlock.setTransparentColorIndex(Operators.castToByte(iColorPalette.getNearestColorIndex(n3), 9));
        }
    }

    public static IColorPalette getColorPalette(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        IColorPalette iColorPalette3 = null;
        if (iColorPalette != null) {
            iColorPalette3 = iColorPalette;
        } else if (iColorPalette2 != null) {
            iColorPalette3 = iColorPalette2;
        }
        if (iColorPalette3 == null) {
            throw new GifImageException("Cannot work with GIF frame pixels since palette is not present neither in GIF image nor in GIF frame. Tip: setup color palette first.");
        }
        return iColorPalette3;
    }

    public static byte createFlags(IColorPalette iColorPalette, boolean bl2, boolean bl3) {
        byte by2 = 0;
        if (iColorPalette != null) {
            if (iColorPalette.getEntriesCount() == 1) {
                throw new ArgumentOutOfRangeException("colorPalette", "The color palette must contain entries count equal to the power of 2. Minimal entries count are 2 and maximal 256.");
            }
            byte by3 = 0;
            int n2 = iColorPalette.getEntriesCount();
            while (n2 > 2) {
                if ((n2 & 1) == 1) {
                    throw new ArgumentOutOfRangeException("colorPalette", "The color palette must contain entries count equal to the power of 2. Minimal entries count are 2 and maximal 256.");
                }
                n2 >>= 1;
                by3 = (byte)(by3 + 1);
            }
            by2 = (byte)(Operators.castToInt32(by2, 6) | Operators.castToInt32(by3, 6));
            by2 = (byte)(Operators.castToInt32(by2, 6) | 0x80);
        }
        if (bl2) {
            by2 = (byte)(Operators.castToInt32(by2, 6) | 0x20);
        }
        if (bl3) {
            by2 = (byte)(Operators.castToInt32(by2, 6) | 0x40);
        }
        return by2;
    }

    static void saveGifFrameHeader(StreamContainer streamContainer, Rectangle rectangle, byte by2) {
        streamContainer.writeByte((byte)44);
        streamContainer.write(BitConverter.getBytesUInt16(Operators.castToUInt16(rectangle.getLeft(), 9)));
        streamContainer.write(BitConverter.getBytesUInt16(Operators.castToUInt16(rectangle.getTop(), 9)));
        streamContainer.write(BitConverter.getBytesUInt16(Operators.castToUInt16(rectangle.getWidth(), 9)));
        streamContainer.write(BitConverter.getBytesUInt16(Operators.castToUInt16(rectangle.getHeight(), 9)));
        streamContainer.writeByte(by2);
    }

    static void saveGif(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, byte by2, boolean bl2) {
        if (iColorPalette == null) {
            throw new ArgumentNullException("palette");
        }
        streamContainer.writeByte(by2);
        GifFrameBlock.a(rasterImage, streamContainer, iColorPalette, by2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveData(Stream stream) {
        this.verifyNotDisposed();
        StreamContainer streamContainer = new StreamContainer(stream);
        try {
            GifFrameBlock.saveGifFrameHeader(streamContainer, new Rectangle(Operators.castToInt32(this.d, 8), Operators.castToInt32(this.e, 8), this.b, this.c), this.f);
            IColorPalette iColorPalette = this.getPalette();
            if (iColorPalette != null) {
                GifHelper.savePalette(streamContainer, iColorPalette);
            }
            GifFrameBlock.saveGif(this, streamContainer, this.a(), this.a, this.getInterlaced());
        }
        finally {
            if (streamContainer != null) {
                streamContainer.dispose();
            }
        }
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
        this.b = n2;
        this.c = n3;
    }

    @Override
    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        this.f = GifFrameBlock.createFlags(iColorPalette2, (Operators.castToInt32(this.f, 6) & 0x20) > 0, (Operators.castToInt32(this.f, 6) & 0x40) > 0);
        super.onPaletteChanged(iColorPalette, iColorPalette2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, byte by2, boolean bl2) {
        PartialEncoder partialEncoder = new PartialEncoder(rasterImage, streamContainer, iColorPalette, Operators.castToInt32(by2, 6), rasterImage.getWidth(), rasterImage.getHeight());
        try {
            if (bl2) {
                PartialProcessor.processInterlaced(rasterImage.getBounds().Clone(), rasterImage.getWidth(), rasterImage.getHeight(), partialEncoder);
            } else {
                PartialProcessor.process(rasterImage.getBounds().Clone(), partialEncoder);
            }
        }
        finally {
            if (partialEncoder != null) {
                partialEncoder.dispose();
            }
        }
    }

    private IColorPalette a() {
        IColorPalette iColorPalette = null;
        if (this.getContainer() != null) {
            iColorPalette = this.getContainer().getPalette();
        }
        return GifFrameBlock.getColorPalette(this.getPalette(), iColorPalette);
    }

    private void a(IColorPalette iColorPalette, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3, byte by2) {
        this.f = GifFrameBlock.createFlags(iColorPalette, bl2, bl3);
        this.d = n2;
        this.e = n3;
        this.a = Operators.castToInt32(by2, 6) > 8 ? (byte)8 : (Operators.castToInt32(by2, 6) < 2 ? (byte)2 : by2);
        this.b = n4;
        this.c = n5;
    }

    private void a(RasterImagePixelLoader rasterImagePixelLoader, int n2, int n3, boolean bl2, boolean bl3, byte by2) {
        try {
            this.a(rasterImagePixelLoader.getRasterImage().getPalette(), n2, n3, rasterImagePixelLoader.getRasterImage().getWidth(), rasterImagePixelLoader.getRasterImage().getHeight(), bl2, bl3, by2);
            this.setPalette(rasterImagePixelLoader.getRasterImage().getPalette());
            this.setDataLoader(rasterImagePixelLoader);
        }
        catch (RuntimeException runtimeException) {
            rasterImagePixelLoader.dispose();
            throw runtimeException;
        }
    }

    private static class PartialEncoder
    extends DisposableObject
    implements IAdvancedBufferProcessor,
    IPartialArgb32PixelLoader,
    IPartialProcessor,
    IPartialRawDataLoader {
        private final StreamContainer a;
        private final IColorPalette b;
        private final RgbEntriesPaletteHash c;
        private final LzwVariableWidthBlockEncoder d;
        private final int e;
        private byte[] f = null;
        private final RasterImage g;
        private int h;
        private int i;

        public PartialEncoder(RasterImage rasterImage, StreamContainer streamContainer, IColorPalette iColorPalette, int n2, int n3, int n4) {
            this.g = rasterImage;
            this.b = iColorPalette;
            this.c = new RgbEntriesPaletteHash(iColorPalette);
            this.a = new StreamContainer(streamContainer.getStream());
            this.a.seekBegin();
            this.d = new LzwVariableWidthBlockEncoder(this, n2);
            this.d.startEncoding();
            this.e = n4;
            this.i = n3 * n4;
            if (!this.a()) {
                this.f = BufferHelper.allocate(this.i);
            }
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            int n2 = msMath.min(this.f.length - this.h, nArray.length);
            int n3 = 0;
            do {
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n4 = nArray[n3++];
                    this.f[this.h++] = Operators.castToByte(this.c.getNearestColorIndex(n4), 9);
                }
                if (this.f.length - this.h != 0) continue;
                this.d.encode(this.f, this.h);
                this.h = 0;
            } while ((n2 = msMath.min(this.f.length - this.h, nArray.length - n3)) > 0);
            this.i -= nArray.length;
            if (this.i == 0) {
                this.d.encode(this.f, this.h);
                this.d.finishEncoding(this.e);
            }
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2) {
            this.d.encode(byArray, byArray.length);
            this.i -= byArray.length;
            if (this.i == 0) {
                this.d.finishEncoding(this.e);
            }
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2, LoadOptions loadOptions) {
            throw new NotImplementedException();
        }

        @Override
        public void processBuffer(byte[] byArray, int n2) {
            this.a.write(byArray, 0, n2);
        }

        @Override
        public void finishRow() {
        }

        @Override
        public void finishRows(int n2) {
        }

        @Override
        public void process(Rectangle rectangle) {
            if (this.a()) {
                GifFrameBlockDataReader gifFrameBlockDataReader = (GifFrameBlockDataReader)((GifFrameBlock)this.g).getDataLoader();
                gifFrameBlockDataReader.loadRawData(rectangle.Clone(), this);
            } else {
                this.g.loadPartialArgb32Pixels(rectangle.Clone(), this);
            }
        }

        @Override
        protected void releaseManagedResources() {
            this.a.dispose();
            super.releaseManagedResources();
        }

        private boolean a() {
            boolean bl2 = Operators.is(this.g, GifFrameBlock.class) && Operators.is(Operators.as(this.g, GifFrameBlock.class).getDataLoader(), GifFrameBlockDataReader.class);
            return bl2;
        }
    }
}

