/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.GifImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;

public class GifHelper {
    private static final int a = 3;

    public static IColorPalette loadPalette(StreamContainer streamContainer, int n2) {
        if (streamContainer == null) {
            throw new ArgumentNullException("stream");
        }
        if (n2 <= 0) {
            throw new NotSupportedException("palSize");
        }
        int n3 = 3 * n2;
        int[] nArray = ArrayHelper.getColors(n2);
        byte[] byArray = new byte[n3];
        if (n3 != streamContainer.read(byArray)) {
            throw new GifImageException("Cannot load palette. Not enough bytes to read from the stream.");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = ColorHelper.toArgb(ColorHelper.fromArgb(byArray[3 * i2] & 0xFF, byArray[3 * i2 + 1] & 0xFF, byArray[3 * i2 + 2] & 0xFF));
        }
        return new ColorPalette(nArray);
    }

    public static void savePalette(StreamContainer streamContainer, IColorPalette iColorPalette) {
        if (streamContainer == null) {
            throw new ArgumentNullException("stream");
        }
        if (iColorPalette == null) {
            throw new ArgumentNullException("palette");
        }
        int[] nArray = iColorPalette.getArgb32Entries();
        byte[] byArray = new byte[nArray.length * 3];
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            byte by2 = (byte)(n3 >> 16 & 0xFF);
            byte by3 = (byte)(n3 >> 8 & 0xFF);
            byte by4 = (byte)(n3 & 0xFF);
            byArray[n2++] = by2;
            byArray[n2++] = by3;
            byArray[n2++] = by4;
        }
        streamContainer.write(byArray);
    }

    public static byte[] loadBytes(StreamContainer streamContainer, int n2) {
        if (streamContainer == null) {
            throw new ArgumentNullException("streamContainer");
        }
        byte[] byArray = new byte[n2];
        if (streamContainer.read(byArray) != n2) {
            throw new GifImageException("Cannot load data. There is not enough bytes to read from stream.");
        }
        return byArray;
    }

    public static void writePackagedData(byte[] byArray, StreamContainer streamContainer) {
        GifHelper.writePackagedData(byArray, streamContainer.getStream());
    }

    public static void writePackagedData(byte[] byArray, Stream stream) {
        if (byArray != null) {
            int n2;
            for (int i2 = 0; i2 < Array.boxing(byArray).getLength(); i2 += n2) {
                n2 = msMath.min(255, Array.boxing(byArray).getLength() - i2);
                stream.writeByte((byte)n2);
                stream.write(byArray, i2, n2);
            }
        }
        stream.writeByte((byte)0);
    }

    public static byte[] readPackagedData(StreamContainer streamContainer) {
        return GifHelper.readPackagedData(streamContainer.getStream());
    }

    public static byte[] readPackagedData(Stream stream) {
        long l2 = stream.getPosition();
        int n2 = stream.readByte();
        int n3 = 0;
        while (n2 != 0) {
            n3 += n2;
            stream.seek(n2, 1);
            n2 = stream.readByte();
            if (n2 != -1) continue;
            return new byte[]{0};
        }
        byte[] byArray = new byte[n3];
        stream.seek(l2, 0);
        for (int i2 = 0; i2 < n3; i2 += n2) {
            n2 = stream.readByte();
            if (stream.read(byArray, i2, n2) == n2) continue;
            throw new GifImageException("Cannot load application data. There is not enough bytes to read from stream.");
        }
        stream.readByte();
        return byArray;
    }
}

