/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.ImageException;
import com.aspose.html.internal.ms.lang.Operators;

public class GifHeader {
    private static final int a = 6;
    private static final int b = 7;
    private final byte[] c;
    private final byte[] d;
    private int e;
    private int f;
    private byte g;
    private byte h;
    private byte i;
    private boolean j;

    public GifHeader(int n2, int n3, byte by2, byte by3, byte by4) {
        this(new byte[]{71, 73, 70, 56, 57, 97}, n2, n3, by2, by3, by4);
    }

    public GifHeader(byte[] byArray, int n2, int n3, byte by2, byte by3, byte by4) {
        if (byArray == null) {
            throw new ArgumentNullException("formatVersion");
        }
        if (byArray.length != 6) {
            throw new ArgumentOutOfRangeException("formatVersion", "Expected exactly 6 bytes.");
        }
        this.c = new byte[3];
        this.d = new byte[3];
        Array.copy(Array.boxing(byArray), Array.boxing(this.c), 3);
        Array.copy(Array.boxing(byArray), 3, Array.boxing(this.d), 0, 3);
        this.e = n2;
        this.f = n3;
        this.g = by2;
        this.h = by3;
        this.i = by4;
    }

    public boolean isChanged() {
        return this.j;
    }

    public byte getBackgroundColorIndex() {
        return this.h;
    }

    public void setBackgroundColorIndex(byte by2) {
        if (Operators.castToInt32(by2, 6) != Operators.castToInt32(this.h, 6)) {
            this.h = by2;
            this.j = true;
        }
    }

    public String getFormatName() {
        return Encoding.getASCII().getString(this.c, 0, this.c.length);
    }

    public String getFormatVersion() {
        return Encoding.getASCII().getString(this.d, 0, this.d.length);
    }

    public int getWidth() {
        return this.e;
    }

    public void setWidth(int n2) {
        if (Operators.castToUInt16(n2, 8) != Operators.castToUInt16(this.e, 8)) {
            this.e = n2;
            this.j = true;
        }
    }

    public int getHeight() {
        return this.f;
    }

    public void setHeight(int n2) {
        if (Operators.castToUInt16(n2, 8) != Operators.castToUInt16(this.f, 8)) {
            this.f = n2;
            this.j = true;
        }
    }

    public byte getPixelAspectRatio() {
        return this.i;
    }

    public void setPixelAspectRatio(byte by2) {
        if (Operators.castToInt32(this.i, 6) != Operators.castToInt32(by2, 6)) {
            this.i = by2;
            this.j = true;
        }
    }

    public boolean hasPalette() {
        return (Operators.castToInt32(this.g, 6) & 0x80) != 0;
    }

    public void setPalette(boolean bl2) {
        if (bl2 != this.hasPalette()) {
            this.g = bl2 ? (byte)(Operators.castToInt32(this.g, 6) | 0x80) : (byte)(Operators.castToInt32(this.g, 6) & 0x7F);
            this.j = true;
        }
    }

    public boolean isSorted() {
        return (Operators.castToInt32(this.g, 6) & 8) != 0;
    }

    public void setSorted(boolean bl2) {
        if (bl2 != this.isSorted()) {
            this.g = bl2 ? (byte)(Operators.castToInt32(this.g, 6) | 8) : (byte)(Operators.castToInt32(this.g, 6) & 0xF7);
            this.j = true;
        }
    }

    public byte getColorResolution() {
        return Operators.castToByte((Operators.castToInt32(this.g, 6) & 0x70) >> 4, 9);
    }

    public void setColorResolution(byte by2) {
        if (Operators.castToInt32(by2, 6) != Operators.castToInt32(this.getColorResolution(), 6)) {
            this.g = (byte)(Operators.castToInt32(this.g, 6) & 0x8F);
            this.g = (byte)(Operators.castToInt32(this.g, 6) | Operators.castToInt32(Operators.castToByte((Operators.castToInt32(by2, 6) & 7) << 4, 9), 6));
            this.j = true;
        }
    }

    public int getPaletteSize() {
        return 2 << (Operators.castToInt32(this.g, 6) & 7);
    }

    public void setPaletteSize(int n2) {
        if (n2 != this.getPaletteSize()) {
            byte by2 = 0;
            while (n2 > 3) {
                n2 >>= 1;
                by2 = (byte)(by2 + 1);
            }
            this.g = (byte)(Operators.castToInt32(this.g, 6) & 0xF8);
            this.g = (byte)(Operators.castToInt32(this.g, 6) | Operators.castToInt32(by2, 6));
            this.j = true;
        }
    }

    public static byte generateFlags(int n2, boolean bl2, boolean bl3, byte by2) {
        byte by3 = 0;
        while (n2 > 3) {
            n2 >>= 1;
            by3 = (byte)(by3 + 1);
        }
        byte by4 = by3;
        if (bl3) {
            by4 = (byte)(Operators.castToInt32(by4, 6) | 8);
        }
        if (Operators.castToInt32(by2, 6) > 7) {
            throw new ArgumentOutOfRangeException("colorResolution", "The color resolution must be in 0-7 range.");
        }
        by4 = (byte)(Operators.castToInt32(by4, 6) | Operators.castToInt32(Operators.castToByte(Operators.castToInt32(by2, 6) << 4, 9), 6));
        if (bl2) {
            by4 = (byte)(Operators.castToInt32(by4, 6) | 0x80);
        }
        return by4;
    }

    public void writeHeader(StreamContainer streamContainer) {
        if (streamContainer == null) {
            throw new ArgumentNullException("stream");
        }
        streamContainer.setPosition(0L);
        streamContainer.write(this.c);
        streamContainer.write(this.d);
        streamContainer.write(BitConverter.getBytesUInt16(this.e));
        streamContainer.write(BitConverter.getBytesUInt16(this.f));
        streamContainer.writeByte(this.g);
        streamContainer.writeByte(this.h);
        streamContainer.writeByte(this.i);
        this.j = false;
    }

    public static GifHeader readHeader(StreamContainer streamContainer, boolean bl2) {
        streamContainer.seekBegin();
        GifHeader gifHeader = null;
        byte[] byArray = new byte[6];
        int n2 = streamContainer.read(byArray);
        if (n2 == byArray.length) {
            if (Operators.castToInt32(byArray[0], 6) == 71 && Operators.castToInt32(byArray[1], 6) == 73 && Operators.castToInt32(byArray[2], 6) == 70 && Operators.castToInt32(byArray[3], 6) == 56 && (Operators.castToInt32(byArray[4], 6) == 57 || Operators.castToInt32(byArray[4], 6) == 55) && Operators.castToInt32(byArray[5], 6) == 97) {
                byte[] byArray2 = new byte[7];
                n2 = streamContainer.read(byArray2);
                if (n2 == byArray2.length) {
                    int n3 = BitConverter.toUInt16(byArray2, 0);
                    int n4 = BitConverter.toUInt16(byArray2, 2);
                    byte by2 = byArray2[4];
                    byte by3 = byArray2[5];
                    byte by4 = byArray2[6];
                    gifHeader = new GifHeader(byArray, n3, n4, by2, by3, by4);
                } else if (!bl2) {
                    String string = StringExtensions.format("Cannot deserialize dat from stream. There is not enough bytes to read from. Expected: {0} bytes but loaded: {1} bytes", Operators.boxing(byArray2.length), Operators.boxing(n2));
                    throw new ImageException(string);
                }
            } else if (!bl2) {
                throw new ImageException("The GIF version is not supported.");
            }
        } else if (!bl2) {
            String string = StringExtensions.format("Cannot deserialize data from stream. There is not enough bytes to read from. Expected: {0} bytes but loaded: {1} bytes", Operators.boxing(byArray.length), Operators.boxing(n2));
            throw new ImageException(string);
        }
        return gifHeader;
    }
}

