/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.BufferHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.LoadOptions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RawDataSettings;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RgbEntriesPaletteHash;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ValueResult;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.compressors.LzwVariableWidthBlockDecoder;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.imageformats.GifImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks.GifFrameBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.gif.blocks.GifGraphicsControlBlock;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialRawDataLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IRasterImageArgb32PixelLoader;
import com.aspose.html.internal.ms.lang.Operators;

public class GifFrameBlockDataReader
implements IRasterImageArgb32PixelLoader {
    private final StreamContainer a;
    private final IColorPalette b;
    private final int c;
    private final int d;
    private final int e;
    private final boolean f;
    private final long g;
    private GifFrameBlock h;

    public GifFrameBlockDataReader(StreamContainer streamContainer, long l2, boolean bl2, IColorPalette iColorPalette, int n2, int n3, int n4) {
        if (streamContainer == null) {
            throw new ArgumentNullException("loadPixelsDataStream");
        }
        if (iColorPalette == null) {
            throw new ArgumentNullException("pixelsPalette");
        }
        this.g = l2;
        this.a = streamContainer;
        this.b = iColorPalette;
        this.c = n2;
        this.d = n3;
        this.e = n4;
        this.f = bl2;
    }

    @Override
    public boolean isRawDataAvailable() {
        return false;
    }

    @Override
    public RawDataSettings getRawDataSettings() {
        throw new NotImplementedException();
    }

    public IColorPalette getPalette() {
        return this.b;
    }

    @Override
    public void loadRawData(Rectangle rectangle, RawDataSettings rawDataSettings, IPartialRawDataLoader iPartialRawDataLoader) {
        throw new NotImplementedException();
    }

    public void setGifFrameBlock(GifFrameBlock gifFrameBlock) {
        this.h = gifFrameBlock;
    }

    @Override
    public void loadPartialArgb32Pixels(Rectangle rectangle, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
        PartialPixelLoader partialPixelLoader = new PartialPixelLoader(rectangle.Clone(), this, iPartialArgb32PixelLoader);
        this.loadRawData(rectangle.Clone(), partialPixelLoader);
    }

    public void loadRawData(Rectangle rectangle, IPartialRawDataLoader iPartialRawDataLoader) {
        this.a.seek(this.g, 0);
        LzwVariableWidthBlockDecoder lzwVariableWidthBlockDecoder = new LzwVariableWidthBlockDecoder(this.a, this.e);
        lzwVariableWidthBlockDecoder.startDecoding();
        PartialRawLoader partialRawLoader = new PartialRawLoader(lzwVariableWidthBlockDecoder, iPartialRawDataLoader, rectangle.Clone());
        Rectangle.fromLeftTopRightBottom(0, 0, Operators.castToInt32(this.c, 8), rectangle.getBottom()).CloneTo(rectangle);
        if (this.f) {
            PartialProcessor.processInterlaced(rectangle.Clone(), Operators.castToInt32(this.c, 8), Operators.castToInt32(this.d, 8), partialRawLoader);
        } else {
            PartialProcessor.process(rectangle.Clone(), partialRawLoader);
        }
    }

    private static class PartialColorToByteConverter
    implements IPartialArgb32PixelLoader {
        private final IPartialRawDataLoader a;
        private final IColorPalette b;
        private final RgbEntriesPaletteHash c;
        private final int[] d;
        private final byte e;
        private final int f;
        private boolean g = true;

        public PartialColorToByteConverter(IPartialRawDataLoader iPartialRawDataLoader, IColorPalette iColorPalette, int[] nArray, byte by2, int n2) {
            this.a = iPartialRawDataLoader;
            this.b = iColorPalette;
            this.c = new RgbEntriesPaletteHash(iColorPalette);
            this.d = nArray;
            this.e = by2;
            this.f = n2;
            if (this.d == null) {
                this.g = false;
            }
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            byte[] byArray = new byte[nArray.length];
            if (this.g) {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    byArray[i2] = nArray[i2] == this.f ? this.e : Operators.castToByte(this.d[this.c.getNearestColorIndex(nArray[i2])], 9);
                }
            } else {
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    byArray[i3] = Operators.castToByte(this.c.getNearestColorIndex(nArray[i3]), 9);
                }
            }
            this.a.process(rectangle.Clone(), byArray, point.Clone(), point2.Clone());
        }
    }

    private static class PartialRawLoader
    implements IPartialProcessor {
        private final LzwVariableWidthBlockDecoder a;
        private final IPartialRawDataLoader b;
        private final IColorPalette c = null;
        private final ColorPalette d = null;
        private final int[] e = null;
        private final byte f = 0;
        private final int g = 0;
        private final int h = 0;
        private final boolean i = false;
        private final Rectangle j = new Rectangle();

        public PartialRawLoader(LzwVariableWidthBlockDecoder lzwVariableWidthBlockDecoder, IPartialRawDataLoader iPartialRawDataLoader, Rectangle rectangle) {
            rectangle.CloneTo(this.j);
            this.a = lzwVariableWidthBlockDecoder;
            this.b = iPartialRawDataLoader;
        }

        @Override
        public void process(Rectangle rectangle) {
            int n2 = rectangle.getWidth();
            int n3 = rectangle.getHeight();
            int n4 = n2 * n3;
            if (BufferHelper.getMaxAllowedAllocation() > 0 && n4 > BufferHelper.getMaxAllowedAllocation()) {
                throw new OutOfMemoryException();
            }
            Rectangle rectangle2 = Rectangle.intersect(rectangle.Clone(), this.j.Clone()).Clone();
            byte[] byArray = new byte[n4];
            byte[] byArray2 = null;
            if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0 && !rectangle2.equals(Operators.boxing(rectangle))) {
                byArray2 = new byte[rectangle2.getWidth() * rectangle2.getHeight()];
            }
            ValueResult valueResult = this.a.decode(byArray, byArray.length).Clone();
            int n5 = valueResult.Value;
            if (byArray.length != n5 || !valueResult.Success) {
                throw new GifImageException("Found inconsistency in image data. The image data contained has incorrect pixels count.");
            }
            if (rectangle2.getWidth() > 0 && rectangle2.getHeight() > 0) {
                Rectangle rectangle3 = new Rectangle(rectangle2.getLeft() - rectangle.getLeft(), rectangle2.getTop() - rectangle.getTop(), rectangle2.getWidth(), rectangle2.getHeight());
                byte[] byArray3 = BufferHelper.fillDataSubset(byArray, n2, n3, byArray2, rectangle3.Clone(), false);
                rectangle3.offset(rectangle.getLocation().Clone());
                this.b.process(rectangle3.Clone(), byArray3, rectangle3.getLocation().Clone(), new Point(rectangle3.getRight(), rectangle3.getBottom()));
            }
        }
    }

    private static class PartialPixelLoader
    implements IPartialRawDataLoader {
        private final IPartialArgb32PixelLoader a;
        private final GifFrameBlockDataReader b;
        private final Rectangle c = new Rectangle();
        private LoadOptions d;

        public PartialPixelLoader(Rectangle rectangle, GifFrameBlockDataReader gifFrameBlockDataReader, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            rectangle.CloneTo(this.c);
            this.b = gifFrameBlockDataReader;
            this.a = iPartialArgb32PixelLoader;
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2) {
            int n2;
            Object object;
            int[] nArray = this.b.b.getArgb32Entries();
            if (this.b.h != null && (object = this.b.h.getControlBlock()) != null && ((GifGraphicsControlBlock)object).hasTransparentColor() && (n2 = Operators.castToInt32(((GifGraphicsControlBlock)object).getTransparentColorIndex(), 6)) >= 0 && n2 < nArray.length) {
                int n3 = n2;
                nArray[n3] = nArray[n3] & 0xFFFFFF;
            }
            object = new PartialConverter(byArray, rectangle.Clone(), nArray, this.a);
            PartialProcessor.process(this.c.Clone(), (IPartialProcessor)object);
        }

        @Override
        public void process(Rectangle rectangle, byte[] byArray, Point point, Point point2, LoadOptions loadOptions) {
            throw new NotImplementedException();
        }
    }

    private static class PartialConverter
    implements IPartialProcessor {
        private final byte[] a;
        private final IPartialArgb32PixelLoader b;
        private final int[] c;
        private Rectangle d = new Rectangle();

        public PartialConverter(byte[] byArray, Rectangle rectangle, int[] nArray, IPartialArgb32PixelLoader iPartialArgb32PixelLoader) {
            this.c = nArray;
            this.a = byArray;
            rectangle.CloneTo(this.d);
            this.b = iPartialArgb32PixelLoader;
        }

        @Override
        public void process(Rectangle rectangle) {
            Rectangle rectangle2 = Rectangle.intersect(this.d.Clone(), rectangle.Clone()).Clone();
            if (!rectangle2.isEmpty()) {
                int[] nArray = new int[rectangle2.getWidth() * rectangle2.getHeight()];
                for (int i2 = rectangle2.getTop(); i2 < rectangle2.getBottom(); ++i2) {
                    int n2 = (i2 - this.d.getTop()) * this.d.getWidth();
                    int n3 = (i2 - rectangle2.getTop()) * rectangle2.getWidth();
                    for (int i3 = 0; i3 < rectangle2.getWidth(); ++i3) {
                        nArray[i3 + n3] = this.c[Operators.castToInt32(this.a[i3 + n2], 6)];
                    }
                }
                this.b.process(rectangle2.Clone(), nArray, rectangle2.getLocation().Clone(), new Point(rectangle2.getRight(), rectangle2.getBottom()));
            }
        }
    }
}

