/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;

public abstract class RgbToIndexedConverter
extends ColorConverter {
    protected final int DestMask;
    protected final IColorPalette DestinationPalette;
    protected final int FallbackIndex;
    protected final int InitialBitShift;
    protected final int Ratio;
    protected final int SampleSize;
    protected final int SamplesPerByte;

    protected RgbToIndexedConverter(int n2, int n3, int n4, PixelDataFormat pixelDataFormat, Rectangle rectangle, PixelDataFormat pixelDataFormat2, int n5, IColorPalette iColorPalette, int n6) {
        super(n2, n3, n4, pixelDataFormat, rectangle.Clone(), pixelDataFormat2, n5);
        if (this.DestinationPixelSize <= 8 && iColorPalette == null) {
            throw new ArgumentNullException("destinationPalette");
        }
        this.DestinationPalette = iColorPalette;
        int n7 = (int)msMath.pow(2.0, this.DestinationPixelSize);
        this.DestMask = n7 - 1;
        this.FallbackIndex = n6;
        this.SamplesPerByte = 8 / this.DestinationPixelSize;
        this.Ratio = this.SourcePixelSize / this.DestinationPixelSize;
        this.SampleSize = this.SourcePixelSize / 8;
        this.InitialBitShift = 8 - this.DestinationPixelSize;
    }

    @Override
    protected void convert(byte[] byArray, int n2, int n3, int n4, int n5, byte[] byArray2, int n6, int n7) {
        int n8 = (this.SamplesPerByte - n3 / this.SourcePixelSize % this.SamplesPerByte - 1) * this.DestinationPixelSize;
        this.convertToIndexed(byArray, n2, n3, n4, n5, byArray2, n6, n7, n8);
    }

    protected abstract void convertToIndexed(byte[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9);
}

