/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IIndexedColorConverter;

public final class MapColorConverter
extends ColorConverter {
    private static final int a = 256;
    private final byte[] b;

    public MapColorConverter(int n2, int n3, int n4, IColorPalette iColorPalette, PixelDataFormat pixelDataFormat, Rectangle rectangle, int n5, IColorPalette iColorPalette2, int n6, IIndexedColorConverter iIndexedColorConverter, int n7) {
        super(n2, n3, n4, pixelDataFormat, rectangle.Clone(), pixelDataFormat, n5);
        int n8;
        if (iColorPalette == null) {
            throw new ArgumentNullException("sourcePalette");
        }
        if (iColorPalette2 == null) {
            throw new ArgumentNullException("destinationPalette");
        }
        this.b = new byte[256];
        int n9 = (int)msMath.pow(2.0, this.SourcePixelSize);
        byte[] byArray = null;
        int n10 = 8 / this.SourcePixelSize;
        int n11 = n8 = n9 - 1;
        if (n6 == 2) {
            byArray = MapColorConverter.getConversionMap(iIndexedColorConverter, pixelDataFormat, pixelDataFormat, n9, n9);
            for (int i2 = 0; i2 < 256; ++i2) {
                int n12 = 8 - this.SourcePixelSize;
                byte by2 = 0;
                for (int i3 = 0; i3 < n10; ++i3) {
                    int n13 = i2 >> n12 & n8;
                    int n14 = byArray[n13] & 0xFF;
                    by2 = (byte)(by2 & 0xFF | n14 << n12 & 0xFF);
                    n12 -= this.SourcePixelSize;
                }
                this.b[i2] = by2;
            }
        } else {
            int[] nArray = MapColorConverter.correctPaletteEntries(iColorPalette, this.SourcePixelSize).getArgb32Entries();
            for (int i4 = 0; i4 < 256; ++i4) {
                int n15 = 8 - this.SourcePixelSize;
                byte by3 = 0;
                for (int i5 = 0; i5 < n10; ++i5) {
                    int n16 = i4 >> n15 & n8;
                    int n17 = nArray[n16];
                    int n18 = iColorPalette2.getNearestColorIndex(n17);
                    if (n18 > n11) {
                        n18 = n7;
                    }
                    by3 = (byte)(by3 & 0xFF | n18 << n15 & 0xFF);
                    n15 -= this.SourcePixelSize;
                }
                this.b[i4] = by3;
            }
        }
    }

    @Override
    protected void convert(byte[] byArray, int n2, int n3, int n4, int n5, byte[] byArray2, int n6, int n7) {
        int n8 = (n3 + n4 * this.SourcePixelSize - 1) / 8;
        int n9 = n3 / 8;
        int n10 = n8 - n9 + 1;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n11 = n2 + this.LineSize * i2;
            int n12 = i2 * n7 + n6;
            for (int i3 = 0; i3 < n10; ++i3) {
                byte by2;
                byArray2[n12 + i3] = by2 = this.b[byArray[n11 + i3] & 0xFF];
            }
        }
    }
}

