/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PixelDataFormat;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.colorconverters.ColorConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;

public abstract class IndexedToRgbConverter
extends ColorConverter {
    protected final int DestinationBytesCount;
    protected final int Ratio;
    protected final int SamplesPerByte;
    protected final int SourceMask;
    protected final IColorPalette SourcePalette;
    private byte[][] a;

    protected IndexedToRgbConverter(int n2, int n3, int n4, PixelDataFormat pixelDataFormat, Rectangle rectangle, PixelDataFormat pixelDataFormat2, int n5, IColorPalette iColorPalette) {
        super(n2, n3, n4, pixelDataFormat, rectangle.Clone(), pixelDataFormat2, n5);
        if (iColorPalette == null) {
            throw new ArgumentNullException("sourcePalette");
        }
        this.SourcePalette = iColorPalette;
        int n6 = (int)msMath.pow(2.0, this.SourcePixelSize);
        this.SourceMask = n6 - 1;
        this.SamplesPerByte = 8 / this.SourcePixelSize;
        this.Ratio = this.DestinationPixelSize / this.SourcePixelSize;
        this.DestinationBytesCount = this.DestinationPixelSize / 8;
    }

    @Override
    protected void convert(byte[] byArray, int n2, int n3, int n4, int n5, byte[] byArray2, int n6, int n7) {
        if (this.a == null) {
            int[] nArray = IndexedToRgbConverter.correctPaletteEntries(this.SourcePalette, this.SourcePixelSize).getArgb32Entries();
            this.a = this.createMap(nArray);
        }
        for (int i2 = 0; i2 < n5; ++i2) {
            int n8 = n3 + n4 * this.SourcePixelSize;
            int n9 = (n8 - 1) / 8;
            int n10 = n3 / 8;
            int n11 = n9 - n10 + 1;
            int n12 = n3;
            int n13 = n3 % 8 / this.SourcePixelSize * this.DestinationBytesCount;
            int n14 = 0;
            for (int i3 = 0; i3 < n11; ++i3) {
                byte[] byArray3 = this.a[byArray[i3 + this.LineSize * i2 + n2] & 0xFF];
                int n15 = (n12 + 8) / 8 * 8;
                n15 = msMath.min(n15, n8);
                int n16 = (n15 - n12) / this.SourcePixelSize;
                int n17 = n16 * this.DestinationBytesCount;
                System.arraycopy(byArray3, n13, byArray2, n6 + n14, n17);
                n12 += n16 * this.SourcePixelSize;
                n13 = 0;
                n14 += n17;
            }
            n6 += n7;
        }
    }

    protected abstract byte[][] createMap(int[] var1);
}

