/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.BitConverter;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.OutOfMemoryException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ByteConverter;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Cache;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.DisposableObject;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Image;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialPixelSaver;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.PartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.RasterImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ResampleHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Size;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.exceptions.ImageException;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.fileformats.internal.CacheImage;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IColorPalette;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialArgb32PixelLoader;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialProcessor;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IResizeController;
import com.aspose.html.internal.ms.lang.Operators;

public abstract class RasterCachedImage
extends RasterImage {
    private static int a;
    private static int b;

    protected RasterCachedImage() {
    }

    protected RasterCachedImage(IColorPalette iColorPalette) {
        super(iColorPalette);
    }

    public static int getRotateMode() {
        return a;
    }

    public static void setRotateMode(int n2) {
        a = n2;
    }

    public static int getMaxAllowedAllocationForPartialRotateSave() {
        return b;
    }

    public static void setMaxAllowedAllocationForPartialRotateSave(int n2) {
        b = n2;
    }

    @Override
    public final boolean isCached() {
        return Operators.is(this.getDataLoader(), CacheImage.class);
    }

    @Override
    public final void cacheData() {
        this.savePixelsInternal(Rectangle.getEmpty().Clone(), null);
    }

    @Override
    public final void resize(int n2, int n3, int n4) {
        ResampleHelper.resample(this, n2, n3, n4);
    }

    @Override
    public final void rotateFlip(int n2) {
        if (n2 != 14 && n2 != 0) {
            DisposableObject disposableObject = null;
            try {
                switch (n2) {
                    case 2: 
                    case 12: {
                        disposableObject = new PartialRotateNoneFlipXY(this.getWidth(), this.getHeight());
                        break;
                    }
                    case 6: 
                    case 8: {
                        disposableObject = new PartialRotateNoneFlipY(this.getWidth(), this.getHeight());
                        break;
                    }
                    case 4: 
                    case 10: {
                        disposableObject = new PartialRotateNoneFlipX(this.getWidth(), this.getHeight());
                        break;
                    }
                    case 3: 
                    case 13: {
                        disposableObject = new PartialRotate90FlipXY(this.getHeight(), this.getWidth());
                        break;
                    }
                    case 7: 
                    case 9: {
                        disposableObject = new PartialRotate90FlipY(this.getHeight(), this.getWidth());
                        break;
                    }
                    case 1: 
                    case 15: {
                        disposableObject = new PartialRotate90FlipNone(this.getHeight(), this.getWidth());
                        break;
                    }
                    case 5: 
                    case 11: {
                        disposableObject = new PartialRotate90FlipX(this.getHeight(), this.getWidth());
                        break;
                    }
                    default: {
                        throw new ImageException("Unsupported rotate flip operation.");
                    }
                }
                this.loadPartialArgb32Pixels(this.getBounds().Clone(), (IPartialArgb32PixelLoader)((Object)disposableObject));
                this.a(((PartialRotater)disposableObject).getNewWidth(), ((PartialRotater)disposableObject).getNewHeight(), (PartialRotater)disposableObject);
            }
            finally {
                if (disposableObject != null) {
                    disposableObject.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rotate(float f2, boolean bl2, int n2) {
        this.verifyNotDisposed();
        DisposableObject disposableObject = null;
        try {
            f2 = PartialCustomRotater.modAngle(f2);
            if (f2 < Float.MIN_VALUE) {
                return;
            }
            disposableObject = PartialCustomRotater.create(this.getWidth(), this.getHeight(), f2, bl2, n2);
            this.loadPartialArgb32Pixels(this.getBounds().Clone(), (IPartialArgb32PixelLoader)((Object)disposableObject));
            this.a(((PartialRotater)disposableObject).getNewWidth(), ((PartialRotater)disposableObject).getNewHeight(), (PartialRotater)disposableObject);
        }
        finally {
            if (disposableObject != null) {
                disposableObject.dispose();
            }
        }
    }

    @Override
    public void crop(Rectangle rectangle) {
        this.verifyNotDisposed();
        if (rectangle.isEmpty() || rectangle.getX() < 0 || rectangle.getY() < 0 || rectangle.getWidth() < 0 || rectangle.getHeight() < 0) {
            throw new ArgumentException("Rectangle incorrect.", "rectangle");
        }
        if (!this.getBounds().contains(rectangle.Clone())) {
            throw new ArgumentException("Rectangle must be contained in the image bounds.", "rectangle");
        }
        DisposableObject disposableObject = null;
        try {
            disposableObject = new CacheImage(rectangle.getWidth(), rectangle.getHeight());
            int[] nArray = this.loadArgb32Pixels(rectangle.Clone());
            ((RasterImage)disposableObject).saveArgb32Pixels(new Rectangle(Point.getEmpty().Clone(), rectangle.getSize().Clone()), nArray);
        }
        catch (RuntimeException runtimeException) {
            if (disposableObject != null) {
                disposableObject.dispose();
            }
            throw new ImageException("Can't clone cache image.", runtimeException);
        }
        this.replaceDataReader((CacheImage)disposableObject);
    }

    IResizeController beginResize(int n2, int n3) {
        ResizeController resizeController = new ResizeController(this, n2, n3);
        return resizeController;
    }

    protected abstract void updateDimensions(int var1, int var2);

    protected void onCached() {
    }

    @Override
    protected final void savePixelsInternal(Rectangle rectangle, int[] nArray) {
        if (!Operators.is(this.getDataLoader(), CacheImage.class)) {
            DisposableObject disposableObject = null;
            try {
                disposableObject = new CacheImage(this.getWidth(), this.getHeight());
                ((Image)disposableObject).setPalette(this.getPalette());
                if (Rectangle.op_Equality(rectangle, this.getBounds()) && nArray != null) {
                    ((RasterImage)disposableObject).saveArgb32Pixels(rectangle.Clone(), nArray);
                } else {
                    PartialPixelSaver partialPixelSaver = new PartialPixelSaver((RasterImage)disposableObject);
                    this.loadPixelsInternal(this.getBounds().Clone(), partialPixelSaver);
                    if (nArray != null) {
                        ((RasterImage)disposableObject).saveArgb32Pixels(rectangle.Clone(), nArray);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                if (disposableObject != null) {
                    disposableObject.dispose();
                }
                throw runtimeException;
            }
            this.replaceDataReader((CacheImage)disposableObject);
        } else if (nArray != null) {
            Operators.as(this.getDataLoader(), CacheImage.class).saveArgb32Pixels(rectangle.Clone(), nArray);
        }
    }

    @Override
    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        if (Operators.is(this.getDataLoader(), CacheImage.class)) {
            Operators.as(this.getDataLoader(), CacheImage.class).setPalette(iColorPalette2);
        }
        super.onPaletteChanged(iColorPalette, iColorPalette2);
    }

    protected void replaceDataReader(CacheImage cacheImage) {
        this.setDataLoader(cacheImage);
        if (cacheImage != null) {
            this.updateDimensions(cacheImage.getWidth(), cacheImage.getHeight());
        }
        this.onCached();
    }

    private void a(int n2, int n3, PartialRotater partialRotater) {
        CacheImage cacheImage = new CacheImage(n2, n3);
        try {
            cacheImage.setPalette(this.getPalette());
            PartialRotateSaver partialRotateSaver = new PartialRotateSaver(partialRotater, cacheImage);
            PartialProcessor.process(new Rectangle(0, 0, n2, n3), partialRotateSaver);
        }
        catch (RuntimeException runtimeException) {
            cacheImage.dispose();
            throw runtimeException;
        }
        this.replaceDataReader(cacheImage);
    }

    private static class PartialCustomRotater
    extends PartialRotater {
        private final float a;
        private final int b;

        private PartialCustomRotater(int n2, int n3, double d2, int n4) {
            super(n2, n3);
            this.a = Operators.castToFloat(d2 * Math.PI / 180.0, 14);
            this.b = n4;
        }

        public static PartialCustomRotater create(int n2, int n3, float f2, boolean bl2, int n4) {
            if (bl2) {
                Size size = PartialCustomRotater.a(n2, n3, f2).Clone();
                return new PartialCustomRotater(size.getWidth(), size.getHeight(), f2, n4);
            }
            return new PartialCustomRotater(n2, n3, f2, n4);
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            int n2 = this.getNewWidth();
            int n3 = this.getNewHeight();
            int n4 = rectangle.getWidth();
            int n5 = rectangle.getHeight();
            int[] nArray2 = this.getColors();
            byte[] byArray = this.getBytes();
            int[] nArray3 = PartialCustomRotater.a(rectangle.getWidth(), rectangle.getHeight());
            int n6 = n2 / 2;
            int n7 = n3 / 2;
            int n8 = n4 / 2;
            int n9 = n5 / 2;
            double d2 = msMath.sin(-this.a);
            double d3 = msMath.cos(-this.a);
            if (nArray2 != null) {
                int n10 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n11 = i2 - n7;
                    for (int i3 = 0; i3 < n2; ++i3) {
                        int n12 = i3 - n6;
                        int n13 = Operators.castToInt32(msMath.round(d3 * (double)n12 - d2 * (double)n11 + (double)n8), 14);
                        int n14 = Operators.castToInt32(msMath.round(d2 * (double)n12 + d3 * (double)n11 + (double)n9), 14);
                        nArray2[n10++] = n13 >= 0 && n13 < n4 && n14 >= 0 && n14 < n5 ? nArray[nArray3[n14] + n13] : this.b;
                    }
                }
            } else if (byArray != null) {
                int n15 = 0;
                byte[] byArray2 = ByteConverter.getBigEndianBytesInt32(this.b);
                for (int i4 = 0; i4 < n3; ++i4) {
                    int n16 = i4 - n7;
                    for (int i5 = 0; i5 < n2; ++i5) {
                        int n17 = i5 - n6;
                        int n18 = Operators.castToInt32(msMath.round(d3 * (double)n17 - d2 * (double)n16 + (double)n8), 14);
                        int n19 = Operators.castToInt32(msMath.round(d2 * (double)n17 + d3 * (double)n16 + (double)n9), 14);
                        if (n18 >= 0 && n18 < n4 && n19 >= 0 && n19 < n5) {
                            int n20 = nArray[nArray3[n19] + n18];
                            ByteConverter.writeBigEndianBytesInt32(n20, byArray, n15 << 2);
                        } else {
                            Buffer.blockCopy(Array.boxing(byArray2), 0, Array.boxing(byArray), n15 << 2, 4);
                        }
                        ++n15;
                    }
                }
            } else {
                int n21 = 0;
                byte[] byArray3 = BitConverter.getBytesInt32(this.b);
                for (int i6 = 0; i6 < n3; ++i6) {
                    int n22 = i6 - n7;
                    for (int i7 = 0; i7 < n2; ++i7) {
                        int n23 = i7 - n6;
                        int n24 = Operators.castToInt32(msMath.round(d3 * (double)n23 - d2 * (double)n22 + (double)n8), 14);
                        int n25 = Operators.castToInt32(msMath.round(d2 * (double)n23 + d3 * (double)n22 + (double)n9), 14);
                        byte[] byArray4 = n24 >= 0 && n24 < n4 && n25 >= 0 && n25 < n5 ? BitConverter.getBytesInt32(nArray[nArray3[n25] + n24]) : byArray3;
                        this.getStreamContainer().seek(n21 << 2, 0);
                        this.getStreamContainer().write(byArray4, 0, 4);
                        ++n21;
                    }
                }
            }
        }

        public static float modAngle(float f2) {
            if (f2 < 0.0f) {
                while ((f2 += 360.0f) < 0.0f) {
                }
            } else {
                while (f2 >= 360.0f) {
                    f2 -= 360.0f;
                }
            }
            return f2;
        }

        private static float a(float f2) {
            float f3 = f2 <= 180.0f ? f2 : 360.0f - f2;
            if (f3 > 90.0f) {
                f3 = 180.0f - f3;
            }
            return f3;
        }

        private static Size a(int n2, int n3, float f2) {
            f2 = Operators.castToFloat((double)PartialCustomRotater.a(f2) * Math.PI / 180.0, 14);
            int n4 = Operators.castToInt32(msMath.abs((double)n2 * msMath.sin(f2) + (double)n3 * msMath.cos(f2)), 14);
            int n5 = Operators.castToInt32(msMath.abs((double)n2 * msMath.cos(f2) + (double)n3 * msMath.sin(f2)), 14);
            return new Size(n5, n4);
        }

        private static int[] a(int n2, int n3) {
            int[] nArray = new int[n3];
            int n4 = 0;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = n4;
                n4 += n2;
            }
            return nArray;
        }
    }

    private static class PartialRotateNoneFlipXY
    extends PartialRotater {
        public PartialRotateNoneFlipXY(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            int n2 = this.getNewHeight();
            int n3 = this.getNewWidth();
            int n4 = rectangle.getWidth();
            int n5 = rectangle.getHeight();
            int n6 = 0;
            int n7 = rectangle.getTop();
            int n8 = rectangle.getLeft();
            int[] nArray2 = this.getColors();
            byte[] byArray = this.getBytes();
            if (nArray2 != null) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n9 = n3 - (i3 + n8) - 1;
                        int n10 = (n2 - (i2 + n7) - 1) * n3;
                        nArray2[n9 + n10] = nArray[n6++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    for (int i5 = 0; i5 < n4; ++i5) {
                        int n11 = n3 - (i5 + n8) - 1;
                        int n12 = (n2 - (i4 + n7) - 1) * n3;
                        ByteConverter.writeBigEndianBytesInt32(nArray[n6++], byArray, (n11 + n12) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n5; ++i6) {
                    for (int i7 = 0; i7 < n4; ++i7) {
                        int n13 = n3 - (i7 + n8) - 1;
                        int n14 = (n2 - (i6 + n7) - 1) * n3;
                        int n15 = (n13 + n14) * 4;
                        this.getStreamContainer().seek(n15, 0);
                        this.getStreamContainer().write(BitConverter.getBytesInt32(nArray[n6++]), 0, 4);
                    }
                }
            }
        }
    }

    private static class PartialRotateNoneFlipY
    extends PartialRotater {
        public PartialRotateNoneFlipY(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            int n2 = this.getNewHeight();
            int n3 = this.getNewWidth();
            int n4 = rectangle.getWidth();
            int n5 = rectangle.getHeight();
            int n6 = 0;
            int n7 = rectangle.getTop();
            int n8 = rectangle.getLeft();
            int[] nArray2 = this.getColors();
            byte[] byArray = this.getBytes();
            if (nArray2 != null) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n9 = i3 + n8;
                        int n10 = (n2 - (i2 + n7) - 1) * n3;
                        nArray2[n9 + n10] = nArray[n6++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    for (int i5 = 0; i5 < n4; ++i5) {
                        int n11 = i5 + n8;
                        int n12 = (n2 - (i4 + n7) - 1) * n3;
                        ByteConverter.writeBigEndianBytesInt32(nArray[n6++], byArray, (n11 + n12) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n5; ++i6) {
                    for (int i7 = 0; i7 < n4; ++i7) {
                        int n13 = i7 + n8;
                        int n14 = (n2 - (i6 + n7) - 1) * n3;
                        int n15 = (n13 + n14) * 4;
                        this.getStreamContainer().seek(n15, 0);
                        this.getStreamContainer().write(BitConverter.getBytesInt32(nArray[n6++]), 0, 4);
                    }
                }
            }
        }
    }

    private static class PartialRotateNoneFlipX
    extends PartialRotater {
        public PartialRotateNoneFlipX(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            int n2 = this.getNewHeight();
            int n3 = this.getNewWidth();
            int n4 = rectangle.getWidth();
            int n5 = rectangle.getHeight();
            int n6 = 0;
            int n7 = rectangle.getTop();
            int n8 = rectangle.getLeft();
            int[] nArray2 = this.getColors();
            byte[] byArray = this.getBytes();
            if (nArray2 != null) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n9 = n3 - (i3 + n8) - 1;
                        int n10 = (i2 + n7) * n3;
                        nArray2[n9 + n10] = nArray[n6++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    for (int i5 = 0; i5 < n4; ++i5) {
                        int n11 = n3 - (i5 + n8) - 1;
                        int n12 = (i4 + n7) * n3;
                        ByteConverter.writeBigEndianBytesInt32(nArray[n6++], byArray, (n11 + n12) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n5; ++i6) {
                    for (int i7 = 0; i7 < n4; ++i7) {
                        int n13 = n3 - (i7 + n8) - 1;
                        int n14 = (i6 + n7) * n3;
                        int n15 = (n13 + n14) * 4;
                        this.getStreamContainer().seek(n15, 0);
                        this.getStreamContainer().write(BitConverter.getBytesInt32(nArray[n6++]), 0, 4);
                    }
                }
            }
        }
    }

    private static class PartialRotate90FlipXY
    extends PartialRotater {
        public PartialRotate90FlipXY(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            int n2 = this.getNewHeight();
            int n3 = this.getNewWidth();
            int n4 = rectangle.getWidth();
            int n5 = rectangle.getHeight();
            int n6 = 0;
            int n7 = rectangle.getTop();
            int n8 = rectangle.getLeft();
            int[] nArray2 = this.getColors();
            byte[] byArray = this.getBytes();
            if (nArray2 != null) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n9 = i2 + n7;
                        int n10 = (n2 - (i3 + n8) - 1) * n3;
                        nArray2[n9 + n10] = nArray[n6++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    for (int i5 = 0; i5 < n4; ++i5) {
                        int n11 = i4 + n7;
                        int n12 = (n2 - (i5 + n8) - 1) * n3;
                        ByteConverter.writeBigEndianBytesInt32(nArray[n6++], byArray, (n11 + n12) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n5; ++i6) {
                    for (int i7 = 0; i7 < n4; ++i7) {
                        int n13 = i6 + n7;
                        int n14 = (n2 - (i7 + n8) - 1) * n3;
                        int n15 = (n13 + n14) * 4;
                        this.getStreamContainer().seek(n15, 0);
                        this.getStreamContainer().write(BitConverter.getBytesInt32(nArray[n6++]), 0, 4);
                    }
                }
            }
        }
    }

    private static class PartialRotate90FlipY
    extends PartialRotater {
        public PartialRotate90FlipY(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            int n2 = this.getNewHeight();
            int n3 = this.getNewWidth();
            int n4 = rectangle.getWidth();
            int n5 = rectangle.getHeight();
            int n6 = 0;
            int n7 = rectangle.getTop();
            int n8 = rectangle.getLeft();
            int[] nArray2 = this.getColors();
            byte[] byArray = this.getBytes();
            if (nArray2 != null) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    for (int i3 = 0; i3 < n4; ++i3) {
                        int n9 = n3 - (i2 + n7) - 1;
                        int n10 = (n2 - (i3 + n8) - 1) * n3;
                        nArray2[n9 + n10] = nArray[n6++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n5; ++i4) {
                    for (int i5 = 0; i5 < n4; ++i5) {
                        int n11 = n3 - (i4 + n7) - 1;
                        int n12 = (n2 - (i5 + n8) - 1) * n3;
                        ByteConverter.writeBigEndianBytesInt32(nArray[n6++], byArray, (n11 + n12) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n5; ++i6) {
                    for (int i7 = 0; i7 < n4; ++i7) {
                        int n13 = n3 - (i6 + n7) - 1;
                        int n14 = (n2 - (i7 + n8) - 1) * n3;
                        int n15 = (n13 + n14) * 4;
                        this.getStreamContainer().seek(n15, 0);
                        this.getStreamContainer().write(BitConverter.getBytesInt32(nArray[n6++]), 0, 4);
                    }
                }
            }
        }
    }

    private static class PartialRotate90FlipNone
    extends PartialRotater {
        public PartialRotate90FlipNone(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            int n2 = this.getNewWidth();
            int n3 = rectangle.getWidth();
            int n4 = rectangle.getHeight();
            int n5 = 0;
            int n6 = rectangle.getTop();
            int n7 = rectangle.getLeft();
            int[] nArray2 = this.getColors();
            byte[] byArray = this.getBytes();
            if (nArray2 != null) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int n8 = n2 - (i2 + n6) - 1;
                        int n9 = (i3 + n7) * n2;
                        nArray2[n8 + n9] = nArray[n5++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n4; ++i4) {
                    for (int i5 = 0; i5 < n3; ++i5) {
                        int n10 = n2 - (i4 + n6) - 1;
                        int n11 = (i5 + n7) * n2;
                        ByteConverter.writeBigEndianBytesInt32(nArray[n5++], byArray, (n10 + n11) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n4; ++i6) {
                    for (int i7 = 0; i7 < n3; ++i7) {
                        int n12 = n2 - (i6 + n6) - 1;
                        int n13 = (i7 + n7) * n2;
                        int n14 = (n12 + n13) * 4;
                        this.getStreamContainer().seek(n14, 0);
                        this.getStreamContainer().write(BitConverter.getBytesInt32(nArray[n5++]), 0, 4);
                    }
                }
            }
        }
    }

    private static class PartialRotate90FlipX
    extends PartialRotater {
        public PartialRotate90FlipX(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
            int n2 = this.getNewWidth();
            int n3 = rectangle.getWidth();
            int n4 = rectangle.getHeight();
            int n5 = 0;
            int n6 = rectangle.getTop();
            int n7 = rectangle.getLeft();
            int[] nArray2 = this.getColors();
            byte[] byArray = this.getBytes();
            if (nArray2 != null) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n8 = i2 + n6;
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int n9 = (i3 + n7) * n2;
                        nArray2[n8 + n9] = nArray[n5++];
                    }
                }
            } else if (byArray != null) {
                for (int i4 = 0; i4 < n4; ++i4) {
                    int n10 = i4 + n6;
                    for (int i5 = 0; i5 < n3; ++i5) {
                        int n11 = (i5 + n7) * n2;
                        ByteConverter.writeBigEndianBytesInt32(nArray[n5++], byArray, (n10 + n11) * 4);
                    }
                }
            } else {
                for (int i6 = 0; i6 < n4; ++i6) {
                    int n12 = i6 + n6;
                    for (int i7 = 0; i7 < n3; ++i7) {
                        int n13 = (i7 + n7) * n2;
                        int n14 = (n12 + n13) * 4;
                        this.getStreamContainer().seek(n14, 0);
                        this.getStreamContainer().write(BitConverter.getBytesInt32(nArray[n5++]), 0, 4);
                    }
                }
            }
        }
    }

    private static abstract class PartialRotater
    extends DisposableObject
    implements IPartialArgb32PixelLoader {
        private StreamContainer a = null;
        private int[] b = null;
        private byte[] c = null;
        private final int d;
        private final int e;

        protected PartialRotater(int n2, int n3) {
            this.d = n2;
            this.e = n3;
            int n4 = n2 * n3;
            if (a == 0) {
                this.b = PartialRotater.a(n4);
            }
            if (this.b == null) {
                int n5 = n4 * 4;
                if (a == 1) {
                    this.c = PartialRotater.b(n5);
                }
                if (this.c == null) {
                    this.a = Cache.allocate(n5);
                    this.a.seekBegin();
                }
            }
        }

        public int[] getColors() {
            return this.b;
        }

        public byte[] getBytes() {
            return this.c;
        }

        public StreamContainer getStreamContainer() {
            return this.a;
        }

        public int getNewWidth() {
            return this.d;
        }

        public int getNewHeight() {
            return this.e;
        }

        @Override
        public abstract void process(Rectangle var1, int[] var2, Point var3, Point var4);

        @Override
        protected void releaseManagedResources() {
            if (this.a != null) {
                this.a.dispose();
            }
            super.releaseManagedResources();
        }

        private static int[] a(int n2) {
            int[] nArray = null;
            try {
                nArray = new int[n2];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            return nArray;
        }

        private static byte[] b(int n2) {
            byte[] byArray = null;
            try {
                byArray = new byte[n2];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            return byArray;
        }
    }

    private static class ResizeController
    extends DisposableObject
    implements IResizeController {
        private final RasterCachedImage a;
        private CacheImage b;

        public ResizeController(RasterCachedImage rasterCachedImage, int n2, int n3) {
            this.b = new CacheImage(n2, n3);
            this.a = rasterCachedImage;
        }

        @Override
        public void resizePartialPixels(int[] nArray, Rectangle rectangle, Point point, Point point2) {
            this.b.saveArgb32Pixels(rectangle.Clone(), nArray);
        }

        @Override
        public void finishResize() {
            this.a.replaceDataReader(this.b);
            this.b = null;
        }

        @Override
        protected void releaseManagedResources() {
            if (this.b != null) {
                this.b.dispose();
            }
            super.releaseManagedResources();
        }
    }

    private static class PartialRotateSaver
    implements IPartialProcessor {
        private final PartialRotater a;
        private final CacheImage b;

        public PartialRotateSaver(PartialRotater partialRotater, CacheImage cacheImage) {
            this.a = partialRotater;
            this.b = cacheImage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(Rectangle rectangle) {
            if (RasterCachedImage.getMaxAllowedAllocationForPartialRotateSave() > 0 && rectangle.getWidth() * rectangle.getHeight() > RasterCachedImage.getMaxAllowedAllocationForPartialRotateSave()) {
                throw new OutOfMemoryException();
            }
            int n2 = rectangle.getWidth();
            int n3 = rectangle.getHeight();
            int n4 = rectangle.getLeft();
            int n5 = rectangle.getTop();
            int n6 = this.b.getWidth();
            int n7 = this.b.getHeight();
            if (this.a.getColors() != null) {
                if (n4 == 0 && n5 == 0 && n2 == n6 && n3 == n7) {
                    this.b.saveArgb32Pixels(rectangle.Clone(), this.a.getColors());
                } else {
                    int[] nArray = new int[n2 * n3];
                    int[] nArray2 = this.a.getColors();
                    for (int i2 = 0; i2 < n3; ++i2) {
                        int n8 = i2 * n2;
                        int n9 = (i2 + n5) * n6;
                        for (int i3 = 0; i3 < n2; ++i3) {
                            int n10 = i3 + n4 + n9;
                            int n11 = i3 + n8;
                            nArray[n11] = nArray2[n10];
                        }
                    }
                    this.b.saveArgb32Pixels(rectangle.Clone(), nArray);
                }
            } else if (this.a.getBytes() != null) {
                int[] nArray = new int[n2 * n3];
                byte[] byArray = this.a.getBytes();
                for (int i4 = 0; i4 < n3; ++i4) {
                    int n12 = i4 * n2;
                    int n13 = (i4 + n5) * n6;
                    for (int i5 = 0; i5 < n2; ++i5) {
                        int n14 = (i5 + n4 + n13) * 4;
                        int n15 = i5 + n12;
                        nArray[n15] = ByteConverter.fromBigEndianToInt32(byArray, n14);
                    }
                }
                this.b.saveArgb32Pixels(rectangle.Clone(), nArray);
            } else {
                byte[] byArray = new byte[4];
                int[] nArray = new int[n2 * n3];
                StreamContainer streamContainer = new StreamContainer(new MemoryStream(this.a.getStreamContainer().toBytes()));
                try {
                    for (int i6 = 0; i6 < n3; ++i6) {
                        int n16 = i6 * n2;
                        int n17 = (i6 + n5) * n6;
                        for (int i7 = 0; i7 < n2; ++i7) {
                            int n18 = (i7 + n4 + n17) * 4;
                            int n19 = i7 + n16;
                            streamContainer.seek(n18, 0);
                            if (streamContainer.read(byArray) != byArray.length) {
                                throw new ImageException("Cannot read color data. Unable to continue execution.");
                            }
                            nArray[n19] = BitConverter.toInt32(byArray, 0);
                        }
                    }
                }
                finally {
                    if (streamContainer != null) {
                        streamContainer.dispose();
                    }
                }
                this.b.saveArgb32Pixels(rectangle.Clone(), nArray);
            }
        }
    }

    public static final class RotateTestMode
    extends Enum {
        public static final int RegularMode = 0;
        public static final int ByteArrayMode = 1;
        public static final int StreamMode = 2;

        private RotateTestMode() {
        }

        static {
            Enum.register(new Enum.SimpleEnum((Class)RotateTestMode.class, Integer.class){
                {
                    this.addConstant("RegularMode", 0L);
                    this.addConstant("ByteArrayMode", 1L);
                    this.addConstant("StreamMode", 2L);
                }
            });
        }
    }
}

