/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ArrayHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Cache;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorHelper;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.ColorInfo;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.DisposableObject;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Point;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Rectangle;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.Resampler;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.interfaces.IPartialPixelLoader;
import java.awt.Color;

class LanczosResampler
extends Resampler {
    private static final int a = 3;
    private final int b;
    private final int c;
    private final double[][] d;
    private FilterProcessor e;

    public LanczosResampler(int n2, int n3, int n4, int n5, IPartialPixelLoader iPartialPixelLoader) {
        super(n2, n3, n4, n5, iPartialPixelLoader);
        this.b = n2;
        this.c = n3;
        this.d = LanczosResampler.a(this.getScaleX(), this.getScaleY());
    }

    @Override
    public void process(Rectangle rectangle, int[] nArray, Point point, Point point2) {
        if (rectangle.getWidth() == this.b && rectangle.getHeight() == this.c && rectangle.getLeft() == 0 & rectangle.getTop() == 0) {
            FastFilterProcessor fastFilterProcessor = new FastFilterProcessor(this.b, this.c, this.d);
            fastFilterProcessor.setData(nArray);
            for (int i2 = 0; i2 < rectangle.getHeight(); ++i2) {
                this.a(fastFilterProcessor, i2);
            }
        } else {
            boolean bl2;
            int n2;
            if (this.e == null) {
                n2 = 7 * this.b;
                this.e = new FastFilterProcessor(this.b, this.c, this.d);
                bl2 = false;
                try {
                    this.e.prepareData(n2);
                    bl2 = true;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
                if (!bl2) {
                    this.e = new SlowFilterProcessor(this.b, this.c, this.d);
                    this.e.prepareData(n2);
                }
            }
            for (n2 = 0; n2 < rectangle.getHeight(); ++n2) {
                this.e.fillData(nArray, n2 * rectangle.getWidth(), rectangle.getWidth(), rectangle.getTop() + n2);
                if (rectangle.getRight() % this.b != 0) continue;
                boolean bl3 = bl2 = rectangle.getBottom() == this.c && n2 == rectangle.getHeight() - 1;
                if (bl2) {
                    for (int i3 = 0; i3 <= 3; ++i3) {
                        this.a(this.e, rectangle.getTop() + n2 + i3 - 3);
                    }
                    continue;
                }
                this.a(this.e, rectangle.getTop() + n2 - 3);
            }
        }
    }

    @Override
    protected void releaseManagedResources() {
        if (this.e != null) {
            this.e.dispose();
        }
        super.releaseManagedResources();
    }

    private static double[][] a(double d2, double d3) {
        double[][] dArray = new double[7][7];
        for (int i2 = -3; i2 <= 3; ++i2) {
            double d4 = (double)i2 * d3;
            double d5 = 3.0 * msMath.sin(d4 * Math.PI) * msMath.sin(d4 * Math.PI / 3.0) / (Math.PI * Math.PI * d4 * d4);
            if (DoubleExtensions.isNaN(d5)) {
                d5 = 1.0;
            }
            for (int i3 = -3; i3 <= 3; ++i3) {
                double d6;
                double d7 = (double)i3 * d2;
                double d8 = 3.0 * msMath.sin(d7 * Math.PI) * msMath.sin(d7 * Math.PI / 3.0) / (Math.PI * Math.PI * d7 * d7);
                if (DoubleExtensions.isNaN(d8)) {
                    d8 = 1.0;
                }
                dArray[i3 + 3][i2 + 3] = d6 = d8 * d5;
            }
        }
        return dArray;
    }

    private void a(FilterProcessor filterProcessor, int n2) {
        Rectangle rectangle;
        if (n2 >= 0 && (rectangle = this.getProjectedRectangle(new Rectangle(0, n2, this.b, 1)).Clone()).getWidth() > 0 && rectangle.getHeight() > 0) {
            int n3 = rectangle.getLeft();
            int n4 = rectangle.getTop();
            ColorInfo colorInfo = ColorHelper.allocate(rectangle.Clone());
            int n5 = colorInfo.getRectangle().getWidth();
            int n6 = 0;
            int n7 = rectangle.getWidth() * rectangle.getHeight();
            int n8 = colorInfo.getRectangle().getWidth();
            int n9 = colorInfo.getRectangle().getHeight();
            int n10 = 0;
            int n11 = 0;
            double d2 = this.getInvertScaleX();
            double d3 = this.getInvertScaleY();
            IPartialPixelLoader iPartialPixelLoader = this.getFinalProcessor();
            while (n6 < n7) {
                int n12;
                int n13 = n3 + n10 + n8;
                if (n13 > rectangle.getRight()) {
                    n8 -= n13 - rectangle.getRight();
                }
                if ((n12 = n4 + n11 + n9) > rectangle.getBottom()) {
                    n9 -= n12 - rectangle.getBottom();
                }
                for (int i2 = 0; i2 < n9; ++i2) {
                    for (int i3 = 0; i3 < n8; ++i3) {
                        int n14 = (int)(d2 * ((double)(i3 + n3 + n10) + 0.5));
                        int n15 = (int)(d3 * ((double)(i2 + n4 + n11) + 0.5));
                        Color color = filterProcessor.applyLanczosFilter(n14, n15);
                        colorInfo.getColors()[i3 + i2 * n5] = ColorHelper.toArgb(color);
                    }
                }
                Rectangle rectangle2 = new Rectangle(n3 + n10, n4 + n11, n8, n9);
                iPartialPixelLoader.process(rectangle2.Clone(), colorInfo.getColors(), rectangle2.getLocation().Clone(), new Point(rectangle2.getRight(), rectangle2.getBottom()));
                n6 += n8 * n9;
                if (n9 > 1) {
                    n11 += n9;
                    continue;
                }
                if ((n10 += n8) < rectangle.getWidth()) continue;
                n10 = 0;
                ++n11;
                n8 = colorInfo.getRectangle().getWidth();
            }
        }
    }

    private static class SlowFilterProcessor
    extends FilterProcessor {
        private StreamContainer a;
        private int b;
        private int c;

        public SlowFilterProcessor(int n2, int n3, double[][] dArray) {
            super(n2, n3, dArray);
        }

        @Override
        public void prepareData(int n2) {
            this.a = Cache.allocate(n2 * 4);
        }

        @Override
        public void fillData(int[] nArray, int n2, int n3, int n4) {
            if ((long)this.b == this.a.getLength()) {
                this.b = 0;
            }
            this.a.seek(this.b * 4, 0);
            byte[] byArray = new byte[4];
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5 = nArray[n2++];
                byArray[0] = (byte)(n5 >> 24);
                byArray[1] = (byte)(n5 >> 16 & 0xFF);
                byArray[2] = (byte)(n5 >> 8 & 0xFF);
                byArray[3] = (byte)(n5 & 0xFF);
                this.a.write(byArray);
                ++this.b;
            }
            this.c = n4;
        }

        @Override
        public Color applyLanczosFilter(int n2, int n3) {
            int n4;
            int n5;
            int n6 = msMath.max(0, n2 - 3);
            int n7 = msMath.min(this.width - 1, n2 + 3);
            int n8 = msMath.max(0, n3 - 3);
            int n9 = msMath.min(this.height - 1, n3 + 3);
            long l2 = this.b - (this.c - n9) * this.width;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (n5 = n9; n5 >= n8; --n5) {
                if ((l2 -= (long)this.width) < 0L) {
                    l2 = this.a.getLength() - (long)this.width;
                }
                this.a.seek((l2 + (long)n6) * 4L, 0);
                byte[] byArray = new byte[4];
                for (n4 = n6; n4 <= n7; ++n4) {
                    double d7 = this.lancrosFilter[n4 - n2 + 3][n5 - n3 + 3];
                    this.a.read(byArray);
                    byte by2 = byArray[0];
                    byte by3 = byArray[1];
                    byte by4 = byArray[2];
                    byte by5 = byArray[3];
                    d2 += d7 * (double)(by2 & 0xFF);
                    d3 += d7 * (double)(by3 & 0xFF);
                    d4 += d7 * (double)(by4 & 0xFF);
                    d5 += d7 * (double)(by5 & 0xFF);
                    d6 += d7;
                }
            }
            n5 = (int)(d3 / d6 + 0.5);
            int n10 = (int)(d4 / d6 + 0.5);
            n4 = (int)(d5 / d6 + 0.5);
            int n11 = (int)(d2 / d6 + 0.5);
            if (n5 < 0) {
                n5 = 0;
            }
            if (n10 < 0) {
                n10 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (n11 < 0) {
                n11 = 0;
            }
            if (n5 > 255) {
                n5 = 255;
            }
            if (n10 > 255) {
                n10 = 255;
            }
            if (n4 > 255) {
                n4 = 255;
            }
            if (n11 > 255) {
                n11 = 255;
            }
            return ColorHelper.fromArgb(n11, n5, n10, n4);
        }

        @Override
        protected void releaseManagedResources() {
            this.a.dispose();
            super.releaseManagedResources();
        }
    }

    private static class FastFilterProcessor
    extends FilterProcessor {
        private int[] a;
        private int b;
        private int c;

        public FastFilterProcessor(int n2, int n3, double[][] dArray) {
            super(n2, n3, dArray);
        }

        public void setData(int[] nArray) {
            this.a = nArray;
            this.c = nArray.length / this.width - 1;
            this.b = this.a.length;
        }

        @Override
        public void prepareData(int n2) {
            this.a = ArrayHelper.getColors(n2);
        }

        @Override
        public void fillData(int[] nArray, int n2, int n3, int n4) {
            if (this.b == this.a.length) {
                this.b = 0;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5 = nArray[n2++];
                this.a[this.b++] = n5;
            }
            this.c = n4;
        }

        @Override
        public Color applyLanczosFilter(int n2, int n3) {
            int n4;
            int n5;
            int n6 = msMath.max(0, n2 - 3);
            int n7 = msMath.min(this.width - 1, n2 + 3);
            int n8 = msMath.max(0, n3 - 3);
            int n9 = msMath.min(this.height - 1, n3 + 3);
            int n10 = this.b - (this.c - n9) * this.width;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (n5 = n9; n5 >= n8; --n5) {
                if ((n10 -= this.width) < 0) {
                    n10 = this.a.length - this.width;
                }
                for (n4 = n6; n4 <= n7; ++n4) {
                    double d7 = this.lancrosFilter[n4 - n2 + 3][n5 - n3 + 3];
                    int n11 = this.a[n4 + n10];
                    byte by2 = (byte)(n11 >> 24);
                    byte by3 = (byte)(n11 >> 16 & 0xFF);
                    byte by4 = (byte)(n11 >> 8 & 0xFF);
                    byte by5 = (byte)(n11 & 0xFF);
                    d2 += d7 * (double)(by2 & 0xFF);
                    d3 += d7 * (double)(by3 & 0xFF);
                    d4 += d7 * (double)(by4 & 0xFF);
                    d5 += d7 * (double)(by5 & 0xFF);
                    d6 += d7;
                }
            }
            n5 = (int)(d3 / d6 + 0.5);
            n4 = (int)(d4 / d6 + 0.5);
            int n12 = (int)(d5 / d6 + 0.5);
            int n13 = (int)(d2 / d6 + 0.5);
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (n12 < 0) {
                n12 = 0;
            }
            if (n13 < 0) {
                n13 = 0;
            }
            if (n5 > 255) {
                n5 = 255;
            }
            if (n4 > 255) {
                n4 = 255;
            }
            if (n12 > 255) {
                n12 = 255;
            }
            if (n13 > 255) {
                n13 = 255;
            }
            return ColorHelper.fromArgb(n13, n5, n4, n12);
        }
    }

    private static abstract class FilterProcessor
    extends DisposableObject {
        protected final double[][] lancrosFilter;
        protected final int width;
        protected final int height;

        protected FilterProcessor(int n2, int n3, double[][] dArray) {
            this.lancrosFilter = dArray;
            this.width = n2;
            this.height = n3;
        }

        public abstract void prepareData(int var1);

        public abstract void fillData(int[] var1, int var2, int var3, int var4);

        public abstract Color applyLanczosFilter(int var1, int var2);
    }
}

