/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IO.File;
import com.aspose.html.internal.ms.System.IO.FileInfo;
import com.aspose.html.internal.ms.System.IO.FileStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.DisposableObject;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.FileStreamContainer;
import com.aspose.html.internal.ms.core.System.Drawing.imagecodecs.core.StreamContainer;
import com.aspose.html.internal.ms.lang.Operators;

public abstract class DataStreamSupporter
extends DisposableObject {
    private StreamContainer a;

    public StreamContainer getDataStreamContainer() {
        return this.a;
    }

    public void setDataStreamContainer(StreamContainer streamContainer) {
        if (streamContainer == null) {
            throw new ArgumentNullException("value");
        }
        try {
            this.onDataStreamContainerChanging(streamContainer);
        }
        finally {
            this.a = streamContainer;
        }
    }

    public abstract boolean isCached();

    public abstract void cacheData();

    public void save() {
        this.verifyNotDisposed();
        if (this.a == null) {
            throw new IllegalStateException("Cannot perform save operation when underlying stream is not defined.");
        }
        this.a.seekBegin();
        this.save(this.a.getStream());
    }

    public void save(Stream stream) {
        this.verifyNotDisposed();
        if (this.a != null && stream == this.a.getStream() && !this.isCached()) {
            long l2 = stream.getPosition();
            this.cacheData();
            stream.setPosition(l2);
        }
        this.saveData(stream);
    }

    protected abstract void saveData(Stream var1);

    public void save(String string) {
        this.verifyNotDisposed();
        if (this.a(string)) {
            this.save(this.a.getStream());
        } else {
            FileStream fileStream = File.create(string);
            try {
                this.save(fileStream);
            }
            finally {
                if (fileStream != null) {
                    fileStream.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string, boolean bl2) {
        this.verifyNotDisposed();
        if (this.a(string)) {
            if (bl2) {
                this.a.seekBegin();
            } else {
                this.a.seek(0L, 2);
            }
            this.save(this.a.getStream());
        } else {
            if (!bl2 && File.exists(string)) {
                FileStream fileStream = File.openWrite(string);
                try {
                    this.save(fileStream);
                }
                finally {
                    if (fileStream != null) {
                        fileStream.dispose();
                    }
                }
            }
            FileStream fileStream = File.create(string);
            try {
                this.save(fileStream);
            }
            finally {
                if (fileStream != null) {
                    fileStream.dispose();
                }
            }
        }
    }

    @Override
    protected void releaseManagedResources() {
        if (this.a != null) {
            this.a.dispose();
            this.a = null;
        }
        super.releaseManagedResources();
    }

    protected void onDataStreamContainerChanging(StreamContainer streamContainer) {
    }

    private boolean a(String string) {
        boolean bl2 = false;
        if (this.a instanceof FileStreamContainer) {
            FileStreamContainer fileStreamContainer = Operators.as(this.a, FileStreamContainer.class);
            FileInfo fileInfo = new FileInfo(fileStreamContainer.getFilePath());
            FileInfo fileInfo2 = new FileInfo(string);
            bl2 = StringExtensions.equals(fileInfo.getFullName(), fileInfo2.getFullName());
        }
        return bl2;
    }
}

