/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.core.System.Drawing.Printing.Loaders;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Drawing.Printing.InvalidPrinterException;
import com.aspose.html.internal.ms.System.Drawing.Printing.PaperSize;
import com.aspose.html.internal.ms.System.Drawing.Printing.PaperSource;
import com.aspose.html.internal.ms.System.Drawing.Printing.PrinterResolution;
import com.aspose.html.internal.ms.System.Drawing.Printing.PrinterSettings;
import com.aspose.html.internal.ms.core.System.Drawing.Printing.CommonUtils;
import com.aspose.html.internal.ms.core.System.Drawing.Printing.Converters.MediaSizePaperSizeConverter;
import com.aspose.html.internal.ms.core.System.Drawing.Printing.Converters.MediaTrayPaperSourceConverter;
import com.aspose.html.internal.ms.core.System.Drawing.Printing.PrinterUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;

public class PrinterSettingsLoader {
    private String a;
    private PrintService b;
    private PrinterSettings c;
    private Media[] d;

    public static PrinterSettingsLoader getLoader(PrintService printService) {
        return new PrinterSettingsLoader(printService);
    }

    public static PrinterSettingsLoader getLoader(String string) {
        return new PrinterSettingsLoader(string);
    }

    private PrinterSettingsLoader(PrintService printService) {
        if (printService == null) {
            throw new ArgumentNullException("Value of 'printService' cannot be null");
        }
        this.b = printService;
        this.a = printService.getName();
    }

    private PrinterSettingsLoader(String string) {
        this.a = string;
        this.b = PrinterUtils.find(string);
        if (this.b == null) {
            throw new InvalidPrinterException("PrinterService for " + string + " not found");
        }
        this.d = (Media[])this.a(Media.class);
    }

    public void loadPrinterSettings(PrinterSettings printerSettings) {
        this.c = printerSettings;
        this.d = (Media[])this.a(Media.class);
        this.d();
        this.b();
        this.a();
        this.h();
        this.c();
        this.f();
        this.e();
        this.g();
        this.i();
        this.j();
    }

    private void a() {
        this.c.setCopies((short)1);
    }

    private void b() {
        SheetCollate[] sheetCollateArray = (SheetCollate[])this.a(SheetCollate.class);
        this.c.setCollate(false);
        if (sheetCollateArray != null) {
            for (SheetCollate sheetCollate : sheetCollateArray) {
                if (sheetCollate != SheetCollate.COLLATED) continue;
                this.c.setCollate(true);
                break;
            }
        }
    }

    private void c() {
        CopiesSupported copiesSupported = (CopiesSupported)this.b.getSupportedAttributeValues(Copies.class, null, null);
        int n2 = PrinterUtils.getMaximumCopies(copiesSupported);
        this.c.setMaximumCopies(n2);
    }

    private void d() {
        boolean bl2 = false;
        this.c.setDuplex(-1);
        Sides[] sidesArray = (Sides[])this.a(Sides.class);
        if (CommonUtils.isEmpty(sidesArray)) {
            this.c.setCan_duplex(bl2);
            return;
        }
        for (Sides sides : sidesArray) {
            if (!sides.equals(Sides.DUPLEX) && !sides.equals(Sides.TWO_SIDED_LONG_EDGE) && !sides.equals(Sides.TWO_SIDED_SHORT_EDGE)) continue;
            bl2 = true;
            break;
        }
        this.c.setCan_duplex(bl2);
        this.c.setDuplex(-1);
    }

    private void e() {
        Destination destination = this.b(Destination.class);
        this.c.setPrintToFile(false);
        URI uRI = destination.getURI();
        File file = new File(uRI.getSchemeSpecificPart());
        this.c.setPrintFileName(file.getAbsolutePath());
    }

    private PrinterSettings f() {
        JobName jobName = this.b(JobName.class);
        return this.c;
    }

    private PrinterSettings g() {
        javax.print.attribute.standard.PrinterResolution[] printerResolutionArray = (javax.print.attribute.standard.PrinterResolution[])this.a(javax.print.attribute.standard.PrinterResolution.class);
        if (printerResolutionArray == null) {
            return this.c;
        }
        PrinterResolution[] printerResolutionArray2 = new PrinterResolution[printerResolutionArray.length];
        for (int i2 = 0; i2 < printerResolutionArray.length; ++i2) {
            javax.print.attribute.standard.PrinterResolution printerResolution = printerResolutionArray[i2];
            int n2 = printerResolution.getResolution(100)[0];
            int n3 = printerResolution.getResolution(100)[1];
            printerResolutionArray2[i2] = new PrinterResolution(n2, n3, 0);
        }
        this.c.setPrinterResolutions(new PrinterSettings.PrinterResolutionCollection(printerResolutionArray2));
        return this.c;
    }

    private PrinterSettings h() {
        Chromaticity[] chromaticityArray = (Chromaticity[])this.a(Chromaticity.class);
        if (chromaticityArray == null) {
            this.c.setSupportsColor(false);
            return this.c;
        }
        if (chromaticityArray.length > 1) {
            this.c.setSupportsColor(true);
        } else {
            for (Chromaticity chromaticity : chromaticityArray) {
                if (chromaticity.equals(Chromaticity.COLOR)) {
                    this.c.setSupportsColor(true);
                    break;
                }
                this.c.setSupportsColor(false);
            }
        }
        return this.c;
    }

    private void i() {
        ArrayList<PaperSize> arrayList = new ArrayList<PaperSize>();
        if (this.d == null) {
            return;
        }
        for (Media media : this.d) {
            MediaSizeName mediaSizeName;
            PaperSize paperSize;
            if (!(media instanceof MediaSizeName) || (paperSize = MediaSizePaperSizeConverter.convertToPaperSize(mediaSizeName = (MediaSizeName)media)) == null) continue;
            arrayList.add(paperSize);
        }
        Object[] objectArray = new PaperSize[arrayList.size()];
        objectArray = (PaperSize[])arrayList.toArray(objectArray);
        this.c.setPaperSizes(new PrinterSettings.PaperSizeCollection((PaperSize[])objectArray));
    }

    private void j() {
        ArrayList<PaperSource> arrayList = new ArrayList<PaperSource>();
        if (this.d == null) {
            return;
        }
        for (Media media : this.d) {
            MediaTray mediaTray;
            PaperSource paperSource;
            if (!(media instanceof MediaTray) || (paperSource = MediaTrayPaperSourceConverter.convertToPaperSource(mediaTray = (MediaTray)media)) == null) continue;
            arrayList.add(paperSource);
        }
        Object[] objectArray = new PaperSource[arrayList.size()];
        objectArray = (PaperSource[])arrayList.toArray(objectArray);
        this.c.setPaperSources(new PrinterSettings.PaperSourceCollection((PaperSource[])objectArray));
    }

    private <T extends Attribute> T[] a(Class<T> clazz) {
        Attribute[] attributeArray = (Attribute[])this.b.getSupportedAttributeValues(clazz, null, null);
        return attributeArray;
    }

    private <T extends Attribute> T b(Class<T> clazz) {
        Attribute attribute = (Attribute)this.b.getSupportedAttributeValues(clazz, null, null);
        return (T)attribute;
    }
}

