/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.NameTable;
import com.aspose.html.internal.ms.System.Xml.ValidationEventArgs;
import com.aspose.html.internal.ms.System.Xml.ValidationEventHandler;
import com.aspose.html.internal.ms.System.Xml.XmlNameTable;
import com.aspose.html.internal.ms.System.Xml.XmlReader;
import com.aspose.html.internal.ms.System.Xml.XmlResolver;
import com.aspose.html.internal.ms.System.Xml.XmlSchema;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaCollectionEnumerator;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaException;
import com.aspose.html.internal.ms.System.Xml.XmlSchemaSet;
import com.aspose.html.internal.ms.System.Xml.XmlTextReader;
import com.aspose.html.internal.ms.System.Xml.XmlUrlResolver;

public final class XmlSchemaCollection
implements ICollection,
IEnumerable {
    private XmlSchemaSet a;
    public final ValidationEventHandler ValidationEventHandler = new ValidationEventHandler();

    public XmlSchemaCollection() {
        this(new NameTable());
    }

    public XmlSchemaCollection(XmlNameTable xmlNameTable) {
        this(new XmlSchemaSet(xmlNameTable));
        this.a.ValidationEventHandler.add(new ValidationEventHandler(){

            @Override
            public void invoke(Object object, ValidationEventArgs validationEventArgs) {
                XmlSchemaCollection.this.a(object, validationEventArgs);
            }
        });
    }

    XmlSchemaCollection(XmlSchemaSet xmlSchemaSet) {
        this.a = xmlSchemaSet;
    }

    XmlSchemaSet getSchemaSet() {
        return this.a;
    }

    @Override
    public int size() {
        return this.a.getCount();
    }

    public XmlNameTable getNameTable() {
        return this.a.getNameTable();
    }

    public XmlSchema get_Item(String string) {
        ICollection iCollection = this.a.schemas(string);
        if (iCollection == null) {
            return null;
        }
        IEnumerator iEnumerator = iCollection.iterator();
        if (iEnumerator.hasNext()) {
            return (XmlSchema)iEnumerator.next();
        }
        return null;
    }

    public XmlSchema add(String string, XmlReader xmlReader) {
        return this.add(string, xmlReader, new XmlUrlResolver());
    }

    public XmlSchema add(String string, XmlReader xmlReader, XmlResolver xmlResolver) {
        XmlSchema xmlSchema = XmlSchema.read(xmlReader, this.ValidationEventHandler);
        if (xmlSchema.getTargetNamespace() == null) {
            xmlSchema.setTargetNamespace(string);
        } else if (string != null && !StringExtensions.equals(xmlSchema.getTargetNamespace(), string)) {
            throw new XmlSchemaException("The actual targetNamespace in the schema does not match the parameter.");
        }
        return this.add(xmlSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlSchema add(String string, String string2) {
        XmlTextReader xmlTextReader = new XmlTextReader(string2);
        try {
            XmlSchema xmlSchema = this.add(string, xmlTextReader);
            return xmlSchema;
        }
        finally {
            ((XmlReader)xmlTextReader).close();
        }
    }

    public XmlSchema add(XmlSchema xmlSchema) {
        return this.add(xmlSchema, new XmlUrlResolver());
    }

    public XmlSchema add(XmlSchema xmlSchema, XmlResolver xmlResolver) {
        if (xmlSchema == null) {
            throw new ArgumentNullException("schema");
        }
        XmlSchemaSet xmlSchemaSet = new XmlSchemaSet(this.a.getNameTable());
        xmlSchemaSet.add(this.a);
        xmlSchemaSet.add(xmlSchema);
        xmlSchemaSet.ValidationEventHandler.add(new ValidationEventHandler(){

            @Override
            public void invoke(Object object, ValidationEventArgs validationEventArgs) {
                XmlSchemaCollection.this.ValidationEventHandler.invoke(object, validationEventArgs);
            }
        });
        xmlSchemaSet.setXmlResolver(xmlResolver);
        xmlSchemaSet.compile();
        if (!xmlSchemaSet.isCompiled()) {
            return null;
        }
        this.a = xmlSchemaSet;
        return xmlSchema;
    }

    public void add(XmlSchemaCollection xmlSchemaCollection) {
        if (xmlSchemaCollection == null) {
            throw new ArgumentNullException("schema");
        }
        XmlSchemaSet xmlSchemaSet = new XmlSchemaSet(this.a.getNameTable());
        xmlSchemaSet.add(this.a);
        xmlSchemaSet.add(xmlSchemaCollection.a);
        xmlSchemaSet.ValidationEventHandler.add(new ValidationEventHandler(){

            @Override
            public void invoke(Object object, ValidationEventArgs validationEventArgs) {
                XmlSchemaCollection.this.ValidationEventHandler.invoke(object, validationEventArgs);
            }
        });
        xmlSchemaSet.setXmlResolver(this.a.getXmlResolver());
        xmlSchemaSet.compile();
        if (!xmlSchemaSet.isCompiled()) {
            return;
        }
        this.a = xmlSchemaSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String string) {
        XmlSchemaSet xmlSchemaSet = this.a;
        synchronized (xmlSchemaSet) {
            return this.a.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(XmlSchema xmlSchema) {
        XmlSchemaSet xmlSchemaSet = this.a;
        synchronized (xmlSchemaSet) {
            return this.a.contains(xmlSchema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(XmlSchema[] xmlSchemaArray, int n2) {
        XmlSchemaSet xmlSchemaSet = this.a;
        synchronized (xmlSchemaSet) {
            this.a.copyTo(xmlSchemaArray, n2);
        }
    }

    public XmlSchemaCollectionEnumerator iterator() {
        return new XmlSchemaCollectionEnumerator(this.a.schemas());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(Array array, int n2) {
        XmlSchemaSet xmlSchemaSet = this.a;
        synchronized (xmlSchemaSet) {
            this.a.copyTo(array, n2);
        }
    }

    @Override
    public boolean isSynchronized() {
        return true;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void a(Object object, ValidationEventArgs validationEventArgs) {
        if (this.ValidationEventHandler != null && this.ValidationEventHandler.isReady()) {
            this.ValidationEventHandler.invoke(object, validationEventArgs);
        } else if (validationEventArgs.getSeverity() == 0) {
            throw validationEventArgs.getException();
        }
    }
}

