/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Xml;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Xml.DTDAttListDeclaration;
import com.aspose.html.internal.ms.System.Xml.DTDAttributeDefinition;
import com.aspose.html.internal.ms.System.Xml.IHasXmlChildNode;
import com.aspose.html.internal.ms.System.Xml.IXmlSchemaInfo;
import com.aspose.html.internal.ms.System.Xml.XmlChar;
import com.aspose.html.internal.ms.System.Xml.XmlCharacterData;
import com.aspose.html.internal.ms.System.Xml.XmlDocument;
import com.aspose.html.internal.ms.System.Xml.XmlElement;
import com.aspose.html.internal.ms.System.Xml.XmlException;
import com.aspose.html.internal.ms.System.Xml.XmlLinkedNode;
import com.aspose.html.internal.ms.System.Xml.XmlNameEntry;
import com.aspose.html.internal.ms.System.Xml.XmlNamespaceManager;
import com.aspose.html.internal.ms.System.Xml.XmlNode;
import com.aspose.html.internal.ms.System.Xml.XmlParserContext;
import com.aspose.html.internal.ms.System.Xml.XmlTextReader;
import com.aspose.html.internal.ms.System.Xml.XmlWriter;

public class XmlAttribute
extends XmlNode
implements IHasXmlChildNode {
    private XmlNameEntry a;
    boolean isDefault;
    private XmlLinkedNode b;
    private IXmlSchemaInfo c;

    protected XmlAttribute(String string, String string2, String string3, XmlDocument xmlDocument) {
        this(string, string2, string3, xmlDocument, false, true);
    }

    XmlAttribute(String string, String string2, String string3, XmlDocument xmlDocument, boolean bl2, boolean bl3) {
        super(xmlDocument);
        if (!bl2) {
            if (string == null) {
                string = StringExtensions.Empty;
            }
            if (string3 == null) {
                string3 = StringExtensions.Empty;
            }
        }
        if (bl3 && ("xmlns".equals(string) || "".equals(string) && "xmlns".equals(string2))) {
            if (!"http://www.w3.org/2000/xmlns/".equals(string3)) {
                throw new ArgumentException("Invalid attribute namespace for namespace declaration.");
            }
            if ("xml".equals(string) && !"http://www.w3.org/XML/1998/namespace".equals(string3)) {
                throw new ArgumentException("Invalid attribute namespace for namespace declaration.");
            }
        }
        if (!bl2) {
            if (!"".equals(string) && !XmlChar.isName(string)) {
                throw new ArgumentException("Invalid attribute prefix.");
            }
            if (!XmlChar.isName(string2)) {
                throw new ArgumentException("Invalid attribute local name.");
            }
            string = xmlDocument.getNameTable().add(string);
            string2 = xmlDocument.getNameTable().add(string2);
            string3 = xmlDocument.getNameTable().add(string3);
        }
        this.a = xmlDocument.getNameCache().add(string, string2, string3, true);
    }

    @Override
    public XmlLinkedNode getLastLinkedChild() {
        return this.b;
    }

    @Override
    public void setLastLinkedChild(XmlLinkedNode xmlLinkedNode) {
        this.b = xmlLinkedNode;
    }

    @Override
    public String getBaseURI() {
        return this.getOwnerElement() != null ? this.getOwnerElement().getBaseURI() : StringExtensions.Empty;
    }

    @Override
    public void setInnerText(String string) {
        this.setValue(string);
    }

    @Override
    public void setInnerXml(String string) {
        this.removeAll();
        XmlNamespaceManager xmlNamespaceManager = this.constructNamespaceManager();
        XmlParserContext xmlParserContext = new XmlParserContext(this.getOwnerDocument().getNameTable(), xmlNamespaceManager, this.getOwnerDocument().getDocumentType() != null ? this.getOwnerDocument().getDocumentType().getDTD() : null, this.getBaseURI(), this.getXmlLang(), this.getXmlSpace(), null);
        XmlTextReader xmlTextReader = new XmlTextReader(string, 2, xmlParserContext);
        xmlTextReader.setXmlResolver(this.getOwnerDocument().getResolver());
        xmlTextReader.read();
        this.getOwnerDocument().readAttributeNodeValue(xmlTextReader, this);
    }

    @Override
    public String getLocalName() {
        return this.a.LocalName;
    }

    @Override
    public String getName() {
        return this.a.getPrefixedName(this.getOwnerDocument().getNameCache());
    }

    @Override
    public String getNamespaceURI() {
        return this.a.NS;
    }

    @Override
    public int getNodeType() {
        return 2;
    }

    @Override
    int getXPathNodeType() {
        return 2;
    }

    @Override
    public XmlDocument getOwnerDocument() {
        return super.getOwnerDocument();
    }

    public XmlElement getOwnerElement() {
        return this.getAttributeOwnerElement();
    }

    @Override
    public XmlNode getParentNode() {
        return null;
    }

    @Override
    public String getPrefix() {
        return this.a.Prefix;
    }

    @Override
    public void setPrefix(String string) {
        if (this.isReadOnly()) {
            throw new XmlException("This node is readonly.");
        }
        if ("xmlns".equals(this.a.Prefix) && !"xmlns".equals(string)) {
            throw new ArgumentException("Cannot bind to the reserved namespace.");
        }
        string = this.getOwnerDocument().getNameTable().add(string);
        this.a = this.getOwnerDocument().getNameCache().add(string, this.a.LocalName, this.a.NS, true);
    }

    @Override
    public IXmlSchemaInfo getSchemaInfo() {
        return this.c;
    }

    @Override
    void setSchemaInfo(IXmlSchemaInfo iXmlSchemaInfo) {
        this.c = iXmlSchemaInfo;
    }

    public boolean getSpecified() {
        return !this.isDefault;
    }

    @Override
    public String getValue() {
        return this.getInnerText();
    }

    @Override
    public void setValue(String string) {
        XmlNode xmlNode;
        if (this.isReadOnly()) {
            throw new ArgumentException("Attempt to modify a read-only node.");
        }
        this.getOwnerDocument().checkIdTableUpdate(this, this.getInnerText(), string);
        XmlNode xmlNode2 = this.getFirstChild();
        XmlNode xmlNode3 = xmlNode = xmlNode2 instanceof XmlCharacterData ? xmlNode2 : null;
        if (xmlNode == null) {
            this.removeAll();
            this.appendChild(this.getOwnerDocument().createTextNode(string), false);
        } else if (this.getFirstChild().getNextSibling() != null) {
            this.removeAll();
            this.appendChild(this.getOwnerDocument().createTextNode(string), false);
        } else {
            xmlNode.setValue(string);
        }
        this.isDefault = false;
    }

    @Override
    String getXmlLang() {
        return this.getOwnerElement() != null ? this.getOwnerElement().getXmlLang() : StringExtensions.Empty;
    }

    @Override
    int getXmlSpace() {
        return this.getOwnerElement() != null ? this.getOwnerElement().getXmlSpace() : 0;
    }

    @Override
    public XmlNode appendChild(XmlNode xmlNode) {
        return super.appendChild(xmlNode);
    }

    @Override
    public XmlNode insertBefore(XmlNode xmlNode, XmlNode xmlNode2) {
        return super.insertBefore(xmlNode, xmlNode2);
    }

    @Override
    public XmlNode insertAfter(XmlNode xmlNode, XmlNode xmlNode2) {
        return super.insertAfter(xmlNode, xmlNode2);
    }

    @Override
    public XmlNode prependChild(XmlNode xmlNode) {
        return super.prependChild(xmlNode);
    }

    @Override
    public XmlNode removeChild(XmlNode xmlNode) {
        return super.removeChild(xmlNode);
    }

    @Override
    public XmlNode replaceChild(XmlNode xmlNode, XmlNode xmlNode2) {
        return super.replaceChild(xmlNode, xmlNode2);
    }

    @Override
    public XmlNode cloneNode(boolean bl2) {
        XmlAttribute xmlAttribute = this.getOwnerDocument().createAttribute(this.a.Prefix, this.a.LocalName, this.a.NS, true, false);
        if (bl2) {
            for (XmlNode xmlNode = this.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
                xmlAttribute.appendChild(xmlNode.cloneNode(bl2), false);
            }
        }
        return xmlAttribute;
    }

    void setDefault() {
        this.isDefault = true;
    }

    @Override
    public void writeContentTo(XmlWriter xmlWriter) {
        for (XmlNode xmlNode = this.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            xmlNode.writeTo(xmlWriter);
        }
    }

    @Override
    public void writeTo(XmlWriter xmlWriter) {
        if (this.isDefault) {
            return;
        }
        xmlWriter.writeStartAttribute(this.a.Prefix, this.a.LocalName, this.a.NS);
        this.writeContentTo(xmlWriter);
        xmlWriter.writeEndAttribute();
    }

    DTDAttributeDefinition getAttributeDefinition() {
        if (this.getOwnerElement() == null) {
            return null;
        }
        DTDAttListDeclaration dTDAttListDeclaration = this.getOwnerDocument().getDocumentType() != null ? this.getOwnerDocument().getDocumentType().getDTD().getAttListDecls().get_Item(this.getOwnerElement().getName()) : null;
        return dTDAttListDeclaration != null ? dTDAttListDeclaration.get_Item(this.getName()) : null;
    }
}

