/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.OverflowException;
import com.aspose.html.internal.ms.core.System.k;
import com.aspose.html.internal.ms.core.System.p;
import java.math.BigInteger;

public final class UInt64Extensions {
    public static final long MaxValue = -1L;
    public static final long MinValue = 0L;

    public static int compareTo(long l2, long l3) {
        BigInteger bigInteger = UInt64Extensions.getBigIntegerFromLong(l2);
        BigInteger bigInteger2 = UInt64Extensions.getBigIntegerFromLong(l3);
        return bigInteger.compareTo(bigInteger2);
    }

    public static int compareTo(long l2, Object object) {
        if (object == null) {
            return 1;
        }
        if (object.getClass() != Long.class) {
            throw new ArgumentException("Object must be of type Int64");
        }
        long l3 = Convert.toUInt64(object);
        return UInt64Extensions.compareTo(l2, l3);
    }

    public static boolean equals(long l2, long l3) {
        return l2 == l3;
    }

    public static boolean equals(long l2, Object object) {
        if (object == null || object.getClass() != Long.class) {
            return false;
        }
        return Convert.toUInt64(object) == l2;
    }

    public static int getHashCode(long l2) {
        return (int)l2 ^ (int)(l2 >> 32);
    }

    public static int getTypeCode() {
        return 12;
    }

    public static boolean tryParse(String string, int n2, IFormatProvider iFormatProvider, long[] lArray) {
        try {
            lArray[0] = UInt64Extensions.parse(string, n2, iFormatProvider);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        catch (OverflowException overflowException) {
            return false;
        }
    }

    public static boolean tryParse(String string, long[] lArray) {
        return UInt64Extensions.tryParse(string, 7, NumberFormatInfo.getCurrentInfo(), lArray);
    }

    public static long parse(String string) {
        return p.a(string);
    }

    public static long parse(String string, IFormatProvider iFormatProvider) {
        return p.a(string, iFormatProvider);
    }

    public static long parse(String string, int n2) {
        return p.a(string, n2);
    }

    public static long parse(String string, int n2, IFormatProvider iFormatProvider) {
        return p.a(string, n2, iFormatProvider);
    }

    public static String toString(long l2) {
        return k.b(null, l2, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(long l2, IFormatProvider iFormatProvider) {
        return k.b(null, l2, iFormatProvider);
    }

    public static String toString(long l2, String string) {
        return k.b(string, l2, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(long l2, String string, IFormatProvider iFormatProvider) {
        return k.b(string, l2, iFormatProvider);
    }

    public static BigInteger getBigIntegerFromLong(long l2) {
        BigInteger bigInteger;
        if (l2 >= 0L) {
            bigInteger = BigInteger.valueOf(l2);
        } else {
            bigInteger = BigInteger.valueOf(Long.MAX_VALUE);
            bigInteger = bigInteger.add(BigInteger.ONE);
            bigInteger = bigInteger.add(BigInteger.valueOf(Long.MIN_VALUE - l2).abs());
        }
        return bigInteger;
    }
}

