/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Char;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Decimal;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.ICustomFormatter;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.IFormattable;
import com.aspose.html.internal.ms.System.IndexOutOfRangeException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.core.System.k;
import com.aspose.html.internal.ms.lang.Operators;

public final class StringExtensions {
    public static String Empty = "";
    static final char[] a = new char[]{'\t', '\n', '\u000b', '\f', '\r', ' ', '\u0085', '\u00a0', '\u1680', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u200b', '\u2028', '\u2029', '\u3000', '\ufeff'};

    private StringExtensions() {
    }

    public static String newString(String string) {
        throw new NotImplementedException();
    }

    public static String newString(Object object) {
        if (object == null) {
            return Empty;
        }
        if (object.getClass() == Byte.TYPE) {
            return StringExtensions.newString((Byte)object);
        }
        return new String(object.toString());
    }

    public static String newString(byte by2) {
        return new String(new byte[]{by2});
    }

    public static String newString(char[] cArray, int n2, int n3) {
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (cArray == null) {
            throw new ArgumentNullException("value");
        }
        if ((long)n2 + (long)n3 > (long)cArray.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        return new String(cArray, n2, n3);
    }

    public static String newString(char[] cArray) {
        if (cArray == null) {
            return Empty;
        }
        return new String(cArray);
    }

    public static String newString(byte by2, int n2, int n3) {
        byte[] byArray = new byte[]{by2};
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (n2 + n3 >= byArray.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        return new String(byArray, n2, n3);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String newString(Byte by2, int n2, int n3, Encoding encoding) {
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (by2 == null) {
            if (n3 > 0 || n2 > 0) {
                throw new ArgumentNullException("value");
            }
            if (encoding == null) {
                throw new ArgumentNullException("value");
            }
            return Empty;
        }
        byte[] byArray = new byte[]{by2};
        if (n2 + n3 >= byArray.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        return new String(byArray, n2, n3);
    }

    public static String newString(char c2, int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count");
        }
        if (n2 == 0) {
            return "";
        }
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = c2;
        }
        return new String(cArray);
    }

    public static String remove(String string, int n2, int n3) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot be negative.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count", "Cannot be negative.");
        }
        if (n2 > string.length() - n3) {
            throw new ArgumentOutOfRangeException("count", "startIndex + count > this.length");
        }
        return new StringBuilder(string).delete(n2, n2 + n3).toString();
    }

    public static String remove(String string, int n2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "StartIndex can not be less than zero");
        }
        if (n2 >= string.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "StartIndex must be less than the length of the string");
        }
        return StringExtensions.remove(string, n2, string.length() - n2);
    }

    public static String replace(String string, char c2, char c3) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return string.replace(c2, c3);
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string2 == null) {
            throw new ArgumentNullException("oldValue");
        }
        if (string2.length() == 0) {
            throw new ArgumentException("oldValue is the empty string.");
        }
        if (string.length() == 0) {
            return string;
        }
        if (string3 == null) {
            string3 = Empty;
        }
        return string.replace(string2, string3);
    }

    public static String format(String string, Object ... objectArray) {
        if (string == null) {
            throw new ArgumentNullException("format");
        }
        if (objectArray == null) {
            throw new ArgumentNullException("args");
        }
        return StringExtensions.format((IFormatProvider)null, string, objectArray);
    }

    public static String format(IFormatProvider iFormatProvider, String string, Object ... objectArray) {
        msStringBuilder msStringBuilder2 = StringExtensions.formatHelper(null, iFormatProvider, string, objectArray);
        return msStringBuilder2.toString();
    }

    public static msStringBuilder formatHelper(msStringBuilder msStringBuilder2, IFormatProvider iFormatProvider, String string, Object ... objectArray) {
        int n2;
        int n3;
        if (iFormatProvider == null) {
            iFormatProvider = NumberFormatInfo.getInvariantInfo();
        }
        if (string == null) {
            throw new ArgumentNullException("format");
        }
        if (objectArray == null) {
            throw new ArgumentNullException("args");
        }
        if (msStringBuilder2 == null) {
            n3 = 0;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                String string2;
                Object object = objectArray[n2];
                String string3 = string2 = object instanceof String ? (String)object : null;
                if (string2 == null) break;
                n3 += string2.length();
            }
            msStringBuilder2 = n2 == objectArray.length ? new msStringBuilder(n3 + string.length()) : new msStringBuilder();
        }
        n3 = n2 = 0;
        while (n2 < string.length()) {
            char c2;
            if ((c2 = string.charAt(n2++)) == '{') {
                String string4;
                msStringBuilder2.append(string, n3, n2 - n3 - 1);
                if (string.charAt(n2) == '{') {
                    n3 = n2++;
                    continue;
                }
                int n4 = 0;
                int n5 = 0;
                boolean bl2 = false;
                String string5 = null;
                int[] nArray = new int[]{n2};
                int[] nArray2 = new int[]{0};
                int[] nArray3 = new int[]{0};
                boolean[] blArray = new boolean[]{false};
                String[] stringArray = new String[]{string5};
                StringExtensions.a(string, nArray, nArray2, nArray3, blArray, stringArray);
                n2 = nArray[0];
                n4 = nArray2[0];
                n5 = nArray3[0];
                bl2 = blArray[0];
                string5 = stringArray[0];
                if (n4 >= objectArray.length) {
                    throw new FormatException("Index (zero based) must be greater than or equal to zero and less than the size of the argument list.");
                }
                Object object = objectArray[n4];
                ICustomFormatter iCustomFormatter = null;
                if (iFormatProvider != null) {
                    iCustomFormatter = (ICustomFormatter)iFormatProvider.getFormat(Operators.typeOf(ICustomFormatter.class));
                }
                if ((string4 = object == null ? Empty : (iCustomFormatter != null ? iCustomFormatter.format(string5, object, iFormatProvider) : (StringExtensions.a(object) ? k.a(object, string5, iFormatProvider) : (object instanceof IFormattable ? ((IFormattable)object).toString(string5, iFormatProvider) : object.toString())))) == null) {
                    string4 = Empty;
                }
                if (n5 > string4.length()) {
                    char c3 = ' ';
                    int n6 = n5 - string4.length();
                    if (bl2) {
                        msStringBuilder2.append(string4);
                        msStringBuilder2.append(c3, n6);
                    } else {
                        msStringBuilder2.append(c3, n6);
                        msStringBuilder2.append(string4);
                    }
                } else {
                    msStringBuilder2.append(string4);
                }
                n3 = n2;
                continue;
            }
            if (c2 == '}' && n2 < string.length() && string.charAt(n2) == '}') {
                msStringBuilder2.append(string, n3, n2 - n3 - 1);
                n3 = n2++;
                continue;
            }
            if (c2 != '}') continue;
            throw new FormatException("Input string was not in a correct format.");
        }
        if (n3 < string.length()) {
            msStringBuilder2.append(string, n3, string.length() - n3);
        }
        return msStringBuilder2;
    }

    private static void a(String string, int[] nArray, int[] nArray2, int[] nArray3, boolean[] blArray, String[] stringArray) {
        block14: {
            block13: {
                int n2;
                int n3 = string.length();
                nArray2[0] = StringExtensions.a(string, nArray);
                if (nArray2[0] < 0) {
                    throw new FormatException("Input string was not in a correct format.");
                }
                if (nArray[0] < n3 && string.charAt(nArray[0]) == ',') {
                    nArray[0] = nArray[0] + 1;
                    while (nArray[0] < n3 && Char.isWhiteSpace(string.charAt(nArray[0]))) {
                        nArray[0] = nArray[0] + 1;
                    }
                    n2 = nArray[0];
                    stringArray[0] = StringExtensions.substring(string, n2, nArray[0] - n2);
                    boolean bl2 = blArray[0] = nArray[0] < n3 && string.charAt(nArray[0]) == '-';
                    if (blArray[0]) {
                        nArray[0] = nArray[0] + 1;
                    }
                    nArray3[0] = StringExtensions.a(string, nArray);
                    if (nArray3[0] < 0) {
                        throw new FormatException("Input string was not in a correct format.");
                    }
                } else {
                    nArray3[0] = 0;
                    blArray[0] = false;
                    stringArray[0] = Empty;
                }
                if (nArray[0] < n3 && string.charAt(nArray[0]) == ':') {
                    n2 = nArray[0] = nArray[0] + 1;
                    while (nArray[0] < n3 && string.charAt(nArray[0]) != '}') {
                        nArray[0] = nArray[0] + 1;
                    }
                    stringArray[0] = StringExtensions.plusEqOperator(stringArray[0], StringExtensions.substring(string, n2, nArray[0] - n2));
                } else {
                    stringArray[0] = null;
                }
                if (nArray[0] >= n3) break block13;
                int n4 = nArray[0];
                nArray[0] = n4 + 1;
                if (string.charAt(n4) == '}') break block14;
            }
            throw new FormatException("Input string was not in a correct format.");
        }
    }

    private static int a(String string, int[] nArray) {
        char c2;
        int n2;
        int n3 = 0;
        int n4 = string.length();
        for (n2 = nArray[0]; n2 < n4 && (c2 = string.charAt(n2)) >= '0' && '9' >= c2; ++n2) {
            n3 = n3 * 10 + c2 - 48;
        }
        if (n2 == nArray[0] || n2 == n4) {
            return -1;
        }
        nArray[0] = n2;
        return n3;
    }

    public static void copyTo(String string, int n2, char[] cArray, int n3, int n4) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (cArray == null) {
            throw new ArgumentNullException("destination");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("sourceIndex", "Cannot be negative");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("destinationIndex", "Cannot be negative.");
        }
        if (n4 < 0) {
            throw new ArgumentOutOfRangeException("count", "Cannot be negative.");
        }
        if (n2 > string.length() - n4) {
            throw new ArgumentOutOfRangeException("sourceIndex", "sourceIndex + count > Length");
        }
        if (n3 > cArray.length - n4) {
            throw new ArgumentOutOfRangeException("destinationIndex", "destinationIndex + count > destination.Length");
        }
        string.getChars(n2, n2 + n4, cArray, n3);
    }

    public static String insert(String string, int n2, String string2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string2 == null) {
            throw new ArgumentNullException("value");
        }
        if (n2 < 0 || n2 > string.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot be negative and must be less than or equal to length of string.");
        }
        if (string2.length() == 0) {
            return string;
        }
        if (string.length() == 0) {
            return string2;
        }
        return new StringBuilder(string).insert(n2, string2).toString();
    }

    public static int indexOfAny(String string, char[] cArray) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (cArray == null) {
            throw new ArgumentNullException();
        }
        if (string.length() == 0) {
            return -1;
        }
        return StringExtensions.indexOfAny(string, cArray, 0);
    }

    public static int indexOfAny(String string, char[] cArray, int n2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (cArray == null) {
            throw new ArgumentNullException();
        }
        if (n2 < 0 || n2 > string.length()) {
            throw new ArgumentOutOfRangeException();
        }
        if (StringExtensions.isNullOrEmpty(string) || cArray == null || cArray.length == 0 || n2 > string.length()) {
            return -1;
        }
        return StringExtensions.indexOfAny(string, cArray, n2, string.length() - n2);
    }

    public static int indexOfAny(String string, char[] cArray, int n2, int n3) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (cArray == null) {
            throw new ArgumentNullException();
        }
        if (n2 < 0 || n2 > string.length()) {
            throw new ArgumentOutOfRangeException();
        }
        if (n3 < 0 || n2 > string.length() - n3) {
            throw new ArgumentOutOfRangeException("count", "Count cannot be negative, and startIndex + count must be less than length of the string.");
        }
        int n4 = n2 + n3;
        int n5 = n4 - 1;
        int n6 = cArray.length;
        int n7 = n6 - 1;
        for (int i2 = n2; i2 < n4; ++i2) {
            char c2 = string.charAt(i2);
            for (int i3 = 0; i3 < n6; ++i3) {
                if (cArray[i3] != c2) continue;
                if (i2 < n5 && i3 < n7 && Character.isHighSurrogate(c2)) {
                    if (cArray[i3 + 1] != string.charAt(i2 + 1)) continue;
                    return i2;
                }
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOfAny(String string, char[] cArray) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (cArray == null) {
            throw new ArgumentNullException();
        }
        if (string.length() == 0) {
            return -1;
        }
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < cArray.length; ++i3) {
                if (string.charAt(i2) != cArray[i3]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOfAny(String string, char[] cArray, int n2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (cArray == null) {
            throw new ArgumentNullException();
        }
        if (string.length() == 0) {
            return -1;
        }
        if (n2 < 0 || n2 >= string.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot be negative, and should be less than length of string.");
        }
        if (string.length() == 0) {
            return -1;
        }
        if (n2 > string.length() - 1) {
            n2 = string.length() - 1;
        }
        for (int i2 = n2; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < cArray.length; ++i3) {
                if (string.charAt(i2) != cArray[i3]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static int lastIndexOfAny(String string, char[] cArray, int n2, int n3) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (cArray == null) {
            throw new ArgumentNullException();
        }
        if (string.length() == 0) {
            return -1;
        }
        if (n2 < 0 || n2 >= string.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "< 0 || > this.Length");
        }
        if (n3 < 0 || n3 > string.length()) {
            throw new ArgumentOutOfRangeException("count", "< 0 || > this.Length");
        }
        if (n2 - n3 + 1 < 0) {
            throw new ArgumentOutOfRangeException("startIndex - count + 1 < 0");
        }
        if (string.length() == 0) {
            return -1;
        }
        if (n2 > string.length() - 1) {
            n2 = string.length() - 1;
        }
        for (int i2 = n2; i2 >= 0 && i2 > n2 - n3; --i2) {
            for (int i3 = 0; i3 < cArray.length; ++i3) {
                if (string.charAt(i2) != cArray[i3]) continue;
                return i2;
            }
        }
        return -1;
    }

    public static String trim(String string) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.trim(string, a);
    }

    public static String trim(String string, char ... cArray) {
        int n2;
        if (string == null) {
            throw new NullReferenceException();
        }
        if (cArray == null || cArray.length == 0) {
            return StringExtensions.trim(string);
        }
        if (string.length() == 0) {
            return Empty;
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && StringExtensions.a(cArray, string.charAt(n2)); ++n2) {
        }
        while (n2 < n3 && StringExtensions.a(cArray, string.charAt(n3 - 1))) {
            --n3;
        }
        return n2 > 0 || n3 < string.length() ? string.substring(n2, n3) : string;
    }

    public static String trimStart(String string) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.trimStart(string, a);
    }

    public static String trimStart(String string, char ... cArray) {
        int n2;
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string.length() == 0) {
            return Empty;
        }
        int n3 = string.length();
        if (cArray == null || cArray.length == 0) {
            n2 = StringExtensions.a(string, 0, string.length(), 1);
        } else {
            for (n2 = 0; n2 < n3 && StringExtensions.a(cArray, string.charAt(n2)); ++n2) {
            }
        }
        return n2 > 0 ? string.substring(n2) : string;
    }

    public static String trimEnd(String string, char ... cArray) {
        int n2;
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string.length() == 0) {
            return Empty;
        }
        int n3 = 0;
        if (cArray == null || cArray.length == 0) {
            n2 = StringExtensions.a(string, string.length() - 1, -1, -1);
            ++n2;
        } else {
            for (n2 = string.length(); n3 < n2 && StringExtensions.a(cArray, string.charAt(n2 - 1)); --n2) {
            }
        }
        return n2 < string.length() ? string.substring(n3, n2) : string;
    }

    private static int a(String string, int n2, int n3, int n4) {
        while (n2 != n3) {
            char c2 = string.charAt(n2);
            if (c2 < '\u0085' ? c2 != ' ' && (c2 < '\t' || c2 > '\r') : c2 != '\u00a0' && c2 != '\ufeff' && c2 != '\u3000' && c2 != '\u0085' && c2 != '\u1680' && c2 != '\u2028' && c2 != '\u2029' && (c2 < '\u2000' || c2 > '\u200b')) {
                return n2;
            }
            n2 += n4;
        }
        return n2;
    }

    private static boolean a(char[] cArray, char c2) {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != c2) continue;
            return true;
        }
        return false;
    }

    public static String join(String string, String[] stringArray) {
        if (stringArray == null) {
            throw new ArgumentNullException("value");
        }
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (String string2 : stringArray) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(string);
            }
            if (string2 == null) continue;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String join(String string, String[] stringArray, int n2, int n3) {
        if (stringArray == null) {
            throw new ArgumentNullException("value");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "< 0");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count", "< 0");
        }
        if (n2 > stringArray.length - n3) {
            throw new ArgumentOutOfRangeException("startIndex", "startIndex + count > value.length");
        }
        if (n2 == stringArray.length) {
            return Empty;
        }
        if (string == null) {
            string = Empty;
        }
        String string2 = Empty;
        boolean bl2 = true;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            String string3 = stringArray[i2];
            if (string3 == null) {
                string3 = Empty;
            }
            if (bl2) {
                bl2 = false;
                string2 = StringExtensions.copy(stringArray[i2]);
                continue;
            }
            string2 = StringExtensions.concat(string2, string, string3);
        }
        return string2;
    }

    public static String[] split(String string, char c2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        int[] nArray = new int[string.length()];
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != c2) continue;
            nArray[n2++] = i2;
        }
        String[] stringArray = new String[n2 + 1];
        if (n2 == 0) {
            stringArray[0] = string;
            return stringArray;
        }
        int n3 = 0;
        int n4 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            int n5 = nArray[i3];
            stringArray[n3++] = string.substring(n4, n5);
            n4 = n5 + 1;
        }
        stringArray[n3] = string.substring(n4, string.length());
        return stringArray;
    }

    public static String[] split(String string) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.split(string, null);
    }

    public static String[] split(String string, String[] stringArray, int n2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.split(string, stringArray, Integer.MAX_VALUE, n2);
    }

    public static String[] split(String string, String[] stringArray, int n2, int n3) {
        boolean bl2;
        if (string == null) {
            throw new NullReferenceException();
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count", "Count cannot be less than zero.");
        }
        if (n3 != 0 && n3 != 1) {
            throw new ArgumentException(StringExtensions.concat("Illegal enum value: ", n3, "."));
        }
        if (n2 <= 1) {
            String[] stringArray2;
            if (n2 == 0) {
                stringArray2 = new String[]{};
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = string;
            }
            return stringArray2;
        }
        boolean bl3 = bl2 = (n3 & 1) != 0;
        if (stringArray == null || stringArray.length == 0) {
            return StringExtensions.a(string, null, n2, bl2);
        }
        if (string.length() == 0 && bl2) {
            return new String[0];
        }
        List<String> list = new List<String>();
        int n4 = 0;
        int n5 = 0;
        while (n4 < string.length()) {
            int n6 = -1;
            int n7 = Integer.MAX_VALUE;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                int n8;
                String string2 = stringArray[i2];
                if (string2 == null || string2.length() == 0 || (n8 = StringExtensions.indexOf(string, string2, n4, string.length() - n4, (short)4)) < 0 || n8 >= n7) continue;
                n6 = i2;
                n7 = n8;
            }
            if (n6 == -1) break;
            if (n7 != n4 || !bl2) {
                if (list.size() == n2 - 1) break;
                list.addItem(StringExtensions.substring(string, n4, n7 - n4));
            }
            n4 = n7 + stringArray[n6].length();
            ++n5;
        }
        if (n5 == 0) {
            return new String[]{string};
        }
        if (bl2 && n5 != 0 && n4 == string.length() && list.size() == 0) {
            return new String[0];
        }
        if (!bl2 || n4 != string.length()) {
            list.addItem(StringExtensions.substring(string, n4));
        }
        return list.toArray(new String[0]);
    }

    public static String[] split(String string, char ... cArray) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.split(string, cArray, Integer.MAX_VALUE, 0);
    }

    public static String[] split(String string, char[] cArray, int n2, int n3) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("count", "Count cannot be less than zero.");
        }
        if (n3 != 0 && n3 != 1) {
            throw new ArgumentException(StringExtensions.concat("Illegal enum value: ", n3, "."));
        }
        if (string.length() == 0 && (n3 & 1) != 0) {
            return new String[0];
        }
        if (n2 <= 1) {
            String[] stringArray;
            if (n2 == 0) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string;
            }
            return stringArray;
        }
        return StringExtensions.a(string, cArray, n2, n3 != 0);
    }

    private static String[] a(String string, char[] cArray, int n2, boolean bl2) {
        int n3;
        int n4;
        if (cArray == null || cArray.length == 0) {
            cArray = a;
        }
        int[] nArray = new int[string.length()];
        int n5 = 0;
        block0: for (n4 = 0; n4 < string.length(); ++n4) {
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                if (string.charAt(n4) != cArray[i2]) continue;
                nArray[n5++] = n4;
                continue block0;
            }
        }
        if (n5 == string.length() && bl2) {
            return new String[0];
        }
        n4 = n5;
        if (n2 != Integer.MAX_VALUE && n2 < n5) {
            n4 = n2;
        }
        String[] stringArray = new String[n4 + 1];
        if (n5 == 0) {
            stringArray[0] = string;
            return stringArray;
        }
        int n6 = 0;
        int n7 = 0;
        for (int i3 = 0; i3 < n4 && (n2 == Integer.MAX_VALUE || i3 < n2 - 1); ++i3) {
            n3 = nArray[i3];
            String string2 = string.substring(n7, n3);
            if (!string2.equals(Empty) || !bl2) {
                stringArray[n6++] = string2;
            }
            n7 = n3 + 1;
        }
        String string3 = string.substring(n7, string.length());
        if (!bl2 || !string3.equals(Empty)) {
            if (string3.length() > 0) {
                string3 = StringExtensions.a(string3, cArray);
            }
            stringArray[n6] = string3;
        }
        if (stringArray.length > n2 && !bl2) {
            String[] stringArray2 = new String[n2];
            Array.copy(Array.boxing(stringArray), 0, Array.boxing(stringArray2), 0, n2);
            return stringArray2;
        }
        if (bl2) {
            n3 = 0;
            int n8 = 0;
            int[] nArray2 = new int[stringArray.length];
            for (String string4 : stringArray) {
                if (string4 != null && !string4.equals(Empty)) {
                    nArray2[n3++] = n8;
                }
                ++n8;
            }
            if (n3 > 0) {
                String[] stringArray3 = new String[n3];
                for (int i4 = 0; i4 < n3; ++i4) {
                    stringArray3[i4] = stringArray[nArray2[i4]];
                }
                if (n3 < n2 && StringExtensions.indexOfAny(stringArray3[n3 - 1], cArray) != -1) {
                    if (n3 == 1) {
                        return StringExtensions.a(stringArray3[n3 - 1], cArray, n2, bl2);
                    }
                    String[] stringArray4 = StringExtensions.a(stringArray3[n3 - 1], cArray, n2 - n3, bl2);
                    for (int i5 = 0; i5 < stringArray4.length; ++i5) {
                        stringArray3[n3 - 1 + i5] = stringArray4[0];
                    }
                    return stringArray3;
                }
                return stringArray3;
            }
            return new String[0];
        }
        return stringArray;
    }

    private static String a(String string, char[] cArray) {
        String string2 = string;
        while (StringExtensions.indexOfAny(string2, cArray) == 0) {
            string2 = StringExtensions.substring(string2, 1);
        }
        return string2;
    }

    public static String[] split(String string, char[] cArray, int n2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.split(string, cArray, n2, 0);
    }

    public static String[] split(String string, char[] cArray, short s2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.split(string, cArray, Integer.MAX_VALUE, (int)s2);
    }

    public static String plusEqOperator(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string + string2;
    }

    public static String plusEqOperator(String string, char c2) {
        if (string == null) {
            string = "";
        }
        return string + c2;
    }

    public static String plusEqOperator(String string, int n2) {
        if (string == null) {
            string = "";
        }
        return string + n2;
    }

    public static String plusEqOperator(String string, StringBuilder stringBuilder) {
        if (string == null) {
            string = "";
        }
        return string + stringBuilder;
    }

    public static String plusEqOperator(String string, Object object) {
        if (string == null) {
            string = "";
        }
        return string + object;
    }

    public static String toLowerInvariant(String string) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.toLower(string, CultureInfo.getInvariantCulture());
    }

    public static boolean startsWith(String string, String string2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string2 == null) {
            throw new ArgumentNullException("value");
        }
        return CultureInfo.getCurrentCulture().getCompareInfo().isPrefix(string, string2, 0L);
    }

    public static boolean startsWith(String string, String string2, short s2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string2 == null) {
            throw new ArgumentNullException("value");
        }
        switch (s2) {
            case 0: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isPrefix(string, string2, 0L);
            }
            case 1: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isPrefix(string, string2, 1L);
            }
            case 2: {
                return CultureInfo.getInvariantCulture().getCompareInfo().isPrefix(string, string2, 0L);
            }
            case 3: {
                return CultureInfo.getInvariantCulture().getCompareInfo().isPrefix(string, string2, 1L);
            }
            case 4: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isPrefix(string, string2, 0x40000000L);
            }
            case 5: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isPrefix(string, string2, 0x10000000L);
            }
        }
        String string3 = StringExtensions.format("Invalid value '{0}' for StringComparison", s2);
        throw new ArgumentException(string3, "comparisonType");
    }

    public static boolean startsWith(String string, String string2, boolean bl2, CultureInfo cultureInfo) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (cultureInfo == null) {
            cultureInfo = CultureInfo.getCurrentCulture();
        }
        return cultureInfo.getCompareInfo().isPrefix(string, string2, bl2 ? 1L : 0L);
    }

    public static boolean endsWith(String string, String string2, short s2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string2 == null) {
            throw new ArgumentNullException("value");
        }
        switch (s2) {
            case 0: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isSuffix(string, string2, 0L);
            }
            case 1: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isSuffix(string, string2, 1L);
            }
            case 2: {
                return CultureInfo.getInvariantCulture().getCompareInfo().isSuffix(string, string2, 0L);
            }
            case 3: {
                return CultureInfo.getInvariantCulture().getCompareInfo().isSuffix(string, string2, 1L);
            }
            case 4: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isSuffix(string, string2, 0x40000000L);
            }
            case 5: {
                return CultureInfo.getCurrentCulture().getCompareInfo().isSuffix(string, string2, 0x10000000L);
            }
        }
        throw new ArgumentException(StringExtensions.format("Invalid value '{0}' for StringComparison", s2), "comparisonType");
    }

    public static boolean endsWith(String string, String string2, boolean bl2, CultureInfo cultureInfo) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string2 == null) {
            throw new ArgumentNullException("value");
        }
        if (cultureInfo == null) {
            cultureInfo = CultureInfo.getCurrentCulture();
        }
        return cultureInfo.getCompareInfo().isSuffix(string, string2, bl2 ? 1L : 0L);
    }

    public static boolean endsWith(String string, String string2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string2 == null) {
            throw new ArgumentNullException("value");
        }
        return CultureInfo.getCurrentCulture().getCompareInfo().isSuffix(string, string2, 0L);
    }

    public static String toLower(String string) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.toLower(string, CultureInfo.getCurrentCulture());
    }

    public static String toLower(String string, CultureInfo cultureInfo) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (cultureInfo == null) {
            throw new ArgumentNullException("culture");
        }
        return string.toLowerCase(CultureInfo.toJava(cultureInfo));
    }

    private static String a(int n2, char c2) throws IndexOutOfBoundsException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + n2);
        }
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = c2;
        }
        return new String(cArray);
    }

    public static String padRight(String string, int n2, char c2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("totalWidth", "< 0");
        }
        if (string == null) {
            return null;
        }
        int n3 = n2 - string.length();
        if (n3 <= 0) {
            return string;
        }
        return string.concat(StringExtensions.a(n3, c2));
    }

    public static String padRight(String string, int n2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.padRight(string, n2, ' ');
    }

    public static String padLeft(String string, int n2, char c2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("totalWidth", "< 0");
        }
        if (string == null) {
            return null;
        }
        int n3 = n2 - string.length();
        if (n3 <= 0) {
            return string;
        }
        return StringExtensions.a(n3, c2).concat(string);
    }

    public static String padLeft(String string, int n2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.padLeft(string, n2, ' ');
    }

    public static String copy(String string) {
        if (string == null) {
            throw new ArgumentNullException("str");
        }
        int n2 = string.length();
        String string2 = new String(string.toCharArray(), 0, n2);
        return string2;
    }

    public static int lastIndexOf(String string, String string2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.lastIndexOf(string, string2, string.length() - 1, string.length());
    }

    public static int lastIndexOf(String string, String string2, short s2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string.length() == 0) {
            return string2.length() == 0 ? 0 : -1;
        }
        return StringExtensions.lastIndexOf(string, string2, string.length() - 1, string.length(), s2);
    }

    public static int lastIndexOf(String string, String string2, int n2, short s2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.lastIndexOf(string, string2, n2, n2 + 1, s2);
    }

    public static int lastIndexOf(String string, String string2, int n2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        int n3 = n2;
        if (n3 < string.length()) {
            ++n3;
        }
        return StringExtensions.lastIndexOf(string, string2, n2, n3);
    }

    public static int lastIndexOf(String string, String string2, int n2, int n3) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string2 == null) {
            throw new ArgumentNullException("value");
        }
        if (string.length() == 0) {
            return string2.length() == 0 ? 0 : -1;
        }
        if (n2 < -1 || n2 > string.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "< 0 || > this.Length");
        }
        if (n3 < 0 || n3 > string.length()) {
            throw new ArgumentOutOfRangeException("count", "< 0 || > this.Length");
        }
        if (n2 - n3 + 1 < 0) {
            throw new ArgumentOutOfRangeException("startIndex - count + 1 < 0");
        }
        if (string2.length() == 0) {
            return Math.min(string.length() - 1, n2);
        }
        if (n2 == 0 && string.length() == 0) {
            return -1;
        }
        if (string.length() == 0 && string2.length() > 0) {
            return -1;
        }
        if (n3 == 0) {
            return -1;
        }
        if (n2 == string.length()) {
            --n2;
        }
        return CultureInfo.getCurrentCulture().getCompareInfo().lastIndexOf(string, string2, n2, n3);
    }

    public static int lastIndexOf(String string, char c2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string.length() == 0) {
            return -1;
        }
        return StringExtensions.lastIndexOf(string, c2, string.length() - 1, string.length());
    }

    public static int lastIndexOf(String string, char c2, int n2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.lastIndexOf(string, c2, n2, n2 + 1);
    }

    public static int lastIndexOf(String string, char c2, int n2, int n3) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string.length() == 0) {
            return -1;
        }
        if (n2 < 0 || n2 >= string.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "< 0 || >= this.Length");
        }
        if (n3 < 0 || n3 > string.length()) {
            throw new ArgumentOutOfRangeException("count", "< 0 || > this.Length");
        }
        if (n2 - n3 + 1 < 0) {
            throw new ArgumentOutOfRangeException("startIndex - count + 1 < 0");
        }
        int n4 = n2 - n3 + 1;
        int n5 = n2 + 1;
        String string2 = string.substring(n4, n5);
        int n6 = string2.lastIndexOf(c2, n3 - 1);
        if (n6 >= 0) {
            return n6 += n4;
        }
        return n6;
    }

    public static int lastIndexOf(String string, String string2, int n2, int n3, short s2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string2 == null) {
            throw new ArgumentNullException("value");
        }
        if (string.length() == 0) {
            return string2.length() == 0 ? 0 : -1;
        }
        if (s2 < 0 || s2 > 5) {
            throw new ArgumentException("comparisonType");
        }
        if (string2.length() == 0) {
            return Math.min(string.length() - 1, n2);
        }
        if (n2 < 0 || n2 > string.length()) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (n3 < 0 || n2 < n3 - 1) {
            throw new ArgumentOutOfRangeException("count");
        }
        switch (s2) {
            case 0: {
                return CultureInfo.getCurrentCulture().getCompareInfo().lastIndexOf(string, string2, n2, n3, 0L);
            }
            case 1: {
                return CultureInfo.getCurrentCulture().getCompareInfo().lastIndexOf(string, string2, n2, n3, 1L);
            }
            case 2: {
                return CultureInfo.getInvariantCulture().getCompareInfo().lastIndexOf(string, string2, n2, n3, 0L);
            }
            case 3: {
                return CultureInfo.getInvariantCulture().getCompareInfo().lastIndexOf(string, string2, n2, n3, 1L);
            }
            case 4: {
                return CultureInfo.getInvariantCulture().getCompareInfo().lastIndexOf(string, string2, n2, n3, 0x40000000L);
            }
            case 5: {
                return CultureInfo.getInvariantCulture().getCompareInfo().lastIndexOf(string, string2, n2, n3, 0x10000000L);
            }
        }
        String string3 = StringExtensions.format("Invalid value '{0}' for StringComparison", s2);
        throw new ArgumentException(string3, "comparisonType");
    }

    public static boolean equals(String string, String string2) {
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    public static boolean equals(String string, Object object) {
        return string == null && object == null || string != null && string.equals(object);
    }

    public static boolean equals(String string, String string2, short s2) {
        return string == null && string2 == null || string != null && string2 != null && StringExtensions.compare(string, string2, s2) == 0;
    }

    public static int compare(String string, String string2) {
        return CultureInfo.getCurrentCulture().getCompareInfo().compare(string, string2, 0L);
    }

    public static int compare(String string, String string2, boolean bl2) {
        return CultureInfo.getCurrentCulture().getCompareInfo().compare(string, string2, bl2 ? 1L : 0L);
    }

    public static int compare(String string, String string2, boolean bl2, CultureInfo cultureInfo) {
        if (cultureInfo == null) {
            throw new ArgumentNullException("culture");
        }
        return cultureInfo.getCompareInfo().compare(string, string2, bl2 ? 1L : 0L);
    }

    public static int compare(String string, int n2, String string2, int n3, int n4) {
        return StringExtensions.compare(string, n2, string2, n3, n4, false, CultureInfo.getCurrentCulture());
    }

    public static int compare(String string, int n2, String string2, int n3, int n4, boolean bl2) {
        return StringExtensions.compare(string, n2, string2, n3, n4, bl2, CultureInfo.getCurrentCulture());
    }

    public static int compare(String string, int n2, String string2, int n3, int n4, boolean bl2, CultureInfo cultureInfo) {
        if (cultureInfo == null) {
            throw new ArgumentNullException("culture");
        }
        if (n4 == 0) {
            return 0;
        }
        if (string == null) {
            if (string2 == null) {
                return 0;
            }
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        if (n2 > string.length() || n3 > string2.length() || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new ArgumentException();
        }
        long l2 = bl2 ? 1L : 0L;
        int n5 = n4;
        int n6 = n4;
        if (n4 > string.length() - n2) {
            n5 = string.length() - n2;
        }
        if (n4 > string2.length() - n3) {
            n6 = string2.length() - n3;
        }
        return cultureInfo.getCompareInfo().compare(string, n2, n5, string2, n3, n6, l2);
    }

    public static int compare(String string, String string2, short s2) {
        switch (s2) {
            case 0: {
                return StringExtensions.compare(string, string2, false, CultureInfo.getCurrentCulture());
            }
            case 1: {
                return StringExtensions.compare(string, string2, true, CultureInfo.getCurrentCulture());
            }
            case 2: {
                return StringExtensions.compare(string, string2, false, CultureInfo.getInvariantCulture());
            }
            case 3: {
                return StringExtensions.compare(string, string2, true, CultureInfo.getInvariantCulture());
            }
            case 4: {
                return StringExtensions.compareOrdinal(string, string2);
            }
            case 5: {
                return StringExtensions.a(string, string2);
            }
        }
        String string3 = StringExtensions.format("Invalid value '{0}' for StringComparison", s2);
        throw new ArgumentException(string3 + "\r\nParameter name: comparisonType");
    }

    public static int compare(String string, int n2, String string2, int n3, int n4, short s2) {
        switch (s2) {
            case 0: {
                return StringExtensions.compare(string, n2, string2, n3, n4, false, CultureInfo.getCurrentCulture());
            }
            case 1: {
                return StringExtensions.compare(string, n2, string2, n3, n4, true, CultureInfo.getCurrentCulture());
            }
            case 2: {
                return StringExtensions.compare(string, n2, string2, n3, n4, false, CultureInfo.getInvariantCulture());
            }
            case 3: {
                return StringExtensions.compare(string, n2, string2, n3, n4, true, CultureInfo.getInvariantCulture());
            }
            case 4: {
                return StringExtensions.compareOrdinal(string, n2, string2, n3, n4);
            }
            case 5: {
                return StringExtensions.a(string, n2, string2, n3, n4);
            }
        }
        String string3 = StringExtensions.format("Invalid value '{0}' for StringComparison", s2);
        throw new ArgumentException(string3 + "\r\nParameter name: comparisonType");
    }

    public static int compare(String string, String string2, CultureInfo cultureInfo, long l2) {
        if (cultureInfo == null) {
            throw new ArgumentNullException("culture");
        }
        return cultureInfo.getCompareInfo().compare(string, string2, l2);
    }

    public static int compare(String string, int n2, String string2, int n3, int n4, CultureInfo cultureInfo, long l2) {
        if (cultureInfo == null) {
            throw new ArgumentNullException("culture");
        }
        int n5 = n4;
        int n6 = n4;
        if (n4 > string.length() - n2) {
            n5 = string.length() - n2;
        }
        if (n4 > string2.length() - n3) {
            n6 = string2.length() - n3;
        }
        return cultureInfo.getCompareInfo().compare(string, n2, n5, string2, n3, n6, l2);
    }

    public static int compareOrdinal(String string, String string2) {
        if (string == null && string2 == null) {
            return 0;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    public static int compareOrdinal(String string, int n2, String string2, int n3, int n4) {
        if (n2 > string.length() || n3 > string2.length() || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new ArgumentException();
        }
        String string3 = string.substring(n2, Math.min(n2 + n4, string.length()));
        String string4 = string2.substring(n3, Math.min(n3 + n4, string2.length()));
        return string3.compareTo(string4);
    }

    private static int a(String string, String string2) {
        return string.compareToIgnoreCase(string2);
    }

    private static int a(String string, int n2, String string2, int n3, int n4) {
        if (n2 > string.length() || n3 > string2.length() || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new ArgumentException();
        }
        String string3 = string.substring(n2, n2 + n4);
        String string4 = string2.substring(n3, n3 + n4);
        return string3.compareToIgnoreCase(string4);
    }

    public static int indexOf(String string, String string2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string2 == null) {
            throw new ArgumentNullException("value");
        }
        if (string2.length() == 0) {
            return 0;
        }
        if (string.length() == 0) {
            return -1;
        }
        return CultureInfo.getCurrentCulture().getCompareInfo().indexOf(string, string2, 0, string.length(), 0x40000000L);
    }

    public static int indexOf(String string, String string2, int n2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.indexOf(string, string2, n2, string.length() - n2);
    }

    public static int indexOf(String string, char c2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.indexOf(string, c2, 0);
    }

    public static int indexOf(String string, char c2, int n2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "< 0");
        }
        if (n2 > string.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "startIndex > this.length");
        }
        if (n2 == 0 && string.length() == 0 || n2 == string.length()) {
            return -1;
        }
        return string.indexOf(c2, n2);
    }

    public static int indexOf(String string, char c2, int n2, int n3) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (n2 < 0 || n2 > string.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot be negative and must be< 0");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count", "< 0");
        }
        if (n2 > string.length() - n3) {
            throw new ArgumentOutOfRangeException("count", "startIndex + count > this.length");
        }
        if (n2 == 0 && string.length() == 0 || n2 == string.length() || n3 == 0) {
            return -1;
        }
        int n4 = string.indexOf(c2, n2);
        return n4 >= n2 + n3 ? -1 : n4;
    }

    public static int indexOf(String string, String string2, short s2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.indexOf(string, string2, 0, string.length(), s2);
    }

    public static int indexOf(String string, String string2, int n2, short s2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.indexOf(string, string2, n2, string.length() - n2, s2);
    }

    public static int indexOf(String string, String string2, int n2, int n3, short s2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        switch (s2) {
            case 0: {
                return CultureInfo.getCurrentCulture().getCompareInfo().indexOf(string, string2, n2, n3, 0L);
            }
            case 1: {
                return CultureInfo.getCurrentCulture().getCompareInfo().indexOf(string, string2, n2, n3, 1L);
            }
            case 2: {
                return CultureInfo.getInvariantCulture().getCompareInfo().indexOf(string, string2, n2, n3, 0L);
            }
            case 3: {
                return CultureInfo.getInvariantCulture().getCompareInfo().indexOf(string, string2, n2, n3, 1L);
            }
            case 4: {
                return CultureInfo.getInvariantCulture().getCompareInfo().indexOf(string, string2, n2, n3, 0x40000000L);
            }
            case 5: {
                return CultureInfo.getInvariantCulture().getCompareInfo().indexOf(string, string2, n2, n3, 0x10000000L);
            }
        }
        String string3 = StringExtensions.format("Invalid value '{0}' for StringComparison", s2);
        throw new ArgumentException(string3, "comparisonType");
    }

    public static int indexOf(String string, String string2, int n2, int n3) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (string2 == null) {
            throw new ArgumentNullException("value");
        }
        if (n2 < 0 || n2 > string.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot be negative, and should not exceed length of string.");
        }
        if (n3 < 0 || n2 > string.length() - n3) {
            throw new ArgumentOutOfRangeException("count", "Cannot be negative, and should point to location in string.");
        }
        if (string2.length() == 0) {
            return n2;
        }
        if (n2 == 0 && string.length() == 0) {
            return -1;
        }
        if (n3 == 0) {
            return -1;
        }
        return CultureInfo.getCurrentCulture().getCompareInfo().indexOf(string, string2, n2, n3);
    }

    private static String[] a(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = objectArray[i2] == null ? Empty : objectArray[i2].toString();
        }
        return stringArray;
    }

    private static StringBuilder a(String[] stringArray) {
        int n2 = 0;
        for (String string : stringArray) {
            if (string == null) continue;
            n2 += string.length();
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (String string : stringArray) {
            if (string == null) continue;
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    public static String concat(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return "";
        }
        return StringExtensions.a(stringArray).toString();
    }

    public static String concat(Object ... objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return "";
        }
        return StringExtensions.a(StringExtensions.a(objectArray)).toString();
    }

    public static boolean contains(String string, String string2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.indexOf(string, string2) != -1;
    }

    public static String isInterned(String string) {
        if (string == null) {
            throw new ArgumentNullException("str");
        }
        String string2 = new String(string);
        String string3 = string2.intern();
        return string == string3 ? string3 : null;
    }

    public static String intern(String string) {
        if (string == null) {
            throw new ArgumentNullException("str");
        }
        return string.intern();
    }

    public static String substring(String string, int n2) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (n2 == 0) {
            return string;
        }
        if (n2 < 0 || n2 > string.length()) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        return string.substring(n2);
    }

    public static String substring(String string, int n2, int n3) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("length", "Cannot be negative.");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot be negative.");
        }
        if (n2 > string.length()) {
            throw new ArgumentOutOfRangeException("startIndex", "Cannot exceed length of string.");
        }
        if (n2 > string.length() - n3) {
            throw new ArgumentOutOfRangeException("length", "startIndex + length cannot exceed length of string.");
        }
        if (n2 == 0 && n3 == string.length()) {
            return string;
        }
        return string.substring(n2, n2 + n3);
    }

    public static char[] toCharArray(String string) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.toCharArray(string, 0, string.length());
    }

    public static char[] toCharArray(String string, int n2, int n3) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "< 0");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("length", "< 0");
        }
        if (n2 > string.length() - n3) {
            throw new ArgumentOutOfRangeException("startIndex", "Must be greater than the length of the string.");
        }
        char[] cArray = new char[n3];
        System.arraycopy(string.toCharArray(), n2, cArray, 0, n3);
        return cArray;
    }

    public static String toString(String string) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return string;
    }

    public static String toUpper(String string) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.toUpper(string, CultureInfo.getCurrentCulture());
    }

    public static String toUpper(String string, CultureInfo cultureInfo) {
        if (string == null) {
            throw new NullReferenceException();
        }
        if (cultureInfo == null) {
            throw new ArgumentNullException("culture");
        }
        return string.toUpperCase(CultureInfo.toJava(cultureInfo));
    }

    public static String toUpperInvariant(String string) {
        if (string == null) {
            throw new NullReferenceException();
        }
        return StringExtensions.toUpper(string, CultureInfo.getInvariantCulture());
    }

    public static char get_Item(String string, int n2) {
        if (string == null) {
            throw new ArgumentNullException("str");
        }
        if (n2 < 0 || n2 >= string.length()) {
            throw new IndexOutOfRangeException();
        }
        return string.charAt(n2);
    }

    private static boolean a(Object object) {
        boolean bl2 = false;
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof Float || object instanceof Decimal) {
            bl2 = true;
        }
        return bl2;
    }
}

