/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Principal;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.IntPtr;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.Security.Principal.IIdentity;
import com.aspose.html.internal.ms.System.Security.Principal.IPrincipal;
import com.aspose.html.internal.ms.System.Security.Principal.SecurityIdentifier;
import com.aspose.html.internal.ms.System.Security.Principal.WindowsIdentity;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;

public class WindowsPrincipal
implements IPrincipal {
    private WindowsIdentity a;
    private String[] b;

    public WindowsPrincipal(WindowsIdentity windowsIdentity) {
        if (windowsIdentity == null) {
            throw new ArgumentNullException("ntIdentity");
        }
        this.a = windowsIdentity;
    }

    @Override
    public IIdentity getIdentity() {
        return this.a;
    }

    public boolean isInRoleByRID(int n2) {
        if (!Environment.IsRunningOnWindows) {
            throw new NotImplementedException();
        }
        String string = null;
        switch (n2) {
            case 544: {
                string = "BUILTIN\\Administrators";
                break;
            }
            case 545: {
                string = "BUILTIN\\Users";
                break;
            }
            case 546: {
                string = "BUILTIN\\Guests";
                break;
            }
            case 547: {
                string = "BUILTIN\\Power Users";
                break;
            }
            case 548: {
                string = "BUILTIN\\Account Operators";
                break;
            }
            case 549: {
                string = "BUILTIN\\System Operators";
                break;
            }
            case 550: {
                string = "BUILTIN\\Print Operators";
                break;
            }
            case 551: {
                string = "BUILTIN\\Backup Operators";
                break;
            }
            case 552: {
                string = "BUILTIN\\Replicator";
                break;
            }
            default: {
                return false;
            }
        }
        return this.isInRole(string);
    }

    @Override
    public boolean isInRole(String string) {
        if (string == null) {
            return false;
        }
        if (!Environment.IsRunningOnWindows) {
            return WindowsPrincipal.a(this.a(), string);
        }
        if (this.b == null) {
            this.b = WindowsIdentity.a(this.a());
        }
        string = StringExtensions.toUpperInvariant(string);
        for (String string2 : this.b) {
            if (string2 == null || !StringExtensions.equals(string, StringExtensions.toUpperInvariant(string2))) continue;
            return true;
        }
        return false;
    }

    public boolean isInRoleByWindowsBuiltInRID(int n2) {
        if (!Environment.IsRunningOnWindows) {
            String string = null;
            switch (n2) {
                case 544: {
                    string = "root";
                    break;
                }
                default: {
                    return false;
                }
            }
            return this.isInRole(string);
        }
        return this.isInRoleByRID(n2);
    }

    public boolean isInRole(SecurityIdentifier securityIdentifier) {
        throw new NotImplementedException();
    }

    private IntPtr a() {
        return Operators.as(this.a, WindowsIdentity.class).getToken();
    }

    private static boolean a(IntPtr intPtr, IntPtr intPtr2) {
        throw new NotImplementedException();
    }

    private static boolean a(IntPtr intPtr, String string) {
        throw new NotImplementedException();
    }
}

