/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.Oid;
import com.aspose.html.internal.ms.System.Security.Cryptography.OidCollection;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Extension;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1Convert;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

public final class X509EnhancedKeyUsageExtension
extends X509Extension {
    public static final String oid = "2.5.29.37";
    public static final String friendlyName = "Enhanced Key Usage";
    private OidCollection a;
    private int b;
    private static final StringSwitchMap c = new StringSwitchMap("1.3.6.1.5.5.7.3.1");

    public X509EnhancedKeyUsageExtension() {
        this._oid = new Oid(oid, friendlyName);
    }

    public X509EnhancedKeyUsageExtension(AsnEncodedData asnEncodedData, boolean bl2) {
        if (asnEncodedData == null) {
            throw new NullReferenceException();
        }
        this._oid = new Oid(oid, friendlyName);
        this._raw = asnEncodedData.getRawData();
        super.setCritical(bl2);
        this.b = this.decode(this.getRawData());
    }

    public X509EnhancedKeyUsageExtension(OidCollection oidCollection, boolean bl2) {
        if (oidCollection == null) {
            throw new ArgumentNullException("enhancedKeyUsages");
        }
        this._oid = new Oid(oid, friendlyName);
        super.setCritical(bl2);
        this.a = oidCollection.readOnlyCopy();
        this.setRawData(this.encode());
    }

    public OidCollection getEnhancedKeyUsages() {
        switch (this.b) {
            case 0: 
            case 4: {
                if (this.a == null) {
                    this.a = new OidCollection();
                }
                this.a.setReadOnly(true);
                return this.a;
            }
        }
        throw new CryptographicException("Badly encoded extension.");
    }

    @Override
    public void copyFrom(AsnEncodedData asnEncodedData) {
        if (asnEncodedData == null) {
            throw new ArgumentNullException("encodedData");
        }
        X509Extension x509Extension = Operators.as(asnEncodedData, X509Extension.class);
        if (x509Extension == null) {
            throw new ArgumentException(StringExtensions.format("Wrong type.", new Object[0]), "asnEncodedData");
        }
        this._oid = x509Extension._oid == null ? new Oid(oid, friendlyName) : new Oid(x509Extension._oid);
        this.setRawData(x509Extension.getRawData());
        super.setCritical(x509Extension.getCritical());
        this.b = this.decode(this.getRawData());
    }

    public int decode(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return 1;
        }
        if (Operators.castToInt32(byArray[0], 6) != 48) {
            return 2;
        }
        if (this.a == null) {
            this.a = new OidCollection();
        }
        try {
            ASN1 aSN1 = new ASN1(byArray);
            if (Operators.castToInt32(aSN1.getTag(), 6) != 48) {
                throw new CryptographicException(StringExtensions.format("Invalid ASN.1 Tag", new Object[0]));
            }
            for (int i2 = 0; i2 < aSN1.getCount(); ++i2) {
                this.a.add(new Oid(ASN1Convert.toOid(aSN1.get_Item(i2))));
            }
        }
        catch (RuntimeException runtimeException) {
            return 1;
        }
        return 0;
    }

    public byte[] encode() {
        ASN1 aSN1 = new ASN1(48);
        for (Oid oid : this.a) {
            aSN1.add(ASN1Convert.fromOid(oid.getValue()));
        }
        return aSN1.getBytes();
    }

    @Override
    public String toString(boolean bl2) {
        switch (this.b) {
            case 1: {
                return StringExtensions.Empty;
            }
            case 2: 
            case 3: {
                return this.formatUnkownData(this._raw);
            }
            case 4: {
                return "Information Not Available";
            }
        }
        if (!oid.equals(this._oid.getValue())) {
            return StringExtensions.format("Unknown Key Usage ({0})", this._oid.getValue());
        }
        if (this.a.size() == 0) {
            return "Information Not Available";
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            Oid oid = this.a.get_Item(i2);
            switch (c.of(oid.getValue())) {
                case 0: {
                    msStringBuilder2.append("Server Authentication (");
                    break;
                }
                default: {
                    msStringBuilder2.append("Unknown Key Usage (");
                }
            }
            msStringBuilder2.append(oid.getValue());
            msStringBuilder2.append(")");
            if (bl2) {
                msStringBuilder2.append(Environment.get_NewLine());
                continue;
            }
            if (i2 == this.a.size() - 1) continue;
            msStringBuilder2.append(", ");
        }
        return msStringBuilder2.toString();
    }
}

