/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.Security.Cryptography.CipherMode;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.ICryptoTransform;
import com.aspose.html.internal.ms.System.Security.Cryptography.KeySizes;
import com.aspose.html.internal.ms.System.Security.Cryptography.PaddingMode;
import com.aspose.html.internal.ms.System.msArray;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public abstract class SymmetricAlgorithm
implements IDisposable {
    protected int BlockSizeValue;
    protected byte[] IVValue;
    protected int KeySizeValue;
    protected byte[] KeyValue;
    protected KeySizes[] LegalBlockSizesValue;
    protected KeySizes[] LegalKeySizesValue;
    protected int FeedbackSizeValue;
    protected int ModeValue = 1;
    protected int PaddingValue = 2;
    private boolean a = false;

    protected SymmetricAlgorithm() {
    }

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    public void clear() {
        this.dispose(true);
    }

    protected void dispose(boolean bl2) {
        if (!this.a) {
            if (this.KeyValue != null) {
                msArray.clear(this.KeyValue, 0, this.KeyValue.length);
                this.KeyValue = null;
            }
            if (bl2) {
                // empty if block
            }
            this.a = true;
        }
    }

    public int getBlockSize() {
        return this.BlockSizeValue;
    }

    public void setBlockSize(int n2) {
        if (!KeySizes.a(this.LegalBlockSizesValue, n2)) {
            throw new CryptographicException(n.a("block size not supported by algorithm"));
        }
        if (this.BlockSizeValue != n2) {
            this.BlockSizeValue = n2;
            this.IVValue = null;
        }
    }

    public int getFeedbackSize() {
        return this.FeedbackSizeValue;
    }

    public void setFeedbackSize(int n2) {
        if (n2 <= 0 || n2 > this.BlockSizeValue) {
            throw new CryptographicException(n.a("feedback size larger than block size"));
        }
        this.FeedbackSizeValue = n2;
    }

    public byte[] getIV() {
        if (this.IVValue == null) {
            this.generateIV();
        }
        return (byte[])this.IVValue.clone();
    }

    public void setIV(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("value");
        }
        if (byArray.length << 3 != this.BlockSizeValue) {
            throw new CryptographicException(n.a("IV length is different than block size"));
        }
        this.IVValue = (byte[])byArray.clone();
    }

    public byte[] getKey() {
        if (this.KeyValue == null) {
            this.generateKey();
        }
        return (byte[])this.KeyValue.clone();
    }

    public void setKey(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("value");
        }
        int n2 = byArray.length << 3;
        if (!KeySizes.a(this.LegalKeySizesValue, n2)) {
            throw new CryptographicException(n.a("Key size not supported by algorithm"));
        }
        this.KeySizeValue = n2;
        this.KeyValue = (byte[])byArray.clone();
    }

    public int getKeySize() {
        return this.KeySizeValue;
    }

    public void setKeySize(int n2) {
        if (!KeySizes.a(this.LegalKeySizesValue, n2)) {
            throw new CryptographicException(n.a("Key size not supported by algorithm"));
        }
        this.KeySizeValue = n2;
        this.KeyValue = null;
    }

    public KeySizes[] getLegalBlockSizes() {
        return this.LegalBlockSizesValue;
    }

    public KeySizes[] getLegalKeySizes() {
        return this.LegalKeySizesValue;
    }

    public int getMode() {
        return this.ModeValue;
    }

    public void setMode(int n2) {
        if (!Enum.isDefined(CipherMode.class, (long)n2)) {
            throw new CryptographicException(n.a("Cipher mode not available"));
        }
        this.ModeValue = n2;
    }

    public int getPadding() {
        return this.PaddingValue;
    }

    public void setPadding(int n2) {
        if (!Enum.isDefined(PaddingMode.class, (long)n2)) {
            throw new CryptographicException(n.a("Padding mode not available"));
        }
        this.PaddingValue = n2;
    }

    public ICryptoTransform createDecryptor() {
        return this.createDecryptor(this.getKey(), this.getIV());
    }

    public abstract ICryptoTransform createDecryptor(byte[] var1, byte[] var2);

    public ICryptoTransform createEncryptor() {
        return this.createEncryptor(this.getKey(), this.getIV());
    }

    public abstract ICryptoTransform createEncryptor(byte[] var1, byte[] var2);

    public abstract void generateIV();

    public abstract void generateKey();

    public boolean validKeySize(int n2) {
        return KeySizes.a(this.LegalKeySizesValue, n2);
    }

    public static SymmetricAlgorithm create() {
        return SymmetricAlgorithm.create("System.Security.Cryptography.SymmetricAlgorithm");
    }

    public static SymmetricAlgorithm create(String string) {
        return (SymmetricAlgorithm)CryptoConfig.createFromName(string);
    }

    public String toString() {
        String string = ObjectExtensions.getType(this).getName().substring(ObjectExtensions.getType(this).getName().lastIndexOf(46) + 1);
        return "System.Security.Cryptography." + string;
    }
}

