/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.Pkcs;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.Oid;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.PKCS7;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

public final class ContentInfo {
    private Oid a;
    private byte[] b;
    private static final StringSwitchMap c = new StringSwitchMap("1.2.840.113549.1.7.1", "1.2.840.113549.1.7.2", "1.2.840.113549.1.7.3", "1.2.840.113549.1.7.5", "1.2.840.113549.1.7.6");

    public ContentInfo(byte[] byArray) {
        this(new Oid("1.2.840.113549.1.7.1"), byArray);
    }

    public ContentInfo(Oid oid, byte[] byArray) {
        if (oid == null) {
            throw new ArgumentNullException("oid");
        }
        if (byArray == null) {
            throw new ArgumentNullException("content");
        }
        this.a = oid;
        this.b = byArray;
    }

    public byte[] getContent() {
        return (byte[])this.b.clone();
    }

    public Oid getContentType() {
        return this.a;
    }

    public static Oid getContentType(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("algorithm");
        }
        try {
            PKCS7.ContentInfo contentInfo = new PKCS7.ContentInfo(byArray);
            switch (c.of(contentInfo.getContentType())) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return new Oid(contentInfo.getContentType());
                }
            }
            String string = "Bad ASN1 - invalid OID '{0}'";
            throw new CryptographicException(StringExtensions.format(string, contentInfo.getContentType()));
        }
        catch (RuntimeException runtimeException) {
            throw new CryptographicException("Bad ASN1 - invalid structure", runtimeException);
        }
    }
}

