/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.EventArgs;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.CspKeyContainerInfo;
import com.aspose.html.internal.ms.System.Security.Cryptography.CspParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSAParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.ICspAsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.KeySizes;
import com.aspose.html.internal.ms.System.Security.Cryptography.SHA1;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.e;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.f;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.m;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public final class DSACryptoServiceProvider
extends DSA
implements ICspAsymmetricAlgorithm {
    private static final int a = 13;
    private m b;
    private boolean c;
    private boolean d;
    private boolean e = true;
    private boolean f;
    private f g;

    public DSACryptoServiceProvider() {
        this(1024, null);
    }

    public DSACryptoServiceProvider(CspParameters cspParameters) {
        this(1024, cspParameters);
    }

    public DSACryptoServiceProvider(int n2) {
        this(n2, null);
    }

    public DSACryptoServiceProvider(int n2, CspParameters cspParameters) {
        this.LegalKeySizesValue = new KeySizes[1];
        this.LegalKeySizesValue[0] = new KeySizes(512, 1024, 64);
        this.setKeySize(n2);
        this.g = new f(n2);
        this.g.a.add(new f.a(){

            @Override
            public void a(Object object, EventArgs eventArgs) {
                DSACryptoServiceProvider.this.a(object, eventArgs);
            }
        });
        boolean bl2 = this.c = cspParameters != null;
        if (cspParameters == null) {
            cspParameters = new CspParameters(13);
            this.b = new m(cspParameters);
        } else {
            this.b = new m(cspParameters);
            this.b.d();
            if (this.b.b() != null) {
                this.d = true;
                this.fromXmlString(this.b.b());
            }
        }
    }

    @Override
    public String getKeyExchangeAlgorithm() {
        return null;
    }

    @Override
    public int getKeySize() {
        return this.g.getKeySize();
    }

    public boolean getPersistKeyInCsp() {
        return this.c;
    }

    public void setPersistKeyInCsp(boolean bl2) {
        this.c = bl2;
    }

    public boolean getPublicOnly() {
        return this.g.a();
    }

    @Override
    public String getSignatureAlgorithm() {
        return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    }

    @Override
    public DSAParameters exportParameters(boolean bl2) {
        if (bl2 && !this.e) {
            throw new CryptographicException(n.a("Cannot export private key"));
        }
        return this.g.exportParameters(bl2);
    }

    @Override
    public void importParameters(DSAParameters dSAParameters) {
        this.g.importParameters(dSAParameters.Clone());
    }

    @Override
    public byte[] createSignature(byte[] byArray) {
        return this.g.createSignature(byArray);
    }

    public byte[] signData(byte[] byArray) {
        SHA1 sHA1 = SHA1.create();
        byte[] byArray2 = sHA1.computeHash(byArray);
        return this.g.createSignature(byArray2);
    }

    public byte[] signData(byte[] byArray, int n2, int n3) {
        SHA1 sHA1 = SHA1.create();
        byte[] byArray2 = sHA1.computeHash(byArray, n2, n3);
        return this.g.createSignature(byArray2);
    }

    public byte[] signData(Stream stream) {
        SHA1 sHA1 = SHA1.create();
        byte[] byArray = sHA1.computeHash(stream);
        return this.g.createSignature(byArray);
    }

    public byte[] signHash(byte[] byArray, String string) {
        if (StringExtensions.compare(string, "SHA1", true, CultureInfo.getInvariantCulture()) != 0) {
            throw new CryptographicException(n.a("Only SHA1 is supported."));
        }
        return this.g.createSignature(byArray);
    }

    public boolean verifyData(byte[] byArray, byte[] byArray2) {
        SHA1 sHA1 = SHA1.create();
        byte[] byArray3 = sHA1.computeHash(byArray);
        return this.g.verifySignature(byArray3, byArray2);
    }

    public boolean verifyHash(byte[] byArray, String string, byte[] byArray2) {
        if (string == null) {
            string = "SHA1";
        }
        if (StringExtensions.compare(string, "SHA1", true, CultureInfo.getInvariantCulture()) != 0) {
            throw new CryptographicException(n.a("Only SHA1 is supported."));
        }
        return this.g.verifySignature(byArray, byArray2);
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        return this.g.verifySignature(byArray, byArray2);
    }

    @Override
    protected void dispose(boolean bl2) {
        if (!this.f) {
            if (this.d && !this.c) {
                this.b.f();
            }
            if (this.g != null) {
                this.g.clear();
            }
            this.f = true;
        }
    }

    private void a(Object object, EventArgs eventArgs) {
        if (this.c && !this.d) {
            this.b.a(this.toXmlString(!this.g.a()));
            this.b.e();
            this.d = true;
        }
    }

    @Override
    public CspKeyContainerInfo getCspKeyContainerInfo() {
        return null;
    }

    @Override
    public byte[] exportCspBlob(boolean bl2) {
        byte[] byArray = null;
        byArray = bl2 ? com.aspose.html.internal.ms.core.System.Security.Cryptography.e.a(this) : com.aspose.html.internal.ms.core.System.Security.Cryptography.e.b(this);
        return byArray;
    }

    @Override
    public void importCspBlob(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("keyBlob");
        }
        DSA dSA = com.aspose.html.internal.ms.core.System.Security.Cryptography.e.f(byArray);
        if (dSA instanceof DSACryptoServiceProvider) {
            DSAParameters dSAParameters = dSA.exportParameters(!((DSACryptoServiceProvider)dSA).getPublicOnly()).Clone();
            this.importParameters(dSAParameters.Clone());
        } else {
            try {
                DSAParameters dSAParameters = dSA.exportParameters(true).Clone();
                this.importParameters(dSAParameters.Clone());
            }
            catch (Exception exception) {
                DSAParameters dSAParameters = dSA.exportParameters(false).Clone();
                this.importParameters(dSAParameters.Clone());
            }
        }
    }
}

