/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Runtime.InteropServices;

import com.aspose.html.internal.ms.System.AccessViolationException;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.IntPtr;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.core.Win32.Kernel32;
import com.aspose.html.internal.ms.core.memory.Pointer;
import com.aspose.html.internal.ms.core.memory.PointerToArray;

public class Marshal {
    public static long sizeOf(Object object) {
        if (object instanceof IntPtr) {
            return ((IntPtr)object).toPointer().getSize();
        }
        if (object instanceof Pointer) {
            return ((Pointer)object).getSize();
        }
        throw new NotImplementedException("");
    }

    public static void copy(byte[] byArray, int n2, IntPtr intPtr, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(byArray, 1, n2, intPtr, intPtr.toPointer().getOffset(), n3);
    }

    public static void copy(short[] sArray, int n2, IntPtr intPtr, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(sArray, 2, n2, intPtr, intPtr.toPointer().getOffset(), n3);
    }

    public static void copy(int[] nArray, int n2, IntPtr intPtr, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(nArray, 4, n2, intPtr, intPtr.toPointer().getOffset(), n3);
    }

    public static void copy(long[] lArray, int n2, IntPtr intPtr, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(lArray, 8, n2, intPtr, intPtr.toPointer().getOffset(), n3);
    }

    public static void copy(float[] fArray, int n2, IntPtr intPtr, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(fArray, 4, n2, intPtr, intPtr.toPointer().getOffset(), n3);
    }

    public static void copy(char[] cArray, int n2, IntPtr intPtr, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(cArray, 2, n2, intPtr, intPtr.toPointer().getOffset(), n3);
    }

    public static void copy(IntPtr intPtr, char[] cArray, int n2, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(intPtr, intPtr.toPointer().getOffset(), cArray, 2, n2, n3);
    }

    public static void copy(double[] dArray, int n2, IntPtr intPtr, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(dArray, 8, n2, intPtr, intPtr.toPointer().getOffset(), n3);
    }

    public static void copy(IntPtr intPtr, double[] dArray, int n2, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(intPtr, intPtr.toPointer().getOffset(), dArray, 8, n2, n3);
    }

    public static void copy(IntPtr intPtr, float[] fArray, int n2, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(intPtr, intPtr.toPointer().getOffset(), fArray, 4, n2, n3);
    }

    public static void copy(IntPtr intPtr, byte[] byArray, int n2, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(intPtr, intPtr.toPointer().getOffset(), byArray, 1, n2, n3);
    }

    public static void copy(IntPtr intPtr, short[] sArray, int n2, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(intPtr, intPtr.toPointer().getOffset(), sArray, 2, n2, n3);
    }

    public static void copy(IntPtr intPtr, int[] nArray, int n2, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(intPtr, intPtr.toPointer().getOffset(), nArray, 4, n2, n3);
    }

    public static void copy(IntPtr intPtr, long[] lArray, int n2, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(intPtr, intPtr.toPointer().getOffset(), lArray, 8, n2, n3);
    }

    public static IntPtr allocHGlobal(int n2) {
        if (n2 <= 0) {
            throw new ArgumentOutOfRangeException("cb", "Non-negative number required.");
        }
        return new IntPtr(Pointer.create(new byte[n2]));
    }

    public static IntPtr allocHGlobal(IntPtr intPtr) {
        if (intPtr == null || intPtr.toPointer() == null || intPtr.toPointer().getData() == null) {
            throw new ArgumentNullException("cb cannot be null");
        }
        if (intPtr.toPointer().getData() instanceof byte[]) {
            return Marshal.allocHGlobal(((byte[])intPtr.toPointer().getData()).length);
        }
        if (intPtr.toPointer().getData() instanceof short[]) {
            return Marshal.allocHGlobal(((short[])intPtr.toPointer().getData()).length * 2);
        }
        if (intPtr.toPointer().getData() instanceof int[]) {
            return Marshal.allocHGlobal(((int[])intPtr.toPointer().getData()).length * 4);
        }
        if (intPtr.toPointer().getData() instanceof long[]) {
            return Marshal.allocHGlobal(((long[])intPtr.toPointer().getData()).length * 8);
        }
        throw new NotSupportedException();
    }

    public static void freeHGlobal(IntPtr intPtr) {
        intPtr.toPointer().cleanup();
    }

    public static byte readByte(IntPtr intPtr) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        byte[] byArray = new byte[1];
        Marshal.a(intPtr, intPtr.toPointer().getOffset(), byArray, 1, 0, 1);
        return byArray[0];
    }

    public static byte readByte(IntPtr intPtr, int n2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        byte[] byArray = new byte[1];
        Marshal.a(intPtr, intPtr.toPointer().getOffset() + n2, byArray, 1, 0, 1);
        return byArray[0];
    }

    public static void writeByte(IntPtr intPtr, byte by2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new byte[]{by2}, Marshal.sizeOf(Byte.TYPE), 0, intPtr, intPtr.toPointer().getOffset(), 1);
    }

    public static void writeByte(IntPtr intPtr, int n2, byte by2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new byte[]{by2}, Marshal.sizeOf(Byte.TYPE), 0, intPtr, intPtr.toPointer().getOffset() + n2, 1);
    }

    public static byte readByte(Object object, int n2) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static void writeByte(Object object, int n2, byte by2) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static short readInt16(IntPtr intPtr) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        short[] sArray = new short[1];
        Marshal.a(intPtr, intPtr.toPointer().getOffset(), sArray, 2, 0, 1);
        return sArray[0];
    }

    public static short readInt16(IntPtr intPtr, int n2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        short[] sArray = new short[1];
        Marshal.a(intPtr, intPtr.toPointer().getOffset() + n2, sArray, 2, 0, 1);
        return sArray[0];
    }

    public static short readInt16(Object object, int n2) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static void writeInt16(IntPtr intPtr, short s2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new short[]{s2}, 2, 0, intPtr, intPtr.toPointer().getOffset(), 1);
    }

    public static void writeInt16(IntPtr intPtr, int n2, short s2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new short[]{s2}, 2, 0, intPtr, intPtr.toPointer().getOffset() + n2, 1);
    }

    public static void writeInt16(Object object, int n2, byte by2) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static int readInt32(IntPtr intPtr) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        int[] nArray = new int[1];
        Marshal.a(intPtr, intPtr.toPointer().getOffset(), nArray, 4, 0, 1);
        return nArray[0];
    }

    public static int readInt32(IntPtr intPtr, int n2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        int[] nArray = new int[1];
        Marshal.a(intPtr, intPtr.toPointer().getOffset() + n2, nArray, 4, 0, 1);
        return nArray[0];
    }

    public static int readInt32(Object object, int n2) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static void writeInt32(IntPtr intPtr, int n2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new int[]{n2}, 4, 0, intPtr, intPtr.toPointer().getOffset(), 1);
    }

    public static void writeInt32(IntPtr intPtr, int n2, int n3) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new int[]{n3}, 4, 0, intPtr, intPtr.toPointer().getOffset() + n2, 1);
    }

    public static void writeInt32(Object object, int n2, int n3) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static long readInt64(IntPtr intPtr) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        long[] lArray = new long[1];
        Marshal.a(intPtr, intPtr.toPointer().getOffset(), lArray, 8, 0, 1);
        return lArray[0];
    }

    public static long readInt64(IntPtr intPtr, int n2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        long[] lArray = new long[1];
        Marshal.a(intPtr, intPtr.toPointer().getOffset() + n2, lArray, 8, 0, 1);
        return lArray[0];
    }

    public static int readInt64(Object object, int n2) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static void writeInt64(IntPtr intPtr, long l2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new long[]{l2}, 8, 0, intPtr, intPtr.toPointer().getOffset(), 1);
    }

    public static void writeInt64(IntPtr intPtr, int n2, long l2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.a(new long[]{l2}, 8, 0, intPtr, intPtr.toPointer().getOffset() + n2, 1);
    }

    public static void writeInt64(Object object, int n2, long l2) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static IntPtr readIntPtr(IntPtr intPtr) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        return new IntPtr(Marshal.readInt64(intPtr));
    }

    public static IntPtr readIntPtr(IntPtr intPtr, int n2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        return new IntPtr(Marshal.readInt64(intPtr, n2));
    }

    public static int readIntPtr(Object object, int n2) {
        throw new NotSupportedException("Only IntPtr supported");
    }

    public static void writeIntPtr(IntPtr intPtr, IntPtr intPtr2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.writeInt64(intPtr, intPtr2.toInt64());
    }

    public static void writeIntPtr(IntPtr intPtr, int n2, IntPtr intPtr2) {
        if (intPtr == null || intPtr.toPointer() == null) {
            throw new ArgumentNullException();
        }
        Marshal.writeInt64(intPtr, n2, intPtr2.toInt64());
    }

    public static int sizeOf(Class clazz) {
        if (clazz == IntPtr.class || clazz == Long.TYPE || clazz == Long.class) {
            return 8;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return 4;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return 2;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return 1;
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return 2;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return 1;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return 4;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return 8;
        }
        throw new NotSupportedException(clazz + " type is not supported");
    }

    private static void a(Object object, int n2, int n3, IntPtr intPtr, int n4, int n5) {
        if (intPtr == null || intPtr.isNull()) {
            throw new ArgumentNullException("Destination cannot be null");
        }
        if (object == null) {
            throw new ArgumentNullException("Source cannot be null");
        }
        Pointer pointer = intPtr.toPointer();
        if (!(pointer instanceof PointerToArray)) {
            throw new ArgumentException("invalid type of destination", "destination");
        }
        PointerToArray pointerToArray = (PointerToArray)pointer;
        Array array = Array.boxing(object);
        Array array2 = Array.boxing(pointer.getData());
        if (n5 < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("sourceStartIndex", "Non-negative number required.");
        }
        if (n3 > array.getLength() - n5) {
            throw new ArgumentOutOfRangeException("Source array was not long enough");
        }
        if (n4 > array2.getLength() - n5) {
            throw new AccessViolationException("Source array was not long enough");
        }
        if (pointer.getOffset() > (array2.getLength() - n5) * pointerToArray.getElementSize()) {
            throw new ArgumentOutOfRangeException("Destination array was not long enough");
        }
        try {
            Buffer.blockCopy(array, n3 * n2, array2, n4, n5 * n2);
        }
        catch (ArgumentException argumentException) {
            throw new AccessViolationException("Cannot write. Address inaccessible");
        }
    }

    private static void a(IntPtr intPtr, int n2, Object object, int n3, int n4, int n5) {
        if (intPtr == null || intPtr.isNull()) {
            throw new ArgumentNullException("Destination cannot be null");
        }
        if (object == null) {
            throw new ArgumentNullException("Source cannot be null");
        }
        Pointer pointer = intPtr.toPointer();
        if (!(pointer instanceof PointerToArray)) {
            throw new ArgumentException("invalid type of source", "source");
        }
        PointerToArray pointerToArray = (PointerToArray)pointer;
        Array array = Array.boxing(pointer.getData());
        Array array2 = Array.boxing(object);
        if (n5 < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (n2 > array.getLength() - n5) {
            throw new ArgumentOutOfRangeException("Source array was not long enough");
        }
        if (n4 < 0) {
            throw new ArgumentOutOfRangeException("destinationStartIndex", "Non-negative number required.");
        }
        if (n4 > array2.getLength() - n5) {
            throw new ArgumentOutOfRangeException("Destination array was not long enough");
        }
        if (pointer.getOffset() > (array.getLength() - n5) * pointerToArray.getElementSize()) {
            throw new ArgumentOutOfRangeException("Source array was not long enough");
        }
        try {
            Buffer.blockCopy(array, n2, array2, n4 * n3, n5 * n3);
        }
        catch (ArgumentException argumentException) {
            throw new AccessViolationException("Cannot read. Address inaccessible");
        }
    }

    public static int getLastWin32Error() {
        return Kernel32.GetLastError();
    }
}

