/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Version;

public class OperatingSystem
implements ICloneable {
    private int a;
    private String b;
    private Version c;
    private String d;
    private boolean e;

    public OperatingSystem(int n2, Version version) {
        this(n2, version, null);
    }

    public OperatingSystem(int n2, Version version, String string) {
        if (n2 < 0 || n2 > 10) {
            throw new ArgumentException("Illegal platform Id");
        }
        if (version == null) {
            throw new ArgumentNullException("version");
        }
        this.a = n2;
        this.c = (Version)version.deepClone();
        this.b = string;
    }

    @Override
    public Object deepClone() {
        return new OperatingSystem(this.a, this.c);
    }

    public int get_Platform() {
        return this.a;
    }

    public String get_ServicePack() {
        if (this.b == null) {
            return StringExtensions.Empty;
        }
        return this.b;
    }

    public Version get_Version() {
        return this.c;
    }

    public String get_VersionString() {
        if (this.d == null) {
            String string;
            switch (this.a) {
                case 2: {
                    string = "Microsoft Windows NT ";
                    break;
                }
                case 0: {
                    string = "Microsoft Win32S ";
                    break;
                }
                case 1: {
                    if (this.c.getMajor() > 4 || this.c.getMajor() == 4 && this.c.getMinor() > 0) {
                        string = "Microsoft Windows 98 ";
                        break;
                    }
                    string = "Microsoft Windows 95 ";
                    break;
                }
                case 3: {
                    string = "Microsoft Windows CE ";
                    break;
                }
                case 4: 
                case 128: {
                    string = "Unix ";
                    break;
                }
                case 5: {
                    string = "XBox ";
                    break;
                }
                case 6: {
                    string = "Mac OS X ";
                    break;
                }
                case 7: {
                    string = "Mac OS ";
                    break;
                }
                case 8: {
                    string = "OS/2 ";
                    break;
                }
                case 9: {
                    string = "IBM i ";
                    break;
                }
                case 10: {
                    string = "IBM z/OS ";
                    break;
                }
                default: {
                    string = "<unknown> ";
                }
            }
            if (this.e) {
                string = string + StringExtensions.format("V{0}R{1}", this.c.getMajor(), this.c.getMinor());
                this.d = StringExtensions.isNullOrEmpty(this.b) ? string : string + " " + this.b;
                return this.d;
            }
            this.d = StringExtensions.isNullOrEmpty(this.b) ? string + this.c.toString() : string + this.c.toString(2) + " " + this.b;
        }
        return this.d;
    }

    protected void setIsOldIBMFormatVersion(boolean bl2) {
        this.e = bl2;
    }

    public String toString() {
        return this.get_VersionString();
    }
}

