/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.Net.IPAddress;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;

class IPv6Address {
    private int[] c;
    private int d;
    private long e = Operators.castToInt64(0, 9);
    public static final IPv6Address a = IPv6Address.a("::1");
    public static final IPv6Address b = IPv6Address.a("::");

    public IPv6Address(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("addr");
        }
        if (Array.boxing(nArray).getLength() != 8) {
            throw new ArgumentException("addr");
        }
        this.c = nArray;
    }

    public IPv6Address(int[] nArray, int n2) {
        this(nArray);
        if (n2 < 0 || n2 > 128) {
            throw new ArgumentException("prefixLength");
        }
        this.d = n2;
    }

    public IPv6Address(int[] nArray, int n2, int n3) {
        this(nArray, n2);
        this.e = Operators.castToInt64(n3, 9);
    }

    public static IPv6Address a(String string) {
        if (string == null) {
            throw new ArgumentNullException("ipString");
        }
        IPv6Address iPv6Address = null;
        IPv6Address[] iPv6AddressArray = new IPv6Address[]{iPv6Address};
        boolean bl2 = IPv6Address.a(string, iPv6AddressArray);
        iPv6Address = iPv6AddressArray[0];
        if (bl2) {
            return iPv6Address;
        }
        throw new FormatException("Not a valid IPv6 address");
    }

    static int a(int[] nArray, String string) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (string.length() == 0) {
            return 0;
        }
        if (StringExtensions.indexOf(string, "::", (short)4) != -1) {
            return -1;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n5;
            char c2 = string.charAt(i2);
            if (c2 == ':') {
                if (i2 == 0) {
                    return -1;
                }
                if (i2 == string.length() - 1) {
                    return -1;
                }
                if (n4 == 8) {
                    return -1;
                }
                nArray[n4++] = Operators.castToUInt16(n2, 9);
                n2 = 0;
                n3 = 0;
                continue;
            }
            if (++n3 > 4) {
                return -1;
            }
            if ('0' <= c2 && c2 <= '9') {
                n5 = Operators.castToInt32(Character.valueOf(c2), 4) - Operators.castToInt32(Character.valueOf('0'), 4);
            } else if ('a' <= c2 && c2 <= 'f') {
                n5 = Operators.castToInt32(Character.valueOf(c2), 4) - Operators.castToInt32(Character.valueOf('a'), 4) + 10;
            } else if ('A' <= c2 && c2 <= 'F') {
                n5 = Operators.castToInt32(Character.valueOf(c2), 4) - Operators.castToInt32(Character.valueOf('A'), 4) + 10;
            } else {
                return -1;
            }
            n2 = (n2 << 4) + n5;
            if (n2 <= Operators.castToUInt16(65535, 8)) continue;
            return -1;
        }
        if (n4 == 8) {
            return -1;
        }
        nArray[n4++] = Operators.castToUInt16(n2, 9);
        return n4;
    }

    static boolean a(String string, int[] nArray) {
        return Int32Extensions.tryParse(string, 7, CultureInfo.getInvariantCulture(), nArray);
    }

    public static boolean a(String string, IPv6Address[] iPv6AddressArray) {
        int n2;
        int n3;
        String string2;
        int n4;
        int[] nArray;
        Object object;
        iPv6AddressArray[0] = null;
        if (string == null) {
            return false;
        }
        if (string.length() > 2 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = StringExtensions.substring(string, 1, string.length() - 2);
        }
        if (string.length() < 2) {
            return false;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = StringExtensions.lastIndexOf(string, '/');
        if (n7 != -1) {
            object = StringExtensions.substring(string, n7 + 1);
            nArray = new int[]{0};
            n4 = !IPv6Address.a((String)object, nArray) ? 1 : 0;
            n5 = nArray[0];
            if (n4 != 0) {
                n5 = -1;
            }
            if (n5 < 0 || n5 > 128) {
                return false;
            }
            string = StringExtensions.substring(string, 0, n7);
        } else {
            n7 = StringExtensions.lastIndexOf(string, '%');
            if (n7 != -1) {
                object = StringExtensions.substring(string, n7 + 1);
                nArray = new int[]{0};
                n4 = !IPv6Address.a((String)object, nArray) ? 1 : 0;
                n6 = nArray[0];
                if (n4 != 0) {
                    n6 = 0;
                }
                string = StringExtensions.substring(string, 0, n7);
            }
        }
        object = new int[8];
        int n8 = StringExtensions.lastIndexOf(string, ':');
        if (n8 == -1) {
            return false;
        }
        n4 = 0;
        if (n8 < string.length() - 1 && StringExtensions.indexOf(string2 = StringExtensions.substring(string, n8 + 1), '.') != -1) {
            IPAddress iPAddress = null;
            IPAddress[] iPAddressArray = new IPAddress[]{iPAddress};
            n3 = !IPAddress.tryParse(string2, iPAddressArray) ? 1 : 0;
            iPAddress = iPAddressArray[0];
            if (n3 != 0) {
                return false;
            }
            long l2 = iPAddress.a();
            object[6] = Operators.castToUInt16((Operators.castToInt32(l2 & Operators.castToInt64(255, 9), 11) << 8) + Operators.castToInt32(l2 >> 8 & Operators.castToInt64(255, 9), 11), 9);
            object[7] = Operators.castToUInt16((Operators.castToInt32(l2 >> 16 & Operators.castToInt64(255, 9), 11) << 8) + Operators.castToInt32(l2 >> 24 & Operators.castToInt64(255, 9), 11), 9);
            string = n8 > 0 && string.charAt(n8 - 1) == ':' ? StringExtensions.substring(string, 0, n8 + 1) : StringExtensions.substring(string, 0, n8);
            n4 = 2;
        }
        if ((n2 = StringExtensions.indexOf(string, "::", (short)4)) != -1) {
            int n9 = IPv6Address.a((int[])object, StringExtensions.substring(string, n2 + 2));
            if (n9 == -1) {
                return false;
            }
            if (n9 + n4 > 8) {
                return false;
            }
            int n10 = 8 - n4 - n9;
            for (n3 = n9; n3 > 0; --n3) {
                object[n3 + n10 - 1] = object[n3 - 1];
                object[n3 - 1] = Operators.castToUInt16(0, 9);
            }
            n3 = IPv6Address.a((int[])object, StringExtensions.substring(string, 0, n2));
            if (n3 == -1) {
                return false;
            }
            if (n3 + n9 + n4 > 7) {
                return false;
            }
        } else if (IPv6Address.a((int[])object, string) != 8 - n4) {
            return false;
        }
        iPv6AddressArray[0] = new IPv6Address((int[])object, n5, n6);
        return true;
    }

    public int[] a() {
        return this.c;
    }

    public int b() {
        return this.d;
    }

    public long c() {
        return this.e;
    }

    public void a(long l2) {
        this.e = l2;
    }

    public int a(int n2) {
        return this.c[n2];
    }

    public int d() {
        return 23;
    }

    public static boolean a(IPv6Address iPv6Address) {
        if (Operators.castToUInt16(iPv6Address.c[7], 8) != 1) {
            return false;
        }
        int n2 = Operators.castToInt32(Operators.castToUInt16(iPv6Address.c[6], 8) >> 8, 8);
        if (n2 != 127 && n2 != 0) {
            return false;
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            if (Operators.castToUInt16(iPv6Address.c[i2], 8) == 0) continue;
            return false;
        }
        return Operators.castToUInt16(iPv6Address.c[5], 8) == 0 || Operators.castToUInt16(iPv6Address.c[5], 8) == 65535;
    }

    private static int b(int n2) {
        return Operators.castToUInt16((n2 >> 8 & 0xFF) + (n2 << 8 & 0xFF00), 9);
    }

    private long g() {
        return Operators.castToUInt32((IPv6Address.b(this.c[7]) << 16) + IPv6Address.b(this.c[6]), 9);
    }

    public boolean e() {
        for (int i2 = 0; i2 < 6; ++i2) {
            if (Operators.castToUInt16(this.c[i2], 8) == 0) continue;
            return false;
        }
        if (Operators.castToUInt16(this.c[6], 8) == 0) {
            return false;
        }
        return Operators.castToUInt32(this.g(), 10) > 1L;
    }

    public boolean f() {
        for (int i2 = 0; i2 < 5; ++i2) {
            if (Operators.castToUInt16(this.c[i2], 8) == 0) continue;
            return false;
        }
        if (Operators.castToUInt16(this.c[6], 8) == 0) {
            return false;
        }
        return Operators.castToUInt16(this.c[5], 8) == 65535;
    }

    public String toString() {
        int n2;
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        if (this.e() || this.f()) {
            msStringBuilder2.append("::");
            if (this.f()) {
                msStringBuilder2.append("ffff:");
            }
            msStringBuilder2.append(new IPAddress(this.g()).toString());
            return msStringBuilder2.toString();
        }
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            if (Operators.castToUInt16(this.c[n2], 8) != 0) {
                if (n5 > n4 && n5 > 1) {
                    n4 = n5;
                    n3 = n2 - n5;
                }
                n5 = 0;
                continue;
            }
            ++n5;
        }
        if (n5 > n4 && n5 > 1) {
            n4 = n5;
            n3 = 8 - n5;
        }
        if (n3 == 0) {
            msStringBuilder2.append(":");
        }
        for (n2 = 0; n2 < 8; ++n2) {
            if (n2 == n3) {
                msStringBuilder2.append(":");
                n2 += n4 - 1;
                continue;
            }
            msStringBuilder2.appendFormat("{0:x}", Operators.boxing(this.c[n2]));
            if (n2 >= 7) continue;
            msStringBuilder2.append(':');
        }
        if (this.e != 0L) {
            msStringBuilder2.append('%').append(this.e);
        }
        return msStringBuilder2.toString();
    }

    public String a(boolean bl2) {
        if (!bl2) {
            return this.toString();
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (int i2 = 0; i2 < Array.boxing(this.c).getLength() - 1; ++i2) {
            msStringBuilder2.appendFormat("{0:X4}:", Operators.boxing(this.c[i2]));
        }
        msStringBuilder2.appendFormat("{0:X4}", Operators.boxing(this.c[Array.boxing(this.c).getLength() - 1]));
        return msStringBuilder2.toString();
    }

    public boolean equals(Object object) {
        IPv6Address iPv6Address = Operators.as(object, IPv6Address.class);
        if (iPv6Address != null) {
            for (int i2 = 0; i2 < 8; ++i2) {
                if (Operators.castToUInt16(this.c[i2], 8) == Operators.castToUInt16(iPv6Address.c[i2], 8)) continue;
                return false;
            }
            return true;
        }
        IPAddress iPAddress = Operators.as(object, IPAddress.class);
        if (iPAddress != null) {
            for (int i3 = 0; i3 < 5; ++i3) {
                if (Operators.castToUInt16(this.c[i3], 8) == 0) continue;
                return false;
            }
            if (Operators.castToUInt16(this.c[5], 8) != 0 && Operators.castToUInt16(this.c[5], 8) != 65535) {
                return false;
            }
            long l2 = iPAddress.a();
            return Operators.castToUInt16(this.c[6], 8) == Operators.castToUInt16(Operators.castToUInt16((Operators.castToInt32(l2 & Operators.castToInt64(255, 9), 11) << 8) + Operators.castToInt32(l2 >> 8 & Operators.castToInt64(255, 9), 11), 9), 8) && Operators.castToUInt16(this.c[7], 8) == Operators.castToUInt16(Operators.castToUInt16((Operators.castToInt32(l2 >> 16 & Operators.castToInt64(255, 9), 11) << 8) + Operators.castToInt32(l2 >> 24 & Operators.castToInt64(255, 9), 11), 9), 8);
        }
        return false;
    }

    public int hashCode() {
        return IPv6Address.a((Operators.castToInt32(this.c[0], 8) << 16) + Operators.castToInt32(this.c[1], 8), (Operators.castToInt32(this.c[2], 8) << 16) + Operators.castToInt32(this.c[3], 8), (Operators.castToInt32(this.c[4], 8) << 16) + Operators.castToInt32(this.c[5], 8), (Operators.castToInt32(this.c[6], 8) << 16) + Operators.castToInt32(this.c[7], 8));
    }

    private static int a(int n2, int n3, int n4, int n5) {
        return n2 ^ (n3 << 13 | n3 >> 19) ^ (n4 << 26 | n4 >> 6) ^ (n5 << 7 | n5 >> 25);
    }
}

