/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.IO.StreamWriter;
import com.aspose.html.internal.ms.System.Int64Extensions;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.Net.Cookie;
import com.aspose.html.internal.ms.System.Net.CookieCollection;
import com.aspose.html.internal.ms.System.Net.HttpListenerContext;
import com.aspose.html.internal.ms.System.Net.HttpVersion;
import com.aspose.html.internal.ms.System.Net.ProtocolViolationException;
import com.aspose.html.internal.ms.System.Net.ResponseStream;
import com.aspose.html.internal.ms.System.Net.WebHeaderCollection;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Version;
import com.aspose.html.internal.ms.lang.Operators;

public final class HttpListenerResponse
implements IDisposable {
    private boolean c;
    private Encoding d;
    private long e;
    private boolean f;
    private String g;
    private CookieCollection h;
    private WebHeaderCollection i = new WebHeaderCollection();
    private boolean j = true;
    private ResponseStream k;
    private Version l = HttpVersion.Version11;
    private String m;
    private int n = 200;
    private String o = "OK";
    private boolean p;
    private HttpListenerContext q;
    boolean a;
    Object b = new Object();
    private boolean r;

    HttpListenerResponse(HttpListenerContext httpListenerContext) {
        this.q = httpListenerContext;
    }

    boolean a() {
        return this.r;
    }

    public Encoding getContentEncoding() {
        if (this.d == null) {
            this.d = Encoding.getDefault();
        }
        return this.d;
    }

    public void setContentEncoding(Encoding encoding) {
        if (this.c) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        if (this.a) {
            throw new InvalidOperationException("Cannot be changed after headers are sent.");
        }
        this.d = encoding;
    }

    public long getContentLength64() {
        return this.e;
    }

    public void setContentLength64(long l2) {
        if (this.c) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        if (this.a) {
            throw new InvalidOperationException("Cannot be changed after headers are sent.");
        }
        if (l2 < 0L) {
            throw new ArgumentOutOfRangeException("Must be >= 0", "value");
        }
        this.f = true;
        this.e = l2;
    }

    public String getContentType() {
        return this.g;
    }

    public void setContentType(String string) {
        if (this.c) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        if (this.a) {
            throw new InvalidOperationException("Cannot be changed after headers are sent.");
        }
        this.g = string;
    }

    public CookieCollection getCookies() {
        if (this.h == null) {
            this.h = new CookieCollection();
        }
        return this.h;
    }

    public void setCookies(CookieCollection cookieCollection) {
        this.h = cookieCollection;
    }

    public WebHeaderCollection getHeaders() {
        return this.i;
    }

    public void setHeaders(WebHeaderCollection webHeaderCollection) {
        this.i = webHeaderCollection;
    }

    public boolean getKeepAlive() {
        return this.j;
    }

    public void setKeepAlive(boolean bl2) {
        if (this.c) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        if (this.a) {
            throw new InvalidOperationException("Cannot be changed after headers are sent.");
        }
        this.j = bl2;
    }

    public Stream getOutputStream() {
        if (this.k == null) {
            this.k = this.q.d().j();
        }
        return this.k;
    }

    public Version getProtocolVersion() {
        return this.l;
    }

    public void setProtocolVersion(Version version) {
        if (this.c) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        if (this.a) {
            throw new InvalidOperationException("Cannot be changed after headers are sent.");
        }
        if (version == null) {
            throw new ArgumentNullException("value");
        }
        if (version.getMajor() != 1 || version.getMinor() != 0 && version.getMinor() != 1) {
            throw new ArgumentException("Must be 1.0 or 1.1", "value");
        }
        if (this.c) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        this.l = version;
    }

    public String getRedirectLocation() {
        return this.m;
    }

    public void setRedirectLocation(String string) {
        if (this.c) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        if (this.a) {
            throw new InvalidOperationException("Cannot be changed after headers are sent.");
        }
        this.m = string;
    }

    public boolean getSendChunked() {
        return this.p;
    }

    public void setSendChunked(boolean bl2) {
        if (this.c) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        if (this.a) {
            throw new InvalidOperationException("Cannot be changed after headers are sent.");
        }
        this.p = bl2;
    }

    public int getStatusCode() {
        return this.n;
    }

    public void setStatusCode(int n2) {
        if (this.c) {
            throw new ObjectDisposedException(ObjectExtensions.getType(this).toString());
        }
        if (this.a) {
            throw new InvalidOperationException("Cannot be changed after headers are sent.");
        }
        if (n2 < 100 || n2 > 999) {
            throw new ProtocolViolationException("StatusCode must be between 100 and 999.");
        }
        this.n = n2;
        this.o = HttpListenerResponse.a(n2);
    }

    static String a(int n2) {
        switch (n2) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 102: {
                return "Processing";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 207: {
                return "Multi-Status";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-Uri Too Long";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 424: {
                return "Failed Dependency";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "Http Version Not Supported";
            }
            case 507: {
                return "Insufficient Storage";
            }
        }
        return "";
    }

    public String getStatusDescription() {
        return this.o;
    }

    public void setStatusDescription(String string) {
        this.o = string;
    }

    @Override
    public void dispose() {
        this.a(true);
    }

    public void abort() {
        if (this.c) {
            return;
        }
        this.a(true);
    }

    public void addHeader(String string, String string2) {
        if (string == null) {
            throw new ArgumentNullException("name");
        }
        if ("".equals(string)) {
            throw new ArgumentException("'name' cannot be empty", "name");
        }
        if (string2.length() > 65535) {
            throw new ArgumentOutOfRangeException("value");
        }
        this.i.set(string, string2);
    }

    public void appendCookie(Cookie cookie) {
        if (cookie == null) {
            throw new ArgumentNullException("cookie");
        }
        this.getCookies().add(cookie);
    }

    public void appendHeader(String string, String string2) {
        if (string == null) {
            throw new ArgumentNullException("name");
        }
        if ("".equals(string)) {
            throw new ArgumentException("'name' cannot be empty", "name");
        }
        if (string2.length() > 65535) {
            throw new ArgumentOutOfRangeException("value");
        }
        this.i.add(string, string2);
    }

    private void a(boolean bl2) {
        this.c = true;
        this.q.d().a(bl2);
    }

    public void close() {
        if (this.c) {
            return;
        }
        this.a(false);
    }

    public void close(byte[] byArray, boolean bl2) {
        if (this.c) {
            return;
        }
        if (byArray == null) {
            throw new ArgumentNullException("responseEntity");
        }
        this.setContentLength64(byArray.length);
        this.getOutputStream().write(byArray, 0, Operators.castToInt32(this.e, 11));
        this.a(false);
    }

    public void copyFrom(HttpListenerResponse httpListenerResponse) {
        this.i.clear();
        this.i.add(httpListenerResponse.i);
        this.e = httpListenerResponse.e;
        this.n = httpListenerResponse.n;
        this.o = httpListenerResponse.o;
        this.j = httpListenerResponse.j;
        this.l = httpListenerResponse.l;
    }

    public void redirect(String string) {
        this.setStatusCode(302);
        this.m = string;
    }

    private boolean a(Cookie cookie) {
        String string = cookie.getName();
        String string2 = cookie.getDomain();
        String string3 = cookie.getPath();
        for (Cookie cookie2 : this.h) {
            if (!StringExtensions.equals(string, cookie2.getName()) || !StringExtensions.equals(string2, cookie2.getDomain()) || !StringExtensions.equals(string3, cookie2.getPath())) continue;
            return true;
        }
        return false;
    }

    void a(boolean bl2, MemoryStream memoryStream) {
        int n2;
        Object object3;
        int n3;
        boolean bl3;
        Object object2;
        Encoding encoding = this.d;
        if (encoding == null) {
            encoding = Encoding.getDefault();
        }
        if (this.g != null) {
            if (this.d != null && StringExtensions.indexOf(this.g, "charset=", (short)4) == -1) {
                object2 = this.d.getWebName();
                this.i.b("Content-Type", StringExtensions.concat(new String[]{this.g, "; charset=", object2}));
            } else {
                this.i.b("Content-Type", this.g);
            }
        }
        if (this.i.get_Item("Server") == null) {
            this.i.b("Server", "com.aspose.system.net-http/1.0");
        }
        object2 = CultureInfo.getInvariantCulture();
        if (this.i.get_Item("Date") == null) {
            this.i.b("Date", DateTime.getUtcNow().toString("r", (IFormatProvider)object2));
        }
        if (!this.p) {
            if (!this.f && bl2) {
                this.f = true;
                this.e = 0L;
            }
            if (this.f) {
                this.i.b("Content-Length", Int64Extensions.toString(this.e, (IFormatProvider)object2));
            }
        }
        Version version = this.q.getRequest().getProtocolVersion();
        if (!this.f && !this.p && Version.op_GreaterThanOrEqual(version, HttpVersion.Version11)) {
            this.p = true;
        }
        boolean bl4 = bl3 = this.n == 400 || this.n == 408 || this.n == 411 || this.n == 413 || this.n == 414 || this.n == 500 || this.n == 503;
        if (!bl3) {
            boolean bl5 = bl3 = !this.q.getRequest().getKeepAlive();
        }
        if (!this.j || bl3) {
            this.i.b("Connection", "close");
            bl3 = true;
        }
        if (this.p) {
            this.i.b("Transfer-Encoding", "chunked");
        }
        if ((n3 = this.q.d().d()) >= 100) {
            this.r = true;
            if (!bl3) {
                this.i.b("Connection", "close");
                bl3 = true;
            }
        }
        if (!bl3) {
            this.i.b("Keep-Alive", StringExtensions.format("timeout=15,max={0}", Operators.boxing(100 - n3)));
            if (Version.op_LessThanOrEqual(this.q.getRequest().getProtocolVersion(), HttpVersion.Version10)) {
                this.i.b("Connection", "keep-alive");
            }
        }
        if (this.m != null) {
            this.i.b("Location", this.m);
        }
        if (this.h != null) {
            for (Object object3 : this.h) {
                this.i.b("Set-Cookie", ((Cookie)object3).c());
            }
        }
        StreamWriter streamWriter = new StreamWriter(memoryStream, encoding, 256);
        streamWriter.write("HTTP/{0} {1} {2}\r\n", (Object)this.l, Operators.boxing(this.n), (Object)this.o);
        object3 = this.i.a();
        streamWriter.write((String)object3);
        streamWriter.flush();
        int n4 = n2 = encoding.getCodePage() == 65001 ? 3 : encoding.getPreamble().length;
        if (this.k == null) {
            this.k = this.q.d().j();
        }
        memoryStream.setPosition(n2);
        this.a = true;
    }

    public void setCookie(Cookie cookie) {
        if (cookie == null) {
            throw new ArgumentNullException("cookie");
        }
        if (this.h != null) {
            if (this.a(cookie)) {
                throw new ArgumentException("The cookie already exists.");
            }
        } else {
            this.h = new CookieCollection();
        }
        this.h.add(cookie);
    }
}

