/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.AsyncCallback;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.IAsyncResult;
import com.aspose.html.internal.ms.System.IO.FileAccess;
import com.aspose.html.internal.ms.System.IO.FileMode;
import com.aspose.html.internal.ms.System.IO.FileNotFoundException;
import com.aspose.html.internal.ms.System.IO.IOException;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.mscorlib.c.c;
import java.io.File;

public class FileStream
extends Stream {
    private boolean a = false;
    private boolean b;
    private boolean c;
    private boolean d;
    private c e;
    private final String f;

    public FileStream(String string, boolean bl2, boolean bl3) {
        this.f = string;
        if (bl2 && bl3) {
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
        } else if (!(bl2 || bl3 || new File(string).exists())) {
            throw new FileNotFoundException("Can't find read-only file: " + string);
        }
        this.e = new c(string, bl2 ? "rw" : "r");
        this.c = bl2;
        this.b = true;
        this.d = true;
    }

    public FileStream(String string, int n2) {
        this(string, n2, n2 == 6 ? 2 : 3);
    }

    private FileStream(int n2, String string, int n3, int n4) {
        String string2;
        if (n2 != -2 && n2 <= 0) {
            throw new ArgumentOutOfRangeException("bufferSize", "Positive number required.");
        }
        boolean bl2 = n2 > 0;
        this.f = string;
        if (string == null) {
            throw new ArgumentNullException("path", "Path cannot be null.");
        }
        if (StringExtensions.trim(string).length() == 0) {
            throw new ArgumentException("Empty path name is not legal.");
        }
        if (n3 < 1 || n3 > 6) {
            throw new ArgumentOutOfRangeException("mode", "Enum value was out of legal range.");
        }
        if (n4 < 1 || n4 > 3) {
            throw new ArgumentOutOfRangeException("access", "Enum value was out of legal range.");
        }
        if (n4 == 1) {
            this.c = false;
            this.b = true;
            string2 = "r";
        } else if (n4 == 2) {
            this.c = true;
            this.b = false;
            string2 = "rw";
        } else {
            this.c = true;
            this.b = true;
            string2 = "rw";
        }
        File file = new File(string);
        if (n3 == 6) {
            if (n4 == 3) {
                throw new ArgumentException("Append access can be requested only in write-only mode.");
            }
            if (n4 == 1) {
                throw new ArgumentException(StringExtensions.format("Combining FileMode: {0} with FileAccess: {1} is invalid.", Enum.getName(FileMode.class, n3), Enum.getName(FileAccess.class, n4)));
            }
        }
        if ((n3 == 2 || n3 == 1 || n3 == 5) && n4 == 1) {
            throw new ArgumentException(StringExtensions.format("Combining FileMode: {0} with FileAccess: {1} is invalid.", Enum.getName(FileMode.class, n3), Enum.getName(FileAccess.class, n4)));
        }
        if (file.exists()) {
            if (n3 == 1) {
                throw new IOException("Can't create new file. File '" + string + "' already exist.");
            }
            if (n3 == 2 || n3 == 5) {
                file.delete();
            }
            this.e = bl2 ? new c(file, string2, n2) : new c(file, string2);
            if (n3 == 6) {
                this.e.a(this.e.i());
            }
        } else {
            if (n3 == 3 || n3 == 5) {
                throw new FileNotFoundException("Can't find file: " + string + ".", string);
            }
            if (bl2) {
                this.e = new c(file, string2, n2);
            } else if (string2.equals("r") && n3 == 4) {
                string2 = "rw";
                this.e = new c(file, string2);
                this.e.a(true);
            } else {
                this.e = new c(file, string2);
            }
        }
        this.d = true;
    }

    public FileStream(String string, int n2, int n3) {
        this(-2, string, n2, n3);
    }

    public FileStream(String string, int n2, int n3, int n4) {
        this(string, n2, n3);
    }

    public FileStream(String string, int n2, int n3, int n4, int n5) {
        this(n5, string, n2, n3);
    }

    @Override
    public boolean canRead() {
        return this.b;
    }

    @Override
    public boolean canSeek() {
        return this.d;
    }

    @Override
    public boolean canWrite() {
        return this.c;
    }

    @Override
    public long getLength() {
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.e.i();
    }

    @Override
    public long getPosition() {
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        return this.e.g();
    }

    @Override
    public void setPosition(long l2) {
        if (l2 < 0L) {
            throw new ArgumentOutOfRangeException("value", "Non-negative number required.");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        this.e.a(l2);
    }

    @Override
    public void flush() {
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        this.e.j();
    }

    @Override
    public long seek(long l2, int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new ArgumentException("Invalid seek origin.");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        switch (n2) {
            case 0: {
                this.e.a(l2);
                break;
            }
            case 1: {
                this.e.a(this.e.g() + l2);
                break;
            }
            case 2: {
                this.e.a(this.e.i() + l2);
            }
        }
        return this.e.g();
    }

    @Override
    protected void dispose(boolean bl2) {
        try {
            if (this.e != null && !this.e.e()) {
                this.e.d();
            }
        }
        finally {
            this.b = false;
            this.c = false;
            this.d = false;
            super.dispose(bl2);
            this.a = true;
        }
    }

    @Override
    public void setLength(long l2) {
        if (l2 < 0L) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (l2 == Long.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "file length too big");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.canSeek()) {
            throw new NotSupportedException("Stream does not support seeking.");
        }
        if (!this.c) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.e.e(l2);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (byArray.length - n2 < n3) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.b) {
            int n4 = this.e.b(byArray, n2, n3);
            return n4 == -1 ? 0 : n4;
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public int readByte() {
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (this.b) {
            return this.e.l();
        }
        throw new NotSupportedException("Stream does not support reading.");
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new ArgumentNullException("array", "Buffer cannot be null.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("count", "Non-negative number required.");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (byArray.length - n2 < n3) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.c) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.e.write(byArray, n2, n3);
    }

    @Override
    public void writeByte(byte by2) {
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        if (!this.c) {
            throw new NotSupportedException("Stream does not support writing.");
        }
        this.e.write(by2);
    }

    public String getName() {
        return this.f;
    }

    @Override
    public IAsyncResult beginRead(byte[] byArray, int n2, int n3, AsyncCallback asyncCallback, Object object) {
        if (byArray == null) {
            throw new ArgumentNullException("buffer");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (byArray.length - n2 < n3) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginRead(byArray, n2, n3, asyncCallback, object);
    }

    @Override
    public int endRead(IAsyncResult iAsyncResult) {
        if (iAsyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        return super.endRead(iAsyncResult);
    }

    @Override
    public IAsyncResult beginWrite(byte[] byArray, int n2, int n3, AsyncCallback asyncCallback, Object object) {
        if (byArray == null) {
            throw new ArgumentNullException("array");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("offset", "Non-negative number required.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("numBytes", "Non-negative number required.");
        }
        if (byArray.length - n2 < n3) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (this.a) {
            throw new ObjectDisposedException("Cannot access a closed file.");
        }
        return super.beginWrite(byArray, n2, n3, asyncCallback, object);
    }

    @Override
    public void endWrite(IAsyncResult iAsyncResult) {
        if (iAsyncResult == null) {
            throw new ArgumentNullException("asyncResult");
        }
        super.endWrite(iAsyncResult);
    }
}

