/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Drawing.BasicShape;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.GraphicsPath;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.Matrix;
import com.aspose.html.internal.ms.System.Drawing.Drawing2D.RegionData;
import com.aspose.html.internal.ms.System.Drawing.Graphics;
import com.aspose.html.internal.ms.System.Drawing.Point;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.Rectangle;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.Drawing.RegionScans;
import com.aspose.html.internal.ms.System.IntPtr;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NullReferenceException;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.ExtendedGeneralPath;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;

public final class Region
extends BasicShape {
    public static Region InfiniteRegion = new Region(new Rectangle(-4194304, -4194304, 0x800000, 0x800000));
    private RegionData a = null;

    public RegionType getType() {
        if (this.c() || this.d()) {
            return RegionType.RegionTypeEmpty;
        }
        return this.b();
    }

    private RegionType b() {
        Area area = this.a();
        if (area.isEmpty()) {
            return RegionType.RegionTypeEmpty;
        }
        if (area.isRectangular()) {
            return RegionType.RegionTypeRectF;
        }
        return RegionType.RegionTypePath;
    }

    Area a() {
        return (Area)this.getShape();
    }

    public Region() {
        this((Area)InfiniteRegion.a().clone());
    }

    private Region(Area area) {
        super(area);
    }

    public Region(GraphicsPath graphicsPath) {
        this(Region.a(graphicsPath));
    }

    public Region(Rectangle rectangle) {
        this(Region.a(rectangle));
    }

    public Region(RectangleF rectangleF) {
        this(Region.a((Object)rectangleF));
    }

    private static Area a(Object object) {
        if (object == null) {
            throw new ArgumentNullException("Argument 'r' cannot be null");
        }
        if (object instanceof Rectangle) {
            return new Area(((Rectangle)object).getNativeObject());
        }
        if (object instanceof RectangleF) {
            return new Area(((RectangleF)object).a());
        }
        if (object instanceof GraphicsPath) {
            return new Area(((GraphicsPath)object).getNativeObject());
        }
        return null;
    }

    private static Area a(RegionData regionData) {
        if (regionData == null) {
            throw new ArgumentNullException("Value of 'region_data' cannot be null");
        }
        if (regionData.getData() == null) {
            throw new NullReferenceException("Value of 'region_data.data' cannot be null");
        }
        return new Area(regionData.getNativeShape());
    }

    public Region(RegionData regionData) {
        super(Region.a(regionData));
        this.a = regionData;
    }

    public void union(GraphicsPath graphicsPath) {
        if (graphicsPath == null) {
            throw new ArgumentNullException("path");
        }
        this.a().add(new Area(graphicsPath.getNativeObject()));
    }

    public void union(Rectangle rectangle) {
        this.a().add(new Area(rectangle.getNativeObject()));
    }

    public void union(RectangleF rectangleF) {
        this.a().add(new Area(rectangleF.a()));
    }

    public void union(Region region) {
        if (region == null) {
            throw new ArgumentNullException("region");
        }
        this.a().add(region.a());
    }

    public void intersect(GraphicsPath graphicsPath) {
        if (graphicsPath == null) {
            throw new ArgumentNullException("path");
        }
        this.a().intersect(new Area(graphicsPath.getNativeObject()));
    }

    private static RectangleF a(RectangleF rectangleF) {
        RectangleF rectangleF2 = rectangleF.Clone();
        if (rectangleF.getWidth() < 0.0f) {
            rectangleF2.setX(rectangleF.getX() + rectangleF.getWidth());
            rectangleF2.setWidth(Math.abs(rectangleF.getWidth()));
        } else {
            rectangleF2.setX(rectangleF.getX());
            rectangleF2.setWidth(rectangleF.getWidth());
        }
        if (rectangleF.getHeight() < 0.0f) {
            rectangleF2.setY(rectangleF.getY() + rectangleF.getHeight());
            rectangleF2.setHeight(Math.abs(rectangleF.getHeight()));
        } else {
            rectangleF2.setY(rectangleF.getY());
            rectangleF2.setHeight(rectangleF.getHeight());
        }
        return rectangleF2;
    }

    public void intersect(Rectangle rectangle) {
        this.a().intersect(new Area(Region.a(RectangleF.to_RectangleF(rectangle)).a()));
    }

    public void intersect(RectangleF rectangleF) {
        this.a().intersect(new Area(Region.a(rectangleF).a()));
    }

    public void intersect(Region region) {
        if (region == null) {
            throw new ArgumentNullException("region");
        }
        this.a().intersect(region.a());
    }

    public void complement(GraphicsPath graphicsPath) {
        if (graphicsPath == null) {
            throw new ArgumentNullException("path");
        }
        Area area = new Area(graphicsPath.getNativeObject());
        area.subtract(this.a());
        this.setShape(area);
    }

    public void complement(Rectangle rectangle) {
        Area area = new Area(rectangle.getNativeObject());
        area.subtract(this.a());
        this.setShape(area);
    }

    public void complement(RectangleF rectangleF) {
        Area area = new Area(rectangleF.a());
        area.subtract(this.a());
        this.setShape(area);
    }

    public void complement(Region region) {
        if (region == null) {
            throw new ArgumentNullException("region");
        }
        Area area = (Area)region.a().clone();
        area.subtract(this.a());
        this.setShape(area);
    }

    public void exclude(GraphicsPath graphicsPath) {
        if (graphicsPath == null) {
            throw new ArgumentNullException("path");
        }
        this.a().subtract(new Area(graphicsPath.getNativeObject()));
    }

    public void exclude(Rectangle rectangle) {
        this.a().subtract(new Area(rectangle.getNativeObject()));
    }

    public void exclude(RectangleF rectangleF) {
        this.a().subtract(new Area(rectangleF.a()));
    }

    public void exclude(Region region) {
        if (region == null) {
            throw new ArgumentNullException("region");
        }
        this.a().subtract(region.a());
    }

    public void xor(GraphicsPath graphicsPath) {
        if (graphicsPath == null) {
            throw new ArgumentNullException("path");
        }
        this.a().exclusiveOr(new Area(graphicsPath.getNativeObject()));
    }

    public void xor(Rectangle rectangle) {
        this.a().exclusiveOr(new Area(rectangle.getNativeObject()));
    }

    public void xor(RectangleF rectangleF) {
        this.a().exclusiveOr(new Area(rectangleF.a()));
    }

    public void xor(Region region) {
        if (region == null) {
            throw new ArgumentNullException("region");
        }
        this.a().exclusiveOr(region.a());
    }

    public RectangleF getBounds(Graphics graphics) {
        if (graphics == null) {
            throw new ArgumentNullException("graphics");
        }
        return new RectangleF(this.a().getBounds2D());
    }

    private static void a(RegionScans.RegionBitmap regionBitmap, RectangleF rectangleF) {
        int n2 = regionBitmap.d() + 1;
        int n3 = -1;
        int n4 = regionBitmap.c() + 1;
        int n5 = -1;
        int n6 = 0;
        int n7 = regionBitmap.c() * regionBitmap.d() >> 3;
        int n8 = regionBitmap.c() >> 3;
        int n9 = 0;
        int n10 = 0;
        while (n6 < n7) {
            if (regionBitmap.e()[n6++] != 0) {
                if (n9 < n4) {
                    n4 = n9;
                }
                if (n9 > n5) {
                    n5 = n9;
                }
                if (n10 < n2) {
                    n2 = n10;
                }
                if (n10 > n3) {
                    n3 = n10;
                }
            }
            if (++n9 != n8) continue;
            n9 = 0;
            ++n10;
        }
        if (n5 == -1 && n3 == -1 && n4 == regionBitmap.c() + 1 && n2 == regionBitmap.d() + 1) {
            rectangleF.setHeight(0.0f);
            rectangleF.setWidth(0.0f);
            rectangleF.setY(0.0f);
            rectangleF.setX(0.0f);
        } else {
            rectangleF.setX(regionBitmap.a() + (n4 << 3));
            rectangleF.setY(regionBitmap.b() + n2);
            rectangleF.setWidth(Math.abs((n5 + 1 << 3) - n4));
            rectangleF.setHeight(n3 - n2 + 1);
        }
    }

    private static void a(RectangleF[] rectangleFArray, RectangleF rectangleF) {
        if (rectangleFArray == null || rectangleFArray.length == 0) {
            rectangleF.setX(0.0f);
            rectangleF.setY(0.0f);
            rectangleF.setWidth(0.0f);
            rectangleF.setHeight(0.0f);
            return;
        }
        float f2 = rectangleFArray[0].getX();
        float f3 = rectangleFArray[0].getY();
        float f4 = rectangleFArray[0].getX() + rectangleFArray[0].getWidth();
        float f5 = rectangleFArray[0].getY() + rectangleFArray[0].getHeight();
        for (RectangleF rectangleF2 : rectangleFArray) {
            if (rectangleF2.getX() < f2) {
                f2 = rectangleF2.getX();
            }
            if (rectangleF2.getY() < f3) {
                f3 = rectangleF2.getY();
            }
            if (rectangleF2.getX() + rectangleF2.getWidth() > f4) {
                f4 = rectangleF2.getX() + rectangleF2.getWidth();
            }
            if (!(rectangleF2.getY() + rectangleF2.getHeight() > f5)) continue;
            f5 = rectangleF2.getY() + rectangleF2.getHeight();
        }
        rectangleF.setX(f2);
        rectangleF.setY(f3);
        rectangleF.setWidth(f4 - f2);
        rectangleF.setHeight(f5 - f3);
    }

    static RectangleF a(Region region) {
        RectangleF rectangleF = new RectangleF();
        if (region.getType() == RegionType.RegionTypePath) {
            RectangleF rectangleF2 = new RectangleF();
            RegionScans.RegionBitmap regionBitmap = RegionScans.RegionBitmap.a(new ExtendedGeneralPath(region.getShape()));
            Region.a(regionBitmap, rectangleF2);
            rectangleF = new RectangleF(rectangleF2.getX(), rectangleF2.getY(), rectangleF2.getWidth(), rectangleF2.getHeight());
        } else {
            Matrix matrix = new Matrix();
            Region.a(region.getRegionScans(matrix), rectangleF);
        }
        return rectangleF;
    }

    public void translate(int n2, int n3) {
        this.translate((float)n2, (float)n3);
    }

    public void translate(float f2, float f3) {
        if (this.d()) {
            return;
        }
        this.a().transform(AffineTransform.getTranslateInstance(f2, f3));
    }

    public boolean isVisible(int n2, int n3, Graphics graphics) {
        return this.isVisible((float)n2, (float)n3, graphics);
    }

    public boolean isVisible(int n2, int n3, int n4, int n5) {
        return this.isVisible((float)n2, (float)n3, (float)n4, (float)n5);
    }

    public boolean isVisible(int n2, int n3, int n4, int n5, Graphics graphics) {
        return this.isVisible((float)n2, (float)n3, (float)n4, (float)n5, graphics);
    }

    public boolean isVisible(Point point) {
        return this.isVisible(point.getX(), point.getY());
    }

    public boolean isVisible(PointF pointF) {
        return this.isVisible(pointF.getX(), pointF.getY());
    }

    public boolean isVisible(Point point, Graphics graphics) {
        return this.isVisible(point.getX(), point.getY(), graphics);
    }

    public boolean isVisible(PointF pointF, Graphics graphics) {
        return this.isVisible(pointF.getX(), pointF.getY(), graphics);
    }

    public boolean isVisible(Rectangle rectangle) {
        return this.isVisible(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public boolean isVisible(RectangleF rectangleF) {
        return this.isVisible(rectangleF.getX(), rectangleF.getY(), rectangleF.getWidth(), rectangleF.getHeight());
    }

    public boolean isVisible(Rectangle rectangle, Graphics graphics) {
        return this.isVisible(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), graphics);
    }

    public boolean isVisible(RectangleF rectangleF, Graphics graphics) {
        return this.isVisible(rectangleF.getX(), rectangleF.getY(), rectangleF.getWidth(), rectangleF.getHeight(), graphics);
    }

    public boolean isVisible(float f2, float f3) {
        return this.a().contains(f2, f3);
    }

    public boolean isVisible(float f2, float f3, Graphics graphics) {
        return this.a().contains(f2, f3);
    }

    public boolean isVisible(float f2, float f3, float f4, float f5) {
        return this.a().intersects(f2, f3, f4, f5);
    }

    public boolean isVisible(float f2, float f3, float f4, float f5, Graphics graphics) {
        if (f4 == 0.0f || f5 == 0.0f) {
            return false;
        }
        return this.a().intersects(f2, f3, f4, f5);
    }

    public int getPathCount() {
        int n2 = 0;
        PathIterator pathIterator = this.getPathIterator(null);
        if (pathIterator != null) {
            while (!pathIterator.isDone()) {
                pathIterator.next();
                ++n2;
            }
        }
        return n2;
    }

    private boolean c() {
        return this.a().isEmpty();
    }

    public boolean isEmpty(Graphics graphics) {
        if (graphics == null) {
            throw new ArgumentNullException("graphics");
        }
        return this.c();
    }

    private static boolean b(RectangleF rectangleF) {
        java.awt.Rectangle rectangle = InfiniteRegion.a().getBounds();
        return rectangleF.getWidth() >= (float)rectangle.width || rectangleF.getHeight() >= (float)rectangle.height;
    }

    private static boolean c(RectangleF rectangleF) {
        return Region.b(rectangleF);
    }

    private boolean d() {
        RegionType regionType = this.b();
        switch (regionType) {
            case RegionTypeRectF: {
                if (this.getPathCount() != 5) {
                    return false;
                }
                return Region.c(new RectangleF(this.getBounds2D()));
            }
            case RegionTypePath: {
                if (this.getPathCount() != 5) break;
                return Region.c(new RectangleF(this.getBounds2D()));
            }
            case RegionTypeEmpty: {
                return Region.c(new RectangleF(this.getBounds2D()));
            }
        }
        return false;
    }

    public boolean isInfinite(Graphics graphics) {
        if (graphics == null) {
            throw new ArgumentNullException("Value of 'g' cannot be null");
        }
        return this.d();
    }

    public void makeEmpty() {
        this.a().reset();
    }

    public void makeInfinite() {
        this.setShape((Area)InfiniteRegion.a().clone());
    }

    public boolean equals(Region region, Graphics graphics) {
        if (graphics == null) {
            throw new ArgumentNullException("g");
        }
        if (region == null) {
            throw new ArgumentNullException("region");
        }
        return this.a().equals(region.a());
    }

    public RegionData getRegionData() {
        Region region = this.deepClone();
        this.a = new RegionData(region, region.getShape());
        return this.a;
    }

    public IntPtr getHrgn(Graphics graphics) {
        if (graphics == null) {
            throw new ArgumentNullException("g");
        }
        throw new NotImplementedException();
    }

    private static List<PointF> a(PointF pointF, PointF pointF2) {
        ArrayList<PointF> arrayList = new ArrayList<PointF>();
        int n2 = pointF.getX() <= pointF2.getX() ? 1 : -1;
        int n3 = pointF.getY() <= pointF2.getY() ? 1 : -1;
        float f2 = Math.abs((pointF2.getY() - pointF.getY()) / (pointF2.getX() - pointF.getX()));
        int n4 = 0;
        while ((float)n4 < Math.abs(pointF2.getX() - pointF.getX())) {
            arrayList.add(new PointF(Math.round(pointF.getX() + (float)(n4 * n2)), Math.round(pointF.getY() + (float)(n4 * n3) * f2)));
            ++n4;
        }
        return arrayList;
    }

    public RectangleF[] getRegionScans(Matrix matrix) {
        if (matrix == null) {
            throw new ArgumentNullException("matrix");
        }
        if (this.d()) {
            return new RectangleF[]{new RectangleF(this.getBounds())};
        }
        if (this.c()) {
            return new RectangleF[0];
        }
        Region region = this.deepClone();
        region.transform(matrix);
        return RegionScans.a(region);
    }

    public boolean regionScansIsEmptyOrOne(Matrix matrix) {
        if (matrix == null) {
            throw new ArgumentNullException("matrix");
        }
        if (this.d()) {
            return true;
        }
        if (this.c()) {
            return true;
        }
        Region region = this.deepClone();
        region.transform(matrix);
        RectangleF[] rectangleFArray = RegionScans.a(region, 1);
        return rectangleFArray.length == 0 || rectangleFArray.length == 1;
    }

    public void transform(Matrix matrix) {
        if (matrix == null) {
            throw new ArgumentNullException("Value of 'matrix' cannot be null");
        }
        if (matrix.isIdentity()) {
            return;
        }
        if (this.a().equals(InfiniteRegion.a())) {
            return;
        }
        this.a().transform(matrix.getNativeObject());
    }

    public Region deepClone() {
        return new Region((Area)this.a().clone());
    }

    public static enum RegionType {
        RegionTypeEmpty,
        RegionTypeRect,
        RegionTypeRectF,
        RegionTypePath;

    }
}

