/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Drawing2D;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Drawing.Point;
import com.aspose.html.internal.ms.System.Drawing.PointF;
import com.aspose.html.internal.ms.System.Drawing.Rectangle;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.core.System.Drawing.Drawing2D.MatrixUtil;
import com.aspose.html.internal.ms.lang.Operators;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public final class Matrix
implements IDisposable {
    public static final Matrix IdentityTransform = new Matrix();
    final AffineTransform a;

    Matrix(AffineTransform affineTransform) {
        this.a = affineTransform;
    }

    public Matrix() {
        this(new AffineTransform());
    }

    public Matrix(Rectangle rectangle, Point[] pointArray) {
        if (pointArray == null) {
            throw new ArgumentNullException("Value of 'plgpts' cannot be null");
        }
        if (pointArray.length != 3) {
            throw new ArgumentException("Value of 'plgpts' is invalid");
        }
        double d2 = pointArray[1].getX() - pointArray[0].getX();
        double d3 = pointArray[1].getY() - pointArray[0].getY();
        double d4 = pointArray[2].getX() - pointArray[0].getX();
        double d5 = pointArray[2].getY() - pointArray[0].getY();
        this.a = new AffineTransform(d2 / (double)rectangle.getWidth(), d3 / (double)rectangle.getWidth(), d4 / (double)rectangle.getHeight(), d5 / (double)rectangle.getHeight(), (double)pointArray[0].getX(), (double)pointArray[0].getY());
        this.a.translate(-rectangle.getX(), -rectangle.getY());
    }

    public Matrix(RectangleF rectangleF, PointF[] pointFArray) {
        if (pointFArray == null) {
            throw new ArgumentNullException("Value of 'plgpts' cannot be null");
        }
        if (pointFArray.length != 3) {
            throw new ArgumentException("Value of 'plgpts' is invalid");
        }
        double d2 = pointFArray[1].getX() - pointFArray[0].getX();
        double d3 = pointFArray[1].getY() - pointFArray[0].getY();
        double d4 = pointFArray[2].getX() - pointFArray[0].getX();
        double d5 = pointFArray[2].getY() - pointFArray[0].getY();
        this.a = new AffineTransform(d2 / (double)rectangleF.getWidth(), d3 / (double)rectangleF.getWidth(), d4 / (double)rectangleF.getHeight(), d5 / (double)rectangleF.getHeight(), (double)pointFArray[0].getX(), (double)pointFArray[0].getY());
        this.a.translate(-rectangleF.getX(), -rectangleF.getY());
    }

    public Matrix(float f2, float f3, float f4, float f5, float f6, float f7) {
        this(new AffineTransform(f2, f3, f4, f5, f6, f7));
    }

    public float[] getElements() {
        float[] fArray = new float[]{(float)this.getNativeObject().getScaleX(), (float)this.getNativeObject().getShearY(), (float)this.getNativeObject().getShearX(), (float)this.getNativeObject().getScaleY(), (float)this.getNativeObject().getTranslateX(), (float)this.getNativeObject().getTranslateY()};
        return fArray;
    }

    public boolean isIdentity() {
        return MatrixUtil.isMatrixEmpty(this);
    }

    public boolean isInvertible() {
        return this.getNativeObject().getDeterminant() != 0.0;
    }

    public float getOffsetX() {
        return (float)this.getNativeObject().getTranslateX();
    }

    public float getOffsetY() {
        return (float)this.getNativeObject().getTranslateY();
    }

    public Matrix deepClone() {
        return new Matrix((AffineTransform)this.getNativeObject().clone());
    }

    @Override
    public void dispose() {
    }

    public void copyTo(Matrix matrix) {
        matrix.getNativeObject().setTransform(this.getNativeObject());
    }

    public boolean equals(Object object) {
        Matrix matrix = Operators.as(object, Matrix.class);
        if (matrix == null) {
            return false;
        }
        float[] fArray = matrix.getElements();
        float[] fArray2 = this.getElements();
        boolean bl2 = true;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            bl2 &= fArray[i2] == fArray2[i2];
        }
        return bl2;
    }

    public int hashCode() {
        return this.getNativeObject().hashCode();
    }

    public void invert() {
        try {
            this.a.setTransform(this.a.createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new ArgumentException(noninvertibleTransformException.getMessage(), noninvertibleTransformException);
        }
    }

    public void multiply(Matrix matrix) {
        this.multiply(matrix, 0);
    }

    public void multiply(Matrix matrix, int n2) {
        if (matrix == null) {
            throw new ArgumentNullException("Value of 'matrix' cannot be null");
        }
        this.a(matrix.getNativeObject(), n2);
    }

    public void reset() {
        this.getNativeObject().setToIdentity();
    }

    public void rotate(float f2) {
        this.getNativeObject().rotate(Math.toRadians(f2));
    }

    public void rotate(float f2, int n2) {
        this.a(AffineTransform.getRotateInstance(Math.toRadians(f2)), n2);
    }

    public void rotateAt(float f2, PointF pointF) {
        this.getNativeObject().rotate(Math.toRadians(f2), pointF.getX(), pointF.getY());
    }

    public void rotateAt(float f2, PointF pointF, int n2) {
        this.a(AffineTransform.getRotateInstance(Math.toRadians(f2), pointF.getX(), pointF.getY()), n2);
    }

    public void scale(float f2, float f3) {
        this.scale(f2, f3, 0);
    }

    public void scale(float f2, float f3, int n2) {
        this.a(AffineTransform.getScaleInstance(f2, f3), n2);
    }

    public void shear(float f2, float f3) {
        this.getNativeObject().shear(f2, f3);
    }

    public void shear(float f2, float f3, int n2) {
        this.a(AffineTransform.getShearInstance(f2, f3), n2);
    }

    public void transformPoints(Point[] pointArray) {
        if (pointArray == null) {
            throw new ArgumentNullException("Value of 'pts' cannot be null");
        }
        if (pointArray.length < 1) {
            throw new ArgumentException("Argument 'pts' is invalid");
        }
        Point2D.Float float_ = new Point2D.Float();
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            float_.setLocation(pointArray[i2].getX(), pointArray[i2].getY());
            this.getNativeObject().transform(float_, float_);
            pointArray[i2].setX((int)Math.round(float_.getX()));
            pointArray[i2].setY((int)Math.round(float_.getY()));
        }
    }

    public void transformPoints(PointF[] pointFArray) {
        if (pointFArray == null) {
            throw new ArgumentNullException("Value of 'pts' cannot be null");
        }
        if (pointFArray.length < 1) {
            throw new ArgumentException("Argument 'pts' is invalid");
        }
        Point2D.Float float_ = new Point2D.Float();
        for (int i2 = 0; i2 < pointFArray.length; ++i2) {
            float_.setLocation(pointFArray[i2].getX(), pointFArray[i2].getY());
            this.getNativeObject().transform(float_, float_);
            pointFArray[i2].setX((float)float_.getX());
            pointFArray[i2].setY((float)float_.getY());
        }
    }

    public void transformVectors(Point[] pointArray) {
        if (pointArray == null) {
            throw new ArgumentNullException("Value of 'pts' cannot be null");
        }
        if (pointArray.length < 1) {
            throw new ArgumentException("Argument 'pts' is invalid");
        }
        Point2D.Float float_ = new Point2D.Float();
        for (int i2 = 0; i2 < pointArray.length; ++i2) {
            float_.setLocation(pointArray[i2].getX(), pointArray[i2].getY());
            this.getNativeObject().deltaTransform(float_, float_);
            pointArray[i2].setX((int)float_.getX());
            pointArray[i2].setY((int)float_.getY());
        }
    }

    public void transformVectors(PointF[] pointFArray) {
        if (pointFArray == null) {
            throw new ArgumentNullException("Value of 'pts' cannot be null");
        }
        if (pointFArray.length < 1) {
            throw new ArgumentException("Argument 'pts' is invalid");
        }
        Point2D.Float float_ = new Point2D.Float();
        for (int i2 = 0; i2 < pointFArray.length; ++i2) {
            float_.setLocation(pointFArray[i2].getX(), pointFArray[i2].getY());
            this.getNativeObject().deltaTransform(float_, float_);
            pointFArray[i2].setX((float)float_.getX());
            pointFArray[i2].setY((float)float_.getY());
        }
    }

    public void translate(float f2, float f3) {
        this.getNativeObject().translate(f2, f3);
    }

    public void translate(float f2, float f3, int n2) {
        this.a(AffineTransform.getTranslateInstance(f2, f3), n2);
    }

    public void vectorTransformPoints(Point[] pointArray) {
        this.transformVectors(pointArray);
    }

    public AffineTransform getNativeObject() {
        return this.a;
    }

    private void a(AffineTransform affineTransform, int n2) {
        Matrix.multiply(this.getNativeObject(), affineTransform, n2);
    }

    public static void multiply(AffineTransform affineTransform, AffineTransform affineTransform2, int n2) {
        switch (n2) {
            case 0: {
                affineTransform.concatenate(affineTransform2);
                break;
            }
            case 1: {
                affineTransform.preConcatenate(affineTransform2);
                break;
            }
            default: {
                throw new ArgumentException("Value of 'order' is invalid");
            }
        }
    }

    public static AffineTransform toJava(Matrix matrix) {
        if (matrix == null) {
            return null;
        }
        return matrix.getNativeObject();
    }

    public static Matrix fromJava(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return null;
        }
        return new Matrix(affineTransform);
    }
}

