/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.core.System.g;
import com.aspose.html.internal.ms.core.System.k;

public final class DoubleExtensions {
    public static final double Epsilon = Double.MIN_VALUE;
    public static final double MaxValue = Double.MAX_VALUE;
    public static final double MinValue = -1.7976931348623157E308;
    public static final double NaN = Double.NaN;
    public static final double NegativeInfinity = Double.NEGATIVE_INFINITY;
    public static final double PositiveInfinity = Double.POSITIVE_INFINITY;

    public static int compareTo(double d2, double d3) {
        if (DoubleExtensions.isPositiveInfinity(d2) && DoubleExtensions.isPositiveInfinity(d3)) {
            return 0;
        }
        if (DoubleExtensions.isNegativeInfinity(d2) && DoubleExtensions.isNegativeInfinity(d3)) {
            return 0;
        }
        if (DoubleExtensions.isNaN(d3)) {
            if (DoubleExtensions.isNaN(d2)) {
                return 0;
            }
            return 1;
        }
        if (DoubleExtensions.isNaN(d2) && !DoubleExtensions.isNaN(d3)) {
            return -1;
        }
        if (d2 > d3) {
            return 1;
        }
        if (d2 < d3) {
            return -1;
        }
        return 0;
    }

    public static int compareTo(double d2, Object object) {
        if (object == null) {
            return 1;
        }
        if (object.getClass() != Double.class) {
            throw new ArgumentException("Value is not a System.Double");
        }
        double d3 = Convert.toDouble(object);
        if (DoubleExtensions.isPositiveInfinity(d2) && DoubleExtensions.isPositiveInfinity(d3)) {
            return 0;
        }
        if (DoubleExtensions.isNegativeInfinity(d2) && DoubleExtensions.isNegativeInfinity(d3)) {
            return 0;
        }
        if (DoubleExtensions.isNaN(d3)) {
            return DoubleExtensions.isNaN(d2) ? 0 : 1;
        }
        if (DoubleExtensions.isNaN(d2) && !DoubleExtensions.isNaN(d3)) {
            return -1;
        }
        if (d2 > d3) {
            return 1;
        }
        if (d2 < d3) {
            return -1;
        }
        return 0;
    }

    public static boolean equals(double d2, double d3) {
        return d3 == d2 || DoubleExtensions.isNaN(d3) && DoubleExtensions.isNaN(d2);
    }

    public static boolean equals(double d2, Object object) {
        if (object.getClass() != Double.class) {
            return false;
        }
        double d3 = Convert.toDouble(object);
        return DoubleExtensions.equals(d2, d3);
    }

    public static int getHashCode(double d2) {
        return new Double(d2).hashCode();
    }

    public static int getTypeCode() {
        return 14;
    }

    public static boolean isInfinity(double d2) {
        return d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY;
    }

    public static boolean isNaN(double d2) {
        return Double.isNaN(d2);
    }

    public static boolean isNegativeInfinity(double d2) {
        return d2 == Double.NEGATIVE_INFINITY;
    }

    public static boolean isPositiveInfinity(double d2) {
        return d2 == Double.POSITIVE_INFINITY;
    }

    public static double parse(String string) {
        return g.a(string);
    }

    public static double parse(String string, int n2) {
        return g.a(string, n2);
    }

    public static double parse(String string, IFormatProvider iFormatProvider) {
        return g.a(string, iFormatProvider);
    }

    public static double parse(String string, int n2, IFormatProvider iFormatProvider) {
        return g.a(string, n2, iFormatProvider);
    }

    public static String toString(double d2) {
        return k.a("G", d2, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(double d2, IFormatProvider iFormatProvider) {
        return k.a(null, d2, (IFormatProvider)NumberFormatInfo.getInstance(iFormatProvider));
    }

    public static String toString(double d2, String string) {
        return k.a(string, d2, (IFormatProvider)NumberFormatInfo.getCurrentInfo());
    }

    public static String toString(double d2, String string, IFormatProvider iFormatProvider) {
        return k.a(string, d2, (IFormatProvider)NumberFormatInfo.getInstance(iFormatProvider));
    }

    public static boolean tryParse(String string, int n2, IFormatProvider iFormatProvider, double[] dArray) {
        try {
            dArray[0] = DoubleExtensions.parse(string, n2, iFormatProvider);
            return true;
        }
        catch (Exception exception) {
            dArray[0] = 0.0;
            return false;
        }
    }

    public static boolean tryParse(String string, double[] dArray) {
        return DoubleExtensions.tryParse(string, 231, NumberFormatInfo.getCurrentInfo(), dArray);
    }
}

