/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.DateTimeUtils;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Globalization.DateTimeFormatInfo;
import com.aspose.html.internal.ms.System.Globalization.msCalendar;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.TimeZoneExtensions;
import com.aspose.html.internal.ms.lang.Struct;
import com.aspose.time.TimeSpan;
import java.util.TimeZone;

public class DateTimeOffset
extends Struct<DateTimeOffset>
implements Comparable<DateTimeOffset> {
    public static DateTimeOffset MaxValue = new DateTimeOffset(DateTime.MaxValue.Clone(), TimeSpan.Zero.Clone());
    public static DateTimeOffset MinValue = new DateTimeOffset(DateTime.MinValue.Clone(), TimeSpan.Zero.Clone());
    private DateTime b = new DateTime();
    private TimeSpan c = new TimeSpan();

    public DateTimeOffset() {
    }

    public DateTimeOffset(DateTime dateTime) {
        dateTime.CloneTo(this.b);
        if (dateTime.getKind() == 1L) {
            TimeSpan.Zero.CloneTo(this.c);
        } else {
            TimeZoneExtensions.getUtcOffset(TimeZone.getDefault(), dateTime.Clone()).CloneTo(this.c);
        }
        if (DateTime.op_LessThan(this.getUtcDateTime(), DateTime.MinValue) || DateTime.op_GreaterThan(this.getUtcDateTime(), DateTime.MaxValue)) {
            throw new ArgumentOutOfRangeException("The UTC date and time that results from applying the offset is earlier than MinValue or later than MaxValue.");
        }
    }

    public DateTimeOffset(DateTime dateTime, TimeSpan timeSpan) {
        if (dateTime.getKind() == 1L && !TimeSpan.equals(timeSpan, TimeSpan.Zero)) {
            throw new ArgumentException("dateTime.Kind equals Utc and offset does not equal zero.");
        }
        if (dateTime.getKind() == 2L && !TimeSpan.equals(timeSpan, TimeZoneExtensions.getUtcOffset(TimeZone.getDefault(), dateTime.Clone()))) {
            throw new ArgumentException("dateTime.Kind equals Local and offset does not equal the offset of the system's local time zone.");
        }
        if (timeSpan.getTicks() % 600000000L != 0L) {
            throw new ArgumentException("offset is not specified in whole minutes.");
        }
        if (TimeSpan.op_LessThan(timeSpan, new TimeSpan(-14, 0, 0)) || TimeSpan.op_GreaterThan(timeSpan, new TimeSpan(14, 0, 0))) {
            throw new ArgumentOutOfRangeException("offset is less than -14 hours or greater than 14 hours.");
        }
        dateTime.CloneTo(this.b);
        timeSpan.CloneTo(this.c);
        if (DateTime.op_LessThan(this.getUtcDateTime(), DateTime.MinValue) || DateTime.op_GreaterThan(this.getUtcDateTime(), DateTime.MaxValue)) {
            throw new ArgumentOutOfRangeException("The UtcDateTime property is earlier than MinValue or later than MaxValue.");
        }
    }

    public DateTimeOffset(long l2, TimeSpan timeSpan) {
        this(new DateTime(l2), timeSpan.Clone());
    }

    public DateTimeOffset(int n2, int n3, int n4, int n5, int n6, int n7, TimeSpan timeSpan) {
        this(new DateTime(n2, n3, n4, n5, n6, n7), timeSpan.Clone());
    }

    public DateTimeOffset(int n2, int n3, int n4, int n5, int n6, int n7, int n8, TimeSpan timeSpan) {
        this(new DateTime(n2, n3, n4, n5, n6, n7, n8), timeSpan.Clone());
    }

    public DateTimeOffset(int n2, int n3, int n4, int n5, int n6, int n7, int n8, msCalendar msCalendar2, TimeSpan timeSpan) {
        this(new DateTime(n2, n3, n4, n5, n6, n7, n8, msCalendar2), timeSpan.Clone());
    }

    public DateTimeOffset add(TimeSpan timeSpan) {
        return new DateTimeOffset(this.b.add(timeSpan.Clone()).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addDays(double d2) {
        return new DateTimeOffset(this.b.addDays(d2).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addHours(double d2) {
        return new DateTimeOffset(this.b.addHours(d2).getTicks(), this.c.Clone());
    }

    public static DateTimeOffset op_Addition(DateTimeOffset dateTimeOffset, TimeSpan timeSpan) {
        return dateTimeOffset.add(timeSpan.Clone());
    }

    public DateTimeOffset addMilliseconds(double d2) {
        return new DateTimeOffset(this.b.addMilliseconds(d2).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addMinutes(double d2) {
        return new DateTimeOffset(this.b.addMinutes(d2).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addMonths(int n2) {
        return new DateTimeOffset(this.b.addMonths(n2).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addSeconds(double d2) {
        return new DateTimeOffset(this.b.addSeconds(d2).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addTicks(long l2) {
        return new DateTimeOffset(this.b.addTicks(l2).getTicks(), this.c.Clone());
    }

    public DateTimeOffset addYears(int n2) {
        return new DateTimeOffset(this.b.addYears(n2).getTicks(), this.c.Clone());
    }

    public static int compare(DateTimeOffset dateTimeOffset, DateTimeOffset dateTimeOffset2) {
        return dateTimeOffset.compareTo(dateTimeOffset2.Clone());
    }

    @Override
    public int compareTo(DateTimeOffset dateTimeOffset) {
        return this.getUtcDateTime().compareTo(dateTimeOffset.getUtcDateTime().Clone());
    }

    public static boolean op_Equality(DateTimeOffset dateTimeOffset, DateTimeOffset dateTimeOffset2) {
        return dateTimeOffset.equals(dateTimeOffset2.Clone());
    }

    public boolean equals(DateTimeOffset dateTimeOffset) {
        if (ObjectExtensions.referenceEquals(null, dateTimeOffset)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, dateTimeOffset)) {
            return true;
        }
        return DateTime.equals(this.getUtcDateTime(), dateTimeOffset.getUtcDateTime());
    }

    public boolean equalsExact(DateTimeOffset dateTimeOffset) {
        return DateTime.equals(this.b, dateTimeOffset.b) && TimeSpan.equals(this.c, dateTimeOffset.c);
    }

    public static DateTimeOffset fromFileTime(long l2) {
        if (l2 < 0L || l2 > MaxValue.getTicks()) {
            throw new ArgumentOutOfRangeException("fileTime is less than zero or greater than DateTimeOffset.MaxValue.Ticks.");
        }
        return new DateTimeOffset(DateTime.fromFileTime(l2).Clone(), TimeZoneExtensions.getUtcOffset(TimeZone.getDefault(), DateTime.fromFileTime(l2).Clone()).Clone());
    }

    public int hashCode() {
        return this.b.hashCode() ^ this.c.hashCode();
    }

    public static boolean op_GreaterThan(DateTimeOffset dateTimeOffset, DateTimeOffset dateTimeOffset2) {
        return DateTime.op_GreaterThan(dateTimeOffset.getUtcDateTime(), dateTimeOffset2.getUtcDateTime());
    }

    public static boolean op_GreaterThanOrEqual(DateTimeOffset dateTimeOffset, DateTimeOffset dateTimeOffset2) {
        return DateTime.op_GreaterThanOrEqual(dateTimeOffset.getUtcDateTime(), dateTimeOffset2.getUtcDateTime());
    }

    public static DateTimeOffset to_DateTimeOffset(DateTime dateTime) {
        return new DateTimeOffset(dateTime.Clone());
    }

    public static boolean op_Inequality(DateTimeOffset dateTimeOffset, DateTimeOffset dateTimeOffset2) {
        return !DateTime.equals(dateTimeOffset.getUtcDateTime(), dateTimeOffset2.getUtcDateTime());
    }

    public static boolean op_LessThan(DateTimeOffset dateTimeOffset, DateTimeOffset dateTimeOffset2) {
        return DateTime.op_LessThan(dateTimeOffset.getUtcDateTime(), dateTimeOffset2.getUtcDateTime());
    }

    public static boolean op_LessThanOrEqual(DateTimeOffset dateTimeOffset, DateTimeOffset dateTimeOffset2) {
        return DateTime.op_LessThanOrEqual(dateTimeOffset.getUtcDateTime(), dateTimeOffset2.getUtcDateTime());
    }

    public static DateTimeOffset parse(String string) {
        return DateTimeOffset.parse(string, null);
    }

    public static DateTimeOffset parse(String string, IFormatProvider iFormatProvider) {
        return DateTimeOffset.parse(string, iFormatProvider, 7);
    }

    public static DateTimeOffset parse(String string, IFormatProvider iFormatProvider, int n2) {
        if (string == null) {
            throw new ArgumentNullException("input");
        }
        DateTime dateTime = new DateTime();
        DateTimeOffset dateTimeOffset = new DateTimeOffset();
        RuntimeException runtimeException = null;
        try {
            DateTime[] dateTimeArray = new DateTime[]{dateTime};
            DateTimeOffset[] dateTimeOffsetArray = new DateTimeOffset[]{dateTimeOffset};
            RuntimeException[] runtimeExceptionArray = new RuntimeException[]{runtimeException};
            boolean bl2 = !DateTime.a(string, iFormatProvider, n2, dateTimeArray, dateTimeOffsetArray, true, runtimeExceptionArray);
            dateTimeArray[0].CloneTo(dateTime);
            dateTimeOffsetArray[0].CloneTo(dateTimeOffset);
            runtimeException = runtimeExceptionArray[0];
            if (bl2) {
                throw runtimeException;
            }
        }
        catch (ArgumentOutOfRangeException argumentOutOfRangeException) {
            throw new FormatException("The UTC representation falls outside the 1-9999 year range", argumentOutOfRangeException);
        }
        if (dateTime.getTicks() != 0L && dateTimeOffset.getTicks() == 0L) {
            throw new FormatException("The UTC representation falls outside the 1-9999 year range");
        }
        return dateTimeOffset;
    }

    public static DateTimeOffset parseExact(String string, String string2, IFormatProvider iFormatProvider) {
        return DateTimeOffset.parseExact(string, string2, iFormatProvider, 32);
    }

    public static DateTimeOffset parseExact(String string, String string2, IFormatProvider iFormatProvider, int n2) {
        if (string2 == null) {
            throw new ArgumentNullException("format");
        }
        if (StringExtensions.equals(string2, "")) {
            throw new FormatException("format is an empty string");
        }
        return DateTimeOffset.parseExact(string, new String[]{string2}, iFormatProvider, n2);
    }

    public static DateTimeOffset parseExact(String string, String[] stringArray, IFormatProvider iFormatProvider, int n2) {
        if (string == null) {
            throw new ArgumentNullException("input");
        }
        if (StringExtensions.equals(string, "")) {
            throw new FormatException("input is an empty string");
        }
        if (stringArray == null) {
            throw new ArgumentNullException("formats");
        }
        if (stringArray.length == 0) {
            throw new FormatException("Invalid format specifier");
        }
        if ((n2 & 0x20) != 0 && (n2 & 0x40) != 0) {
            throw new ArgumentException("styles parameter contains incompatible flags");
        }
        DateTimeOffset dateTimeOffset = new DateTimeOffset();
        DateTimeOffset[] dateTimeOffsetArray = new DateTimeOffset[]{dateTimeOffset};
        boolean bl2 = !DateTimeOffset.a(string, stringArray, iFormatProvider, n2, dateTimeOffsetArray);
        dateTimeOffsetArray[0].CloneTo(dateTimeOffset);
        if (bl2) {
            throw new FormatException("Invalid format string");
        }
        return dateTimeOffset;
    }

    private static boolean a(String string, String[] stringArray, IFormatProvider iFormatProvider, int n2, DateTimeOffset[] dateTimeOffsetArray) {
        for (String string2 : stringArray) {
            if (string2 == null || StringExtensions.equals(string2, "")) {
                throw new FormatException("Invalid format string");
            }
            DateTimeOffset dateTimeOffset = new DateTimeOffset();
            DateTimeOffset[] dateTimeOffsetArray2 = new DateTimeOffset[]{dateTimeOffset};
            boolean bl2 = DateTimeOffset.a(string, string2, false, dateTimeOffsetArray2, iFormatProvider, n2);
            dateTimeOffsetArray2[0].CloneTo(dateTimeOffset);
            if (!bl2) continue;
            dateTimeOffset.CloneTo(dateTimeOffsetArray[0]);
            return true;
        }
        MinValue.CloneTo(dateTimeOffsetArray[0]);
        return false;
    }

    private static boolean a(String string, String string2, boolean bl2, DateTimeOffset[] dateTimeOffsetArray, IFormatProvider iFormatProvider, int n2) {
        int n3;
        DateTimeFormatInfo dateTimeFormatInfo = DateTimeFormatInfo.getInstance(iFormatProvider);
        if ((n2 & 1) != 0) {
            string2 = StringExtensions.trimStart(string2, null);
            string = StringExtensions.trimStart(string, null);
        }
        if ((n2 & 2) != 0) {
            string2 = StringExtensions.trimEnd(string2, null);
            string = StringExtensions.trimEnd(string, null);
        }
        boolean bl3 = false;
        if ((n2 & 4) != 0) {
            bl3 = true;
        }
        MinValue.CloneTo(dateTimeOffsetArray[0]);
        boolean bl4 = false;
        boolean bl5 = false;
        if (string2.length() == 1) {
            boolean[] blArray = new boolean[]{false};
            boolean[] blArray2 = new boolean[]{false};
            string2 = DateTimeUtils.getStandardPattern(string2.charAt(0), dateTimeFormatInfo, blArray, blArray2, true);
            bl4 = blArray[0];
            bl5 = blArray2[0];
            if (string2 == null) {
                return false;
            }
        }
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        double d2 = -1.0;
        int n11 = -1;
        TimeSpan timeSpan = TimeSpan.MinValue.Clone();
        int n12 = 0;
        block20: for (int i2 = 0; i2 < string2.length(); i2 += n3) {
            char c2 = string2.charAt(i2);
            switch (c2) {
                case 'd': {
                    n3 = DateTimeUtils.countRepeat(string2, i2, c2);
                    if (n6 != -1 || n3 > 4) {
                        return false;
                    }
                    if (n3 <= 2) {
                        int[] nArray = new int[]{n6};
                        n12 += DateTimeOffset.a(string, n12, 2, n3 == 2, bl3, nArray);
                        n6 = nArray[0];
                        continue block20;
                    }
                    int[] nArray = new int[]{n11};
                    n12 += DateTimeOffset.a(string, n12, n3 == 3 ? dateTimeFormatInfo.getAbbreviatedDayNames() : dateTimeFormatInfo.getDayNames(), bl3, nArray);
                    n11 = nArray[0];
                    continue block20;
                }
                case 'f': {
                    n3 = DateTimeUtils.countRepeat(string2, i2, c2);
                    int[] nArray = new int[]{n11};
                    n12 += DateTimeOffset.a(string, n12, n3, true, bl3, nArray);
                    n11 = nArray[0];
                    if (d2 >= 0.0 || n3 > 7 || n11 == -1) {
                        return false;
                    }
                    d2 = (double)n11 / Math.pow(10.0, n3);
                    continue block20;
                }
                case 'F': {
                    n3 = DateTimeUtils.countRepeat(string2, i2, c2);
                    int n13 = 0;
                    int[] nArray = new int[]{n11};
                    int[] nArray2 = new int[]{0};
                    int n14 = DateTimeOffset.a(string, n12, n3, true, bl3, nArray, nArray2);
                    n11 = nArray[0];
                    n13 = nArray2[0];
                    if (n11 == -1) {
                        nArray[0] = n11;
                        n12 += DateTimeOffset.a(string, n12, n13, true, bl3, nArray);
                        n11 = nArray[0];
                    } else {
                        n12 += n14;
                    }
                    if (d2 >= 0.0 || n3 > 7 || n11 == -1) {
                        return false;
                    }
                    d2 = (double)n11 / Math.pow(10.0, n13);
                    continue block20;
                }
                case 'h': {
                    n3 = DateTimeUtils.countRepeat(string2, i2, c2);
                    if (n8 != -1 || n3 > 2) {
                        return false;
                    }
                    int[] nArray = new int[]{n11};
                    n12 += DateTimeOffset.a(string, n12, 2, n3 == 2, bl3, nArray);
                    n11 = nArray[0];
                    if (n11 == -1) {
                        return false;
                    }
                    if (n7 == -1) {
                        n7 = n11;
                        continue block20;
                    }
                    n8 = n7 + n11;
                    continue block20;
                }
                case 'H': {
                    n3 = DateTimeUtils.countRepeat(string2, i2, c2);
                    if (n8 != -1 || n3 > 2) {
                        return false;
                    }
                    int[] nArray = new int[]{n8};
                    n12 += DateTimeOffset.a(string, n12, 2, n3 == 2, bl3, nArray);
                    n8 = nArray[0];
                    continue block20;
                }
                case 'm': {
                    n3 = DateTimeUtils.countRepeat(string2, i2, c2);
                    if (n9 != -1 || n3 > 2) {
                        return false;
                    }
                    int[] nArray = new int[]{n9};
                    n12 += DateTimeOffset.a(string, n12, 2, n3 == 2, bl3, nArray);
                    n9 = nArray[0];
                    continue block20;
                }
                case 'M': {
                    n3 = DateTimeUtils.countRepeat(string2, i2, c2);
                    if (n5 != -1 || n3 > 4) {
                        return false;
                    }
                    if (n3 <= 2) {
                        int[] nArray = new int[]{n5};
                        n12 += DateTimeOffset.a(string, n12, 2, n3 == 2, bl3, nArray);
                        n5 = nArray[0];
                        continue block20;
                    }
                    int[] nArray = new int[]{n5};
                    n12 += DateTimeOffset.a(string, n12, n3 == 3 ? dateTimeFormatInfo.getAbbreviatedMonthNames() : dateTimeFormatInfo.getMonthNames(), bl3, nArray);
                    n5 = nArray[0];
                    ++n5;
                    continue block20;
                }
                case 's': {
                    n3 = DateTimeUtils.countRepeat(string2, i2, c2);
                    if (n10 != -1 || n3 > 2) {
                        return false;
                    }
                    int[] nArray = new int[]{n10};
                    n12 += DateTimeOffset.a(string, n12, 2, n3 == 2, bl3, nArray);
                    n10 = nArray[0];
                    continue block20;
                }
                case 't': {
                    String[] stringArray;
                    n3 = DateTimeUtils.countRepeat(string2, i2, c2);
                    if (n8 != -1 || n3 > 2) {
                        return false;
                    }
                    int[] nArray = new int[]{n11};
                    if (n3 == 1) {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = StringExtensions.newString(dateTimeFormatInfo.getAMDesignator().charAt(0), 1);
                        stringArray = stringArray2;
                        stringArray2[1] = StringExtensions.newString(dateTimeFormatInfo.getPMDesignator().charAt(0), 0);
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = dateTimeFormatInfo.getAMDesignator();
                        stringArray = stringArray3;
                        stringArray3[1] = dateTimeFormatInfo.getPMDesignator();
                    }
                    n12 += DateTimeOffset.a(string, n12, stringArray, bl3, nArray);
                    n11 = nArray[0];
                    if (n11 == -1) {
                        return false;
                    }
                    if (n7 == -1) {
                        n7 = n11 * 12;
                        continue block20;
                    }
                    n8 = n7 + n11 * 12;
                    continue block20;
                }
                case 'y': {
                    if (n4 != -1) {
                        return false;
                    }
                    n3 = DateTimeUtils.countRepeat(string2, i2, c2);
                    if (n3 <= 2) {
                        int[] nArray = new int[]{n4};
                        n12 += DateTimeOffset.a(string, n12, 2, n3 == 2, bl3, nArray);
                        n4 = nArray[0];
                        if (n4 == -1) continue block20;
                        n4 = dateTimeFormatInfo.getCalendar().toFourDigitYear(n4);
                        continue block20;
                    }
                    if (n3 <= 4) {
                        int n15 = 0;
                        int[] nArray = new int[]{n4};
                        int[] nArray3 = new int[]{0};
                        n12 += DateTimeOffset.a(string, n12, 5, false, bl3, nArray, nArray3);
                        n4 = nArray[0];
                        n15 = nArray3[0];
                        if (n15 >= n3 && (n15 <= n3 || !((double)n4 / Math.pow(10.0, n15 - 1) < 1.0))) continue block20;
                        return false;
                    }
                    int[] nArray = new int[]{n4};
                    n12 += DateTimeOffset.a(string, n12, n3, true, bl3, nArray);
                    n4 = nArray[0];
                    continue block20;
                }
                case 'K': {
                    n3 = 1;
                    int n16 = 0;
                    int n17 = 0;
                    int n18 = 0;
                    n11 = 0;
                    int[] nArray = new int[]{0};
                    n12 += DateTimeOffset.a(string, n12, new String[]{"-", "+"}, bl3, nArray);
                    n18 = nArray[0];
                    int[] nArray4 = new int[]{0};
                    n12 += DateTimeOffset.a(string, n12, 4, false, false, nArray4);
                    n16 = nArray4[0];
                    if (n16 == -1 || n17 == -1 || n18 == -1) {
                        return false;
                    }
                    if (n18 == 0) {
                        n18 = -1;
                    }
                    timeSpan = new TimeSpan(n18 * n16, n18 * n17, 0);
                    continue block20;
                }
                case 'z': {
                    n3 = DateTimeUtils.countRepeat(string2, i2, c2);
                    if (!TimeSpan.equals(timeSpan, TimeSpan.MinValue) || n3 > 3) {
                        return false;
                    }
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    n11 = 0;
                    int[] nArray = new int[]{0};
                    n12 += DateTimeOffset.a(string, n12, new String[]{"-", "+"}, bl3, nArray);
                    n21 = nArray[0];
                    int[] nArray4 = new int[]{0};
                    n12 += DateTimeOffset.a(string, n12, 2, n3 != 1, false, nArray4);
                    n19 = nArray4[0];
                    if (n3 == 3) {
                        int[] nArray5 = new int[]{0};
                        n12 += DateTimeOffset.a(string, n12, new String[]{dateTimeFormatInfo.getTimeSeparator()}, false, nArray5);
                        n11 = nArray5[0];
                        int[] nArray6 = new int[]{0};
                        n12 += DateTimeOffset.a(string, n12, 2, true, false, nArray6);
                        n20 = nArray6[0];
                    }
                    if (n19 == -1 || n20 == -1 || n21 == -1) {
                        return false;
                    }
                    if (n21 == 0) {
                        n21 = -1;
                    }
                    timeSpan = new TimeSpan(n21 * n19, n21 * n20, 0);
                    continue block20;
                }
                case ':': {
                    n3 = 1;
                    int[] nArray = new int[]{n11};
                    n12 += DateTimeOffset.a(string, n12, new String[]{dateTimeFormatInfo.getTimeSeparator()}, false, nArray);
                    n11 = nArray[0];
                    if (n11 != -1) continue block20;
                    return false;
                }
                case '/': {
                    n3 = 1;
                    int[] nArray = new int[]{n11};
                    n12 += DateTimeOffset.a(string, n12, new String[]{dateTimeFormatInfo.getDateSeparator()}, false, nArray);
                    n11 = nArray[0];
                    if (n11 != -1) continue block20;
                    return false;
                }
                case '%': {
                    n3 = 1;
                    if (i2 == 0) continue block20;
                    return false;
                }
                case ' ': {
                    n3 = 1;
                    int[] nArray = new int[]{n11};
                    n12 += DateTimeOffset.a(string, n12, ' ', false, nArray);
                    n11 = nArray[0];
                    if (n11 != -1) continue block20;
                    return false;
                }
                case '\\': {
                    n3 = 2;
                    int[] nArray = new int[]{n11};
                    n12 += DateTimeOffset.a(string, n12, string2.charAt(i2 + 1), bl3, nArray);
                    n11 = nArray[0];
                    if (n11 != -1) continue block20;
                    return false;
                }
                case '\"': 
                case '\'': {
                    n3 = 1;
                    while (n12 < string.length()) {
                        char c3 = string2.charAt(i2 + n3);
                        ++n3;
                        if (c3 == string2.charAt(i2)) {
                            if (!bl4 || n3 != 5 || string.charAt(n12 - 3) != 'G' || string.charAt(n12 - 2) != 'M' || string.charAt(n12 - 1) != 'T') continue block20;
                            TimeSpan.Zero.CloneTo(timeSpan);
                            continue block20;
                        }
                        if (c3 == string.charAt(n12++)) continue;
                        return false;
                    }
                    continue block20;
                }
                default: {
                    n3 = 1;
                    int[] nArray = new int[]{n11};
                    n12 += DateTimeOffset.a(string, n12, string2.charAt(i2), bl3, nArray);
                    n11 = nArray[0];
                    if (n11 != -1) continue block20;
                    return false;
                }
            }
        }
        if (TimeSpan.equals(timeSpan, TimeSpan.MinValue)) {
            if ((n2 & 0x40) != 0) {
                TimeSpan.Zero.CloneTo(timeSpan);
            } else if ((n2 & 0x20) != 0) {
                TimeSpan timeSpan2 = timeSpan = bl5 ? TimeSpan.Zero.Clone() : TimeZoneExtensions.getUtcOffset(TimeZone.getDefault(), DateTime.getNow().Clone()).Clone();
            }
        }
        if (n8 < 0) {
            n8 = 0;
        }
        if (n9 < 0) {
            n9 = 0;
        }
        if (n10 < 0) {
            n10 = 0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (n4 > 0 && n5 > 0 && n6 > 0) {
            dateTimeOffsetArray[0] = new DateTimeOffset(n4, n5, n6, n8, n9, n10, 0, timeSpan.Clone());
            if (bl4) {
                // empty if block
            }
            dateTimeOffsetArray[0].addSeconds(d2).CloneTo(dateTimeOffsetArray[0]);
            if ((n2 & 0x10) != 0) {
                dateTimeOffsetArray[0].toUniversalTime().CloneTo(dateTimeOffsetArray[0]);
            }
            return true;
        }
        return false;
    }

    private static int a(String string, int n2, int n3, boolean bl2, boolean bl3, int[] nArray) {
        boolean bl4 = false;
        int[] nArray2 = new int[]{0};
        return DateTimeOffset.a(string, n2, n3, bl2, bl3, nArray, nArray2);
    }

    private static int a(String string, int n2, int n3, boolean bl2, boolean bl3, int[] nArray, int[] nArray2) {
        int n4 = 0;
        nArray2[0] = 0;
        nArray[0] = 0;
        while (bl3 && n2 < string.length() && string.charAt(n2) == ' ') {
            ++n4;
            ++n2;
        }
        while (n2 < string.length() && Character.isDigit(string.charAt(n2)) && n3 > 0) {
            nArray[0] = 10 * nArray[0] + ((byte)(string.charAt(n2) - 48) & 0xFF);
            ++n2;
            ++n4;
            nArray2[0] = nArray2[0] + 1;
            --n3;
        }
        if (bl2 && n3 > 0) {
            nArray[0] = -1;
        }
        if (nArray2[0] == 0) {
            nArray[0] = -1;
        }
        return n4;
    }

    private static int a(String string, int n2, String[] stringArray, boolean bl2, int[] nArray) {
        int n3 = 0;
        nArray[0] = -1;
        while (bl2 && n2 < string.length() && string.charAt(n2) == ' ') {
            ++n3;
            ++n2;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string.substring(n2).startsWith(stringArray[i2])) continue;
            nArray[0] = i2;
            break;
        }
        if (nArray[0] >= 0) {
            n3 += stringArray[nArray[0]].length();
        }
        return n3;
    }

    private static int a(String string, int n2, char c2, boolean bl2, int[] nArray) {
        int n3 = 0;
        nArray[0] = -1;
        while (bl2 && n2 < string.length() && string.charAt(n2) == ' ') {
            ++n2;
            ++n3;
        }
        if (n2 < string.length() && string.charAt(n2) == c2) {
            nArray[0] = c2;
            ++n3;
        }
        return n3;
    }

    public TimeSpan subtract(DateTimeOffset dateTimeOffset) {
        return DateTime.op_Subtraction(this.getUtcDateTime(), dateTimeOffset.getUtcDateTime());
    }

    public DateTimeOffset subtract(TimeSpan timeSpan) {
        TimeSpan timeSpan2 = new TimeSpan(-timeSpan.getTicks());
        return this.add(timeSpan2.Clone());
    }

    public static TimeSpan op_Subtraction(DateTimeOffset dateTimeOffset, DateTimeOffset dateTimeOffset2) {
        return dateTimeOffset.subtract(dateTimeOffset2.Clone());
    }

    public static DateTimeOffset op_Subtraction(DateTimeOffset dateTimeOffset, TimeSpan timeSpan) {
        return dateTimeOffset.subtract(timeSpan.Clone());
    }

    public long toFileTime() {
        return this.getUtcDateTime().toFileTime();
    }

    public DateTimeOffset toLocalTime() {
        return new DateTimeOffset(this.getUtcDateTime().toLocalTime().Clone(), TimeZoneExtensions.getUtcOffset(TimeZone.getDefault(), this.getUtcDateTime().toLocalTime().Clone()).Clone());
    }

    public DateTimeOffset toOffset(TimeSpan timeSpan) {
        return new DateTimeOffset(DateTime.op_Addition(DateTime.op_Subtraction(this.b, this.c), timeSpan).Clone(), timeSpan.Clone());
    }

    public String toString() {
        return this.toString(null, null);
    }

    public String toString(IFormatProvider iFormatProvider) {
        return this.toString(null, iFormatProvider);
    }

    public String toString(String string) {
        return this.toString(string, null);
    }

    public String toString(String string, IFormatProvider iFormatProvider) {
        DateTimeFormatInfo dateTimeFormatInfo = DateTimeFormatInfo.getInstance(iFormatProvider);
        if ((string == null || StringExtensions.equals(string, "")) && (string = StringExtensions.concat(dateTimeFormatInfo.getShortDatePattern(), " ", dateTimeFormatInfo.getLongTimePattern())).indexOf("zzz") < 0) {
            string = string.indexOf("zz") > 0 ? string.replace("zz", "zzz") : (string.indexOf("z") > 0 ? string.replace("z", "zzz") : string + " zzz");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.length() == 1) {
            char c2 = string.charAt(0);
            try {
                boolean[] blArray = new boolean[]{false};
                boolean[] blArray2 = new boolean[]{false};
                string = DateTimeUtils.getStandardPattern_DateTimeOffset(c2, dateTimeFormatInfo, blArray, blArray2, true);
                bl2 = blArray[0];
                bl3 = blArray2[0];
            }
            catch (Exception exception) {
                string = null;
            }
            if (string == null) {
                throw new FormatException("format is not one of the format specifier characters defined for DateTimeFormatInfo");
            }
        }
        return bl2 ? DateTimeUtils.toString(this.getUtcDateTime().Clone(), TimeSpan.Zero.Clone(), string, dateTimeFormatInfo) : DateTimeUtils.toString(this.getDateTime().Clone(), this.getOffset().Clone(), string, dateTimeFormatInfo);
    }

    public DateTimeOffset toUniversalTime() {
        return new DateTimeOffset(this.getUtcDateTime().Clone(), TimeSpan.Zero.Clone());
    }

    public static boolean tryParse(String string, DateTimeOffset[] dateTimeOffsetArray) {
        try {
            DateTimeOffset.parse(string).CloneTo(dateTimeOffsetArray[0]);
            return true;
        }
        catch (Exception exception) {
            MinValue.CloneTo(dateTimeOffsetArray[0]);
            return false;
        }
    }

    public static boolean tryParse(String string, IFormatProvider iFormatProvider, int n2, DateTimeOffset[] dateTimeOffsetArray) {
        try {
            DateTimeOffset.parse(string, iFormatProvider, n2).CloneTo(dateTimeOffsetArray[0]);
            return true;
        }
        catch (Exception exception) {
            MinValue.CloneTo(dateTimeOffsetArray[0]);
            return false;
        }
    }

    public static boolean tryParseExact(String string, String string2, IFormatProvider iFormatProvider, int n2, DateTimeOffset[] dateTimeOffsetArray) {
        try {
            DateTimeOffset.parseExact(string, string2, iFormatProvider, n2).CloneTo(dateTimeOffsetArray[0]);
            return true;
        }
        catch (Exception exception) {
            MinValue.CloneTo(dateTimeOffsetArray[0]);
            return false;
        }
    }

    public static boolean tryParseExact(String string, String[] stringArray, IFormatProvider iFormatProvider, int n2, DateTimeOffset[] dateTimeOffsetArray) {
        try {
            DateTimeOffset.parseExact(string, stringArray, iFormatProvider, n2).CloneTo(dateTimeOffsetArray[0]);
            return true;
        }
        catch (Exception exception) {
            MinValue.CloneTo(dateTimeOffsetArray[0]);
            return false;
        }
    }

    public DateTime getDate() {
        return DateTime.specifyKind(this.b.getDate().Clone(), 0L);
    }

    public DateTime getDateTime() {
        return DateTime.specifyKind(this.b.Clone(), 0L);
    }

    public int getDay() {
        return this.b.getDay();
    }

    public int getDayOfWeek() {
        return this.b.getDayOfWeek();
    }

    public int getDayOfYear() {
        return this.b.getDayOfYear();
    }

    public int getHour() {
        return this.b.getHour();
    }

    public DateTime getLocalDateTime() {
        return this.getUtcDateTime().toLocalTime();
    }

    public int getMillisecond() {
        return this.b.getMillisecond();
    }

    public int getMinute() {
        return this.b.getMinute();
    }

    public int getMonth() {
        return this.b.getMonth();
    }

    public static DateTimeOffset getNow() {
        return new DateTimeOffset(DateTime.getNow().Clone());
    }

    public TimeSpan getOffset() {
        return this.c;
    }

    public int getSecond() {
        return this.b.getSecond();
    }

    public long getTicks() {
        return this.b.getTicks();
    }

    public TimeSpan getTimeOfDay() {
        return this.b.getTimeOfDay();
    }

    public DateTime getUtcDateTime() {
        return DateTime.specifyKind(DateTime.op_Subtraction(this.b, this.c).Clone(), 1L);
    }

    public static DateTimeOffset getUtcNow() {
        return new DateTimeOffset(DateTime.getUtcNow().Clone());
    }

    public long getUtcTicks() {
        return this.getUtcDateTime().getTicks();
    }

    public int getYear() {
        return this.b.getYear();
    }

    @Override
    public void CloneTo(DateTimeOffset dateTimeOffset) {
        this.b.CloneTo(dateTimeOffset.b);
        this.c.CloneTo(dateTimeOffset.c);
    }

    @Override
    public DateTimeOffset Clone() {
        DateTimeOffset dateTimeOffset = new DateTimeOffset();
        this.CloneTo(dateTimeOffset);
        return dateTimeOffset;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(DateTimeOffset dateTimeOffset) {
        return ObjectExtensions.equals(dateTimeOffset.b, this.b) && ObjectExtensions.equals(dateTimeOffset.c, this.c);
    }

    public boolean equals(Object object) {
        assert (object != null);
        if (ObjectExtensions.referenceEquals(null, object)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, object)) {
            return true;
        }
        if (!(object instanceof DateTimeOffset)) {
            return false;
        }
        return this.a((DateTimeOffset)object);
    }

    public static boolean equals(DateTimeOffset dateTimeOffset, DateTimeOffset dateTimeOffset2) {
        return dateTimeOffset.equals(dateTimeOffset2);
    }
}

