/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections.Generic;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.DictionaryEntry;
import com.aspose.html.internal.ms.System.Collections.Generic.Comparer;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericCollection;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericDictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericList;
import com.aspose.html.internal.ms.System.Collections.Generic.KeyNotFoundException;
import com.aspose.html.internal.ms.System.Collections.Generic.KeyValuePair;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IDictionaryEnumerator;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msArray;
import com.aspose.html.internal.ms.lang.Struct;
import java.util.Comparator;

public class SortedList<TKey, TValue>
implements IGenericCollection<KeyValuePair<TKey, TValue>>,
IGenericDictionary<TKey, TValue>,
IGenericEnumerable<KeyValuePair<TKey, TValue>> {
    private static final int a = 4;
    private int b;
    private int c;
    private KeyValuePair[] d;
    private Comparator<TKey> e;
    private int f;

    public SortedList() {
        this(4, null);
    }

    public SortedList(int n2) {
        this(n2, null);
    }

    public SortedList(int n2, Comparator<TKey> comparator) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.f = n2 == 0 ? 0 : 4;
        this.a(comparator, n2, true);
    }

    public SortedList(Comparator<TKey> comparator) {
        this(4, comparator);
    }

    public SortedList(IGenericDictionary<TKey, TValue> iGenericDictionary) {
        this(iGenericDictionary, null);
    }

    public SortedList(IGenericDictionary<TKey, TValue> iGenericDictionary, Comparator<TKey> comparator) {
        if (iGenericDictionary == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.a(comparator, iGenericDictionary.size(), true);
        for (KeyValuePair keyValuePair : iGenericDictionary) {
            this.addItem(keyValuePair.getKey(), keyValuePair.getValue());
        }
    }

    @Override
    public int size() {
        return this.b;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public TValue get_Item(TKey TKey) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        int n2 = this.a(TKey);
        if (n2 >= 0) {
            return this.d[n2].getValue();
        }
        throw new KeyNotFoundException();
    }

    @Override
    public void set_Item(TKey TKey, TValue TValue) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        this.a(TKey, TValue, true);
    }

    public int getCapacity() {
        return this.d.length;
    }

    public void setCapacity(int n2) {
        int n3 = this.d.length;
        if (this.b > n2) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (n2 == 0) {
            this.d = new KeyValuePair[0];
        } else if (n2 >= this.b) {
            KeyValuePair[] keyValuePairArray = msArray.createArrayWithInitialization(KeyValuePair.class, n2);
            Array.copy(Array.boxing(this.d), 0, Array.boxing(keyValuePairArray), 0, this.b);
            this.d = keyValuePairArray;
        } else if (n2 > n3) {
            KeyValuePair[] keyValuePairArray = msArray.createArrayWithInitialization(KeyValuePair.class, n2);
            Array.copy(Array.boxing(this.d), 0, Array.boxing(keyValuePairArray), 0, n3);
            this.d = keyValuePairArray;
        }
    }

    @Override
    public IGenericList<TKey> getKeys() {
        return new ListKeys(this);
    }

    @Override
    public IGenericList<TValue> getValues() {
        return new ListValues(this);
    }

    public Comparator<TKey> getComparer() {
        return this.e;
    }

    @Override
    public void addItem(TKey TKey, TValue TValue) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        this.a(TKey, TValue, false);
    }

    @Override
    public boolean containsKey(TKey TKey) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        return this.a(TKey) >= 0;
    }

    @Override
    public IGenericEnumerator<KeyValuePair<TKey, TValue>> iterator() {
        List list = new List();
        for (int i2 = 0; i2 < this.b; ++i2) {
            KeyValuePair keyValuePair = this.d[i2].Clone();
            list.addItem(new KeyValuePair(keyValuePair.getKey(), keyValuePair.getValue()));
        }
        return list.iterator();
    }

    @Override
    public boolean removeItemByKey(TKey TKey) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        int n2 = this.indexOfKey(TKey);
        if (n2 >= 0) {
            this.removeAt(n2);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.b = 0;
        ++this.c;
    }

    public void copyToTArray(KeyValuePair<TKey, TValue>[] keyValuePairArray, int n2) {
        if (this.size() == 0) {
            return;
        }
        if (null == keyValuePairArray) {
            throw new ArgumentNullException();
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (n2 >= keyValuePairArray.length) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > keyValuePairArray.length - n2) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        int n3 = n2;
        for (KeyValuePair keyValuePair : this) {
            keyValuePair.CloneTo(keyValuePairArray[n3++]);
        }
    }

    @Override
    public void addItem(KeyValuePair<TKey, TValue> keyValuePair) {
        this.addItem(keyValuePair.getKey(), keyValuePair.getValue());
    }

    @Override
    public boolean containsItem(KeyValuePair<TKey, TValue> keyValuePair) {
        int n2 = this.a(keyValuePair.getKey());
        if (n2 >= 0) {
            return Comparer.getDefault().compare(this.d[n2].Clone(), keyValuePair.Clone()) == 0;
        }
        return false;
    }

    @Override
    public boolean removeItem(KeyValuePair<TKey, TValue> keyValuePair) {
        int n2 = this.a(keyValuePair.getKey());
        if (n2 >= 0 && Comparer.getDefault().compare(this.d[n2].Clone(), keyValuePair.Clone()) == 0) {
            this.removeAt(n2);
            return true;
        }
        return false;
    }

    public IDictionaryEnumerator iterator_IDictionary() {
        return new Enumerator(this, 2);
    }

    public void copyTo(Array array, int n2) {
        if (this.size() == 0) {
            return;
        }
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.getRank() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (n2 >= array.getLength()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.getLength() - n2) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IEnumerator iEnumerator = this.iterator();
        int n3 = n2;
        while (iEnumerator.hasNext()) {
            msArray.setValue(array, ((KeyValuePair)iEnumerator.next()).Clone(), n3++);
        }
    }

    public void removeAt(int n2) {
        KeyValuePair[] keyValuePairArray = this.d;
        int n3 = this.size();
        if (n2 >= 0 && n2 < n3) {
            if (n2 != n3 - 1) {
                Array.copy(Array.boxing(keyValuePairArray), n2 + 1, Array.boxing(keyValuePairArray), n2, n3 - 1 - n2);
            } else {
                keyValuePairArray[n2] = null;
            }
            --this.b;
            ++this.c;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(TKey TKey) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        int n2 = 0;
        try {
            n2 = this.a(TKey);
        }
        catch (Exception exception) {
            throw new InvalidOperationException();
        }
        return n2 | n2 >> 31;
    }

    public int indexOfValue(TValue TValue) {
        if (this.b == 0) {
            return -1;
        }
        for (int i2 = 0; i2 < this.b; ++i2) {
            KeyValuePair keyValuePair = this.d[i2].Clone();
            if (!ObjectExtensions.equals(TValue, keyValuePair.getValue())) continue;
            return i2;
        }
        return -1;
    }

    public boolean containsValue(TValue TValue) {
        return this.indexOfValue(TValue) >= 0;
    }

    public void trimExcess() {
        if (this.b < (int)((double)this.d.length * 0.9)) {
            this.setCapacity(this.b);
        }
    }

    @Override
    public boolean tryGetValue(TKey TKey, Object[] objectArray) {
        if (TKey == null) {
            throw new ArgumentNullException("key");
        }
        int n2 = this.a(TKey);
        if (n2 >= 0) {
            objectArray[0] = this.d[n2].getValue();
            return true;
        }
        objectArray[0] = null;
        return false;
    }

    private void a(int n2, int n3) {
        boolean bl2;
        KeyValuePair[] keyValuePairArray = this.d;
        KeyValuePair[] keyValuePairArray2 = null;
        int n4 = this.getCapacity();
        boolean bl3 = bl2 = n3 >= 0 && n3 < this.size();
        if (n2 > n4) {
            if (n2 == 1) {
                this.f = 4;
                keyValuePairArray2 = msArray.createArrayWithInitialization(KeyValuePair.class, this.f);
            } else {
                keyValuePairArray2 = msArray.createArrayWithInitialization(KeyValuePair.class, n2 - 1 << 1);
            }
        }
        if (keyValuePairArray2 != null) {
            if (bl2) {
                int n5 = n3;
                if (n5 > 0) {
                    Array.copy(Array.boxing(keyValuePairArray), 0, Array.boxing(keyValuePairArray2), 0, n5);
                }
                if ((n5 = this.size() - n3) > 0) {
                    Array.copy(Array.boxing(keyValuePairArray), n3, Array.boxing(keyValuePairArray2), n3 + 1, n5);
                }
            } else {
                Array.copy(Array.boxing(keyValuePairArray), 0, Array.boxing(keyValuePairArray2), 0, this.size());
            }
            this.d = keyValuePairArray2;
        } else if (bl2) {
            Array.copy(Array.boxing(keyValuePairArray), n3, Array.boxing(keyValuePairArray), n3 + 1, this.size() - n3);
        }
    }

    private void a(TKey TKey, TValue TValue, boolean bl2) {
        if (TKey == null) {
            throw new ArgumentNullException("null key");
        }
        KeyValuePair[] keyValuePairArray = this.d;
        int n2 = -1;
        try {
            n2 = this.a(TKey);
        }
        catch (Exception exception) {
            throw new InvalidOperationException();
        }
        if (n2 >= 0) {
            if (!bl2) {
                throw new ArgumentException("element already exists");
            }
            keyValuePairArray[n2] = new KeyValuePair<TKey, TValue>(TKey, TValue);
            ++this.c;
            return;
        }
        if ((n2 ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new Exception(StringExtensions.concat("SortedList::internal error (", TKey, ", ", TValue, ") at [", n2, "]"));
        }
        this.a(this.size() + 1, n2);
        keyValuePairArray = this.d;
        keyValuePairArray[n2] = new KeyValuePair<TKey, TValue>(TKey, TValue);
        ++this.b;
        ++this.c;
    }

    private void a(Comparator<TKey> comparator, int n2, boolean bl2) {
        if (comparator == null) {
            comparator = Comparer.getDefault();
        }
        this.e = comparator;
        if (!bl2 && n2 < this.f) {
            n2 = this.f;
        }
        this.d = msArray.createArrayWithInitialization(KeyValuePair.class, n2);
        this.b = 0;
        this.c = 0;
    }

    private void a(Array array, int n2, int n3) {
        if (array == null) {
            throw new ArgumentNullException("arr");
        }
        if (n2 < 0 || n2 + this.size() > array.getLength()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n3);
        while (enumerator.hasNext()) {
            msArray.setValue(array, enumerator.next(), n2++);
        }
    }

    private int a(TKey TKey) {
        KeyValuePair[] keyValuePairArray = this.d;
        int n2 = this.size();
        if (n2 == 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >> 1;
            int n6 = this.e.compare(keyValuePairArray[n5].getKey(), TKey);
            if (n6 == 0) {
                return n5;
            }
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5 - 1;
        }
        return ~n3;
    }

    TKey a(int n2) {
        if (n2 >= 0 && n2 < this.size()) {
            return this.d[n2].getKey();
        }
        throw new ArgumentOutOfRangeException("Index out of range");
    }

    TValue b(int n2) {
        if (n2 >= 0 && n2 < this.size()) {
            return this.d[n2].getValue();
        }
        throw new ArgumentOutOfRangeException("Index out of range");
    }

    private static class ListValues<TKey, TValue>
    implements IGenericList<TValue> {
        private SortedList<TKey, TValue> a;

        public ListValues(SortedList<TKey, TValue> sortedList) {
            if (sortedList == null) {
                throw new ArgumentNullException();
            }
            this.a = sortedList;
        }

        @Override
        public void addItem(TValue TValue) {
            throw new NotSupportedException();
        }

        @Override
        public boolean removeItem(TValue TValue) {
            throw new NotSupportedException();
        }

        @Override
        public void clear() {
            throw new NotSupportedException();
        }

        @Override
        public void copyToTArray(TValue[] TValueArray, int n2) {
            if (this.a.size() == 0) {
                return;
            }
            if (TValueArray == null) {
                throw new ArgumentNullException("array");
            }
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException();
            }
            if (n2 >= TValueArray.length) {
                throw new ArgumentOutOfRangeException("arrayIndex is greater than or equal to array.Length");
            }
            if (this.size() > TValueArray.length - n2) {
                throw new ArgumentOutOfRangeException("Not enough space in array from arrayIndex to end of array");
            }
            int n3 = n2;
            for (int i2 = 0; i2 < this.size(); ++i2) {
                TValueArray[n3++] = this.a.b(i2);
            }
        }

        @Override
        public boolean containsItem(TValue TValue) {
            return this.a.indexOfValue(TValue) > -1;
        }

        @Override
        public int indexOfItem(TValue TValue) {
            return this.a.indexOfValue(TValue);
        }

        @Override
        public void insertItem(int n2, TValue TValue) {
            throw new NotSupportedException();
        }

        @Override
        public void removeAt(int n2) {
            throw new NotSupportedException();
        }

        @Override
        public TValue get_Item(int n2) {
            return this.a.b(n2);
        }

        @Override
        public void set_Item(int n2, TValue TValue) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public IGenericEnumerator<TValue> iterator() {
            return new ValueEnumerator<TKey, TValue>(this.a);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        public boolean a() {
            return ((ICollection)((Object)this.a)).isSynchronized();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public Object b() {
            return ((ICollection)((Object)this.a)).getSyncRoot();
        }

        public void a(Array array, int n2) {
            ((SortedList)this.a).a(array, n2, 1);
        }
    }

    private static class ListKeys<TKey, TValue>
    implements IGenericList<TKey> {
        private SortedList<TKey, TValue> a;

        public ListKeys(SortedList<TKey, TValue> sortedList) {
            if (sortedList == null) {
                throw new ArgumentNullException();
            }
            this.a = sortedList;
        }

        @Override
        public void addItem(TKey TKey) {
            throw new NotSupportedException();
        }

        @Override
        public boolean removeItem(TKey TKey) {
            throw new NotSupportedException();
        }

        @Override
        public void clear() {
            throw new NotSupportedException();
        }

        @Override
        public void copyToTArray(TKey[] TKeyArray, int n2) {
            if (this.a.size() == 0) {
                return;
            }
            if (TKeyArray == null) {
                throw new ArgumentNullException("array");
            }
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException();
            }
            if (n2 >= TKeyArray.length) {
                throw new ArgumentOutOfRangeException("arrayIndex is greater than or equal to array.Length");
            }
            if (this.size() > TKeyArray.length - n2) {
                throw new ArgumentOutOfRangeException("Not enough space in array from arrayIndex to end of array");
            }
            int n3 = n2;
            for (int i2 = 0; i2 < this.size(); ++i2) {
                TKeyArray[n3++] = this.a.a(i2);
            }
        }

        @Override
        public boolean containsItem(TKey TKey) {
            return this.a.indexOfKey(TKey) > -1;
        }

        @Override
        public int indexOfItem(TKey TKey) {
            return this.a.indexOfKey(TKey);
        }

        @Override
        public void insertItem(int n2, TKey TKey) {
            throw new NotSupportedException();
        }

        @Override
        public void removeAt(int n2) {
            throw new NotSupportedException();
        }

        @Override
        public TKey get_Item(int n2) {
            return this.a.a(n2);
        }

        @Override
        public void set_Item(int n2, TKey TKey) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public IGenericEnumerator<TKey> iterator() {
            return new KeyEnumerator<TKey, TValue>(this.a);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        public boolean a() {
            return ((ICollection)((Object)this.a)).isSynchronized();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public Object b() {
            return ((ICollection)((Object)this.a)).getSyncRoot();
        }

        public void a(Array array, int n2) {
            ((SortedList)this.a).a(array, n2, 0);
        }
    }

    private static class ValueEnumerator<TKey, TValue>
    extends Struct<ValueEnumerator>
    implements IGenericEnumerator<TValue>,
    IDisposable {
        private static final int b = -2;
        private static final int c = -1;
        private SortedList<TKey, TValue> d;
        private int e;
        private int f;

        public ValueEnumerator() {
        }

        ValueEnumerator(SortedList<TKey, TValue> sortedList) {
            this.d = sortedList;
            this.e = -2;
            this.f = ((SortedList)sortedList).c;
        }

        @Override
        public void dispose() {
            this.e = -2;
        }

        @Override
        public boolean hasNext() {
            if (this.f != ((SortedList)this.d).c) {
                throw new InvalidOperationException("Collection was modified after the enumerator was instantiated.");
            }
            if (this.e == -2) {
                this.e = this.d.size();
            }
            return this.e != -1 && --this.e != -1;
        }

        @Override
        public TValue next() {
            if (this.e < 0) {
                throw new InvalidOperationException();
            }
            return this.d.b(this.d.size() - 1 - this.e);
        }

        @Override
        public void reset() {
            if (this.f != ((SortedList)this.d).c) {
                throw new InvalidOperationException("Collection was modified after the enumerator was instantiated.");
            }
            this.e = -2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }

        public void a(ValueEnumerator valueEnumerator) {
            valueEnumerator.d = this.d;
            valueEnumerator.e = this.e;
            valueEnumerator.f = this.f;
        }

        public ValueEnumerator a() {
            ValueEnumerator<TKey, TValue> valueEnumerator = new ValueEnumerator<TKey, TValue>();
            this.a(valueEnumerator);
            return valueEnumerator;
        }

        public Object clone() {
            return this.a();
        }

        private boolean b(ValueEnumerator valueEnumerator) {
            return ObjectExtensions.equals(valueEnumerator.d, this.d) && valueEnumerator.e == this.e && valueEnumerator.f == this.f;
        }

        public boolean equals(Object object) {
            assert (object != null);
            if (ObjectExtensions.referenceEquals(null, object)) {
                return false;
            }
            if (ObjectExtensions.referenceEquals(this, object)) {
                return true;
            }
            if (!(object instanceof ValueEnumerator)) {
                return false;
            }
            return this.b((ValueEnumerator)object);
        }

        public static boolean a(ValueEnumerator valueEnumerator, ValueEnumerator valueEnumerator2) {
            return valueEnumerator.equals(valueEnumerator2);
        }

        public int hashCode() {
            int n2 = this.d != null ? this.d.hashCode() : 0;
            n2 = 31 * n2 + this.e;
            n2 = 31 * n2 + this.f;
            return n2;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.a();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.a((ValueEnumerator)object);
        }
    }

    private static class KeyEnumerator<TKey, TValue>
    extends Struct<KeyEnumerator>
    implements IGenericEnumerator<TKey>,
    IDisposable {
        private static final int b = -2;
        private static final int c = -1;
        private SortedList<TKey, TValue> d;
        private int e;
        private int f;

        public KeyEnumerator() {
        }

        KeyEnumerator(SortedList<TKey, TValue> sortedList) {
            this.d = sortedList;
            this.e = -2;
            this.f = ((SortedList)sortedList).c;
        }

        @Override
        public void dispose() {
            this.e = -2;
        }

        @Override
        public boolean hasNext() {
            if (this.f != ((SortedList)this.d).c) {
                throw new InvalidOperationException("Collection was modified after the enumerator was instantiated.");
            }
            if (this.e == -2) {
                this.e = this.d.size();
            }
            return this.e != -1 && --this.e != -1;
        }

        @Override
        public TKey next() {
            if (this.e < 0) {
                throw new InvalidOperationException();
            }
            return this.d.a(this.d.size() - 1 - this.e);
        }

        @Override
        public void reset() {
            if (this.f != ((SortedList)this.d).c) {
                throw new InvalidOperationException("Collection was modified after the enumerator was instantiated.");
            }
            this.e = -2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }

        public void a(KeyEnumerator keyEnumerator) {
            keyEnumerator.d = this.d;
            keyEnumerator.e = this.e;
            keyEnumerator.f = this.f;
        }

        public KeyEnumerator a() {
            KeyEnumerator<TKey, TValue> keyEnumerator = new KeyEnumerator<TKey, TValue>();
            this.a(keyEnumerator);
            return keyEnumerator;
        }

        public Object clone() {
            return this.a();
        }

        private boolean b(KeyEnumerator keyEnumerator) {
            return ObjectExtensions.equals(keyEnumerator.d, this.d) && keyEnumerator.e == this.e && keyEnumerator.f == this.f;
        }

        public boolean equals(Object object) {
            assert (object != null);
            if (ObjectExtensions.referenceEquals(null, object)) {
                return false;
            }
            if (ObjectExtensions.referenceEquals(this, object)) {
                return true;
            }
            if (!(object instanceof KeyEnumerator)) {
                return false;
            }
            return this.b((KeyEnumerator)object);
        }

        public static boolean a(KeyEnumerator keyEnumerator, KeyEnumerator keyEnumerator2) {
            return keyEnumerator.equals(keyEnumerator2);
        }

        public int hashCode() {
            int n2 = this.d != null ? this.d.hashCode() : 0;
            n2 = 31 * n2 + this.e;
            n2 = 31 * n2 + this.f;
            return n2;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.a();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.a((KeyEnumerator)object);
        }
    }

    private static final class Enumerator<TKey, TValue>
    implements IDictionaryEnumerator,
    IEnumerator,
    ICloneable {
        private SortedList<TKey, TValue> a;
        private int b;
        private int c;
        private int d;
        private int e;
        private Object f;
        private Object g;
        private boolean h = false;
        private static final String i = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList<TKey, TValue> sortedList, int n2) {
            this.a = sortedList;
            this.b = ((SortedList)sortedList).c;
            this.d = sortedList.size();
            this.e = n2;
            this.reset();
        }

        public Enumerator(SortedList<TKey, TValue> sortedList) {
            this(sortedList, 2);
        }

        @Override
        public void reset() {
            if (((SortedList)this.a).c != this.b || this.h) {
                throw new InvalidOperationException(i);
            }
            this.c = -1;
            this.f = null;
            this.g = null;
        }

        @Override
        public boolean hasNext() {
            if (((SortedList)this.a).c != this.b || this.h) {
                throw new InvalidOperationException(i);
            }
            KeyValuePair[] keyValuePairArray = ((SortedList)this.a).d;
            if (++this.c < this.d) {
                KeyValuePair keyValuePair = keyValuePairArray[this.c].Clone();
                this.f = keyValuePair.getKey();
                this.g = keyValuePair.getValue();
                return true;
            }
            this.f = null;
            this.g = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.h || this.c >= this.d || this.c == -1) {
                throw new InvalidOperationException(i);
            }
            return new DictionaryEntry(this.f, this.g);
        }

        @Override
        public Object getKey() {
            if (this.h || this.c >= this.d || this.c == -1) {
                throw new InvalidOperationException(i);
            }
            return this.f;
        }

        @Override
        public Object getValue() {
            if (this.h || this.c >= this.d || this.c == -1) {
                throw new InvalidOperationException(i);
            }
            return this.g;
        }

        @Override
        public Object next() {
            if (this.h || this.c >= this.d || this.c == -1) {
                throw new InvalidOperationException(i);
            }
            switch (this.e) {
                case 0: {
                    return this.f;
                }
                case 1: {
                    return this.g;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(StringExtensions.concat(Enum.getName(EnumeratorMode.class, this.e), " is not a supported mode."));
        }

        @Override
        public Object deepClone() {
            Enumerator<TKey, TValue> enumerator = new Enumerator<TKey, TValue>(this.a, this.e);
            enumerator.b = this.b;
            enumerator.c = this.c;
            enumerator.d = this.d;
            enumerator.f = this.f;
            enumerator.g = this.g;
            enumerator.h = this.h;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends Enum {
        public static final int a = 0;
        public static final int b = 1;
        public static final int c = 2;

        private EnumeratorMode() {
        }

        static {
            Enum.register(new Enum.SimpleEnum((Class)EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }
}

