/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections.Generic;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import java.util.Comparator;

public abstract class Comparer<T>
implements Comparator<T> {
    static Comparer a = new DefaultComparer();

    @Override
    public abstract int compare(T var1, T var2);

    public static <T> Comparer<T> getDefault() {
        return a;
    }

    static final class DefaultComparer<T>
    extends Comparer<T> {
        DefaultComparer() {
        }

        @Override
        public int compare(T t2, T t3) {
            if (t2 == null) {
                return t3 == null ? 0 : -1;
            }
            if (t3 == null) {
                return 1;
            }
            if (t2 instanceof String && t3 instanceof String) {
                return CultureInfo.getCurrentCulture().getCompareInfo().compare((String)t2, (String)t3, 0L);
            }
            if (t2 instanceof Comparable) {
                return ((Comparable)t2).compareTo(t3);
            }
            throw new ArgumentException("Neither 'x' nor 'y' implement Comparable");
        }
    }
}

