/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;

public final class BitArray
implements ICollection,
ICloneable {
    private int[] a;
    private int b;
    private int c = 0;

    public BitArray(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException("bits");
        }
        this.b = bitArray.b;
        this.a = new int[(this.b + 31) / 32];
        if (this.a.length == 1) {
            this.a[0] = bitArray.a[0];
        } else {
            Array.copy(Array.boxing(bitArray.a), 0, Array.boxing(this.a), 0, this.a.length);
        }
    }

    public BitArray(boolean[] blArray) {
        if (blArray == null) {
            throw new ArgumentNullException("values");
        }
        this.b = blArray.length;
        this.a = new int[(this.b + 31) / 32];
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            this.set_Item(i2, blArray[i2]);
        }
    }

    public BitArray(byte[] byArray) {
        if (byArray == null) {
            throw new ArgumentNullException("bytes");
        }
        this.b = byArray.length * 8;
        this.a = new int[(this.b + 31) / 32];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.a(i2, byArray[i2]);
        }
    }

    public BitArray(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("values");
        }
        int n2 = nArray.length;
        this.b = n2 * 32;
        this.a = new int[n2];
        Array.copy(Array.boxing(nArray), 0, Array.boxing(this.a), 0, n2);
    }

    public BitArray(int n2) {
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.b = n2;
        this.a = new int[(this.b + 31) / 32];
    }

    public BitArray(int n2, boolean bl2) {
        this(n2);
        if (bl2) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2] = -1;
            }
        }
    }

    private BitArray(int[] nArray, int n2) {
        this.a = nArray;
        this.b = n2;
    }

    private byte a(int n2) {
        int n3 = n2 / 4;
        int n4 = n2 % 4 * 8;
        int n5 = this.a[n3] & 255 << n4;
        return (byte)(n5 >> n4 & 0xFF);
    }

    private void a(int n2, byte by2) {
        int n3 = n2 / 4;
        int n4 = n2 % 4 * 8;
        int n5 = n3;
        this.a[n5] = this.a[n5] & ~(255 << n4);
        int n6 = n3;
        this.a[n6] = this.a[n6] | (by2 & 0xFF) << n4;
        ++this.c;
    }

    private void b(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.b != this.b) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.b;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int n2) {
        return this.get(n2);
    }

    public void set_Item(int n2, boolean bl2) {
        this.set(n2, bl2);
    }

    public int getLength() {
        return this.b;
    }

    public void setLength(int n2) {
        if (this.b == n2) {
            return;
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (n2 > this.b) {
            int n3 = (n2 + 31) / 32;
            int n4 = (this.b + 31) / 32;
            if (n3 > this.a.length) {
                int[] nArray = new int[n3];
                Array.copy(Array.boxing(this.a), 0, Array.boxing(nArray), 0, this.a.length);
                this.a = nArray;
            } else {
                Array.clear(Array.boxing(this.a), n4, n3 - n4);
            }
            int n5 = this.b % 32;
            if (n5 > 0) {
                int n6 = n4 - 1;
                this.a[n6] = this.a[n6] & (1 << n5) - 1;
            }
        }
        this.b = n2;
        ++this.c;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(Array array, int n2) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.getRank() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (n2 >= array.getLength() && this.b > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = Array.unboxing(array);
        if (object instanceof Boolean[]) {
            if (array.getLength() - n2 < this.b) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i2 = 0; i2 < this.b; ++i2) {
                booleanArray[n2 + i2] = this.get_Item(i2);
            }
        } else if (object instanceof boolean[]) {
            if (array.getLength() - n2 < this.b) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i3 = 0; i3 < this.b; ++i3) {
                blArray[n2 + i3] = this.get_Item(i3);
            }
        } else if (object instanceof Byte[]) {
            int n3 = (this.b + 7) / 8;
            if (array.getLength() - n2 < n3) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i4 = 0; i4 < n3; ++i4) {
                byteArray[n2 + i4] = this.a(i4);
            }
        } else if (object instanceof byte[]) {
            int n4 = (this.b + 7) / 8;
            if (array.getLength() - n2 < n4) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i5 = 0; i5 < n4; ++i5) {
                byArray[n2 + i5] = this.a(i5);
            }
        } else if (object instanceof Integer[]) {
            Array.copy(Array.boxing(this.a), 0, array, n2, (this.b + 31) / 32);
        } else if (object instanceof int[]) {
            Array.copy(Array.boxing(this.a), 0, array, n2, (this.b + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n2 = (this.b + 31) / 32;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a[i2] = ~this.a[i2];
        }
        ++this.c;
        return this;
    }

    public BitArray and(BitArray bitArray) {
        this.b(bitArray);
        int n2 = (this.b + 31) / 32;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            this.a[n3] = this.a[n3] & bitArray.a[i2];
        }
        ++this.c;
        return this;
    }

    public BitArray or(BitArray bitArray) {
        this.b(bitArray);
        int n2 = (this.b + 31) / 32;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            this.a[n3] = this.a[n3] | bitArray.a[i2];
        }
        ++this.c;
        return this;
    }

    public BitArray xor(BitArray bitArray) {
        this.b(bitArray);
        int n2 = (this.b + 31) / 32;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2;
            this.a[n3] = this.a[n3] ^ bitArray.a[i2];
        }
        ++this.c;
        return this;
    }

    public boolean get(int n2) {
        if (n2 < 0 || n2 >= this.b) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.a[n2 >> 5] & 1 << (n2 & 0x1F)) != 0;
    }

    public void set(int n2, boolean bl2) {
        if (n2 < 0 || n2 >= this.b) {
            throw new ArgumentOutOfRangeException();
        }
        if (bl2) {
            int n3 = n2 >> 5;
            this.a[n3] = this.a[n3] | 1 << (n2 & 0x1F);
        } else {
            int n4 = n2 >> 5;
            this.a[n4] = this.a[n4] & ~(1 << (n2 & 0x1F));
        }
        ++this.c;
    }

    public void setAll(boolean bl2) {
        if (bl2) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2] = -1;
            }
        } else {
            Array.clear(Array.boxing(this.a), 0, this.a.length);
        }
        ++this.c;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    private static class BitArrayEnumerator
    implements IEnumerator,
    ICloneable,
    Cloneable {
        private BitArray a;
        private boolean b;
        private int c;
        private int d;

        @Override
        public Object deepClone() {
            return this.a();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray bitArray) {
            this.c = -1;
            this.a = bitArray;
            this.d = bitArray.c;
        }

        @Override
        public Object next() {
            if (this.c == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.c >= this.a.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.b;
        }

        @Override
        public boolean hasNext() {
            this.b();
            if (this.c < this.a.size() - 1) {
                this.b = this.a.get_Item(++this.c);
                return true;
            }
            this.c = this.a.size();
            return false;
        }

        @Override
        public void reset() {
            this.b();
            this.c = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void b() {
            if (this.d != this.a.c) {
                throw new InvalidOperationException();
            }
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.a = this.a;
            bitArrayEnumerator.b = this.b;
            bitArrayEnumerator.c = this.c;
            bitArrayEnumerator.d = this.d;
            return bitArrayEnumerator;
        }
    }
}

