/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Comparer;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Collections.IList;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.msArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ArrayList
implements IList,
List {
    private static final int a = 4;
    private Object[] b;
    private int c;
    private int d;
    private static Object[] e = new Object[0];

    protected int getVersion() {
        return this.d;
    }

    public ArrayList() {
        this.b = new Object[4];
    }

    public ArrayList(ICollection iCollection) {
        if (iCollection == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.b = new Object[iCollection.size()];
        this.addRange(iCollection);
    }

    public ArrayList(int n2) {
        if (n2 < 0) {
            ArrayList.a("capacity", (Object)n2, "The initial capacity can't be smaller than zero.");
        }
        if (n2 == 0) {
            n2 = 4;
        }
        this.b = new Object[n2];
    }

    private ArrayList(int n2, boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.b = null;
    }

    private ArrayList(Array array, int n2, int n3) {
        this.b = n3 == 0 ? new Object[4] : new Object[n3];
        Array.copy(array, n2, Array.boxing(this.b), 0, n3);
        this.c = n3;
    }

    @Override
    public Object get_Item(int n2) {
        if (n2 < 0 || n2 >= this.c) {
            ArrayList.a("index", (Object)n2, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.b[n2];
    }

    @Override
    public void set_Item(int n2, Object object) {
        if (n2 < 0 || n2 >= this.c) {
            ArrayList.a("index", (Object)n2, "Index is less than 0 or more than or equal to the list count.");
        }
        this.b[n2] = object;
        ++this.d;
    }

    @Override
    public int size() {
        return this.c;
    }

    public int getCapacity() {
        return this.b.length;
    }

    public void setCapacity(int n2) {
        if (n2 < this.c) {
            ArrayList.a("Capacity", (Object)n2, "Must be more than count.");
        }
        this.b = n2 > 0 ? Arrays.copyOf(this.b, n2) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void a(int n2) {
        int n3;
        if (n2 <= this.b.length) {
            return;
        }
        int n4 = n3 = this.b.length == 0 ? 4 : this.b.length * 2;
        if (n3 < n2) {
            n3 = n2;
        }
        this.setCapacity(n3);
    }

    private void a(int n2, int n3) {
        if (n3 > 0) {
            if (this.c + n3 > this.b.length) {
                int n4;
                int n5 = n4 = this.b.length > 0 ? this.b.length << 1 : 1;
                while (n4 < this.c + n3) {
                    n4 <<= 1;
                }
                Object[] objectArray = new Object[n4];
                Array.copy(Array.boxing(this.b), 0, Array.boxing(objectArray), 0, n2);
                Array.copy(Array.boxing(this.b), n2, Array.boxing(objectArray), n2 + n3, this.c - n2);
                this.b = objectArray;
            } else {
                Array.copy(Array.boxing(this.b), n2, Array.boxing(this.b), n2 + n3, this.c - n2);
            }
        } else if (n3 < 0) {
            int n6 = n2 - n3;
            Array.copy(Array.boxing(this.b), n6, Array.boxing(this.b), n2, this.c - n6);
            msArray.clear(this.b, this.c + n3, -n3);
        }
    }

    @Override
    public int addItem(Object object) {
        if (this.b.length <= this.c) {
            this.a(this.c + 1);
        }
        this.b[this.c] = object;
        ++this.d;
        return this.c++;
    }

    @Override
    public void clear() {
        msArray.clear(this.b, 0, this.c);
        this.c = 0;
        ++this.d;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object, 0, this.c) > -1;
    }

    boolean a(Object object, int n2, int n3) {
        return this.indexOf(object, n2, n3) > -1;
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public int indexOf(Object object, int n2) {
        return this.indexOf(object, n2, this.c - n2);
    }

    public int indexOf(Object object, int n2, int n3) {
        if (n2 < 0 || n2 > this.c) {
            ArrayList.a("startIndex", (Object)n2, "Does not specify valid index.");
        }
        if (n3 < 0) {
            ArrayList.a("count", (Object)n3, "Can't be less than 0.");
        }
        if (n2 > this.c - n3) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return msArray.indexOf(this.b, object, n2, n3);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.c - 1);
    }

    public int lastIndexOf(Object object, int n2) {
        return this.lastIndexOf(object, n2, n2 + 1);
    }

    public int lastIndexOf(Object object, int n2, int n3) {
        return msArray.lastIndexOf(this.b, object, n2, n3);
    }

    @Override
    public void insertItem(int n2, Object object) {
        if (n2 < 0 || n2 > this.c) {
            ArrayList.a("index", (Object)n2, "Index must be >= 0 and <= Count.");
        }
        this.a(n2, 1);
        this.b[n2] = object;
        ++this.c;
        ++this.d;
    }

    public void insertRange(int n2, ICollection iCollection) {
        int n3;
        if (iCollection == null) {
            throw new ArgumentNullException("c");
        }
        if (n2 < 0 || n2 > this.c) {
            ArrayList.a("index", (Object)n2, "Index must be >= 0 and <= Count.");
        }
        if ((n3 = iCollection.size()) > 0) {
            if (this.b.length < this.c + n3) {
                this.a(this.c + n3);
            }
            if (n2 < this.c) {
                Array.copy(Array.boxing(this.b), n2, Array.boxing(this.b), n2 + n3, this.c - n2);
            }
            if (this == iCollection.getSyncRoot()) {
                Array.copy(Array.boxing(this.b), 0, Array.boxing(this.b), n2, n2);
                Array.copy(Array.boxing(this.b), n2 + n3, Array.boxing(this.b), n2 << 1, this.c - n2);
            } else {
                iCollection.copyTo(Array.boxing(this.b), n2);
            }
            this.c += iCollection.size();
            ++this.d;
        }
    }

    public void insertRange(int n2, Object[] objectArray) {
        int n3;
        if (objectArray == null) {
            throw new ArgumentNullException("c");
        }
        if (n2 < 0 || n2 > this.c) {
            ArrayList.a("index", (Object)n2, "Index must be >= 0 and <= Count.");
        }
        if ((n3 = objectArray.length) > 0) {
            if (this.b.length < this.c + n3) {
                this.a(this.c + n3);
            }
            if (n2 < this.c) {
                Array.copy(Array.boxing(this.b), n2, Array.boxing(this.b), n2 + n3, this.c - n2);
            }
            Array.boxing(objectArray).copyTo(Array.boxing(this.b), n2);
            this.c += objectArray.length;
            ++this.d;
        }
    }

    @Override
    public void removeItem(Object object) {
        int n2 = this.indexOf(object);
        if (n2 > -1) {
            this.removeAt(n2);
        }
        ++this.d;
    }

    @Override
    public void removeAt(int n2) {
        if (n2 < 0 || n2 >= this.c) {
            ArrayList.a("index", (Object)n2, "Less than 0 or more than list count.");
        }
        this.a(n2, -1);
        --this.c;
        ++this.d;
    }

    public void removeRange(int n2, int n3) {
        ArrayList.a(n2, n3, this.c);
        this.a(n2, -n3);
        this.c -= n3;
        ++this.d;
    }

    public void reverse() {
        msArray.reverse(this.b, 0, this.c);
        ++this.d;
    }

    public void reverse(int n2, int n3) {
        ArrayList.a(n2, n3, this.c);
        msArray.reverse(this.b, n2, n3);
        ++this.d;
    }

    public void copyTo(Array array) {
        Array.copy(Array.boxing(this.b), 0, array, 0, this.c);
    }

    @Override
    public void copyTo(Array array, int n2) {
        this.copyTo(0, array, n2, this.c);
    }

    public void copyTo(int n2, Array array, int n3, int n4) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        Array.copy(Array.boxing(this.b), n2, array, n3, n4);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int n2, int n3) {
        ArrayList.a(n2, n3, this.c);
        return new ArrayListEnumerator(this, n2, n3);
    }

    public void addRange(ICollection iCollection) {
        if (iCollection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.c, iCollection);
    }

    public void addRange(Object[] objectArray) {
        if (objectArray == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.c, objectArray);
    }

    public int binarySearch(Object object) {
        if (object == null) {
            return -1;
        }
        try {
            return msArray.binarySearch(this.b, 0, this.c, object);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object object, Comparator comparator) {
        try {
            return msArray.binarySearch(this.b, 0, this.c, object, comparator);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int n2, int n3, Object object, Comparator comparator) {
        try {
            return msArray.binarySearch(this.b, n2, n3, object, comparator);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int n2, int n3) {
        ArrayList.a(n2, n3, this.c);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, n2, n3));
        }
        return new RangedArrayList(this, n2, n3);
    }

    public void setRange(int n2, ICollection iCollection) {
        if (iCollection == null) {
            throw new ArgumentNullException("c");
        }
        if (n2 < 0 || n2 + iCollection.size() > this.c) {
            throw new ArgumentOutOfRangeException("index");
        }
        iCollection.copyTo(Array.boxing(this.b), n2);
        ++this.d;
    }

    public void trimToSize() {
        this.setCapacity(this.c);
    }

    public void sort() {
        Arrays.sort(this.b, 0, this.c, Comparer.Default);
        ++this.d;
    }

    public void sort(Comparator comparator) {
        try {
            Arrays.sort(this.b, 0, this.c, comparator);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Array.sort(this.b, 0, this.c, comparator);
        }
    }

    public void sort(int n2, int n3, Comparator comparator) {
        ArrayList.a(n2, n3, this.c);
        Arrays.sort(this.b, n2, n2 + n3, comparator);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.c];
        this.copyTo(Array.boxing(objectArray));
        return objectArray;
    }

    public Array toArray(Type type) {
        Array array = Array.createInstance(type, this.c);
        this.copyTo(array);
        return array;
    }

    public Object deepClone() {
        return new ArrayList(Array.boxing(this.b), 0, this.c);
    }

    static void a(int n2, int n3, int n4) {
        if (n2 < 0) {
            ArrayList.a("index", (Object)n2, "Can't be less than 0.");
        }
        if (n3 < 0) {
            ArrayList.a("count", (Object)n3, "Can't be less than 0.");
        }
        if (n2 > n4 - n3) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void a(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList iList) {
        ArrayList arrayList;
        if (iList == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = iList instanceof ArrayList ? (ArrayList)iList : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(iList);
        if (iList.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList arrayList) {
        if (arrayList == null) {
            throw new ArgumentNullException("list");
        }
        if (arrayList.isSynchronized()) {
            return arrayList;
        }
        return new SynchronizedArrayListWrapper(arrayList);
    }

    public static IList sync(IList iList) {
        if (iList == null) {
            throw new ArgumentNullException("list");
        }
        if (iList.isSynchronized()) {
            return iList;
        }
        return new SynchronizedListWrapper(iList);
    }

    public static ArrayList readOnly(ArrayList arrayList) {
        if (arrayList == null) {
            throw new ArgumentNullException("list");
        }
        if (arrayList.isReadOnly()) {
            return arrayList;
        }
        return new ReadOnlyArrayListWrapper(arrayList);
    }

    public static IList readOnly(IList iList) {
        if (iList == null) {
            throw new ArgumentNullException("list");
        }
        if (iList.isReadOnly()) {
            return iList;
        }
        return new ReadOnlyListWrapper(iList);
    }

    public static ArrayList fixedSize(ArrayList arrayList) {
        if (arrayList == null) {
            throw new ArgumentNullException("list");
        }
        if (arrayList.isFixedSize()) {
            return arrayList;
        }
        return new FixedSizeArrayListWrapper(arrayList);
    }

    public static IList fixedSize(IList iList) {
        if (iList == null) {
            throw new ArgumentNullException("list");
        }
        if (iList.isFixedSize()) {
            return iList;
        }
        return new FixedSizeListWrapper(iList);
    }

    public static ArrayList repeat(Object object, int n2) {
        ArrayList arrayList = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.addItem(object);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length <= this.size()) {
            objectArray = new Object[this.size()];
        }
        this.copyTo(Array.boxing(objectArray));
        return objectArray;
    }

    @Override
    public boolean add(Object object) {
        int n2 = this.size();
        this.addItem(object);
        return this.size() != n2;
    }

    @Override
    public boolean remove(Object object) {
        int n2 = this.size();
        this.removeItem(object);
        return this.size() != n2;
    }

    @Override
    public boolean containsAll(Collection collection) {
        for (Object e2 : collection) {
            if (this.contains(e2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.addAll(this.c, collection);
    }

    public boolean addAll(int n2, Collection collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        int n3 = n2;
        int n4 = this.size();
        for (Object e2 : collection) {
            this.insertItem(n3++, e2);
        }
        return n4 != this.size();
    }

    @Override
    public boolean removeAll(Collection collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        int n2 = this.size();
        for (Object e2 : collection) {
            this.removeItem(e2);
        }
        return n2 != this.size();
    }

    @Override
    public boolean retainAll(Collection collection) {
        Object[] objectArray;
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        int n2 = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (collection.contains(object)) continue;
            this.remove(object);
        }
        return n2 != this.size();
    }

    public Object get(int n2) {
        return this.get_Item(n2);
    }

    public Object set(int n2, Object object) {
        Object object2 = this.get_Item(n2);
        this.set_Item(n2, object);
        return object2;
    }

    public void add(int n2, Object object) {
        this.insertItem(n2, object);
    }

    public Object remove(int n2) {
        Object object = this.get_Item(n2);
        this.removeAt(n2);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int n2) {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
        return new ListItr(n2);
    }

    public List subList(int n2, int n3) {
        int n4 = n3 - n2;
        ArrayList arrayList = this.getRange(n2, n4);
        return arrayList;
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList arrayList) {
        return arrayList;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List a;
        private int b;

        @Override
        protected int getVersion() {
            return this.a instanceof ArrayList ? ((ArrayList)this.a).getVersion() : this.b;
        }

        public ArrayListInternalized(List list) {
            this.a = list;
            if (list instanceof ArrayList) {
                this.b = ((ArrayList)list).getVersion();
            }
        }

        @Override
        public Object get_Item(int n2) {
            return this.a.get(n2);
        }

        @Override
        public void set_Item(int n2, Object object) {
            this.a.set(n2, object);
            ++this.b;
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.a.size());
        }

        @Override
        public void setCapacity(int n2) {
            if (n2 < this.a.size()) {
                throw new ArgumentOutOfRangeException("Capacity", n2, "Must be more than count.");
            }
            for (int i2 = 0; i2 < n2 - this.a.size(); ++i2) {
                this.a.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object object) {
            int n2 = this.a.size();
            this.a.add(object);
            ++this.b;
            return n2;
        }

        @Override
        public void clear() {
            this.a.clear();
            ++this.b;
        }

        @Override
        public boolean contains(Object object) {
            return this.a.contains(object);
        }

        @Override
        public int indexOf(Object object) {
            return this.a.indexOf(object);
        }

        @Override
        public int indexOf(Object object, int n2) {
            return this.indexOf(object, n2, this.a.size() - n2);
        }

        @Override
        public int indexOf(Object object, int n2, int n3) {
            if (n2 < 0 || n2 > this.a.size()) {
                throw new ArgumentOutOfRangeException("startIndex", n2, "Does not specify valid index.");
            }
            if (n3 < 0) {
                throw new ArgumentOutOfRangeException("count", n3, "Can't be less than 0.");
            }
            if (n2 > this.a.size() - n3) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return msArray.indexOf(this.a.toArray(), object, n2, n3);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.a.lastIndexOf(object);
        }

        @Override
        public int lastIndexOf(Object object, int n2) {
            return this.lastIndexOf(object, n2, n2 + 1);
        }

        @Override
        public int lastIndexOf(Object object, int n2, int n3) {
            return msArray.lastIndexOf(this.a.toArray(), object, n2, n3);
        }

        @Override
        public void insertItem(int n2, Object object) {
            if (n2 < 0 || n2 > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", n2, "Index must be >= 0 and <= Count.");
            }
            this.a.add(n2, object);
            ++this.b;
        }

        @Override
        public void insertRange(int n2, ICollection iCollection) {
            if (iCollection == null) {
                throw new ArgumentNullException("c");
            }
            if (n2 < 0 || n2 > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", n2, "Index must be >= 0 and <= Count.");
            }
            for (Object e2 : iCollection) {
                this.a.add(n2++, e2);
            }
            ++this.b;
        }

        @Override
        public void insertRange(int n2, Object[] objectArray) {
            if (objectArray == null) {
                throw new ArgumentNullException("c");
            }
            if (n2 < 0 || n2 > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", n2, "Index must be >= 0 and <= Count.");
            }
            for (Object object : objectArray) {
                this.a.add(n2++, object);
            }
            ++this.b;
        }

        @Override
        public void removeItem(Object object) {
            this.a.remove(object);
            ++this.b;
        }

        @Override
        public void removeAt(int n2) {
            if (n2 < 0 || n2 > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", n2, "Index must be >= 0 and <= Count.");
            }
            this.a.remove(n2);
            ++this.b;
        }

        @Override
        public void removeRange(int n2, int n3) {
            if (n2 < 0 || n2 > this.a.size()) {
                throw new ArgumentOutOfRangeException("index", n2, "Index must be >= 0 and <= Count.");
            }
            if (n3 < 0) {
                throw new ArgumentOutOfRangeException("count", n3, "Can't be less than 0.");
            }
            if (n2 > this.a.size() - n3) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                this.a.remove(n2);
            }
            ++this.b;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.a.size());
        }

        @Override
        public void reverse(int n2, int n3) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("index", n2, "Can't be less than 0.");
            }
            if (n3 < 0) {
                throw new ArgumentOutOfRangeException("count", n3, "Can't be less than 0.");
            }
            if (n2 > this.a.size() - n3) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n4 = n2;
            for (int i2 = n2 + this.a.size() - 1; n4 < i2; ++n4, --i2) {
                Object e2 = this.a.get(n4);
                this.a.set(n4, this.a.get(i2));
                this.a.set(i2, e2);
            }
            ++this.b;
        }

        @Override
        public void copyTo(Array array) {
            Array.copy(Array.boxing(this.a.toArray()), 0, array, 0, this.a.size());
        }

        @Override
        public void copyTo(Array array, int n2) {
            this.copyTo(0, array, n2, this.a.size());
        }

        @Override
        public void copyTo(int n2, Array array, int n3, int n4) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.getRank() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            Array.copy(Array.boxing(this.a.toArray()), n2, array, n3, n4);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int n2, int n3) {
            ArrayList.a(n2, n3, this.a.size());
            return new ArrayListEnumerator(this, n2, n3);
        }

        @Override
        public void addRange(ICollection iCollection) {
            if (iCollection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), iCollection);
        }

        @Override
        public void addRange(Object[] objectArray) {
            if (objectArray == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.a.size(), objectArray);
        }

        @Override
        public int binarySearch(Object object) {
            if (object == null) {
                return -1;
            }
            try {
                return msArray.binarySearch(this.a.toArray(), 0, this.a.size(), object);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            try {
                return msArray.binarySearch(this.a.toArray(), 0, this.a.size(), object, comparator);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int n2, int n3, Object object, Comparator comparator) {
            try {
                return msArray.binarySearch(this.a.toArray(), n2, n3, object, comparator);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int n2, int n3) {
            ArrayList.a(n2, n3, this.a.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, n2, n3));
            }
            return new RangedArrayList(this, n2, n3);
        }

        @Override
        public void setRange(int n2, ICollection iCollection) {
            if (iCollection == null) {
                throw new ArgumentNullException("c");
            }
            if (n2 < 0 || n2 + iCollection.size() > this.a.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e2 : iCollection) {
                this.a.set(n2++, e2);
            }
            ++this.b;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.a, null);
            ++this.b;
        }

        @Override
        public void sort(Comparator comparator) {
            Collections.sort(this.a, comparator);
            ++this.b;
        }

        @Override
        public void sort(int n2, int n3, Comparator comparator) {
            if (n2 < 0) {
                throw new ArgumentOutOfRangeException("index", n2, "Can't be less than 0.");
            }
            if (n3 < 0) {
                throw new ArgumentOutOfRangeException("count", n3, "Can't be less than 0.");
            }
            if (n2 > this.a.size() - n3) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.a.subList(n2, n3);
            if (comparator == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparator);
            }
            for (int i2 = n2; i2 < n3; ++i2) {
                this.a.set(i2, list.get(i2 - n2));
            }
            ++this.b;
        }

        @Override
        public Object[] toArray() {
            return this.a.toArray();
        }

        @Override
        public Array toArray(Type type) {
            Array array = Array.createInstance(type, this.a.size());
            this.copyTo(array);
            return array;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.a.size()];
            Array.copy(Array.boxing(this.a.toArray()), 0, Array.boxing(objectArray), 0, this.a.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            for (Object e2 : arrayList) {
                arrayList.add(e2);
            }
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.a.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] objectArray) {
            return this.a.toArray(objectArray);
        }

        @Override
        public boolean add(Object object) {
            ++this.b;
            return this.a.add(object);
        }

        @Override
        public boolean remove(Object object) {
            ++this.b;
            return this.a.remove(object);
        }

        @Override
        public boolean containsAll(Collection collection) {
            return this.a.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection collection) {
            ++this.b;
            return this.a.addAll(collection);
        }

        @Override
        public boolean addAll(int n2, Collection collection) {
            ++this.b;
            return this.a.addAll(n2, collection);
        }

        @Override
        public boolean removeAll(Collection collection) {
            ++this.b;
            return this.a.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection collection) {
            ++this.b;
            return this.a.retainAll(collection);
        }

        @Override
        public Object get(int n2) {
            return this.a.get(n2);
        }

        @Override
        public Object set(int n2, Object object) {
            ++this.b;
            return this.a.set(n2, object);
        }

        @Override
        public void add(int n2, Object object) {
            this.a.add(n2, object);
            ++this.b;
        }

        @Override
        public Object remove(int n2) {
            ++this.b;
            return this.a.remove(n2);
        }

        @Override
        public ListIterator listIterator() {
            return this.a.listIterator();
        }

        @Override
        public ListIterator listIterator(int n2) {
            return this.a.listIterator(n2);
        }

        @Override
        public List subList(int n2, int n3) {
            return this.a.subList(n2, n3);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int n2) {
            this.a = n2;
        }

        @Override
        public boolean hasPrevious() {
            return this.a != 0;
        }

        @Override
        public int nextIndex() {
            return this.a;
        }

        @Override
        public int previousIndex() {
            return this.a - 1;
        }

        public Object previous() {
            int n2 = this.a - 1;
            if (n2 < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.b;
            if (n2 >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n2;
            this.b = n2;
            return objectArray[this.b];
        }

        public void set(Object object) {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).b[this.b] = object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object object) {
            try {
                int n2 = this.a;
                ArrayList.this.add(n2, object);
                this.a = n2 + 1;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int a;
        int b = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.a != ArrayList.this.size();
        }

        public Object next() {
            int n2 = this.a;
            if (n2 >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.b;
            if (n2 >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.a = n2 + 1;
            this.b = n2;
            return objectArray[this.b];
        }

        @Override
        public void remove() {
            if (this.b < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.b);
                this.a = this.b;
                this.b = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class ListWrapper
    implements IList {
        protected IList a;

        public ListWrapper(IList iList) {
            this.a = iList;
        }

        @Override
        public Object get_Item(int n2) {
            return this.a.get_Item(n2);
        }

        @Override
        public void set_Item(int n2, Object object) {
            this.a.set_Item(n2, object);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.a.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.a.isReadOnly();
        }

        @Override
        public int addItem(Object object) {
            return this.a.addItem(object);
        }

        @Override
        public void clear() {
            this.a.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.a.contains(object);
        }

        @Override
        public int indexOf(Object object) {
            return this.a.indexOf(object);
        }

        @Override
        public void insertItem(int n2, Object object) {
            this.a.insertItem(n2, object);
        }

        @Override
        public void removeItem(Object object) {
            this.a.removeItem(object);
        }

        @Override
        public void removeAt(int n2) {
            this.a.removeAt(n2);
        }

        @Override
        public void copyTo(Array array, int n2) {
            this.a.copyTo(array, n2);
        }

        @Override
        public IEnumerator iterator() {
            return this.a.iterator();
        }
    }

    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String a() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList iList) {
            super(iList);
        }

        @Override
        public Object get_Item(int n2) {
            return this.a.get_Item(n2);
        }

        @Override
        public void set_Item(int n2, Object object) {
            throw new NotSupportedException(this.a());
        }
    }

    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String a() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList iList) {
            super(iList);
        }

        @Override
        public int addItem(Object object) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void insertItem(int n2, Object object) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeItem(Object object) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeAt(int n2) {
            throw new NotSupportedException(this.a());
        }
    }

    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private Object b;

        public SynchronizedListWrapper(IList iList) {
            super(iList);
            this.b = iList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.b;
            synchronized (object) {
                return this.a.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.b;
            synchronized (object) {
                return this.a.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.b;
            synchronized (object) {
                return this.a.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.b;
            synchronized (object) {
                return this.a.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int n2) {
            Object object = this.b;
            synchronized (object) {
                return this.a.get_Item(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int n2, Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                this.a.set_Item(n2, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.addItem(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.b;
            synchronized (object) {
                this.a.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int n2, Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                this.a.insertItem(n2, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                this.a.removeItem(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int n2) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeAt(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(Array array, int n2) {
            Object object = this.b;
            synchronized (object) {
                this.a.copyTo(array, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.b;
            synchronized (object) {
                return this.a.iterator();
            }
        }
    }

    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int b;
        private int c;
        private int d;

        public RangedArrayList(ArrayList arrayList, int n2, int n3) {
            super(arrayList);
            this.b = n2;
            this.c = n3;
            this.d = arrayList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int n2) {
            if (n2 < 0 || n2 > this.c) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.a.get_Item(this.b + n2);
        }

        @Override
        public void set_Item(int n2, Object object) {
            if (n2 < 0 || n2 > this.c) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.a.set_Item(this.b + n2, object);
        }

        @Override
        public int size() {
            this.a();
            return this.c;
        }

        @Override
        public int getCapacity() {
            return this.a.getCapacity();
        }

        @Override
        public void setCapacity(int n2) {
            if (n2 < this.c) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void a() {
            if (this.d != this.a.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object object) {
            this.a();
            this.a.insertItem(this.b + this.c, object);
            this.d = this.a.getVersion();
            return ++this.c;
        }

        @Override
        public void clear() {
            this.a();
            this.a.removeRange(this.b, this.c);
            this.c = 0;
            this.d = this.a.getVersion();
        }

        @Override
        public boolean contains(Object object) {
            return this.a.a(object, this.b, this.c);
        }

        @Override
        public int indexOf(Object object) {
            return this.indexOf(object, 0);
        }

        @Override
        public int indexOf(Object object, int n2) {
            return this.indexOf(object, n2, this.c - n2);
        }

        @Override
        public int indexOf(Object object, int n2, int n3) {
            if (n2 < 0 || n2 > this.c) {
                RangedArrayList.a("startIndex", (Object)n2, "Does not specify valid index.");
            }
            if (n3 < 0) {
                RangedArrayList.a("count", (Object)n3, "Can't be less than 0.");
            }
            if (n2 > this.c - n3) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n4 = this.a.indexOf(object, this.b + n2, n3);
            if (n4 == -1) {
                return -1;
            }
            return n4 - this.b;
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.lastIndexOf(object, this.c - 1);
        }

        @Override
        public int lastIndexOf(Object object, int n2) {
            return this.lastIndexOf(object, n2, n2 + 1);
        }

        @Override
        public int lastIndexOf(Object object, int n2, int n3) {
            int n4;
            if (n2 < 0) {
                RangedArrayList.a("startIndex", (Object)n2, "< 0");
            }
            if (n3 < 0) {
                RangedArrayList.a("count", (Object)n3, "count is negative.");
            }
            if ((n4 = this.a.lastIndexOf(object, this.b + n2, n3)) == -1) {
                return -1;
            }
            return n4 - this.b;
        }

        @Override
        public void insertItem(int n2, Object object) {
            this.a();
            if (n2 < 0 || n2 > this.c) {
                RangedArrayList.a("index", (Object)n2, "Index must be >= 0 and <= Count.");
            }
            this.a.insertItem(this.b + n2, object);
            ++this.c;
            this.d = this.a.getVersion();
        }

        @Override
        public void insertRange(int n2, ICollection iCollection) {
            this.a();
            if (n2 < 0 || n2 > this.c) {
                RangedArrayList.a("index", (Object)n2, "Index must be >= 0 and <= Count.");
            }
            this.a.insertRange(this.b + n2, iCollection);
            this.c += iCollection.size();
            this.d = this.a.getVersion();
        }

        @Override
        public void removeItem(Object object) {
            this.a();
            int n2 = this.indexOf(object);
            if (n2 > -1) {
                this.removeAt(n2);
            }
            this.d = this.a.getVersion();
        }

        @Override
        public void removeAt(int n2) {
            this.a();
            if (n2 < 0 || n2 > this.c) {
                RangedArrayList.a("index", (Object)n2, "Index must be >= 0 and <= Count.");
            }
            this.a.removeAt(this.b + n2);
            --this.c;
            this.d = this.a.getVersion();
        }

        @Override
        public void removeRange(int n2, int n3) {
            this.a();
            RangedArrayList.a(n2, n3, this.c);
            this.a.removeRange(this.b + n2, n3);
            this.c -= n3;
            this.d = this.a.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.c);
        }

        @Override
        public void reverse(int n2, int n3) {
            this.a();
            RangedArrayList.a(n2, n3, this.c);
            this.a.reverse(this.b + n2, n3);
            this.d = this.a.getVersion();
        }

        @Override
        public void setRange(int n2, ICollection iCollection) {
            this.a();
            if (n2 < 0 || n2 > this.c) {
                RangedArrayList.a("index", (Object)n2, "Index must be >= 0 and <= Count.");
            }
            this.a.setRange(this.b + n2, iCollection);
            this.d = this.a.getVersion();
        }

        @Override
        public void copyTo(Array array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(Array array, int n2) {
            this.copyTo(0, array, n2, this.c);
        }

        @Override
        public void copyTo(int n2, Array array, int n3, int n4) {
            RangedArrayList.a(n2, n4, this.c);
            this.a.copyTo(this.b + n2, array, n3, n4);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.c);
        }

        @Override
        public IEnumerator iterator(int n2, int n3) {
            RangedArrayList.a(n2, n3, this.c);
            return this.a.iterator(this.b + n2, n3);
        }

        @Override
        public void addRange(ICollection iCollection) {
            this.a();
            this.a.insertRange(this.c, iCollection);
            this.c += iCollection.size();
            this.d = this.a.getVersion();
        }

        @Override
        public int binarySearch(Object object) {
            return this.binarySearch(0, this.c, object, Comparer.Default);
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            return this.binarySearch(0, this.c, object, comparator);
        }

        @Override
        public int binarySearch(int n2, int n3, Object object, Comparator comparator) {
            RangedArrayList.a(n2, n3, this.c);
            return this.a.binarySearch(this.b + n2, n3, object, comparator);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.a.deepClone(), this.b, this.c);
        }

        @Override
        public ArrayList getRange(int n2, int n3) {
            RangedArrayList.a(n2, n3, this.c);
            return new RangedArrayList(this, n2, n3);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparator) {
            this.sort(0, this.c, comparator);
        }

        @Override
        public void sort(int n2, int n3, Comparator comparator) {
            this.a();
            RangedArrayList.a(n2, n3, this.c);
            this.a.sort(this.b + n2, n3, comparator);
            this.d = this.a.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.c];
            this.a.copyTo(this.b, Array.boxing(objectArray), 0, this.c);
            return objectArray;
        }

        @Override
        public Array toArray(Type type) {
            Array array = Array.createInstance(type, this.c);
            this.a.copyTo(this.b, array, 0, this.c);
            return array;
        }
    }

    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String a() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList arrayList) {
            super(arrayList);
        }

        @Override
        public Object get_Item(int n2) {
            return this.a.get_Item(n2);
        }

        @Override
        public void set_Item(int n2, Object object) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void reverse(int n2, int n3) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void setRange(int n2, ICollection iCollection) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void sort(Comparator comparator) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void sort(int n2, int n3, Comparator comparator) {
            throw new NotSupportedException(this.a());
        }
    }

    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList arrayList) {
            super(arrayList);
        }

        protected String a() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int n2) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object object) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void addRange(ICollection iCollection) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void insertItem(int n2, Object object) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void insertRange(int n2, ICollection iCollection) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void insertRange(int n2, Object[] objectArray) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeItem(Object object) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeAt(int n2) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void removeRange(int n2, int n3) {
            throw new NotSupportedException(this.a());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.a());
        }
    }

    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private Object b;

        SynchronizedArrayListWrapper(ArrayList arrayList) {
            super(arrayList);
            this.b = arrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int n2) {
            Object object = this.b;
            synchronized (object) {
                return this.a.get_Item(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int n2, Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                this.a.set_Item(n2, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.b;
            synchronized (object) {
                return this.a.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.b;
            synchronized (object) {
                return this.a.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int n2) {
            Object object = this.b;
            synchronized (object) {
                this.a.setCapacity(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.b;
            synchronized (object) {
                return this.a.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.b;
            synchronized (object) {
                return this.a.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.addItem(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.b;
            synchronized (object) {
                this.a.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.contains(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object object, int n2) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.indexOf(object, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object object, int n2, int n3) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.indexOf(object, n2, n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.lastIndexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object object, int n2) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.lastIndexOf(object, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object object, int n2, int n3) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.lastIndexOf(object, n2, n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int n2, Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                this.a.insertItem(n2, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int n2, ICollection iCollection) {
            Object object = this.b;
            synchronized (object) {
                this.a.insertRange(n2, iCollection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                this.a.removeItem(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int n2) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeAt(n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int n2, int n3) {
            Object object = this.b;
            synchronized (object) {
                this.a.removeRange(n2, n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.b;
            synchronized (object) {
                this.a.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int n2, int n3) {
            Object object = this.b;
            synchronized (object) {
                this.a.reverse(n2, n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(Array array) {
            Object object = this.b;
            synchronized (object) {
                this.a.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(Array array, int n2) {
            Object object = this.b;
            synchronized (object) {
                this.a.copyTo(array, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int n2, Array array, int n3, int n4) {
            Object object = this.b;
            synchronized (object) {
                this.a.copyTo(n2, array, n3, n4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.b;
            synchronized (object) {
                return this.a.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int n2, int n3) {
            Object object = this.b;
            synchronized (object) {
                return this.a.iterator(n2, n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection iCollection) {
            Object object = this.b;
            synchronized (object) {
                this.a.addRange(iCollection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object object) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.binarySearch(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object object, Comparator comparator) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.binarySearch(object, comparator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int n2, int n3, Object object, Comparator comparator) {
            Object object2 = this.b;
            synchronized (object2) {
                return this.a.binarySearch(n2, n3, object, comparator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.b;
            synchronized (object) {
                return this.a.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int n2, int n3) {
            Object object = this.b;
            synchronized (object) {
                return this.a.getRange(n2, n3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.b;
            synchronized (object) {
                this.a.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.b;
            synchronized (object) {
                this.a.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparator) {
            Object object = this.b;
            synchronized (object) {
                this.a.sort(comparator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int n2, int n3, Comparator comparator) {
            Object object = this.b;
            synchronized (object) {
                this.a.sort(n2, n3, comparator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.b;
            synchronized (object) {
                return this.a.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Array toArray(Type type) {
            Object object = this.b;
            synchronized (object) {
                return this.a.toArray(type);
            }
        }
    }

    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList a;

        public ArrayListWrapper(ArrayList arrayList) {
            this.a = arrayList;
        }

        @Override
        public Object get_Item(int n2) {
            return this.a.get_Item(n2);
        }

        @Override
        public void set_Item(int n2, Object object) {
            this.a.set_Item(n2, object);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public int getCapacity() {
            return this.a.getCapacity();
        }

        @Override
        public void setCapacity(int n2) {
            this.a.setCapacity(n2);
        }

        @Override
        public boolean isFixedSize() {
            return this.a.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.a.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public int addItem(Object object) {
            return this.a.addItem(object);
        }

        @Override
        public void clear() {
            this.a.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.a.contains(object);
        }

        @Override
        public int indexOf(Object object) {
            return this.a.indexOf(object);
        }

        @Override
        public int indexOf(Object object, int n2) {
            return this.a.indexOf(object, n2);
        }

        @Override
        public int indexOf(Object object, int n2, int n3) {
            return this.a.indexOf(object, n2, n3);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.a.lastIndexOf(object);
        }

        @Override
        public int lastIndexOf(Object object, int n2) {
            return this.a.lastIndexOf(object, n2);
        }

        @Override
        public int lastIndexOf(Object object, int n2, int n3) {
            return this.a.lastIndexOf(object, n2, n3);
        }

        @Override
        public void insertItem(int n2, Object object) {
            this.a.insertItem(n2, object);
        }

        @Override
        public void insertRange(int n2, ICollection iCollection) {
            this.a.insertRange(n2, iCollection);
        }

        @Override
        public void removeItem(Object object) {
            this.a.removeItem(object);
        }

        @Override
        public void removeAt(int n2) {
            this.a.removeAt(n2);
        }

        @Override
        public void removeRange(int n2, int n3) {
            this.a.removeRange(n2, n3);
        }

        @Override
        public void reverse() {
            this.a.reverse();
        }

        @Override
        public void reverse(int n2, int n3) {
            this.a.reverse(n2, n3);
        }

        @Override
        public void setRange(int n2, ICollection iCollection) {
            this.a.setRange(n2, iCollection);
        }

        @Override
        public void copyTo(Array array) {
            this.a.copyTo(array);
        }

        @Override
        public void copyTo(Array array, int n2) {
            this.a.copyTo(array, n2);
        }

        @Override
        public void copyTo(int n2, Array array, int n3, int n4) {
            this.a.copyTo(n2, array, n3, n4);
        }

        @Override
        public IEnumerator iterator() {
            return this.a.iterator();
        }

        @Override
        public IEnumerator iterator(int n2, int n3) {
            return this.a.iterator(n2, n3);
        }

        @Override
        public void addRange(ICollection iCollection) {
            this.a.addRange(iCollection);
        }

        @Override
        public int binarySearch(Object object) {
            return this.a.binarySearch(object);
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            return this.a.binarySearch(object, comparator);
        }

        @Override
        public int binarySearch(int n2, int n3, Object object, Comparator comparator) {
            return this.a.binarySearch(n2, n3, object, comparator);
        }

        @Override
        public Object deepClone() {
            return this.a.deepClone();
        }

        @Override
        public ArrayList getRange(int n2, int n3) {
            return this.a.getRange(n2, n3);
        }

        @Override
        public void trimToSize() {
            this.a.trimToSize();
        }

        @Override
        public void sort() {
            this.a.sort();
        }

        @Override
        public void sort(Comparator comparator) {
            this.a.sort(comparator);
        }

        @Override
        public void sort(int n2, int n3, Comparator comparator) {
            this.a.sort(n2, n3, comparator);
        }

        @Override
        public Object[] toArray() {
            return this.a.toArray();
        }

        @Override
        public Array toArray(Type type) {
            return this.a.toArray(type);
        }
    }

    private static final class ArrayListAdapter
    extends ArrayList {
        private IList a;

        public ArrayListAdapter(IList iList) {
            super(0, true);
            this.a = iList;
        }

        @Override
        public Object get_Item(int n2) {
            return this.a.get_Item(n2);
        }

        @Override
        public void set_Item(int n2, Object object) {
            this.a.set_Item(n2, object);
        }

        @Override
        public int size() {
            return this.a.size();
        }

        @Override
        public int getCapacity() {
            return this.a.size();
        }

        @Override
        public void setCapacity(int n2) {
            if (n2 < this.a.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.a.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.a.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.a.getSyncRoot();
        }

        @Override
        public int addItem(Object object) {
            return this.a.addItem(object);
        }

        @Override
        public void clear() {
            this.a.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.a.contains(object);
        }

        @Override
        public int indexOf(Object object) {
            return this.a.indexOf(object);
        }

        @Override
        public int indexOf(Object object, int n2) {
            return this.indexOf(object, n2, this.a.size() - n2);
        }

        @Override
        public int indexOf(Object object, int n2, int n3) {
            if (n2 < 0 || n2 > this.a.size()) {
                ArrayListAdapter.a("startIndex", (Object)n2, "Does not specify valid index.");
            }
            if (n3 < 0) {
                ArrayListAdapter.a("count", (Object)n3, "Can't be less than 0.");
            }
            if (n2 > this.a.size() - n3) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (object == null) {
                for (int i2 = n2; i2 < n2 + n3; ++i2) {
                    if (this.a.get_Item(i2) != null) continue;
                    return i2;
                }
            } else {
                for (int i3 = n2; i3 < n2 + n3; ++i3) {
                    if (!object.equals(this.a.get_Item(i3))) continue;
                    return i3;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.lastIndexOf(object, this.a.size() - 1);
        }

        @Override
        public int lastIndexOf(Object object, int n2) {
            return this.lastIndexOf(object, n2, n2 + 1);
        }

        @Override
        public int lastIndexOf(Object object, int n2, int n3) {
            if (n2 < 0) {
                ArrayListAdapter.a("startIndex", (Object)n2, "< 0");
            }
            if (n3 < 0) {
                ArrayListAdapter.a("count", (Object)n3, "count is negative.");
            }
            if (n2 - n3 + 1 < 0) {
                ArrayListAdapter.a("count", (Object)n3, "count is too large.");
            }
            if (object == null) {
                for (int i2 = n2; i2 > n2 - n3; --i2) {
                    if (this.a.get_Item(i2) != null) continue;
                    return i2;
                }
            } else {
                for (int i3 = n2; i3 > n2 - n3; --i3) {
                    if (!object.equals(this.a.get_Item(i3))) continue;
                    return i3;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int n2, Object object) {
            this.a.insertItem(n2, object);
        }

        @Override
        public void insertRange(int n2, ICollection iCollection) {
            if (iCollection == null) {
                throw new ArgumentNullException("c");
            }
            if (n2 > this.a.size()) {
                ArrayListAdapter.a("index", (Object)n2, "Index must be >= 0 and <= Count.");
            }
            for (Object e2 : iCollection) {
                this.a.insertItem(n2++, e2);
            }
        }

        @Override
        public void removeItem(Object object) {
            this.a.removeItem(object);
        }

        @Override
        public void removeAt(int n2) {
            this.a.removeAt(n2);
        }

        @Override
        public void removeRange(int n2, int n3) {
            ArrayListAdapter.a(n2, n3, this.a.size());
            for (int i2 = 0; i2 < n3; ++i2) {
                this.a.removeAt(n2);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.a.size());
        }

        @Override
        public void reverse(int n2, int n3) {
            ArrayListAdapter.a(n2, n3, this.a.size());
            for (int i2 = 0; i2 < n3 / 2; ++i2) {
                Object object = this.a.get_Item(i2 + n2);
                this.a.set_Item(i2 + n2, this.a.get_Item(n2 + n3 - i2 + n2 - 1));
                this.a.set_Item(n2 + n3 - i2 + n2 - 1, object);
            }
        }

        @Override
        public void setRange(int n2, ICollection iCollection) {
            if (iCollection == null) {
                throw new ArgumentNullException("c");
            }
            if (n2 < 0 || n2 + iCollection.size() > this.a.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n3 = n2;
            for (Object e2 : iCollection) {
                this.a.set_Item(n3++, e2);
            }
        }

        @Override
        public void copyTo(Array array) {
            this.a.copyTo(array, 0);
        }

        @Override
        public void copyTo(Array array, int n2) {
            this.a.copyTo(array, n2);
        }

        @Override
        public void copyTo(int n2, Array array, int n3, int n4) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (n2 < 0) {
                ArrayListAdapter.a("index", (Object)n2, "Can't be less than zero.");
            }
            if (n3 < 0) {
                ArrayListAdapter.a("arrayIndex", (Object)n3, "Can't be less than zero.");
            }
            if (n4 < 0) {
                ArrayListAdapter.a("index", (Object)n2, "Can't be less than zero.");
            }
            if (array.getRank() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.getLength() - n3 < n4) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (n2 > this.a.size() - n4) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                array.setValue(this.a.get_Item(n2 + i2), n3 + i2);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.a.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.a.iterator();
        }

        @Override
        public IEnumerator iterator(int n2, int n3) {
            ArrayListAdapter.a(n2, n3, this.a.size());
            return new EnumeratorWithRange(this.a.iterator(), n2, n3);
        }

        @Override
        public void addRange(ICollection iCollection) {
            for (Object e2 : iCollection) {
                this.a.addItem(e2);
            }
        }

        @Override
        public int binarySearch(Object object) {
            return this.binarySearch(object, null);
        }

        @Override
        public int binarySearch(Object object, Comparator comparator) {
            return this.binarySearch(0, this.a.size(), object, comparator);
        }

        @Override
        public int binarySearch(int n2, int n3, Object object, Comparator comparator) {
            ArrayListAdapter.a(n2, n3, this.a.size());
            if (comparator == null) {
                comparator = Comparer.Default;
            }
            int n4 = n2;
            int n5 = n2 + n3 - 1;
            while (n4 <= n5) {
                int n6;
                int n7 = n4 + (n5 - n4) / 2;
                try {
                    n6 = comparator.compare(object, this.a.get_Item(n7));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n6 < 0) {
                    n5 = n7 - 1;
                    continue;
                }
                if (n6 > 0) {
                    n4 = n7 + 1;
                    continue;
                }
                return n7;
            }
            return ~n4;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.a);
        }

        @Override
        public ArrayList getRange(int n2, int n3) {
            ArrayListAdapter.a(n2, n3, this.a.size());
            return new RangedArrayList(this, n2, n3);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparator) {
            this.sort(0, this.a.size(), comparator);
        }

        @Override
        public void sort(int n2, int n3, Comparator comparator) {
            ArrayListAdapter.a(n2, n3, this.a.size());
            if (comparator == null) {
                comparator = Comparer.Default;
            }
            ArrayListAdapter.a(this.a, n2, n2 + n3 - 1, comparator);
        }

        private static void a(IList iList, int n2, int n3) {
            Object object = iList.get_Item(n2);
            iList.set_Item(n2, iList.get_Item(n3));
            iList.set_Item(n3, object);
        }

        static void a(IList iList, int n2, int n3, Comparator comparator) {
            if (n2 >= n3) {
                return;
            }
            int n4 = n2 + (n3 - n2) / 2;
            if (comparator.compare(iList.get_Item(n4), iList.get_Item(n2)) < 0) {
                ArrayListAdapter.a(iList, n4, n2);
            }
            if (comparator.compare(iList.get_Item(n3), iList.get_Item(n2)) < 0) {
                ArrayListAdapter.a(iList, n3, n2);
            }
            if (comparator.compare(iList.get_Item(n3), iList.get_Item(n4)) < 0) {
                ArrayListAdapter.a(iList, n3, n4);
            }
            if (n3 - n2 + 1 <= 3) {
                return;
            }
            ArrayListAdapter.a(iList, n3 - 1, n4);
            Object object = iList.get_Item(n3 - 1);
            int n5 = n2;
            int n6 = n3 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n5), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n6), object) > 0) {
                }
                if (n5 >= n6) break;
                ArrayListAdapter.a(iList, n5, n6);
            }
            ArrayListAdapter.a(iList, n3 - 1, n5);
            ArrayListAdapter.a(iList, n2, n5 - 1, comparator);
            ArrayListAdapter.a(iList, n5 + 1, n3, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.a.size()];
            this.a.copyTo(Array.boxing(objectArray), 0);
            return objectArray;
        }

        @Override
        public Array toArray(Type type) {
            Array array = Array.createInstance(type, this.a.size());
            this.a.copyTo(array, 0);
            return array;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        ICloneable,
        Cloneable {
            private int a;
            private int b;
            private int c;
            private IEnumerator d;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator iEnumerator, int n2, int n3) {
                this.b = 0;
                this.a = n2;
                this.c = n3;
                this.d = iEnumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.a();
            }

            @Override
            public Object next() {
                return this.d.next();
            }

            @Override
            public boolean hasNext() {
                if (this.b >= this.c) {
                    return false;
                }
                ++this.b;
                return this.d.hasNext();
            }

            @Override
            public void reset() {
                this.b = 0;
                this.d.reset();
                for (int i2 = 0; i2 < this.a; ++i2) {
                    this.d.hasNext();
                }
            }

            protected Object a() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.a = this.a;
                enumeratorWithRange.b = this.b;
                enumeratorWithRange.c = this.c;
                enumeratorWithRange.d = this.d;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    ICloneable,
    Cloneable {
        private ArrayList b;
        private Object c;
        private int d;
        private int e;
        static Object a = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList arrayList) {
            this.b = arrayList;
            this.d = -1;
            this.e = arrayList.getVersion();
            this.c = a;
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        @Override
        public boolean hasNext() {
            if (this.e != this.b.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.d < this.b.size()) {
                this.c = this.b.get_Item(this.d);
                return true;
            }
            this.c = a;
            return false;
        }

        @Override
        public Object next() {
            if (this.c == a) {
                if (this.d == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.c;
        }

        @Override
        public void reset() {
            if (this.e != this.b.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.c = a;
            this.d = -1;
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.b = this.b;
            simpleEnumerator.c = this.c;
            simpleEnumerator.d = this.d;
            simpleEnumerator.e = this.e;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    ICloneable,
    Cloneable {
        private Object a;
        private ArrayList b;
        private int c;
        private int d;
        private int e;
        private int f;

        private ArrayListEnumerator() {
        }

        public ArrayListEnumerator(ArrayList arrayList) {
            this(arrayList, 0, arrayList.size());
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        public ArrayListEnumerator(ArrayList arrayList, int n2, int n3) {
            this.b = arrayList;
            this.d = n2;
            this.e = n3;
            this.c = this.d - 1;
            this.a = null;
            this.f = arrayList.getVersion();
        }

        @Override
        public Object next() {
            if (this.c == this.d - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.a;
        }

        @Override
        public boolean hasNext() {
            if (this.b.getVersion() != this.f) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.c;
            if (this.c - this.d < this.e) {
                this.a = this.b.get_Item(this.c);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.a = null;
            this.c = this.d - 1;
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.a = this.a;
            arrayListEnumerator.b = this.b;
            arrayListEnumerator.c = this.c;
            arrayListEnumerator.d = this.d;
            arrayListEnumerator.e = this.e;
            arrayListEnumerator.f = this.f;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

