/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.forms;

import com.aspose.html.HTMLButtonElement;
import com.aspose.html.HTMLDocument;
import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLFormElement;
import com.aspose.html.HTMLInputElement;
import com.aspose.html.HTMLOptionElement;
import com.aspose.html.HTMLSelectElement;
import com.aspose.html.HTMLTextAreaElement;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.dom.DOMException;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.z1;
import com.aspose.html.forms.ButtonElement;
import com.aspose.html.forms.FormElementBase;
import com.aspose.html.forms.InputElement;
import com.aspose.html.forms.OptionElement;
import com.aspose.html.forms.SelectElement;
import com.aspose.html.forms.TextAreaElement;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Collections.Generic.Dictionary;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.KeyValuePair;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.net.HttpMethod;
import com.aspose.html.z10;
import com.aspose.html.z20;

public class FormEditor
implements IGenericEnumerable<FormElementBase>,
IDisposable {
    private static final Dictionary<Type, z20> TypeToTagMap = new Dictionary();
    private Dictionary<Element, FormElementBase> _fields = new Dictionary();
    private HTMLFormElement _form;

    public final String getAction() {
        return this._form.getAction();
    }

    public final void setAction(String string) {
        this._form.setAction(string);
    }

    public final int getCount() {
        return this._form.getLength();
    }

    public final HTMLFormElement getForm() {
        return this._form;
    }

    public final HttpMethod getMethod() {
        return new HttpMethod(this._form.getMethod());
    }

    public final void setMethod(HttpMethod httpMethod) {
        this._form.setMethod(HttpMethod.z1.m1(httpMethod));
    }

    public final FormElementBase get_Item(String string) {
        HTMLElement hTMLElement = Operators.as(this._form.getElements().namedItem(string), HTMLElement.class);
        if (hTMLElement == null) {
            z10.m40();
        }
        return this.getOrCreate(hTMLElement);
    }

    public final FormElementBase get_Item(int n2) {
        HTMLElement hTMLElement = Operators.as(this._form.getElements().get_Item(n2), HTMLElement.class);
        if (hTMLElement == null) {
            z10.m30();
        }
        return this.getOrCreate(hTMLElement);
    }

    private FormEditor(HTMLFormElement hTMLFormElement) {
        this._form = hTMLFormElement;
    }

    public final <T extends FormElementBase> T add(Class<T> clazz, String string) {
        Type type = Operators.typeOf(clazz);
        if (!TypeToTagMap.containsKey(type)) {
            throw new ArgumentException(StringExtensions.format("'{0}' is not valid.", type));
        }
        Element element = this._form.getOwnerDocument().createElement(z20.m1(TypeToTagMap.get_Item(type)));
        element.setAttribute("name", string);
        this._form.appendChild(element);
        return (T)this.getOrCreate((HTMLElement)element);
    }

    public final InputElement addInput(String string) {
        return this.addInput(string, 2);
    }

    public final InputElement addInput(String string, int n2) {
        InputElement inputElement = this.add(InputElement.class, string);
        inputElement.setType(n2);
        return inputElement;
    }

    public static FormEditor create(HTMLDocument hTMLDocument, int n2) {
        HTMLCollection hTMLCollection = hTMLDocument.getForms();
        if (n2 < 0 || n2 >= hTMLCollection.getLength()) {
            z10.m30();
        }
        return FormEditor.create((HTMLFormElement)hTMLCollection.get_Item(n2));
    }

    public static FormEditor create(HTMLDocument hTMLDocument, String string) {
        HTMLFormElement hTMLFormElement;
        Element element = hTMLDocument.getElementById(string);
        if (element == null) {
            z10.m40();
        }
        if ((hTMLFormElement = Operators.as(element, HTMLFormElement.class)) == null) {
            z10.m45();
        }
        return FormEditor.create(hTMLFormElement);
    }

    public static FormEditor create(HTMLFormElement hTMLFormElement) {
        return new FormEditor(hTMLFormElement);
    }

    public static FormEditor createNew(HTMLDocument hTMLDocument) {
        HTMLFormElement hTMLFormElement = (HTMLFormElement)hTMLDocument.createElement("form");
        return FormEditor.create(hTMLFormElement);
    }

    @Override
    public final void dispose() {
        this._fields.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fill(Dictionary<String, String> dictionary) {
        block8: {
            IGenericEnumerator iGenericEnumerator = dictionary.iterator();
            block5: while (true) {
                while (iGenericEnumerator.hasNext()) {
                    KeyValuePair keyValuePair = (KeyValuePair)iGenericEnumerator.next();
                    try {
                        FormElementBase formElementBase = this.get_Item((String)keyValuePair.getKey());
                        formElementBase.setValue((String)keyValuePair.getValue());
                        continue block5;
                    }
                    catch (DOMException dOMException) {
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
    }

    public final <T extends FormElementBase> T getElement(Class<T> clazz, int n2) {
        return (T)((FormElementBase)Operators.as(this.get_Item(n2), clazz));
    }

    public final <T extends FormElementBase> T getElement(Class<T> clazz, String string) {
        return (T)((FormElementBase)Operators.as(this.get_Item(string), clazz));
    }

    @Override
    public final IGenericEnumerator<FormElementBase> iterator() {
        return new z1(this);
    }

    private FormElementBase getOrCreate(HTMLElement hTMLElement) {
        if (!this._fields.containsKey(hTMLElement)) {
            z20 z2010 = Element.z1.m16(hTMLElement);
            if (ObjectExtensions.referenceEquals(z2010, z1.z5.m2186)) {
                this._fields.addItem(hTMLElement, new InputElement((HTMLInputElement)hTMLElement));
            } else if (ObjectExtensions.referenceEquals(z2010, z1.z5.m2244)) {
                this._fields.addItem(hTMLElement, new SelectElement((HTMLSelectElement)hTMLElement));
            } else if (ObjectExtensions.referenceEquals(z2010, z1.z5.m2219)) {
                this._fields.addItem(hTMLElement, new OptionElement((HTMLOptionElement)hTMLElement));
            } else if (ObjectExtensions.referenceEquals(z2010, z1.z5.m2264)) {
                this._fields.addItem(hTMLElement, new TextAreaElement((HTMLTextAreaElement)hTMLElement));
            } else if (ObjectExtensions.referenceEquals(z2010, z1.z5.m2107)) {
                this._fields.addItem(hTMLElement, new ButtonElement((HTMLButtonElement)hTMLElement));
            } else {
                this._fields.addItem(hTMLElement, new com.aspose.html.forms.z1(hTMLElement));
            }
        }
        return this._fields.get_Item(hTMLElement);
    }

    static {
        TypeToTagMap.addItem(Operators.typeOf(InputElement.class), z1.z5.m2186);
        TypeToTagMap.addItem(Operators.typeOf(SelectElement.class), z1.z5.m2244);
        TypeToTagMap.addItem(Operators.typeOf(OptionElement.class), z1.z5.m2219);
        TypeToTagMap.addItem(Operators.typeOf(TextAreaElement.class), z1.z5.m2264);
        TypeToTagMap.addItem(Operators.typeOf(ButtonElement.class), z1.z5.m2107);
    }

    private static class z1
    implements IGenericEnumerator<FormElementBase> {
        private FormEditor m6248;
        private IGenericEnumerator<Element> m1521;

        public final FormElementBase m1159() {
            return this.m6248.getOrCreate((HTMLElement)this.m1521.next());
        }

        public z1(FormEditor formEditor) {
            this.m6248 = formEditor;
            this.m1521 = formEditor.getForm().getElements().iterator();
        }

        @Override
        public final void dispose() {
            this.m1521.dispose();
        }

        @Override
        public final boolean hasNext() {
            return this.m1521.hasNext();
        }

        @Override
        public final void reset() {
            this.m1521.reset();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.m1159();
        }
    }
}

