/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.drawing;

import com.aspose.html.drawing.Angle;
import com.aspose.html.drawing.Frequency;
import com.aspose.html.drawing.Length;
import com.aspose.html.drawing.Resolution;
import com.aspose.html.drawing.Time;
import com.aspose.html.drawing.UnitType;
import com.aspose.html.drawing.z4;
import com.aspose.html.drawing.z6;
import com.aspose.html.drawing.z7;
import com.aspose.html.internal.ms.System.IEquatable;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.lang.Operators;

public abstract class Unit
implements IEquatable<Unit> {
    private final UnitType unitType;

    public final UnitType getUnitType() {
        return this.unitType;
    }

    Unit(UnitInit unitInit) {
        this(unitInit.getType());
    }

    protected Unit(UnitType unitType) {
        this.unitType = unitType;
    }

    public boolean equals(Unit unit) {
        if (ObjectExtensions.referenceEquals(null, unit)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, unit)) {
            return true;
        }
        return (this.getUnitType().getCategory() & 0xFF) != (unit.getUnitType().getCategory() & 0xFF);
    }

    @Override
    public boolean equals(Object object) {
        return this.equals(Operators.as(object, Unit.class));
    }

    public static Length fromCentimeters(double d2) {
        return new Length(d2, UnitType.CM);
    }

    public static Angle fromDegrees(double d2) {
        return new Angle(d2, UnitType.DEG);
    }

    public static Resolution fromDotsPerCentimeters(double d2) {
        return new Resolution(d2, UnitType.DPCM);
    }

    public static Resolution fromDotsPerInch(double d2) {
        return new Resolution(d2, UnitType.DPI);
    }

    public static Resolution fromDotsPerPixel(double d2) {
        return new Resolution(d2, UnitType.DPPX);
    }

    public static Angle fromGradians(double d2) {
        return new Angle(d2, UnitType.GRAD);
    }

    public static Frequency fromHertz(double d2) {
        return new Frequency(d2, UnitType.HZ);
    }

    public static Length fromInches(double d2) {
        return new Length(d2, UnitType.IN);
    }

    private static z4 fromInteger(int n2) {
        return new z4(n2);
    }

    public static Frequency fromKiloHertz(double d2) {
        return new Frequency(d2, UnitType.K_HZ);
    }

    public static Length fromMillimeters(double d2) {
        return new Length(d2, UnitType.MM);
    }

    public static Time fromMilliseconds(double d2) {
        return new Time(d2, UnitType.MS);
    }

    private static z6 fromPercent(double d2) {
        return new z6(d2);
    }

    public static Length fromPicas(double d2) {
        return new Length(d2, UnitType.PC);
    }

    public static Length fromPixels(double d2) {
        return new Length(d2, UnitType.PX);
    }

    public static Length fromPoints(double d2) {
        return new Length(d2, UnitType.PT);
    }

    public static Length fromQuarterMillimeters(double d2) {
        return new Length(d2, UnitType.Q);
    }

    public static Angle fromRadians(double d2) {
        return new Angle(d2, UnitType.RAD);
    }

    private static z7 fromReal(double d2) {
        return new z7(d2);
    }

    public static Time fromSeconds(double d2) {
        return new Time(d2, UnitType.S);
    }

    public static Angle fromTurns(double d2) {
        return new Angle(d2, UnitType.TURN);
    }

    public int hashCode() {
        return this.getUnitType().hashCode();
    }

    public String toString() {
        return this.getUnitType().toString();
    }

    static class UnitInit {
        private UnitType auto_Type;

        UnitInit() {
        }

        public final UnitType getType() {
            return this.auto_Type;
        }

        public final void setType(UnitType unitType) {
            this.auto_Type = unitType;
        }
    }
}

