/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.drawing;

import com.aspose.html.drawing.Unit;
import com.aspose.html.drawing.UnitType;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.DoubleExtensions;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p283.z24;

public abstract class Numeric
extends Unit {
    private int hash;
    private double original;
    private double value;

    Numeric(NumericInit numericInit) {
        super(numericInit);
        this.original = numericInit.getValue();
        this.initialize(numericInit);
        Numeric[] numericArray = new Numeric[]{this};
        this.value = z1.m1(this.original, numericArray);
        this.hash = z24.m33(this.getUnitType().hashCode(), DoubleExtensions.getHashCode(this.value));
    }

    public final int compareTo(Numeric numeric) {
        if (ObjectExtensions.referenceEquals(null, numeric)) {
            throw new ArgumentNullException("other");
        }
        if ((this.getUnitType().getCategory() & 0xFF) != (numeric.getUnitType().getCategory() & 0xFF)) {
            throw new ArgumentException(StringExtensions.format("The unit '{0}' is invalid", numeric));
        }
        if (this.value < numeric.value) {
            return -1;
        }
        if (this.value == numeric.value) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean equals(Unit unit) {
        Numeric numeric = Operators.as(unit, Numeric.class);
        if (ObjectExtensions.referenceEquals(null, numeric)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, numeric)) {
            return true;
        }
        if ((this.getUnitType().getCategory() & 0xFF) != (numeric.getUnitType().getCategory() & 0xFF)) {
            return false;
        }
        return this.value == numeric.value;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    public final double getValue() {
        return this.original;
    }

    public final double getValue(UnitType unitType) {
        if (ObjectExtensions.referenceEquals(null, unitType)) {
            throw new ArgumentNullException("unitType");
        }
        return this.onConvert(this.value / (double)this.getUnitType().getFraction().getMultiplier(), this.getUnitType().getFraction(), unitType);
    }

    void initialize(Unit.UnitInit unitInit) {
    }

    protected abstract double onConvert(double var1, UnitType var3, UnitType var4);

    @Override
    public String toString() {
        return DoubleExtensions.toString(this.getValue(), com.aspose.html.internal.p215.z1.DEFAULT_CULTURE);
    }

    static class z1 {
        public static double m1(Numeric numeric, Numeric numeric2) {
            return (numeric.value + numeric2.value) / (double)numeric.getUnitType().getFraction().getMultiplier();
        }

        public static double m1(double d2, Numeric[] numericArray) {
            if (UnitType.op_Inequality(numericArray[0].getUnitType().getFraction(), numericArray[0].getUnitType())) {
                d2 = numericArray[0].onConvert(d2, numericArray[0].getUnitType(), numericArray[0].getUnitType().getFraction());
                d2 = msMath.round(d2, 3, (short)1);
            }
            return d2 * (double)numericArray[0].getUnitType().getFraction().getMultiplier();
        }

        public static boolean m2(Numeric numeric, Numeric numeric2) {
            return numeric.value >= numeric2.value;
        }

        public static boolean m3(Numeric numeric, Numeric numeric2) {
            return numeric.value > numeric2.value;
        }

        public static boolean m4(Numeric numeric, Numeric numeric2) {
            return numeric.value <= numeric2.value;
        }

        public static boolean m5(Numeric numeric, Numeric numeric2) {
            return numeric.value < numeric2.value;
        }

        public static double m6(Numeric numeric, Numeric numeric2) {
            return (numeric.value - numeric2.value) / (double)numeric.getUnitType().getFraction().getMultiplier();
        }
    }

    static class NumericInit
    extends Unit.UnitInit {
        private double auto_Value;

        NumericInit() {
        }

        public final double getValue() {
            return this.auto_Value;
        }

        public final void setValue(double d2) {
            this.auto_Value = d2;
        }
    }
}

