/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.drawing;

import com.aspose.html.drawing.z5;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Drawing.KnownColor;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Struct;

public class Color
extends Struct<Color> {
    private long e;
    short a;
    short b;
    String c;
    public static Color Empty = new Color();

    public java.awt.Color getNativeObject() {
        return new java.awt.Color(this.getR() & 0xFF, this.getG() & 0xFF, this.getB() & 0xFF, this.getA() & 0xFF);
    }

    static Color a(int n2, int n3, int n4, int n5, String string, int n6) {
        Color color = Color.fromArgb(n2, n3, n4, n5).Clone();
        color.a = (short)5;
        color.c = z5.getName(n6);
        color.b = (short)n6;
        return color;
    }

    static Color b(int n2, int n3, int n4, int n5, String string, int n6) {
        Color color = Color.a(n2, n3, n4, n5, string, n6).Clone();
        color.a = (short)(color.a | 8);
        return color;
    }

    public String getName() {
        if (this.c == null) {
            this.c = this.isNamedColor() ? z5.m4(this.b) : StringExtensions.format("{0:x}", this.toArgb());
        }
        return this.c;
    }

    public boolean isKnownColor() {
        return (this.a & 1) != 0;
    }

    public boolean isSystemColor() {
        return (this.a & 8) != 0;
    }

    public boolean isNamedColor() {
        return (this.a & 5) != 0;
    }

    long a() {
        if (this.e == 0L && this.isKnownColor()) {
            this.e = (long)z5.fromKnownColor(this.b).toArgb() & 0xFFFFFFFFL;
        }
        return this.e;
    }

    void a(long l2) {
        this.e = l2;
    }

    public static Color fromArgb(int n2, int n3, int n4) {
        return Color.fromArgb(255, n2, n3, n4);
    }

    public static Color fromArgb(int n2, int n3, int n4, int n5) {
        Color.a(n2, n3, n4, n5);
        Color color = new Color();
        color.a = (short)2;
        color.a((n2 << 24) + (n3 << 16) + (n4 << 8) + n5);
        return color;
    }

    public int toArgb() {
        return (int)this.a();
    }

    public static Color fromArgb(int n2, Color color) {
        return Color.fromArgb(n2, color.getR() & 0xFF, color.getG() & 0xFF, color.getB() & 0xFF);
    }

    public static Color fromArgb(int n2) {
        return Color.fromArgb(n2 >>> 24 & 0xFF, n2 >>> 16 & 0xFF, n2 >>> 8 & 0xFF, n2 & 0xFF);
    }

    public static Color fromKnownColor(int n2) {
        return z5.fromKnownColor(n2);
    }

    public static Color fromName(String string) {
        try {
            int n2 = (int)Enum.parse(KnownColor.class, string, (Boolean)true);
            return z5.fromKnownColor(n2);
        }
        catch (Exception exception) {
            Color color = Color.fromArgb(0, 0, 0, 0).Clone();
            color.c = string;
            color.a = (short)(color.a | 4);
            return color;
        }
    }

    public static boolean op_Equality(Color color, Color color2) {
        if (color.a() != color2.a()) {
            return false;
        }
        if (color.isNamedColor() != color2.isNamedColor()) {
            return false;
        }
        if (color.isSystemColor() != color2.isSystemColor()) {
            return false;
        }
        if (color.isEmpty() != color2.isEmpty()) {
            return false;
        }
        return !color.isNamedColor() || StringExtensions.equals(color.getName(), color2.getName());
    }

    public static boolean op_Inequality(Color color, Color color2) {
        return !Color.equals(color, color2);
    }

    public float getBrightness() {
        byte by2 = (byte)Math.min(this.getR() & 0xFF, Math.min(this.getG() & 0xFF, this.getB() & 0xFF));
        byte by3 = (byte)Math.max(this.getR() & 0xFF, Math.max(this.getG() & 0xFF, this.getB() & 0xFF));
        return (float)((by3 & 0xFF) + (by2 & 0xFF)) / 510.0f;
    }

    public float getSaturation() {
        byte by2 = (byte)Math.min(this.getR() & 0xFF, Math.min(this.getG() & 0xFF, this.getB() & 0xFF));
        byte by3 = (byte)Math.max(this.getR() & 0xFF, Math.max(this.getG() & 0xFF, this.getB() & 0xFF));
        if (by3 == by2) {
            return 0.0f;
        }
        int n2 = (by3 & 0xFF) + (by2 & 0xFF);
        if (n2 > 255) {
            n2 = 510 - n2;
        }
        return (float)((by3 & 0xFF) - (by2 & 0xFF)) / (float)n2;
    }

    public float getHue() {
        int n2 = this.getR() & 0xFF;
        int n3 = this.getG() & 0xFF;
        int n4 = this.getB() & 0xFF;
        byte by2 = (byte)Math.min(n2, Math.min(n3, n4));
        byte by3 = (byte)Math.max(n2, Math.max(n3, n4));
        if (by3 == by2) {
            return 0.0f;
        }
        float f2 = (by3 & 0xFF) - (by2 & 0xFF);
        float f3 = (float)((by3 & 0xFF) - n2) / f2;
        float f4 = (float)((by3 & 0xFF) - n3) / f2;
        float f5 = (float)((by3 & 0xFF) - n4) / f2;
        float f6 = 0.0f;
        if (n2 == (by3 & 0xFF)) {
            f6 = 60.0f * (6.0f + f5 - f4);
        }
        if (n3 == (by3 & 0xFF)) {
            f6 = 60.0f * (2.0f + f3 - f5);
        }
        if (n4 == (by3 & 0xFF)) {
            f6 = 60.0f * (4.0f + f4 - f3);
        }
        if (f6 > 360.0f) {
            f6 -= 360.0f;
        }
        return f6;
    }

    public int toKnownColor() {
        return this.b;
    }

    public boolean isEmpty() {
        return this.a == 0;
    }

    public byte getA() {
        return (byte)(this.a() >> 24 & 0xFFL);
    }

    public byte getR() {
        return (byte)(this.a() >> 16 & 0xFFL);
    }

    public byte getG() {
        return (byte)(this.a() >> 8 & 0xFFL);
    }

    public byte getB() {
        return (byte)(this.a() & 0xFFL);
    }

    public int hashCode() {
        int n2 = (int)(this.a() ^ this.a() >> 32 ^ (long)this.a ^ (long)(this.b >> 16));
        if (this.isNamedColor()) {
            n2 ^= this.getName().hashCode();
        }
        return n2;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Color [Empty]";
        }
        if (this.isNamedColor()) {
            return "Color [" + this.getName() + "]";
        }
        return StringExtensions.format("Color [A={0}, R={1}, G={2}, B={3}]", this.getA() & 0xFF, this.getR() & 0xFF, this.getG() & 0xFF, this.getB() & 0xFF);
    }

    private static void a(int n2, int n3, int n4) {
        if (n2 > 255 || n2 < 0) {
            throw Color.a(n2, "red");
        }
        if (n3 > 255 || n3 < 0) {
            throw Color.a(n3, "green");
        }
        if (n4 > 255 || n4 < 0) {
            throw Color.a(n4, "blue");
        }
    }

    private static ArgumentException a(int n2, String string) {
        return new ArgumentException(StringExtensions.format("'{0}' is not a valid value for '{1}'. '{1}' should be greater or equal to 0 and less than or equal to 255.", n2, string));
    }

    private static void a(int n2, int n3, int n4, int n5) {
        if (n2 > 255 || n2 < 0) {
            throw Color.a(n2, "alpha");
        }
        Color.a(n3, n4, n5);
    }

    public static Color getTransparent() {
        return z5.fromKnownColor(27);
    }

    public static Color getAliceBlue() {
        return z5.fromKnownColor(28);
    }

    public static Color getAntiqueWhite() {
        return z5.fromKnownColor(29);
    }

    public static Color getAqua() {
        return z5.fromKnownColor(30);
    }

    public static Color getAquamarine() {
        return z5.fromKnownColor(31);
    }

    public static Color getAzure() {
        return z5.fromKnownColor(32);
    }

    public static Color getBeige() {
        return z5.fromKnownColor(33);
    }

    public static Color getBisque() {
        return z5.fromKnownColor(34);
    }

    public static Color getBlack() {
        return z5.fromKnownColor(35);
    }

    public static Color getBlanchedAlmond() {
        return z5.fromKnownColor(36);
    }

    public static Color getBlue() {
        return z5.fromKnownColor(37);
    }

    public static Color getBlueViolet() {
        return z5.fromKnownColor(38);
    }

    public static Color getBrown() {
        return z5.fromKnownColor(39);
    }

    public static Color getBurlyWood() {
        return z5.fromKnownColor(40);
    }

    public static Color getCadetBlue() {
        return z5.fromKnownColor(41);
    }

    public static Color getChartreuse() {
        return z5.fromKnownColor(42);
    }

    public static Color getChocolate() {
        return z5.fromKnownColor(43);
    }

    public static Color getCoral() {
        return z5.fromKnownColor(44);
    }

    public static Color getCornflowerBlue() {
        return z5.fromKnownColor(45);
    }

    public static Color getCornsilk() {
        return z5.fromKnownColor(46);
    }

    public static Color getCrimson() {
        return z5.fromKnownColor(47);
    }

    public static Color getCyan() {
        return z5.fromKnownColor(48);
    }

    public static Color getDarkBlue() {
        return z5.fromKnownColor(49);
    }

    public static Color getDarkCyan() {
        return z5.fromKnownColor(50);
    }

    public static Color getDarkGoldenrod() {
        return z5.fromKnownColor(51);
    }

    public static Color getDarkGray() {
        return z5.fromKnownColor(52);
    }

    public static Color getDarkGreen() {
        return z5.fromKnownColor(53);
    }

    public static Color getDarkKhaki() {
        return z5.fromKnownColor(54);
    }

    public static Color getDarkMagenta() {
        return z5.fromKnownColor(55);
    }

    public static Color getDarkOliveGreen() {
        return z5.fromKnownColor(56);
    }

    public static Color getDarkOrange() {
        return z5.fromKnownColor(57);
    }

    public static Color getDarkOrchid() {
        return z5.fromKnownColor(58);
    }

    public static Color getDarkRed() {
        return z5.fromKnownColor(59);
    }

    public static Color getDarkSalmon() {
        return z5.fromKnownColor(60);
    }

    public static Color getDarkSeaGreen() {
        return z5.fromKnownColor(61);
    }

    public static Color getDarkSlateBlue() {
        return z5.fromKnownColor(62);
    }

    public static Color getDarkSlateGray() {
        return z5.fromKnownColor(63);
    }

    public static Color getDarkTurquoise() {
        return z5.fromKnownColor(64);
    }

    public static Color getDarkViolet() {
        return z5.fromKnownColor(65);
    }

    public static Color getDeepPink() {
        return z5.fromKnownColor(66);
    }

    public static Color getDeepSkyBlue() {
        return z5.fromKnownColor(67);
    }

    public static Color getDimGray() {
        return z5.fromKnownColor(68);
    }

    public static Color getDodgerBlue() {
        return z5.fromKnownColor(69);
    }

    public static Color getFirebrick() {
        return z5.fromKnownColor(70);
    }

    public static Color getFloralWhite() {
        return z5.fromKnownColor(71);
    }

    public static Color getForestGreen() {
        return z5.fromKnownColor(72);
    }

    public static Color getFuchsia() {
        return z5.fromKnownColor(73);
    }

    public static Color getGainsboro() {
        return z5.fromKnownColor(74);
    }

    public static Color getGhostWhite() {
        return z5.fromKnownColor(75);
    }

    public static Color getGold() {
        return z5.fromKnownColor(76);
    }

    public static Color getGoldenrod() {
        return z5.fromKnownColor(77);
    }

    public static Color getGray() {
        return z5.fromKnownColor(78);
    }

    public static Color getGreen() {
        return z5.fromKnownColor(79);
    }

    public static Color getGreenYellow() {
        return z5.fromKnownColor(80);
    }

    public static Color getHoneydew() {
        return z5.fromKnownColor(81);
    }

    public static Color getHotPink() {
        return z5.fromKnownColor(82);
    }

    public static Color getIndianRed() {
        return z5.fromKnownColor(83);
    }

    public static Color getIndigo() {
        return z5.fromKnownColor(84);
    }

    public static Color getIvory() {
        return z5.fromKnownColor(85);
    }

    public static Color getKhaki() {
        return z5.fromKnownColor(86);
    }

    public static Color getLavender() {
        return z5.fromKnownColor(87);
    }

    public static Color getLavenderBlush() {
        return z5.fromKnownColor(88);
    }

    public static Color getLawnGreen() {
        return z5.fromKnownColor(89);
    }

    public static Color getLemonChiffon() {
        return z5.fromKnownColor(90);
    }

    public static Color getLightBlue() {
        return z5.fromKnownColor(91);
    }

    public static Color getLightCoral() {
        return z5.fromKnownColor(92);
    }

    public static Color getLightCyan() {
        return z5.fromKnownColor(93);
    }

    public static Color getLightGoldenrodYellow() {
        return z5.fromKnownColor(94);
    }

    public static Color getLightGreen() {
        return z5.fromKnownColor(96);
    }

    public static Color getLightGray() {
        return z5.fromKnownColor(95);
    }

    public static Color getLightPink() {
        return z5.fromKnownColor(97);
    }

    public static Color getLightSalmon() {
        return z5.fromKnownColor(98);
    }

    public static Color getLightSeaGreen() {
        return z5.fromKnownColor(99);
    }

    public static Color getLightSkyBlue() {
        return z5.fromKnownColor(100);
    }

    public static Color getLightSlateGray() {
        return z5.fromKnownColor(101);
    }

    public static Color getLightSteelBlue() {
        return z5.fromKnownColor(102);
    }

    public static Color getLightYellow() {
        return z5.fromKnownColor(103);
    }

    public static Color getLime() {
        return z5.fromKnownColor(104);
    }

    public static Color getLimeGreen() {
        return z5.fromKnownColor(105);
    }

    public static Color getLinen() {
        return z5.fromKnownColor(106);
    }

    public static Color getMagenta() {
        return z5.fromKnownColor(107);
    }

    public static Color getMaroon() {
        return z5.fromKnownColor(108);
    }

    public static Color getMediumAquamarine() {
        return z5.fromKnownColor(109);
    }

    public static Color getMediumBlue() {
        return z5.fromKnownColor(110);
    }

    public static Color getMediumOrchid() {
        return z5.fromKnownColor(111);
    }

    public static Color getMediumPurple() {
        return z5.fromKnownColor(112);
    }

    public static Color getMediumSeaGreen() {
        return z5.fromKnownColor(113);
    }

    public static Color getMediumSlateBlue() {
        return z5.fromKnownColor(114);
    }

    public static Color getMediumSpringGreen() {
        return z5.fromKnownColor(115);
    }

    public static Color getMediumTurquoise() {
        return z5.fromKnownColor(116);
    }

    public static Color getMediumVioletRed() {
        return z5.fromKnownColor(117);
    }

    public static Color getMidnightBlue() {
        return z5.fromKnownColor(118);
    }

    public static Color getMintCream() {
        return z5.fromKnownColor(119);
    }

    public static Color getMistyRose() {
        return z5.fromKnownColor(120);
    }

    public static Color getMoccasin() {
        return z5.fromKnownColor(121);
    }

    public static Color getNavajoWhite() {
        return z5.fromKnownColor(122);
    }

    public static Color getNavy() {
        return z5.fromKnownColor(123);
    }

    public static Color getOldLace() {
        return z5.fromKnownColor(124);
    }

    public static Color getOlive() {
        return z5.fromKnownColor(125);
    }

    public static Color getOliveDrab() {
        return z5.fromKnownColor(126);
    }

    public static Color getOrange() {
        return z5.fromKnownColor(127);
    }

    public static Color getOrangeRed() {
        return z5.fromKnownColor(128);
    }

    public static Color getOrchid() {
        return z5.fromKnownColor(129);
    }

    public static Color getPaleGoldenrod() {
        return z5.fromKnownColor(130);
    }

    public static Color getPaleGreen() {
        return z5.fromKnownColor(131);
    }

    public static Color getPaleTurquoise() {
        return z5.fromKnownColor(132);
    }

    public static Color getPaleVioletRed() {
        return z5.fromKnownColor(133);
    }

    public static Color getPapayaWhip() {
        return z5.fromKnownColor(134);
    }

    public static Color getPeachPuff() {
        return z5.fromKnownColor(135);
    }

    public static Color getPeru() {
        return z5.fromKnownColor(136);
    }

    public static Color getPink() {
        return z5.fromKnownColor(137);
    }

    public static Color getPlum() {
        return z5.fromKnownColor(138);
    }

    public static Color getPowderBlue() {
        return z5.fromKnownColor(139);
    }

    public static Color getPurple() {
        return z5.fromKnownColor(140);
    }

    public static Color getRed() {
        return z5.fromKnownColor(141);
    }

    public static Color getRosyBrown() {
        return z5.fromKnownColor(142);
    }

    public static Color getRoyalBlue() {
        return z5.fromKnownColor(143);
    }

    public static Color getSaddleBrown() {
        return z5.fromKnownColor(144);
    }

    public static Color getSalmon() {
        return z5.fromKnownColor(145);
    }

    public static Color getSandyBrown() {
        return z5.fromKnownColor(146);
    }

    public static Color getSeaGreen() {
        return z5.fromKnownColor(147);
    }

    public static Color getSeaShell() {
        return z5.fromKnownColor(148);
    }

    public static Color getSienna() {
        return z5.fromKnownColor(149);
    }

    public static Color getSilver() {
        return z5.fromKnownColor(150);
    }

    public static Color getSkyBlue() {
        return z5.fromKnownColor(151);
    }

    public static Color getSlateBlue() {
        return z5.fromKnownColor(152);
    }

    public static Color getSlateGray() {
        return z5.fromKnownColor(153);
    }

    public static Color getSnow() {
        return z5.fromKnownColor(154);
    }

    public static Color getSpringGreen() {
        return z5.fromKnownColor(155);
    }

    public static Color getSteelBlue() {
        return z5.fromKnownColor(156);
    }

    public static Color getTan() {
        return z5.fromKnownColor(157);
    }

    public static Color getTeal() {
        return z5.fromKnownColor(158);
    }

    public static Color getThistle() {
        return z5.fromKnownColor(159);
    }

    public static Color getTomato() {
        return z5.fromKnownColor(160);
    }

    public static Color getTurquoise() {
        return z5.fromKnownColor(161);
    }

    public static Color getViolet() {
        return z5.fromKnownColor(162);
    }

    public static Color getWheat() {
        return z5.fromKnownColor(163);
    }

    public static Color getWhite() {
        return z5.fromKnownColor(164);
    }

    public static Color getWhiteSmoke() {
        return z5.fromKnownColor(165);
    }

    public static Color getYellow() {
        return z5.fromKnownColor(166);
    }

    public static Color getYellowGreen() {
        return z5.fromKnownColor(167);
    }

    @Override
    public void CloneTo(Color color) {
        color.e = this.e;
        color.a = this.a;
        color.b = this.b;
        color.c = this.c;
    }

    @Override
    public Color Clone() {
        Color color = new Color();
        this.CloneTo(color);
        return color;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(Color color) {
        return color.e == this.e && color.a == this.a && color.b == this.b && ObjectExtensions.equals(color.c, this.c);
    }

    public boolean equals(Object object) {
        assert (object != null);
        if (ObjectExtensions.referenceEquals(null, object)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, object)) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        return this.a((Color)object);
    }

    public static boolean equals(Color color, Color color2) {
        return color.equals(color2);
    }

    public static java.awt.Color toJava(Color color) {
        if (color == null) {
            return null;
        }
        return color.getNativeObject();
    }

    public static Color fromJava(java.awt.Color color) {
        if (color == null) {
            return new Color();
        }
        return Color.fromArgb(color.getRGB());
    }
}

